PRO closeps,devicename

@varps

IF N_ELEMENTS(devicename) EQ 0 THEN devicename=originaldevicepsdef

DEVICE,/CLOSE
SET_PLOT,devicename
thinps
setcolorps

CASE !VERSION.OS_FAMILY OF
    'unix' : BEGIN
    END
    ELSE: BEGIN
        PRINT,' [CLOSEPS] WARNING: ------------------------------------------------------------'
        PRINT,' [CLOSEPS] WARNING: This routine is only adopted to some Unix systems.'
        PRINT,' [CLOSEPS] WARNING: It may not work properly on other systems'
        PRINT,' [CLOSEPS] WARNING: Please adjust accordingly.'
        PRINT,' [CLOSEPS] WARNING: ------------------------------------------------------------'
    END
ENDCASE


extension='.ps'
i=STRPOS(STRUPCASE(filename),STRUPCASE(extension),/REVERSE_SEARCH)
IF i EQ STRLEN(filename)-STRLEN(extension) THEN BEGIN
    filename_pdf=STRMID(filename,0,i)+'.pdf'
    filename_ps=filename
ENDIF ELSE BEGIN
    extension='.pdf'
    i=STRPOS(STRUPCASE(filename),STRUPCASE(extension),/REVERSE_SEARCH)
    IF i EQ STRLEN(filename)-STRLEN(extension) THEN BEGIN
        filename_ps=filename
        filename_pdf=STRMID(filename,0,i)+'.pdf'
    ENDIF ELSE BEGIN
        filename_ps=filename+'.ps'
        filename_pdf=filename+'.pdf'
    ENDELSE
ENDELSE

IF save_pdf NE 0 THEN BEGIN
    program='ps2pdf'
    IF save_pdf EQ 1 THEN program+='13'
    IF save_pdf GT 10 THEN program+=STRTRIM(STRING(save_pdf),2)
    
    command=program+' '+filename+'_ps '+filename_pdf
    spawn,command,res,err

    IF (res[0] NE '') OR (err[0] NE '') THEN $
      PRINT,' [CLOSEPS] ps2pdf COMMAND: '+command
    IF res[0] NE '' THEN $
      PRINT,' [CLOSEPS] ps2pdf  OUTPUT: '+res
    IF err[0] NE '' THEN $
      PRINT,' [CLOSEPS] ps2pdf   ERROR: '+res
ENDIF
IF save_ps EQ 0 THEN BEGIN
    IF save_pdf NE 0 THEN BEGIN
        filename_rm=filename+'_ps'
    ENDIF ELSE BEGIN
        filename_rm=filename
    ENDELSE
    program='rm'
    command=program+' '+filename_rm
    spawn,command,res,err
    SPAWN,command,res,err  
    IF (res[0] NE '') OR (err[0] NE '') THEN $
      PRINT,' [CLOSEPS] '+program+' COMMAND: '+res
    IF res[0] NE '' THEN $
      PRINT,' [CLOSEPS] '+program+'  OUTPUT: '+res    
    IF err[0] NE '' THEN $
      PRINT,' [CLOSEPS] '+program+'   ERROR: '+res    
ENDIF ELSE BEGIN
    IF save_pdf NE 0 THEN BEGIN
        program='mv'
        command=program+' '+filename+'_ps '+filename_ps
        SPAWN,command,res,err  
        IF (res[0] NE '') OR (err[0] NE '') THEN $
          PRINT,' [CLOSEPS] '+program+' COMMAND: '+res
        IF res[0] NE '' THEN $
          PRINT,' [CLOSEPS] '+program+'  OUTPUT: '+res    
        IF err[0] NE '' THEN $
          PRINT,' [CLOSEPS] '+program+'   ERROR: '+res    
    ENDIF
ENDELSE

IF file_compress NE 0 THEN BEGIN
    CASE file_compress OF
        2: BEGIN 
            program='bzip2'
            parameters=' -v9f'
        END
        ELSE: BEGIN 
            program='gzip'
            parameters=' -v9f'
        END
    ENDCASE
    command=program+' '+parameters+' '+filename_ps
    spawn,command,res,err
    IF (res[0] NE '') OR (err[0] NE '') THEN $
      PRINT,' [CLOSEPS] '+program+' COMMAND: '+res
    IF res[0] NE '' THEN $
      PRINT,' [CLOSEPS] '+program+'  OUTPUT: '+res    
    IF err[0] NE '' THEN $
      PRINT,' [CLOSEPS] '+program+'   ERROR: '+res    
ENDIF


IF saved_PT THEN BEGIN
    !P.T3D=save_PT3D
    !P.T=save_PT
ENDIF

END

