PRO extract_layer,layer,layer_sizes,index1,index2,data, $
                  index,ldata, $
                  NSTART=nstart,$
                  NEND=nend, $
                  NSTEP=nstep

IF N_ELEMENTS(nstart) EQ 0 THEN nstart=0L
IF N_ELEMENTS(nend  ) EQ 0 THEN nend  =N_ELEMENTS(index1)-2L
IF N_ELEMENTS(nstep ) EQ 0 THEN nstep =1L

ldata=DBLARR(2,layer_sizes[layer],/NOZERO)

n=((nend-nstart+nstep)/nstep)+1L
index=LONARR(n)
iindex=0L
index[0]=iindex
iend=n-2L
FOR i=0L,iend DO BEGIN
    ii=MIN([nstart+i*nstep,nend])
    xbi=index1[ii]
    xbi1=index1[ii+1]
    nlevel=xbi1-xbi
    IF layer LT nlevel THEN BEGIN
        xii=index2[xbi+layer]
        xii1=index2[xbi+layer+1L]
        npoly=xii1-xii
        ldata[0:1,iindex:iindex+npoly-1]=data[0:1,xii:xii1-1L]
        iindex=iindex+npoly
    ENDIF
    index[i+1L]=iindex
ENDFOR
END

;#######################################################################
;#######################################################################
;#######################################################################

PRO test_extract_layer

n=10000L
l=16L
m=8L

xb=LONARR(n+1)

nxi=1024L
xi=PTR_NEW(LONARR(nxi),/NO_COPY)

xb[0]=0
(*xi)[0]=0

nl=LONARR(l)

ii=0L
jj=0L

seed=0L

FOR i=0L,n-1 DO BEGIN
    nlevel=ROUND(RANDOMU(seed)*l)
    FOR j=0L,nlevel-1 DO BEGIN
        npoly=1+ROUND(RANDOMU(seed)*(m-1))
        ii=ii+npoly
        IF jj+1 GE nxi THEN BEGIN
            nxi2=ROUND(nxi*1.2)
            xi2=PTR_NEW(LONARR(nxi2),/NO_COPY)
            (*xi2)[0:nxi-1]=(*xi)[0:nxi-1]
            PTR_FREE,xi
            xi=xi2
            nxi=nxi2
        ENDIF
        (*xi)[jj+1]=ii
        jj=jj+1L
        nl[j]=nl[j]+npoly
    ENDFOR
    xb[i+1]=jj
    IF i mod 5000 EQ 0 THEN PRINT,i
ENDFOR

ptr=xi
xi=*xi
PTR_FREE,ptr

print,ii,jj
print,nl

data=DBLARR(2,ii,/NOZERO)

spawn,"date"
t=systime(/SECONDS)

;ll=2L ; start with 0
FOR ll=0L,l-1 DO BEGIN
;     y=DBLARR(nl[ll])
;     yi=LONARR(n+1)
;     yi[0]=0L
;     yn=0L
;     xbi1=xb[0]
;     FOR i=0L,n-1L DO BEGIN
;         xbi=xbi1
;         xbi1=xb[i+1]
;         nlevel=xbi1-xbi
;         IF ll LT nlevel-1 THEN BEGIN
;             xii=xi[xbi+ll]
;             xii1=xi[xbi+ll+1]
;             npoly=xii1-xii
;             y[yn:yn+npoly-1]=data[xii:xii1-1]
;             yn=yn+npoly
;         ENDIF
;         yi[i]=yn
;     ENDFOR
    extract_layer,ll,nl,xb,xi,data,index,layer_data
ENDFOR

spawn,"date"
PRINT,systime(/SECONDS)-t

END
