PRO legende_line,line,text,LENGTH=length,COLOR=color,TEXTCOLOR=textcolor,NONEWLINE=nonewline,THICK=thick,CHARTHICK=charthick
@legende_var

IF NOT N_ELEMENTS(LENGTH) THEN length=legende_length
IF NOT N_ELEMENTS(COLOR) THEN color=!P.COLOR
IF NOT N_ELEMENTS(THICK) THEN thick=!P.THICK

p=DBLARR(4)
p(0:1)=legende_pos-legende_b*(1+length)+legende_h*0.5
p(2:3)=legende_pos-legende_b+legende_h*0.5
plots,p([0,2]),p([1,3]),/NORMAL,LINESTYLE=line,COLOR=color,THICK=thick

legende_text,text,COLOR=textcolor,NONEWLINE=nonewline,CHARTHICK=charthick

RETURN
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO legende_symbol,symbol,text,LENGTH=length,COLOR=color,SYMSIZE=symsize,TEXTCOLOR=textcolor,NONEWLINE=nonewline,THICK=thick,CHARTHICK=charthick
@legende_var

IF NOT N_ELEMENTS(LENGTH) THEN length=legende_length
IF NOT N_ELEMENTS(COLOR) THEN color=!P.COLOR
IF NOT N_ELEMENTS(THICK) THEN thick=!P.THICK
IF NOT N_ELEMENTS(SYMSIZE) THEN symsize=1.0

p=legende_pos-legende_b*(2+length)*0.5+legende_h*0.5
plots,[p(0)],[p(1)],/NORMAL,PSYM=symbol,COLOR=color,SYMSIZE=symsize,THICK=thick

legende_text,text,COLOR=textcolor,NONEWLINE=nonewline,CHARTHICK=charthick

RETURN
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO legende_col,color,text,LENGTH=length,TEXTCOLOR=textcolor, $
                NOFRAME=noframe,FRAMECOLOR=framecolor, $
                NONEWLINE=nonewline,LINE_FILL=line_fill, $
                ORIENTATION=orientation,SPACING=spacing, $
                THICK=thick,CHARTHICK=charthick, $
                FRAMETHICK=framethick,FRAMELINE=frameline
@legende_var

IF NOT N_ELEMENTS(length) THEN length=legende_length 
IF NOT N_ELEMENTS(noframe) THEN noframe=0
IF NOT N_ELEMENTS(FRAMECOLOR) THEN framecolor=!P.COLOR
IF NOT N_ELEMENTS(line_fill) THEN line_fill=0
IF NOT N_ELEMENTS(thick) THEN thick=0
IF NOT N_ELEMENTS(framethick) THEN framethick=!P.THICK
IF NOT N_ELEMENTS(frameline) THEN frameline=0
IF NOT N_ELEMENTS(orientation) THEN orientation=45.
IF NOT N_ELEMENTS(spacing) THEN spacing=0.1

p=DBLARR(4)
p(0:1)=legende_pos-legende_b*(1+length)+legende_h
p(2:3)=legende_pos-legende_b
x=[0,2,2,0,0]
y=[1,1,3,3,1]
IF line_fill THEN BEGIN
    FOR i=0,N_ELEMENTS(spacing)-1 DO $
      POLYFILL,p(x),p(y),color=color,NOCLIP=0,/NORMAL,SPACING=spacing(i),ORIENTATION=orientation(i),THICK=thick
ENDIF ELSE BEGIN
    POLYFILL,p(x),p(y),color=color,NOCLIP=0,/NORMAL
ENDELSE
IF NOT noframe THEN plots,p(x),p(y),/NORMAL,COLOR=framecolor,THICK=framethick,LINE=frameline

legende_text,text,COLOR=textcolor,NONEWLINE=nonewline,CHARTHICK=charthick

RETURN
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO legende_text,text,COLOR=color,NONEWLINE=nonewline,ALIGNMENT=alignment,CHARTHICK=charthick
@legende_var

IF NOT N_ELEMENTS(text) THEN text='(no text)'
IF NOT N_ELEMENTS(color) THEN color=!P.COLOR
IF NOT N_ELEMENTS(nonewline) THEN nonewline=0
IF NOT N_ELEMENTS(alignment) THEN alignment=0
IF NOT N_ELEMENTS(charthick) THEN charthick=!P.CHARTHICK

REPEAT BEGIN
    itab1=STRPOS(text,'\')
    itab2=-1
    IF itab1 NE -1 THEN BEGIN
        text1=STRMID(text,itab1+1)
        itab2=STRPOS(text1,'\')
        IF itab2 NE -1 THEN BEGIN
            ntab=DOUBLE(STRMID(text1,0,itab2))
        ENDIF
        text2=STRMID(text1,itab2+1)
        xyouts,legende_pos(0)+ch(0)*ntab,legende_pos(1),text2,/NORMAL,ALIGNMENT=alignment,CHARSIZE=legende_charsize,ORIENTATION=legende_orientation*90,CHARTHICK=charthick,COLOR=color
        text=STRMID(text,0,itab1)
    ENDIF
ENDREP UNTIL itab2 EQ -1

xyouts,legende_pos(0),legende_pos(1),text,/NORMAL,ALIGNMENT=alignment,CHARSIZE=legende_charsize,ORIENTATION=legende_orientation*90,CHARTHICK=charthick,COLOR=color
IF NOT nonewline THEN BEGIN
    legende_pos=legende_pos-legende_lh
ENDIF

RETURN
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO legende,abstand, $
            LINKS=links, $
            LEFT=left, $
            RECHTS=rechts, $
            RIGHT=right, $
            OBEN=oben, $
            TOP=top, $
            UNTEN=unten, $
            BOTTOM=bottom, $
            YPOS=ypos, $
            XPOS=xpos, $
            LINES=lines, $
            LINEHEIGHT=lineheight,$
            LENGTH=length, $
            CHARSIZE=charsize,$
            ORIENTATION=orientation, $ 
            DRAWFRAME=drawframe, $
            FRAMEBORDER=frameborder,$
            FRAMECOLOR=framecolor,$
            FRAMEBACKGROUND=framebackground,$
            FRAMELEFT=frameleft, $
            FRAMERIGHT=frameright,$
            FRAMELINES=framelines, $
            FRAMETOP=frametop, $
            FRAMEBOTTOM=framebottom

@legende_var

;Parameter bestimmen
ix=0
iy=0

IF KEYWORD_SET(links) THEN left=links
IF KEYWORD_SET(rechts) THEN right=rechts
IF KEYWORD_SET(unten) THEN bottom=unten
IF KEYWORD_SET(oben) THEN top=oben

IF KEYWORD_SET(left) THEN ix=0
IF KEYWORD_SET(right) THEN ix=1
IF KEYWORD_SET(bottom) THEN iy=0
IF KEYWORD_SET(top) THEN iy=1
IF N_ELEMENTS(xpos) THEN ix=xpos
IF N_ELEMENTS(ypos) THEN iy=ypos
IF NOT N_ELEMENTS(orientation) THEN orientation=0 ELSE orientation=(2L^30+orientation) MOD 4
IF NOT N_ELEMENTS(length) THEN legende_length=5 ELSE legende_length=length 
IF N_ELEMENTS(abstand) EQ 0 THEN BEGIN
    CASE orientation OF 
        0: abstand=7+3*ix
        1: abstand=7+3*iy
        2: abstand=7+3*(1-ix)
        3: abstand=7+3*(1-iy)
    END
ENDIF
IF NOT N_ELEMENTS(lines) THEN lines=1
IF NOT N_ELEMENTS(lineheight) THEN lineheight=1
IF N_ELEMENTS(charsize) THEN legende_charsize=charsize ELSE legende_charsize=1.
legende_orientation=orientation

ch=CONVERT_COORD([!D.X_CH_SIZE,!D.Y_CH_SIZE],[!D.Y_CH_SIZE,!D.X_CH_SIZE],/DEVICE,/TO_NORMAL)*legende_charsize

;definiere Einheiten
legende_lh=[0.D0,0.D0]
abstandx=0
abstandy=0
lhfac=1.5


frame=[[0,0],[0,0]]*1.D0
CASE orientation OF
    0: BEGIN 
          abstandx=abstand
          legende_lh[1]=lhfac*ch[1,0]
          IF KEYWORD_SET(bottom) THEN legende_lh=-legende_lh
          frame[1,1]=1
          legende_h=[0,ch[1,0]]
          legende_b=[ch[0,0],0]
       END
    1: BEGIN 
          abstandy=abstand
          legende_lh[0]=-lhfac*ch[0,1] 
          IF KEYWORD_SET(right) THEN legende_lh=-legende_lh
          frame[0,0]=1
          legende_h=[-ch[0,1],0]
          legende_b=[0,ch[1,1]]
       END
    2: BEGIN 
          abstandx=abstand
          legende_lh[1]=-lhfac*ch[1,0]
          IF KEYWORD_SET(top) THEN legende_lh=-legende_lh
          frame[1,0]=1
          legende_h=[0,-ch[1,0]]
          legende_b=[-ch[0,0],0]
       END
    3: BEGIN
          abstandy=abstand
          legende_lh[0]=lhfac*ch[0,1]
          IF KEYWORD_SET(left) THEN legende_lh=-legende_lh
          frame[0,1]=1
          Legende_h=[ch[0,1],0]
          legende_b=[0,-ch[1,1]]
       END
ENDCASE
legende_lh=legende_lh*lineheight

;bestimme Startposition
IF !X.TYPE EQ 0 THEN datax=!X.CRANGE ELSE datax=10.D0^!X.CRANGE
IF !Y.TYPE EQ 0 THEN datay=!Y.CRANGE ELSE datay=10.D0^!Y.CRANGE
eckpunkt=CONVERT_COORD(datax,datay,/DATA,/TO_NORMAL)
eckpunkt=eckpunkt[0:1,0:1]

ticklen=!P.TICKLEN*[1,1]
IF !X.TICKLEN NE 0 THEN ticklen[0]=!X.TICKLEN
IF !Y.TICKLEN NE 0 THEN ticklen[1]=!Y.TICKLEN

; bemahlbarer Bereich (ohne Tickmarks)
eckpunkt=eckpunkt $
  +(frame+1)*[[ch[0,0],ch[1,0]],-[ch[0,0],ch[1,0]]] $
  +[ticklen[0],ticklen[1],-ticklen[0],-ticklen[1]]*0.5

delta=eckpunkt[0:1,1]-eckpunkt[0:1,0]

;setze Positions-Startwerte fuer Grafik
legende_pos= $
  + eckpunkt[0:1,0] $
  + delta[0:1]*[ix,iy] $
  + legende_lh[0:1]*(lines-1) $
  + legende_b*[abstandx,abstandy]*(1-2*[ix,iy])

;draw frame
IF N_ELEMENTS(drawframe) EQ 0 THEN drawframe=0
IF N_ELEMENTS(frameborder) EQ 0 THEN frameborder=1
IF N_ELEMENTS(framecolor) EQ 0 THEN framecolor=!P.COLOR
IF N_ELEMENTS(framebackground) EQ 0 THEN framebackground=!P.BACKGROUND
IF N_ELEMENTS(frametop) EQ 0 THEN frametop=0
IF N_ELEMENTS(framebottom) EQ 0 THEN framebottom=0
IF N_ELEMENTS(frameleft) EQ 0 THEN frameleft=legende_length+2
IF N_ELEMENTS(frameright) EQ 0 THEN frameright=abstand+1 ; as good as any guess...
IF N_ELEMENTS(framelines) EQ 0 THEN framelines=lines

IF drawframe THEN BEGIN
    p=DBLARR(4)
    p(0:1)=legende_pos+(1.0+frametop)*legende_h-frameleft*legende_b
    p(2:3)=legende_pos-(0.5+framebottom)*legende_h+frameright*legende_b
    i=(TOTAL(legende_h*legende_lh) GT 0)
    p(2*i:2*i+1)=p(2*i:2*i+1)-legende_lh*(framelines-1)
    x=[0,2,2,0,0]
    y=[1,1,3,3,1]
    POLYFILL,p(x),p(y),COLOR=framebackground,NOCLIP=0,/NORMAL
    IF frameborder THEN plots,p(x),p(y),/NORMAL,COLOR=framecolor
ENDIF

RETURN
END
