PRO plotconv, $
  TSTART=tstart0, $
  TEND=tend, $
  SSTART=sstart, $
  SEND=send, $
  MODELS=models, $
  NSTART=nstart, $
  NEND=nend, $
  MSTART=mstart, $
  MEND=mend, $
  FIRSTMODELL=firstmodell, $
  LASTMODELL=lastmodell, $
  MLOW=mlow, $
  MHIGH=mhigh, $
  LOGTIME=logtime0, $
;
  SHOWMODELS=showmodels, $
;
  SHOWCONV=showconv, $
  SHOWSEMI=showsemi, $
  SHOWENERGY=showenergy, $
  QUICKVIEW=quickview, $
  MAXPOLY=maxpoly, $
  NUCLEAR=nuclear, $
  NEUTRINO=neutrino, $
  SHOWLEGEND=showlegend, $
  RADIUS=radius, $
  XRANGE=xrange, $
  YRANGE=yrange, $
  NEUTRAL=neutral, $
  CONVECTION=convection, $
  SEMICONV=semiconv,$
  ZEROTIME=zerotime0, $
  ZEROSIME=zerosime0, $
  SHOWLOSS=showloss, $
  SHOWGAIN=showgain, $
  NUCGAIN=nucgain, $
  NUCLOSS=nucloss, $
  NEUGAIN=neugain, $
  NEULOSS=neuloss, $
  MONOCHROME=monochrome, $
  XTITLE=xtitle0, $
  YTITLE=ytitle0, $
  FRAMECONV=frameconv, $
  PATTERNSCALE=patternscale, $
  PATTERNSPACE=patternspace, $
  PATTERNCONVSPACE=patternconvspace, $
  PATTERNSEMISPACE=patternsemispace, $
  PATTERNOSHTSPACE=patternoshtspace, $
  PATTERNNEUTSPACE=patternneutspace, $
  PATTERNTHALSPACE=patternthalspace, $
  PATTERNTHICK=patternthick, $
  YRESOLUTION=yresolution,XRESOLUTION=xresolution, $
  RESOLUTION=resolution,MAXLEVEL=maxlevel, $
  RECTANGULAR=rectangular,LEVELS=levels, $
  CHARSIZE=charsize, $
  XCHARSIZE=xcharsize, $
  YCHARSIZE=ycharsize, $
  XMARGIN=xmargin, $
  YMARGIN=ymargin, $
  XTICKFORMAT=xtickformat,$
  YTICKFORMAT=ytickformat, $
  CONVHATCH=convhatch, $
  SEMIHATCH=semihatch, $
  NEUTHATCH=neuthatch, $
  VERBOSE=verbose, $
  TOTMASSTHICK=totmassthick, $
  TIMESCALE=timescale, $
  TIMEUNIT=timeunit, $
  LEGSCALE=legscale, $
  LEGCHARTHICK=legcharthick, $
  LEGCHARSIZE=legcharsize,  $
  ENDTIME=endtime,$
  REDSHIFT=redshift, $ ; e.g., gravitational redshift
  OVERSHOOT=overshoot,$
  OSHTHATCH=oshthatch, $
  THERMOHAL=thermohal, $
  THALHATCH=thalhatch, $
  TITLE=title0, $
  SHOWTIME=showtime, $
  SATURATION=saturation, $
  CONVSAT=convsat, $
  CONVHUE=convhue, $
  CGS=cgs, $
  SECONDS=seconds, $
  MINUTES=minutes, $
  HOURS=hours, $
  DAYS=days, $
  YEARS=years, $
  GAINMIN=gainmin, $
  LOSSMIN=lossmin, $
  GAINMAX=gainmax, $
  LOSSMAX=lossmax, $
  CONVLOW=convlow, $ ; still needs better implementation
; and for "sphaghetti" plots
  XXFRAC=xxfrac, $
  XXRANGE=xxrange, $
  XXANO=xxano, $
  XXNOTICK=xxnotick, $
  XXTICKINTERVAL=xxtickinterval, $
  XXTICKFORMAT=xxtickformat, $
  XXTITLE=xxtitle, $
  XXLABEL=xxlabel, $
  XTANGLE=xtangle, $
;
  CONVLEGXY=convlegxy, $
  CONVLEGFRAME=convlegframe, $
  MASSZERO=masszero, $  ; set where 0 is in the figure (offset y axis)
  MASSSCALE=massscale, $  ; set scaling factor for mass coordinate; this is applied before masszero
  PTIME=ptime, $ ; output quantity -- xmap from spaghetti
  YOFFSET=yoffset, $ ; output quantity -- from scaleaxis
  XOFFSET=xoffset, $
  YFAC=yfac, $
  XFAC=xfac, $
; some things for XRB -- column depth
  SURFACE=surface, $ ;
  COLUMN=column, $
  COLRAD=colrad, $
  COLSCALE=colscale, $
  ALOGTIME=alogtime0, $
  SURFZERO=surfzero, $
  YLOG=ylog, $ ; to be implemented
; selection
  SELECT=select, $
; erg/cm/s plots
  CM=cm, $
  TOTSMOOTH=totsmooth, $
; plotting
   PS=ps, $
   PDF=pdf

@physconst

COMMON conv, nmodellmax,nnergmax,nergmax,nconvmax,nnerg,nerg,erg,nconv,conv,convr,convtype,time,timecc,modellnr,modells
COMMON konv, nkonvmax,nsemimax,nneutmax,noshtmax,nthalmax,nkonv,nsemi,nneut,nosht,nthal,konv,semi,neut,osht,thal,konvr,semir,neutr,oshtr,thalr
COMMON conv2, nnerkmax,nerkmax,nnerk,nerk,erk,nbermax,nber,ber
COMMON conv3, nnnukmax,nnukmax,nnnuk,nnuk,nuk
COMMON conv5, nlerg,nlerk,nlnuk
COMMON conv6, summ0,levcnv,minloss,mingain,minnucl,minnucg
COMMON conv7, nnnucmax,nnucmax,nnnuc,nnuc,nuc,nlnuc
COMMON conv8, radius0,ergr,erkr,nukr,nucr,minvers,maxvers
COMMON conv9, nnergdmax,nergdmax,nnergd,nergd,ergd,ergdr,nlergd
COMMON conv10,nnerkdmax,nerkdmax,nnerkd,nerkd,erkd,erkdr,nlerkd
COMMON conv11,nnnukdmax,nnukdmax,nnnukd,nnukd,nukd,nukdr,nlnukd
COMMON conv12,nnnucdmax,nnucdmax,nnnucd,nnucd,nucd,nucdr,nlnucd
COMMON conv13,minlossd,mingaind,minnucld,minnucgd
COMMON konv2, xmstar,rstar
COMMON plotlayer,npol,maxpol,nvert,nrem,nvertraw,nremraw
COMMON COLORS, R_ORIG, G_ORIG, B_ORIG, R_CURR, G_CURR, B_CURR
COMMON conv17,minneul,minneug,minneuld,minneugd
COMMON conv18,nnneudmax,nneudmax,nnneud,nneud,neud,neudr,nlneud
COMMON conv19,nnnevdmax,nnevdmax,nnnevd,nnevd,nevd,nevdr,nlnevd
COMMON conv20,nnneumax,nneumax,nnneu,nneu,neu,neur,nlneu
COMMON conv21,nnnevmax,nnevmax,nnnev,nnev,nev,nevr,nlnev

IF N_ELEMENTS(ps) EQ 0 THEN ps=''
IF N_ELEMENTS(pdf) EQ 0 THEN pdf=''

IF (ps NE '') OR (pdf NE '') THEN BEGIN
   plotfile=ps
   IF pdf NE '' THEN BEGIN 
      plotfile=pdf
      ipdf=1
   ENDIF ELSE BEGIN
      plotfile=ps
      ipdf=0
   ENDELSE      
   openpsfl,plotfile,pdf=ipdf
ENDIF

IF N_ELEMENTS(select) EQ 0 THEN select=0
selectloop:

starttime=SYSTIME(/SECONDS)

xmargin_def=!X.MARGIN
ymargin_def=!Y.MARGIN

IF N_ELEMENTS(cgs) EQ 0 THEN cgs=0
IF N_ELEMENTS(cm) EQ 0 THEN cm=0
IF (cm NE 0) AND (N_ELEMENTS(radius) EQ 0) THEN radius=1
IF N_ELEMENTS(radius) EQ 0 THEN radius=0
IF N_ELEMENTS(verbose) EQ 0 THEN verbose=1
IF N_ELEMENTS(showtime) EQ 0 THEN showtime=1

IF N_ELEMENTS(convlow) EQ 0 THEN convlow=0.0D0

IF N_ELEMENTS(maxpoly) EQ 0 THEN maxpol=200000L ELSE maxpol=maxpoly

IF N_ELEMENTS(nmodellmax) EQ 0 THEN loadconv
IF N_ELEMENTS(nkonvmax) EQ 0 THEN convkonv

IF N_ELEMENTS(title0) NE 0 THEN showmodels=0

; precedence: logtime,alogtime,endtime,models
IF N_ELEMENTS(logtime0) EQ 0 THEN logtime=0 ELSE logtime=10.0D0^logtime0
IF logtime NE 0 THEN BEGIN
    endtime=0
    models=0
    alogtime=0
 ENDIF
IF N_ELEMENTS(alogtime0) EQ 0 THEN alogtime=0 ELSE alogtime=10.0D0^alogtime0
IF alogtime NE 0 THEN BEGIN
    endtime=0
    models=0
 ENDIF
IF N_ELEMENTS(endtime) EQ 0 THEN endtime=0
IF endtime NE 0 THEN BEGIN
    models=0
ENDIF
IF N_ELEMENTS(models) EQ 0 THEN models=0
IF N_ELEMENTS(showmodels) EQ 0 THEN showmodels=models EQ 0

IF N_ELEMENTS(showlegend) EQ 0 THEN showlegend=3
IF N_ELEMENTS(legscale) EQ 0 THEN legscale=1.0

IF N_ELEMENTS(seconds) EQ 0 THEN seconds=0
IF seconds EQ 1 THEN BEGIN
    timescale=1.D0/SEC
    timeunit='s'
ENDIF

IF N_ELEMENTS(minutes) EQ 0 THEN minutes=0
IF minutes EQ 1 THEN BEGIN
    timescale=60.D0/SEC
    timeunit='min'
ENDIF

IF N_ELEMENTS(hours) EQ 0 THEN hours=0
IF hours EQ 1 THEN BEGIN
    timescale=3600.D0/SEC
    timeunit='h'
ENDIF

IF N_ELEMENTS(days) EQ 0 THEN days=0
IF days EQ 1 THEN BEGIN
    timescale=86400.D0/SEC
    timeunit='d'
ENDIF

IF N_ELEMENTS(years) EQ 0 THEN years=0
IF years EQ 1 THEN BEGIN
    timescale=1.D0
    timeunit='yr'
ENDIF

IF N_ELEMENTS(timescale) EQ 0 THEN timescale=1.0D0
IF N_ELEMENTS(timeunit) EQ 0 THEN timeunit='yr'

IF N_ELEMENTS(redshift) EQ 0 THEN redshift=0.D0
timescale/=(1.D0+redshift)

IF N_ELEMENTS(tstart0) NE 0 THEN tstart=tstart0

IF N_ELEMENTS(sstart) NE 0 THEN tstart=time(modells-1)/timescale-sstart
IF N_ELEMENTS(send) NE 0 THEN tend=time(modells-1)/timescale-send

setxrange=0
IF N_ELEMENTS(xrange) EQ 2 THEN BEGIN
    tstart=xrange[0]
    tend=xrange[1]
    setxrange=1
ENDIF

IF N_ELEMENTS(mstart) NE 0 THEN nstart=modells-mstart-1L
IF N_ELEMENTS(mend) NE 0 THEN nend=modells-mend-1L

IF N_ELEMENTS(quickview) EQ 0 THEN quickview=-1L

IF cgs EQ 1 THEN BEGIN
    radiusfac=RSUN
    massfac=XMSUN
    ytitm='m / g'
    ytitr='r / cm'
ENDIF ELSE BEGIN
    radiusfac=1.D0
    massfac=1.D0
    ytitm='m / M!b!9n!3!n'
    ytitr='r / R!b!9n!3!n'
ENDELSE

IF N_ELEMENTS(nuclear) EQ 0 THEN nuclear=0
IF N_ELEMENTS(neutrino) EQ 0 THEN neutrino=0

; level setup
maxlevcol=16 ; maximum number of colors
; magnitude of lowest level

IF cm NE 0 THEN BEGIN
    IF neutrino THEN BEGIN
        lowlevelexpg=MIN(minneugd)
        lowlevelexpl=MIN(minneuld)
     ENDIF ELSE IF nuclear THEN BEGIN
        lowlevelexpg=MIN(minnucgd)
        lowlevelexpl=MIN(minnucld)
    ENDIF ELSE BEGIN
        lowlevelexpg=MIN(mingaind)
        lowlevelexpl=MIN(minlossd)
    ENDELSE
ENDIF ELSE BEGIN
;    lowlevelexp=-1
   IF neutrino THEN BEGIN
      lowlevelexpg=MIN(minneug)
      lowlevelexpl=MIN(minneul)
   ENDIF ELSE IF nuclear THEN BEGIN
      lowlevelexpg=MIN(minnucg)
      lowlevelexpl=MIN(minnucl)
   ENDIF ELSE BEGIN
      lowlevelexpg=MIN(mingain)
      lowlevelexpl=MIN(minloss)
   ENDELSE
ENDELSE

IF N_ELEMENTS(gainmin) EQ 0 THEN gainmin=lowlevelexpg
IF N_ELEMENTS(lossmin) EQ 0 THEN lossmin=lowlevelexpl
lossmin>=lowlevelexpl
gainmin>=lowlevelexpg
IF N_ELEMENTS(gainmax) EQ 0 THEN gainmax=gainmin+maxlevcol-1
IF N_ELEMENTS(lossmax) EQ 0 THEN lossmax=lossmin+maxlevcol-1
IF N_ELEMENTS(maxlevel) EQ 0 THEN maxlevel=1+MAX([0,[gainmax-lowlevelexpg,lossmax-lowlevelexpl]])
IF N_ELEMENTS(levels) EQ 0 THEN BEGIN
    showlevels=REPLICATE(0,maxlevel*2+1)
    showlevels[maxlevel-1-lossmin+lowlevelexpl-INDGEN(1+MAX([0,lossmax-lossmin]))]=1
    showlevels[maxlevel+1+gainmin-lowlevelexpg+INDGEN(1+MAX([0,gainmax-gainmin]))]=1
ENDIF ELSE BEGIN
    maxlevel=MAX(ABS(levels))
    showlevels=REPLICATE(0,maxlevel*2+1)
    showlevels(maxlevel+levels)=1
ENDELSE

usedlevels=REPLICATE(0,maxlevel*2+1)
usedlevels(maxlevel)=1
maxlevelp=maxlevel+1
maxlevelm=maxlevel-1
clevels=DBLARR(maxlevel*2+1)
clevels(maxlevel)=255
j=0
FOR i=maxlevelm,0,-1 DO BEGIN
    IF showlevels(i) EQ 1 THEN BEGIN
        clevels(i)=64+j
        j=j+1
    ENDIF
ENDFOR
j=0
FOR i=maxlevelp,2*maxlevel DO BEGIN
    IF showlevels(i) EQ 1 THEN BEGIN
        clevels(i)=48+j
        j=j+1
    ENDIF
ENDFOR

IF N_ELEMENTS(thermohal) EQ 0 THEN thermohal=0
IF N_ELEMENTS(overshoot) EQ 0 THEN overshoot=0
IF N_ELEMENTS(neutral) EQ 0 THEN neutral=0
IF N_ELEMENTS(convection) EQ 0 THEN convection=1
IF N_ELEMENTS(semiconv) EQ 0 THEN semiconv=1

ptime=time/timescale

IF N_ELEMENTS(nstart) EQ 0 THEN nstart=0L ELSE nstart=nstart*1L
IF N_ELEMENTS(nend) EQ 0 THEN nend=modells-1L ELSE nend=nend*1L

IF N_ELEMENTS(frameconv) EQ 0 THEN frameconv=3
IF N_ELEMENTS(showconv) EQ 0 THEN showconv=1
IF N_ELEMENTS(showsemi) EQ 0 THEN showsemi=showconv
IF N_ELEMENTS(showenergy) EQ 0 THEN showenergy=1
IF (radius NE 0) AND (N_ELEMENTS(ergr) LE 2) THEN BEGIN
    showenergy=0
ENDIF
IF N_ELEMENTS(showloss) EQ 0 THEN showloss=1
IF N_ELEMENTS(showgain) EQ 0 THEN showgain=1

IF N_ELEMENTS(nucgain) EQ 0 THEN nucgain=1
IF N_ELEMENTS(nucloss) EQ 0 THEN nucloss=1

IF N_ELEMENTS(neugain) EQ 0 THEN neugain=1
IF N_ELEMENTS(neuloss) EQ 0 THEN neuloss=1
IF neutrino NE 0 THEN BEGIN
   showgain=0
   showloss=0
   nucgain=0
   nucloss=0
ENDIF ELSE IF nuclear NE 0 THEN BEGIN
   showgain=0
   showloss=0
   neugain=0
   neuloss=0
ENDIF ELSE BEGIN
   nucgain=0
   nucloss=0
   neugain=0
   neuloss=0
ENDELSE
IF N_ELEMENTS(nuc) LE 2 THEN nucloss=0
IF N_ELEMENTS(nev) LE 2 THEN neuloss=0
IF showenergy EQ 0 THEN BEGIN
   showgain=0
   showloss=0
   nucgain=0
   nucloss=0
   neugain=0
   neuloss=0
ENDIF
IF (nucgain EQ 0) AND (showgain EQ 0) AND $
   (nucloss EQ 0) AND (showloss EQ 0) AND $
   (neuloss EQ 0) AND (neugain EQ 0) THEN showlegend=0

IF N_ELEMENTS(monochrome) EQ 0 THEN monochrome=0
IF N_ELEMENTS(saturation) EQ 0 THEN saturation=1.0D0

IF N_ELEMENTS(convsat) EQ 0 THEN convsat=1.D0
IF N_ELEMENTS(convhue) EQ 0 THEN convhue=1.D0

IF logtime NE 0 THEN BEGIN
    ntcc=N_ELEMENTS(timecc)-1
    ptime=ALOG10((timecc+logtime)/timescale)
    ttcc=time(N_ELEMENTS(time)-1)+logtime
    IF N_ELEMENTS(tstart) NE 0 THEN tstart=ALOG10((ttcc-tstart)/timescale)
    IF N_ELEMENTS(tend) NE 0 THEN tend=ALOG10((ttcc-tend)/timescale)
ENDIF

IF alogtime NE 0 THEN BEGIN
    IF N_ELEMENTS(tstart) EQ 0 THEN tstart=time[nstart]
    ptime=ALOG10(((time-tstart)/timescale+alogtime)>1.d-99)
    IF N_ELEMENTS(tend) NE 0 THEN tend=ALOG10((tend-tstart)/timescale+alogtime)
    tstart=ALOG10(alogtime)
ENDIF

IF endtime THEN BEGIN
    ptime=timecc/timescale
ENDIF

; "spaghetti" plot setip
spaghetti=0
IF N_ELEMENTS(xxfrac) GT 2 THEN spaghetti=1

IF spaghetti EQ 1 THEN BEGIN
    tstart=xxrange[0]
    tend=xxrange[N_ELEMENTS(xxrange)-1]
ENDIF

; need to determine direction of time in plot
trev=0
IF logtime NE 0 THEN trev=1
IF endtime NE 0 THEN trev=1

; determine plot time limits
IF N_ELEMENTS(tstart) NE 0 THEN BEGIN
    thi=MAX(ptime[[nstart,nend-1]],MIN=tlo)
    tstart=MIN([MAX([tstart,tlo]),thi])
    IF trev THEN BEGIN
        WHILE tstart LT ptime(nstart) DO nstart=nstart+1L
    ENDIF ELSE BEGIN
        WHILE tstart GT ptime(nstart) DO nstart=nstart+1L
     ENDELSE
    nstart=MAX([0,nstart-1])
ENDIF ELSE tstart=ptime(nstart)
IF N_ELEMENTS(tend) NE 0 THEN BEGIN
    thi=MAX(ptime[[nstart+1,nend]],MIN=tlo)
    tend=MIN([MAX([tend,tlo]),thi])
    IF trev THEN BEGIN
        WHILE tend GT ptime(nend) DO nend=nend-1L
    ENDIF ELSE BEGIN
        WHILE tend LT ptime(nend) DO nend=nend-1L
    ENDELSE
    nend=MIN([N_ELEMENTS(ptime)-1,nend+1])
ENDIF ELSE tend=ptime(nend)

IF N_ELEMENTS(firstmodell) EQ 0 THEN firstmodell=-1
IF N_ELEMENTS(lastmodell) EQ 0 THEN lastmodell=-1

IF firstmodell NE -1 THEN BEGIN
  firstmodell=firstmodell*1L
  while firstmodell GT modellnr(nstart) DO nstart=nstart+1L
  tstart=ptime(nstart)
ENDIF
IF lastmodell NE -1 THEN BEGIN
  lastmodell=lastmodell*1L
  while lastmodell LT modellnr(nend) DO nend=nend-1L
  tend=ptime(nend)
ENDIF

nstart=MAX([0,MIN([nstart,modells-2])])
nend=MIN([modells-1,MAX([nstart+1,nend])])

IF N_ELEMENTS(zerotime0) EQ 0 THEN BEGIN
    dozerotime=0
    zerotime=0
ENDIF ELSE BEGIN
    dozerotime=1
    zerotime=zerotime0
ENDELSE

IF N_ELEMENTS(zerosime0) EQ 0 THEN BEGIN
    dozerosime=0
    zerosime=0
ENDIF ELSE BEGIN
    dozerosime=1
    zerosime=zerosime0
ENDELSE

IF models THEN BEGIN
    ptime0=ptime
    ptime=findgen(modells+1)
    xtit='model'
    logtime=0
    endtime=0
    tstart=ptime(nstart)
    tend=ptime(nend)
    xrange=[tstart,tend]
ENDIF ELSE IF logtime NE 0 THEN BEGIN
    xtit='log(!i !ntime till core collapse / '+timeunit+'!i !n)'
ENDIF ELSE IF alogtime NE 0 THEN BEGIN
    xtit='log(!i !ntime / '+timeunit+'!i !n)'
ENDIF ELSE BEGIN
    IF endtime THEN BEGIN
        xtit1='time till core collapse'
    ENDIF ELSE BEGIN
        xtit1='t'
    ENDELSE
    xtit2=timeunit
    xtit=xtit1+'!i !n/!i !n'+xtit2
ENDELSE

;IF (logtime NE 0) THEN BEGIN
;    dt0=logtime
;    ptime(nstart:nend)=ALOG10(ptime(nend)-ptime(nstart:nend)+dt0)
;ENDIF

;tstart=ptime(nstart)
;tend=ptime(nend)

mass=DBLARR(modells)
IF radius EQ 0 THEN BEGIN
    mass[nstart:nend]=xmstar[nstart:nend]
    fac=massfac
    ytit=ytitm
ENDIF ELSE BEGIN
    mass[nstart:nend]=rstar[nstart:nend]
    ytit=ytitr
    fac=radiusfac
ENDELSE

IF N_ELEMENTS(column) EQ 0 THEN column=0
IF N_ELEMENTS(colscale) EQ 0 THEN colscale=1.D0
IF N_ELEMENTS(colrad) EQ 0 THEN colrad=1.d6 ; good for XRBs
IF column EQ 1 THEN BEGIN
    ytit='column depth / g/cm!a2!n'
    fac=XMSUN/(4.D0*!DPI*colrad^2 * colscale)
;    surface=1
ENDIF

convlow=convlow/fac

IF N_ELEMENTS(surfzero) EQ 0 THEN surfzero=-1
IF N_ELEMENTS(masszero) EQ 0 THEN masszero=0
IF N_ELEMENTS(massscale) EQ 0 THEN massscale=1
IF surfzero GE 0 THEN BEGIN
   masszero=xmstar[surfzero]*fac/massscale
   IF N_ELEMENTS(mlow) NE 0 THEN mlow+=masszero*massscale
   IF N_ELEMENTS(mhigh) NE 0 THEN mhigh+=masszero*massscale
ENDIF

IF N_ELEMENTS(mlow) EQ 0 THEN mlow=0
IF N_ELEMENTS(mhigh) EQ 0 THEN mhigh=-1.1D99
IF mhigh LT -1.D99 THEN mhigh=MAX(mass(nstart:nend))*fac

IF N_ELEMENTS(yrange) NE 2 THEN yrange=[mlow,mhigh]
IF N_ELEMENTS(surface) EQ 0 THEN surface=0
IF surface NE 0 THEN yrange=yrange[[1,0]]

mhigh=mhigh/massscale-masszero
mlow=mlow/massscale-masszero
yrange=yrange/massscale-masszero

IF N_ELEMENTS(ylog) EQ 0 THEN ylog=0
IF ylog NE 0 THEN BEGIN
   mhigh=ALOG10(mhigh)
   mlow=ALOG10(mlow)
   yrange=ALOG10(yrange)
   IF yrange[1] LT -1.D99 THEN BEGIN 
      yrange[1]=0 
   ENDIF
   ytit='log( '+ytit+' )'
ENDIF

offset=0.0D0
IF (mhigh-mlow)/(mhigh+mlow) LT 1.D-2 THEN BEGIN
    scaleaxis,yrange,/rescale,x0=offset,TITLE=ytit,POWERFACTOR=xmag,LIMIT=1,POWERRANGE=0,/LARGESUBSCRIPTS
    xmag=1
    offset=offset/xmag
    fac=fac/xmag
ENDIF
yoffset=offset ; output quantity
offset=offset+masszero
offset=REPLICATE(offset,modells+1)
yfac=fac
fac=fac/massscale
fac=REPLICATE(fac,modells+1)


IF N_ELEMENTS(rectangular) EQ 0 THEN rectangular=1
IF (NOT rectangular) AND (quickview GT 0) THEN BEGIN
    PRINT,' [PLOTCONV] WARNING: rectangular=0 not supported for quickview > 0'
    rectangular=1
ENDIF

; time-dependent scaling factor & offset
IF surface EQ 1 THEN BEGIN
    IF (nend-nstart) GT 0 THEN BEGIN
        IF rectangular THEN BEGIN
            xmass=DBLARR(modells+1,/NOZERO)
;            xmass(nstart+1:nend)=0.5D0*(mass(nstart:nend-1)+mass(nstart+1:nend))
;            xmass([nstart,nend+1])=mass([nstart,nend])
            xmass(nstart:nend)=mass(nstart:nend)
            xmass([nend+1])=mass([nend+1<nmodellmax-1])
            offset[nstart:nend+1]=-xmass[nstart:nend+1]*fac[nstart:nend+1]
            fac[nstart:nend+1]=-fac[nstart:nend+1]
        ENDIF ELSE BEGIN
            offset[nstart:nend]=-mass[nstart:nend]*fac[nstart:nend]
            fac[nstart:nend]=-fac[nstart:nend]
        ENDELSE
    ENDIF ELSE BEGIN
        idxrec=[nstart,nend+1]
        offset[idxrec]=-mass[idxrec]*fac[idxrec]
        fac[idxrec]=-fac[idxrec]
    ENDELSE
ENDIF

IF N_ELEMENTS(xrange) NE 0 THEN rangex=xrange
offsetx=zerotime/timescale
IF dozerosime NE 0 THEN BEGIN
   offsetx=ptime[N_ELEMENTS(ptime)-1]-zerosime/timescale
   dozerotime=1
ENDIF

xmagx=1.D0
IF (spaghetti EQ 0) and (logtime EQ 0) and (alogtime EQ 0) THEN BEGIN
    scaleaxis,ptime,ISTART=nstart,IEND=NEND,TITLE=xtit,VARIABLE=xtit1,UNIT=xtit2,LOGMIN=ALOG10(MAX([logtime,alogtime,1.D-99])),LIMIT=2,/RESCALE,POWERRANGE=0,X0=offsetx,SETX0=dozerotime,/LARGESUBSCRIPTS,POWERFACTOR=xmagx,RANGE=rangex,SETRANGE=setxrange
ENDIF

; test
xrange=([tstart,tend]-offsetx)*xmagx

xoffset=offsetx
xfac=xmagx


; don't know what this is good for
;IF logtime EQ 0 THEN BEGIN
;    xoffset=zerotime/timescale
;    scaleaxis,ptime,ISTART=nstart,X0=xoffset,XMAG=xmagx,IEND=NEND,TITLE=xtit,VARIABLE=xtit1,UNIT=xtit2,LIMIT=2,/RESCALE,POWERRANGE=0,SETX0=dozerotime,/LARGESUBSCRIPTS
;ENDIF
;xrange=ptime([nstart,nend])


IF N_ELEMENTS(xtitle0) EQ 0 THEN xtitle=xtit ELSE xtitle=xtitle0
IF N_ELEMENTS(ytitle0) EQ 0 THEN ytitle=ytit ELSE ytitle=ytitle0



IF !D.N_COLORS LE 256 THEN BEGIN
; color table
    IF monochrome NE 0 THEN BEGIN
        max_dark=monochrome
        TVLCT,/HSV,REPLICATE(000,16),REPLICATE(0,16),(15-FINDGEN(16))/16,16
        TVLCT,/HSV,REPLICATE(000,16),REPLICATE(0,16),(15-FINDGEN(16))/16,32
        TVLCT,/HSV,REPLICATE(000,16),REPLICATE(0,16),(1.-max_dark*(1.-(15-FINDGEN(16))/16)),48
        TVLCT,/HSV,REPLICATE(000,16),REPLICATE(0,16),(1.-max_dark*(1.-(15-FINDGEN(16))/16)),64
        TVLCT,/HSV,REPLICATE(000,16),REPLICATE(0,16),(15-FINDGEN(16))/16,80
        TVLCT,/HSV,REPLICATE(000,16),REPLICATE(0,16),(15-FINDGEN(16))/16,112
    ENDIF ELSE BEGIN
        max_dark=saturation
        TVLCT,/HSV,REPLICATE(000,16),(1+FINDGEN(16))/16,REPLICATE(1,16),16
        TVLCT,/HSV,REPLICATE(120,16),convsat*(1+FINDGEN(16))/16,REPLICATE(convhue,16),32
;        TVLCT,/HSV,REPLICATE(000,16),(1+FINDGEN(16))/16,REPLICATE(1,16),32
;        TVLCT,/HSV,REPLICATE(120,16),convsat*(1+FINDGEN(16))/16,REPLICATE(convhue,16),16
        TVLCT,/HSV,REPLICATE(240,16),max_dark*(1+FINDGEN(16))/16,REPLICATE(1,16),48
        TVLCT,/HSV,REPLICATE(285,16),max_dark*(1+FINDGEN(16))/16,REPLICATE(1,16),64
        TVLCT,/HSV,REPLICATE(180,16),(1+FINDGEN(16))/16,REPLICATE(1,16),80
        TVLCT,/HSV,REPLICATE(060,16),(1+FINDGEN(16))/16,REPLICATE(1,16),112
    ENDELSE
    color=INDGEN(256)
    TVLCT,/HSV,REPLICATE(0,16),REPLICATE(0,16),(16-FINDGEN(16))/16,96
    TVLCT,[0,0,255],[0,255,0],[255,0,0],1
    TVLCT,[0],[0],[0],0
    TVLCT,[255],[255],[255],255
ENDIF ELSE BEGIN
; (Pseudo) True-color mode
    color=REPLICATE(0L,256)
    color[0]=RGB(0,/CLEAR,palette=0)
    color[255]=RGB_GRAY(255,palette=255)
    color[1:3]=RGB([0,0,255],[0,255,0],[255,0,0])
    !P.COLOR=color[0]
    !P.BACKGROUND=color[255]
    IF monochrome NE 0 THEN BEGIN
        max_dark=monochrome
        color[16:31]=RGB_GRAY((240-INDGEN(16)*16)/255.)
        color[32:47]=RGB_GRAY((240-INDGEN(16)*16)/255.)
        color[48:63]=RGB_GRAY((1.-max_dark*(1.-(15-FINDGEN(16))/16.)))
        color[64:79]=RGB_GRAY((1.-max_dark*(1.-(15-FINDGEN(16))/16.)))
        color[80:95]=RGB_GRAY((240-FINDGEN(16)*16)/255.)
        color[112:127]=RGB_GRAY((1.-max_dark*(1.-(15-FINDGEN(16))/16.)))
    ENDIF ELSE BEGIN
        max_dark=saturation
        color[16:31]=HSV_COLOR(REPLICATE(1,16),(1+FINDGEN(16))/16,REPLICATE(000,16))
        color[32:47]=HSV_COLOR(REPLICATE(convhue,16),convsat*(1+FINDGEN(16))/16,REPLICATE(120,16))
;        color[32:47]=HSV_COLOR(REPLICATE(1,16),(1+FINDGEN(16))/16,REPLICATE(000,16))
;        color[16:31]=HSV_COLOR(REPLICATE(convhue,16),convsat*(1+FINDGEN(16))/16,REPLICATE(120,16))
        color[48:63]=HSV_COLOR(REPLICATE(1,16),max_dark*(1+FINDGEN(16))/16,REPLICATE(240,16))
        color[64:79]=HSV_COLOR(REPLICATE(1,16),max_dark*(1+FINDGEN(16))/16,REPLICATE(285,16))
        color[80:95]=HSV_COLOR(REPLICATE(1,16),(1+FINDGEN(16))/16,REPLICATE(180,16))
        color[112:127]=HSV_COLOR(REPLICATE(1,16),(1+FINDGEN(16))/16,REPLICATE(060,16))
    ENDELSE
    color[96:111]=RGB_GRAY((16-FINDGEN(16))/16.)
ENDELSE

IF (NOT showmodels) AND (N_ELEMENTS(title0) EQ 0) THEN ymargin_def(1)=0.0
IF spaghetti THEN ymargin_def=ymargin_def+0.5
CASE showlegend OF
    1: xmargin_def(1)=xmargin_def(1)*legscale*1.15
    3: xmargin_def(1)=xmargin_def(1)*legscale*1.34
    4: xmargin_def(1)=xmargin_def(1)*legscale*2.35
    2: xmargin_def(1)=xmargin_def(1)*legscale*0.675
    ELSE: xmargin_def(1)=0.0
ENDCASE
xmargin_def(0)=5.5
ymargin_def(0)=3.2
IF N_ELEMENTS(xmargin) NE 2 THEN xmargin=xmargin_def
IF N_ELEMENTS(ymargin) NE 2 THEN ymargin=ymargin_def
IF N_ELEMENTS(charsize) EQ 0 THEN charsize=!P.charsize
IF N_ELEMENTS(xcharsize) EQ 0 THEN xcharsize=!X.charsize
IF N_ELEMENTS(ycharsize) EQ 0 THEN ycharsize=!Y.charsize
IF N_ELEMENTS(xtickformat) EQ 0 THEN xtickformat=!X.tickformat
IF N_ELEMENTS(ytickformat) EQ 0 THEN ytickformat=!Y.tickformat
IF N_ELEMENTS(totmassthick) EQ 0 THEN totmassthick=!P.THICK

multi_save=!P.MULTI

IF quickview GT 0 THEN axis_style=1 ELSE axis_style=5

IF spaghetti THEN BEGIN
    IF N_ELEMENTS(xxlabel) EQ 0 THEN xxlabel=0
    IF xxlabel[0] EQ 1 THEN BEGIN
; auto label
        nlab=N_ELEMENTS(XXFRAC)-1
        xxlabel=REPLICATE('',nlab)
        xxtickinterval=REPLICATE(1.D0,nlab)
        FOR i=0,nlab-1 DO BEGIN
            xxlabel[i]=TIME2HUMAN(xxrange[i+1]-xxrange[i],NUMERIC=xlabnum,SCALE=labscale)
            xlabdiv0=xlabnum/2.5D0
            IF xlabdiv0 LE 0.1 THEN BEGIN
                xxtickinterval[i]=0
            ENDIF ELSE IF xlabdiv0 LE 0.2 THEN BEGIN
                xxtickinterval[i]=0.1
            ENDIF ELSE IF xlabdiv0 LT 0.5 THEN BEGIN
                xxtickinterval[i]=0.2
            ENDIF ELSE IF xlabdiv0 LT 1.0 THEN BEGIN
                xxtickinterval[i]=0.5
            ENDIF ELSE IF xlabdiv0 LT 2 THEN BEGIN
                xxtickinterval[i]=1
            ENDIF ELSE IF xlabdiv0 LT 5 THEN BEGIN
                xxtickinterval[i]=2
            ENDIF ELSE IF xlabdiv0 LT 10 THEN BEGIN
                xxtickinterval[i]=5
            ENDIF ELSE IF xlabdiv0 LT 20 THEN BEGIN
                xxtickinterval[i]=10
            ENDIF ELSE IF xlabdiv0 LT 50 THEN BEGIN
                xxtickinterval[i]=20
            ENDIF ELSE IF xlabdiv0 LT 100 THEN BEGIN
                xxtickinterval[i]=50
            ENDIF ELSE IF xlabdiv0 LT 200 THEN BEGIN
                xxtickinterval[i]=100
            ENDIF ELSE IF xlabdiv0 LT 500 THEN BEGIN
                xxtickinterval[i]=200
            ENDIF ELSE IF xlabdiv0 LT 1000 THEN BEGIN
                xxtickinterval[i]=500
            ENDIF ELSE IF xlabdiv0 LT 2000 THEN BEGIN
                xxtickinterval[i]=1000
            ENDIF ELSE BEGIN
                xxtickinterval[i]=0
            ENDELSE
            xxtickinterval[i]=xxtickinterval[i]*labscale
        ENDFOR
    ENDIF
    spaghetti,ptime,ptime, $
      XXFRAC=xxfrac, $
      XXRANGE=xxrange, $
      XXANO=xxano, $
      XXNOTICK=xxnotick, $
      YRANGE=yrange, $
      XXTICKINTERVAL=xxtickinterval, $
      XXTICKFORMAT=xxtickformat, $
      XXTITLE=xxtitle, $
      XXLABEL=xxlabel, $
      XMARGIN=xmargin, $
      YMARGIN=ymargin, $
      XTITLE=xtitle, $
      YTITLE=ytitle, $
      XTANGLE=xtangle, $
      /ONELINE,XMAP=xmap,/NODATA,/NOFRAME,/NONORMAL
    ptime=xmap
ENDIF ELSE BEGIN
    PLOT,[0,1],/NODATA, $
      XTITLE=xtitle, $
      YTITLE=ytitle, $
      XSTYLE=axis_style, $
      YSTYLE=axis_style, $
      XRANGE=xrange, $
      YRANGE=yrange, $
      XCHARSIZE=xcharsize, $
      YCHARSIZE=ycharsize, $
      XMARGIN=xmargin, $
      YMARGIN=ymargin, $
      XTICKFORMAT=xtickformat, $
      YTICKFORMAT=ytickformat, $
      NOCLIP=0
ENDELSE

timex=DBLARR(modells+1,/NOZERO)
IF (nend-nstart) GT 0 THEN BEGIN
    IF rectangular THEN BEGIN
        timex([nstart,nend+1])=ptime([nstart,nend])
        timex(nstart+1:nend)=0.5D0*(ptime(nstart:nend-1)+ptime(nstart+1:nend))
    ENDIF ELSE BEGIN
        timex(nstart:nend)=ptime(nstart:nend)
    ENDELSE
ENDIF ELSE BEGIN
    timex(nstart)=ptime(nstart)
    timex(nend+1)=ptime(nend)+1.0D0
ENDELSE

; resolve X11 for half a pixel size.
X11_PIXEL_RES=0.5D0

IF N_ELEMENTS(resolution) EQ 0 THEN resolution=1
IF N_ELEMENTS(xresolution) EQ 0 THEN xresolution=resolution
IF N_ELEMENTS(yresolution) EQ 0 THEN yresolution=resolution
IF xresolution EQ 1 THEN BEGIN
    IF !D.NAME EQ 'X' THEN BEGIN
        xgridcoord=CONVERT_COORD(xrange,yrange,/DATA,/TO_DEVICE)
        xgrid=ABS((xrange(1)-xrange(0))*X11_PIXEL_RES/(xgridcoord(0,0)-xgridcoord(0,1)+1))
        IF verbose GE 1 THEN PRINT,' [PLOTCONV] XRESOLUTION '+STRING(xgrid)+' absolute (X11)'
    ENDIF
    IF !D.NAME EQ 'PS' THEN BEGIN
        xresolution=300
    ENDIF
ENDIF
IF xresolution LT 0 THEN BEGIN
    xgrid=ABS((xrange(1)-xrange(0))*1.D0/xresolution)
    IF verbose GE 1 THEN PRINT,' [PLOTCONV] XRESOLUTION '+STRING(xgrid)+' absolute'
ENDIF
IF xresolution GT 1 THEN BEGIN
    xgridcoord=CONVERT_COORD(xrange,yrange,/DATA,/TO_DEVICE)
    xgrid=ABS((xgridcoord(0,0)-xgridcoord(0,1))*1.D0/(!D.X_PX_CM*2.54)*xresolution)
    xgrid=ABS((xrange(1)-xrange(0))*1.D0/xgrid)
    IF verbose GE 1 THEN PRINT,' [PLOTCONV] XRESOLUTION '+STRING(xresolution)+' dpi = '+STRING(xgrid)+' absolute'
ENDIF
IF yresolution EQ 1 THEN BEGIN
    IF !D.NAME EQ 'X' THEN BEGIN
        ygridcoord=CONVERT_COORD(xrange,yrange,/DATA,/TO_DEVICE)
        ygrid=ABS((yrange(1)-yrange(0))*X11_PIXEL_RES/(ygridcoord(1,0)-ygridcoord(1,1)+1))
        IF verbose GE 1 THEN PRINT,' [PLOTCONV] YRESOLUTION '+STRING(ygrid)+' absolute (X11)'
    ENDIF
    IF !D.NAME EQ 'PS' THEN BEGIN
        yresolution=600
    ENDIF
ENDIF
IF yresolution LT 0 THEN BEGIN
    ygrid=ABS((yrange(1)-yrange(0))*1.D0/yresolution)
    IF verbose GE 1 THEN PRINT,' [PLOTCONV] YRESOLUTION '+STRING(ygrid)+' absolute'
ENDIF
IF yresolution GT 1 THEN BEGIN
    ygridcoord=CONVERT_COORD(xrange,yrange,/DATA,/TO_DEVICE)
    ygrid=ABS((ygridcoord(1,0)-ygridcoord(1,1))*1.D0/(!D.Y_PX_CM*2.54)*yresolution)
    ygrid=ABS((yrange(1)-yrange(0))*1.D0/ygrid)
    IF verbose GE 1 THEN PRINT,' [PLOTCONV] YRESOLUTION '+STRING(yresolution)+' dpi = '+STRING(ygrid)+' absolute'
ENDIF
IF spaghetti THEN BEGIN
; xgrid and ygrid need to go in normal rather than data coordiantes
    xgrid=1.D-4
    IF verbose GE 1 THEN PRINT,' [PLOTCONV] XRESOLUTION '+STRING(xgrid)+' (normal)'
ENDIF

; dummy={layerstyle,color:0L,line_fill:0L,orientation:0.0D0,spacing:0.0D0,thick:0.0D0}

IF N_ELEMENTS(patternthick) EQ 0 THEN patternthick=!P.THICK

IF N_ELEMENTS(patternscale) EQ 0 THEN patternscale=1
IF N_ELEMENTS(patternspace) EQ 0 THEN patternspace=0.5*patternscale
IF N_ELEMENTS(patternconvspace) EQ 0 THEN patternconvspace=0.20*patternspace
IF N_ELEMENTS(patternsemispace) EQ 0 THEN patternsemispace=0.10*patternspace
IF N_ELEMENTS(patternneutspace) EQ 0 THEN patternneutspace=0.20*patternspace
IF N_ELEMENTS(patternoverspace) EQ 0 THEN patternoverspace=0.15*patternspace
IF N_ELEMENTS(patternthalspace) EQ 0 THEN patternthalspace=0.20*patternspace

IF N_ELEMENTS(convhatch) EQ 0 THEN convhatch=[[45    ],[[1  ]*patternconvspace],[[1  ]*patternthick]]
IF N_ELEMENTS(semihatch) EQ 0 THEN semihatch=[[45,-45],[[1,1]*patternsemispace],[[1,1]*patternthick]]
IF N_ELEMENTS(neuthatch) EQ 0 THEN neuthatch=[[45,-45],[[1,1]*patternneutspace],[[1,1]*patternthick]]
IF N_ELEMENTS(overhatch) EQ 0 THEN oshthatch=[[ 0,-90],[[1,1]*patternoverspace],[[1,1]*patternthick]]
IF N_ELEMENTS(thalhatch) EQ 0 THEN thalhatch=[[60,-30],[[1,1]*patternthalspace],[[1,1]*patternthick]]

IF quickview GT 0 THEN BEGIN
    IF !Y.TYPE EQ 0 THEN datay=!Y.CRANGE ELSE datay=10D0^!Y.CRANGE
    datay0=MIN(datay,MAX=datay1)
    n=quickview
    FOR i=nstart,nend,n DO BEGIN
        IF i+n GT nend+1 THEN m=nend+1-i ELSE m=n
        indrec=[i,i,i+m,i+m]
        timerec=timex[indrec]
        facrec=fac[indrec]
        offsetrec=offset[indrec]
        mrec=[0,1,1,0]
        i1=i+1
        IF neugain THEN BEGIN
           plotmultislab,i,i1,mrec,$
                         timerec,facrec,offsetrec,datay0,datay1, $
                         clevels,color, $
                         maxlevel,maxlevelp,maxlevelp,showlevels,usedlevels,cm,radius,spaghetti,ylog, $
                         +1,neu,neur,neud,neudr,nneu,nneud,nnneu,nnneud
        ENDIF
        IF neuloss THEN BEGIN
           plotmultislab,i,i1,mrec,$
                         timerec,facrec,offsetrec,datay0,datay1, $
                         clevels,color, $
                         maxlevel,maxlevelm,maxlevelp,showlevels,usedlevels,cm,radius,spaghetti,ylog, $
                         -1,nev,nevr,nevd,nevdr,nnev,nnevd,nnnev,nnnevd
        ENDIF
        IF nucgain THEN BEGIN
           plotmultislab,i,i1,mrec,$
                         timerec,facrec,offsetrec,datay0,datay1, $
                         clevels,color, $
                         maxlevel,maxlevelp,maxlevelp,showlevels,usedlevels,cm,radius,spaghetti,ylog, $
                         +1,nuk,nukr,nukd,nukdr,nnuk,nnukd,nnnuk,nnnukd
        ENDIF
        IF nucloss THEN BEGIN
           plotmultislab,i,i1,mrec,$
                         timerec,facrec,offsetrec,datay0,datay1, $
                         clevels,color, $
                         maxlevel,maxlevelm,maxlevelp,showlevels,usedlevels,cm,radius,spaghetti,ylog, $
                         -1,nuc,nucr,nucd,nucdr,nnuc,nnucd,nnnuc,nnnucd
        ENDIF
        IF showgain THEN BEGIN
           plotmultislab,i,i1,mrec,$
                         timerec,facrec,offsetrec,datay0,datay1, $
                         clevels,color, $
                         maxlevel,maxlevelm,maxlevelp,showlevels,usedlevels,cm,radius,spaghetti,ylog, $
                         +1,erg,ergr,ergd,ergdr,nerg,nergd,nnerg,nnergd
        ENDIF
        IF showloss THEN BEGIN
           plotmultislab,i,i1,mrec,$
                         timerec,facrec,offsetrec,datay0,datay1, $
                         clevels,color, $
                         maxlevel,maxlevelm,maxlevelp,showlevels,usedlevels,cm,radius,spaghetti,ylog, $
                         -1,erk,erkr,erkd,erkdr,nerk,nerkd,nnerk,nnerkd
        ENDIF
        IF showconv NE 0 THEN BEGIN
            IF convection THEN BEGIN
               plothatchslab, $
                  i,mrec, $
                  timerec,facrec,offsetrec,datay0,datay1,convlow, $
                  radius,spaghetti,ylog, $
                  convhatch,color[47],frameconv,nkonv,konv,konvr
            ENDIF
            IF semiconv THEN BEGIN
               plothatchslab, $
                  i,mrec, $
                  timerec,facrec,offsetrec,datay0,datay1,convlow, $
                  radius,spaghetti,ylog, $
                  semihatch,color[31],0,nsemi,semi,semir
            ENDIF
            IF neutral THEN BEGIN
               plothatchslab, $
                  i,mrec, $
                  timerec,facrec,offsetrec,datay0,datay1,convlow, $
                  radius,spaghetti,ylog, $
                  neuthatch,color[96],0,nneut,neut,neutrr
            ENDIF
            IF overshoot THEN BEGIN
               plothatchslab, $
                  i,mrec, $
                  timerec,facrec,offsetrec,datay0,datay1,convlow, $
                  radius,spaghetti,ylog, $
                  oshthatch,color[79],0,nosht,osht,oshtr
            ENDIF
            IF thermohal THEN BEGIN
               plothatchslab, $
                  i,mrec, $
                  timerec,facrec,offsetrec,datay0,datay1,convlow, $
                  radius,spaghetti,ylog, $
                  thalhatch,color[127],0,nthal,thal,thalr
            ENDIF
        ENDIF
    ENDFOR
ENDIF ELSE BEGIN

; make white background (for posters)
    IF spaghetti EQ 0 THEN BEGIN
        POLYFILL,!X.WINDOW[[0,1,1,0,0]],!Y.WINDOW[[0,0,1,1,0]],/NORMAL,COLOR=!P.BACKGROUND
    ENDIF

; count everything
    IF verbose GE 2 THEN PRINT,' [PLOTCONV] starting layers ...'
    npol=0L
    nvert=0L
    nrem=0L
    nvertraw=0L
    nremraw=0L

; reduced x axis
    nstep=-quickview
    npoint=(nend-nstart+nstep)/nstep
    x=DBLARR(npoint+1)
    xf=DBLARR(npoint+1)
    xo=DBLARR(npoint+1)
    FOR i=0L,npoint-1 DO BEGIN
        ii=MIN([nstart+i*nstep,nend])
        x[i]=timex[ii]
        xf[i]=fac[ii]
        xo[i]=offset[ii]
    ENDFOR
    x[npoint]=timex[ii+1]
    xo[npoint]=offset[ii+1]
    xf[npoint]=fac[ii+1]

    IF neugain THEN BEGIN        
        IF cm EQ 0 THEN BEGIN
            l1=MIN([MAX(nnneu [nstart+1:nend+1]-nnneu [nstart:nend]),maxlevel])-1
        ENDIF ELSE BEGIN
            l1=MIN([MAX(nnneud[nstart+1:nend+1]-nnneud[nstart:nend]),maxlevel])-1
        ENDELSE
        FOR l=0,l1 DO BEGIN
            k1=maxlevelp+l
            IF showlevels[k1] THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] nuc: layer '+STRING(l)
                usedlevels[k1]=1
                IF cm EQ 0 THEN BEGIN
                    IF radius EQ 0 THEN BEGIN
                        extract_layer,l,nlneu ,nnneu ,nneu ,neu  ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDIF ELSE BEGIN
                        extract_layer,l,nlneu ,nnneu ,nneu ,neur ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                     ENDELSE
                    nxmax=nneumax
                ENDIF ELSE BEGIN
                    IF radius EQ 0 THEN BEGIN
                        extract_layer,l,nlneud,nnneud,nneud,neud ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDIF ELSE BEGIN
                        extract_layer,l,nlneud,nnneud,nneud,neudr,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                     ENDELSE
                    nxmax=nneudmax
                ENDELSE
                plotlayer,nxmax,0L,npoint-1,iy,x,y,color[clevels[k1]],0,0,0,0,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,OFFSET=xo,FAC=xf,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
        ENDFOR
    ENDIF
    IF neuloss THEN BEGIN
        IF cm EQ 0 THEN BEGIN
            l1=MIN([MAX(nnnev [nstart+1:nend+1]-nnnev [nstart:nend]),maxlevel])-1
        ENDIF ELSE BEGIN
            l1=MIN([MAX(nnnevd[nstart+1:nend+1]-nnnevd[nstart:nend]),maxlevel])-1
        ENDELSE
        FOR l=0,l1 DO BEGIN
            k1=maxlevelm-l
            IF showlevels[k1] THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] nev: layer '+STRING(l)
                usedlevels[k1]=1
                IF cm EQ 0 THEN BEGIN
                    IF radius EQ 0 THEN BEGIN
                        extract_layer,l,nlnev ,nnnev ,nnev ,nev  ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDIF ELSE BEGIN
                        extract_layer,l,nlnev ,nnnev ,nnev ,nevr ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                     ENDELSE
                    nxmax=nnevmax
                ENDIF ELSE BEGIN
                    IF radius EQ 0 THEN BEGIN
                        extract_layer,l,nlnevd,nnnevd,nnevd,nevd ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDIF ELSE BEGIN
                        extract_layer,l,nlnevd,nnnevd,nnevd,nevdr,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDELSE
                    nxmax=nnevdmax
                ENDELSE
                plotlayer,nxmax,0L,npoint-1,iy,x,y,color[clevels[k1]],0,0,0,0,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,OFFSET=xo,FAC=xf,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
        ENDFOR
    ENDIF
    IF nucgain THEN BEGIN        
        IF cm EQ 0 THEN BEGIN
            l1=MIN([MAX(nnnuk [nstart+1:nend+1]-nnnuk [nstart:nend]),maxlevel])-1
        ENDIF ELSE BEGIN
            l1=MIN([MAX(nnnukd[nstart+1:nend+1]-nnnukd[nstart:nend]),maxlevel])-1
        ENDELSE
        FOR l=0,l1 DO BEGIN
            k1=maxlevelp+l
            IF showlevels[k1] THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] nuc: layer '+STRING(l)
                usedlevels[k1]=1
                IF cm EQ 0 THEN BEGIN
                    IF radius EQ 0 THEN BEGIN
                        extract_layer,l,nlnuk ,nnnuk ,nnuk ,nuk  ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDIF ELSE BEGIN
                        extract_layer,l,nlnuk ,nnnuk ,nnuk ,nukr ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                     ENDELSE
                    nxmax=nnukmax
                ENDIF ELSE BEGIN
                    IF radius EQ 0 THEN BEGIN
                        extract_layer,l,nlnukd,nnnukd,nnukd,nukd ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDIF ELSE BEGIN
                        extract_layer,l,nlnukd,nnnukd,nnukd,nukdr,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                     ENDELSE
                    nxmax=nnukdmax
                ENDELSE
                plotlayer,nxmax,0L,npoint-1,iy,x,y,color[clevels[k1]],0,0,0,0,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,OFFSET=xo,FAC=xf,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
        ENDFOR
    ENDIF
    IF nucloss THEN BEGIN
        IF cm EQ 0 THEN BEGIN
            l1=MIN([MAX(nnnuc [nstart+1:nend+1]-nnnuc [nstart:nend]),maxlevel])-1
        ENDIF ELSE BEGIN
            l1=MIN([MAX(nnnucd[nstart+1:nend+1]-nnnucd[nstart:nend]),maxlevel])-1
        ENDELSE
        FOR l=0,l1 DO BEGIN
            k1=maxlevelm-l
            IF showlevels[k1] THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] nuc: layer '+STRING(l)
                usedlevels[k1]=1
                IF cm EQ 0 THEN BEGIN
                    IF radius EQ 0 THEN BEGIN
                        extract_layer,l,nlnuc ,nnnuc ,nnuc ,nuc  ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDIF ELSE BEGIN
                        extract_layer,l,nlnuc ,nnnuc ,nnuc ,nucr ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                     ENDELSE
                    nxmax=nnucmax
                ENDIF ELSE BEGIN
                    IF radius EQ 0 THEN BEGIN
                        extract_layer,l,nlnucd,nnnucd,nnucd,nucd ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDIF ELSE BEGIN
                        extract_layer,l,nlnucd,nnnucd,nnucd,nucdr,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDELSE
                    nxmax=nnucdmax
                ENDELSE
                plotlayer,nxmax,0L,npoint-1,iy,x,y,color[clevels[k1]],0,0,0,0,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,OFFSET=xo,FAC=xf,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
        ENDFOR
    ENDIF
    IF showgain THEN BEGIN
        IF cm EQ 0 THEN BEGIN
            l1=MIN([MAX(nnerg [nstart+1:nend+1]-nnerg [nstart:nend]),maxlevel])-1
        ENDIF ELSE BEGIN
            l1=MIN([MAX(nnergd[nstart+1:nend+1]-nnergd[nstart:nend]),maxlevel])-1
        ENDELSE
        FOR l=0,l1 DO BEGIN
            k1=maxlevelp+l
            IF showlevels[k1] THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] gain: layer '+STRING(l)
                usedlevels[k1]=1
                IF cm EQ 0 THEN BEGIN
                    IF radius EQ 0 THEN BEGIN
                        extract_layer,l,nlerg ,nnerg ,nerg ,erg  ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDIF ELSE BEGIN
                        extract_layer,l,nlerg ,nnerg ,nerg ,ergr ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDELSE
                    nxmax=nergmax
                ENDIF ELSE BEGIN
                    IF radius EQ 0 THEN BEGIN
                        extract_layer,l,nlergd,nnergd,nergd,ergd ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDIF ELSE BEGIN
                        extract_layer,l,nlergd,nnergd,nergd,ergdr,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDELSE
                    nxmax=nergdmax
                 ENDELSE
                plotlayer,nxmax,0L,npoint-1,iy,x,y,color[clevels[k1]],0,0,0,0,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,OFFSET=xo,FAC=xf,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
        ENDFOR
    ENDIF
    IF showloss THEN BEGIN
        IF cm EQ 0 THEN BEGIN
            l1=MIN([MAX(nnerk [nstart+1:nend+1]-nnerk [nstart:nend]),maxlevel])-1
        ENDIF ELSE BEGIN
            l1=MIN([MAX(nnerkd[nstart+1:nend+1]-nnerkd[nstart:nend]),maxlevel])-1
        ENDELSE
        FOR l=0,l1 DO BEGIN
            k1=maxlevelm-l
            IF showlevels[k1] THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] loss: layer '+STRING(l)
                usedlevels[k1]=1
                IF cm EQ 0 THEN BEGIN
                    IF radius EQ 0 THEN BEGIN
                        extract_layer,l,nlerk ,nnerk ,nerk ,erk  ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDIF ELSE BEGIN
                        extract_layer,l,nlerk ,nnerk ,nerk ,erkr ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDELSE
                    nxmax=nerkmax
                ENDIF ELSE BEGIN
                    IF radius EQ 0 THEN BEGIN
                        extract_layer,l,nlerkd,nnerkd,nerkd,erkd ,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDIF ELSE BEGIN
                        extract_layer,l,nlerkd,nnerkd,nerkd,erkdr,iy,y,NSTART=nstart,NEND=nend,NSTEP=nstep
                    ENDELSE
                    nxmax=nerkdmax
                 ENDELSE
                plotlayer,nxmax,0L,npoint-1,iy,x,y,color[clevels[k1]],0,0,0,0,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,OFFSET=xo,FAC=xf,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
        ENDFOR
    ENDIF

    IF showconv GT 0 THEN BEGIN
        IF radius EQ 0 THEN BEGIN
            IF convection THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] conv'
                plotlayer,nkonvmax,nstart,nend,nkonv,timex,konv,color[47],1,convhatch(*,0),convhatch(*,1),convhatch(*,2),frameconv,NSTEP=quickview,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,LOWCUT=convlow,OFFSET=offset,FAC=fac,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
            IF semiconv THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] semi'
                plotlayer,nsemimax,nstart,nend,nsemi,timex,semi,color[31],1,semihatch(*,0),semihatch(*,1),semihatch(*,2),NSTEP=quickview,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,LOWCUT=convlow,OFFSET=offset,FAC=fac,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
            IF neutral THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] neut'
                plotlayer,nneutmax,nstart,nend,nneut,timex,neut,color[95],1,neuthatch(*,0),neuthatch(*,1),neuthatch(*,2),NSTEP=quickview,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,LOWCUT=convlow,OFFSET=offset,FAC=fac,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
            IF overshoot THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] over'
                plotlayer,noshtmax,nstart,nend,nosht,timex,osht,color[79],1,oshthatch(*,0),oshthatch(*,1),oshthatch(*,2),NSTEP=quickview,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,LOWCUT=convlow,OFFSET=offset,FAC=fac,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
            IF thermohal THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] thal'
                plotlayer,nthalmax,nstart,nend,nthal,timex,thal,color[127],1,thalhatch(*,0),thalhatch(*,1),thalhatch(*,2),NSTEP=quickview,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,LOWCUT=convlow,OFFSET=offset,FAC=fac,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
        ENDIF ELSE BEGIN
            IF convection THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] conv'
                plotlayer,nkonvmax,nstart,nend,nkonv,timex,konvr,color[47],1,convhatch(*,0),convhatch(*,1),convhatch(*,2),frameconv,NSTEP=quickview,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,OFFSET=offset,FAC=fac,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
            IF semiconv THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] semi'
                plotlayer,nsemimax,nstart,nend,nsemi,timex,semir,color[31],1,semihatch(*,0),semihatch(*,1),semihatch(*,2),NSTEP=quickview,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,OFFSET=offset,FAC=fac,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
            IF neutral THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] neut'
                plotlayer,nneutmax,nstart,nend,nneut,timex,neutr,color[95],1,neuthatch(*,0),neuthatch(*,1),neuthatch(*,2),NSTEP=quickview,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,OFFSET=offset,FAC=fac,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
            IF overshoot THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] osht'
                plotlayer,noshtmax,nstart,nend,nosht,timex,oshtr,color[79],1,oshthatch(*,0),oshthatch(*,1),oshthatch(*,2),NSTEP=quickview,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,OFFSET=offset,FAC=fac,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
            IF thermohal THEN BEGIN
                IF verbose GE 2 THEN PRINT,' [PLOTCONV] thal'
                plotlayer,nthalmax,nstart,nend,nthal,timex,thalr,color[127],1,thalhatch(*,0),thalhatch(*,1),thalhatch(*,2),NSTEP=quickview,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,OFFSET=offset,FAC=fac,XNORMAL=spaghetti,YLOG=ylog
            ENDIF
        ENDELSE
    ENDIF ELSE IF convection THEN BEGIN
        IF radius EQ 0 THEN BEGIN
            IF verbose GE 2 THEN PRINT,' [PLOTCONV] conv'
            plotlayer,nkonvmax,nstart,nend,nkonv,timex,konv,color[96-showconv],0,0,0,0,NSTEP=quickview,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,LOWCUT=convlow,OFFSET=offset,FAC=fac,XNORMAL=spaghetti,YLOG=ylog
            plotlayer,nsemimax ,nstart,nend,nsemi ,timex,semi,color[96-showsemi],0,0,0,0,NSTEP=quickview,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,LOWCUT=convlow,OFFSET=offset,FAC=fac,XNORMAL=spaghetti,YLOG=ylog
        ENDIF ELSE BEGIN
            IF verbose GE 2 THEN PRINT,' [PLOTCONV] conv'
            plotlayer,nkonvmax,nstart,nend,nkonv,timex,konvr,color[96-showconv],0,0,0,0,NSTEP=quickview,XGRID=xgrid,YGRID=ygrid,RECTANGULAR=rectangular,LOWCUT=convlow,OFFSET=offset,FAC=fac,XNORMAL=spaghetti,YLOG=ylog
        ENDELSE
    ENDIF

    IF verbose GE 1 THEN PRINT,' [PLOTCONV] '+STRING(npol    )+' polygons'
    IF verbose GE 1 THEN PRINT,' [PLOTCONV] '+STRING(nvert   )+' vertices (reduction by '+string((1.D0*(nvert+nrem))/nvert)+' )'
    IF verbose GE 1 THEN PRINT,' [PLOTCONV] '+STRING(nvertraw)+' raw data (reduction by '+STRING((1.D0*(nvertraw+nremraw))/nvertraw)+' )'
ENDELSE

IF N_ELEMENTS(title0) EQ 0 THEN title='' ELSE title=title0

IF showmodels THEN BEGIN
    ch=CONVERT_COORD([!D.X_CH_SIZE,!D.X_CH_SIZE],/DEVICE,/TO_NORMAL)
    IF !X.TYPE EQ 0 THEN datax=!X.CRANGE ELSE datax=10D0^!X.CRANGE
    IF !Y.TYPE EQ 0 THEN datay=!Y.CRANGE ELSE datay=10D0^!Y.CRANGE
    eckpunkt=CONVERT_COORD(datax,datay,/DATA,/TO_NORMAL)
    tx=[eckpunkt(0,0),eckpunkt(0,1)]
    ty=eckpunkt(1,1)+(spaghetti+[0.5,1.5])*ch(1)
    tt=CONVERT_COORD(tx,ty,/NORMAL,/TO_DATA)
    dtt=tt(1,1)-tt(1,0)
    xlow=MIN(xrange,MAX=xhigh)
    FOR i=nstart,nend DO BEGIN
        IF (ptime[i] GE xlow) AND (ptime[i] LE xhigh) THEN BEGIN
            j=modellnr(i)
            ndtt=1+(j mod 10 EQ 0)+(j mod 100 EQ 0) + (j mod 1000 EQ 0) + (j mod 10000 EQ 0)
            ttx=dtt*ndtt*0.25
            tty=tt[1,0]+[0,ttx]
            IF spaghetti THEN BEGIN
                xyz=CONVERT_COORD(ptime[i]*[1,1],tty,/DATA,/TO_NORMAL,/DOUBLE)
                tty=xyz[1,*]
            ENDIF
            PLOTS,ptime[i]*[1,1],tty,/NOCLIP,THICK=0,COLOR=color[ndtt],NORMAL=spaghetti
        ENDIF
    ENDFOR
    title='!emodels!n'
ENDIF

IF showlegend NE 0 THEN BEGIN
    IF N_ELEMENTS(legcharsize) EQ 0 THEN legcharsize=1

    IF cm THEN BEGIN
        unitstring2='erg!i !n/!i !ncm!i !n/!i !ns'
        unitstring1='erg g!a-1!n cm!a-1!n'
    ENDIF ELSE BEGIN
        unitstring2='erg!i !n/!i !ng!i !n/!i !ns'
        unitstring1='erg g!a-1!n s!a-1!n'
    ENDELSE


    dd=[!D.X_CH_SIZE,!D.X_CH_SIZE]
    IF !P.CHARSIZE NE 0 THEN cf=!P.CHARSIZE ELSE cf=1.0D0
    dd=dd*cf
    ch=CONVERT_COORD(dd,/DEVICE,/TO_NORMAL)
    IF !X.TYPE EQ 0 THEN datax=!X.CRANGE ELSE datax=10D0^!X.CRANGE
    IF !Y.TYPE EQ 0 THEN datay=!Y.CRANGE ELSE datay=10D0^!Y.CRANGE
    eckpunkt=CONVERT_COORD(datax,datay,/DATA,/TO_NORMAL)

    nlevels=LONG(TOTAL(usedlevels))

    tx=eckpunkt(0,1)+[0.5,1.5,1.5]*ch(0)
    ty=[eckpunkt(1,0),eckpunkt(1,1),eckpunkt(1,1)+ch(1)]
    tt=CONVERT_COORD(tx,ty,/NORMAL,/TO_DEVICE)
    dx=(tt(0,1)-tt(0,0))*legscale*1.25
    dy=(tt(1,1)-tt(1,0))/nlevels
    dyc=tt[1,2]-tt[1,1]
    dxc=tt[0,1]-tt[0,0]

    COLOR_RGB,color,col_red,col_green,col_blue
    col_light=(LONG(col_red)+LONG(col_blue)+LONG(col_green))/765.

    j=0
    FOR i=0,2*maxlevel DO BEGIN
        IF usedlevels[i] THEN BEGIN
            lcolor=clevels[i]
            POLYFILL,tt(0,0)+[0,dx,dx,0],tt(1,0)+j*dy+[0,0,dy,dy],COLOR=color[lcolor],/DEVICE
            j=j+1
        ENDIF
    ENDFOR
    IF showlegend EQ 1 THEN BEGIN
        IF N_ELEMENTS(legcharthick) EQ 0 THEN legcharthick=0.5*!P.THICK
        lcharthick=legcharthick
        textsize=MIN([dy*legscale/(6.4*dx),dx/(2.75*dyc)])*cf
;                                  8.0         2.00
        j=0
        FOR i=0,2*maxlevel DO BEGIN
            IF usedlevels[i] THEN BEGIN
                lcolor=clevels[i]
                IF i LT maxlevel THEN BEGIN
                    lxf=0.7
                    text='<-10!a'+STRING(maxlevelm-i+lowlevelexpl,FORMAT='(I2)')+'!n'
                ENDIF ELSE IF i EQ maxlevel THEN BEGIN
                    lxf=0.8
                    text='0'
                ENDIF ELSE BEGIN
                    lxf=0.8
                    text='>10!a'+STRING(i-maxlevelp+lowlevelexpg,FORMAT='(I2)')+'!n'
                ENDELSE
                IF col_light(lcolor) GT 0.5 THEN tcolor=!P.COLOR else tcolor=!P.BACKGROUND
                xyouts,tt(0,0)+lxf*dx, $
                  tt(1,0)+(j+0.5)*dy, $
                  text, $
                  ORIENTATION=90, $
                  ALIGNMENT=0.5, $
                  CHARTHICK=lcharthick, $
                  CHARSIZE=textsize, $
                  /DEVICE, $
                  COLOR=tcolor
                j=j+1
            ENDIF
            xyouts,tt(0,0)+2.0*dx, $
              0.5*(tt(1,0)+tt(1,1)), $
              ' '+unitstring1, $
              ORIENTATION=90, $
              ALIGNMENT=0.5, $
              CHARTHICK=lcharthick, $
              CHARSIZE=textsize, $
              /DEVICE
        ENDFOR
    ENDIF
    IF showlegend EQ 3 THEN BEGIN
        textsize=MIN([dy*legscale/(2.25*dx),dx/(1.5*dyc)])*cf
        IF N_ELEMENTS(legcharthick) EQ 0 THEN BEGIN
            legcharthick=0.5*!P.CHARTHICK
            xlcharsize=!P.CHARSIZE
            IF xlcharsize EQ 0 THEN xlcharsize=1
            IF (!P.CHARTHICK NE 0) THEN $
              legcharthick=textsize/xlcharsize*!P.CHARTHICK
        ENDIF
        lcharthick=legcharthick
;
        j=0
        jl=0
        jg=0
        FOR i=0,2*maxlevel DO BEGIN
            IF usedlevels[i] THEN BEGIN
                lcolor=clevels[i]
                lxf=0.5*(dx+textsize/cf*dyc)
                IF i LT maxlevel THEN BEGIN
                    text=STRTRIM(STRING(maxlevelm-i+lowlevelexpl),2)
                    jl=jl+1
                ENDIF ELSE IF i EQ maxlevel THEN BEGIN
                    IF j EQ 0 THEN BEGIN
                        text=' '
                    ENDIF ELSE BEGIN
                        text='...'
                    ENDELSE
                ENDIF ELSE BEGIN
                    text=STRTRIM(STRING(i-maxlevelp+lowlevelexpg),2)
                    jg=jg+1
                ENDELSE
                IF col_light(lcolor) GT 0.5 THEN tcolor=!P.COLOR else tcolor=!P.BACKGROUND
                xyouts,tt(0,0)+lxf, $
                  tt(1,0)+(j+0.5)*dy, $
                  text, $
                  ORIENTATION=90, $
                  ALIGNMENT=0.5, $
                  CHARTHICK=lcharthick, $
                  CHARSIZE=textsize, $
                  /DEVICE, $
                  COLOR=tcolor
                j=j+1
            ENDIF
        ENDFOR
        xleg=tt(0,0)+2.2*dx
        xyouts,xleg, $
          0.5*(tt(1,0)+tt(1,1)), $
          ' log(!i !n'+unitstring2+'!i !n)', $
          ORIENTATION=90, $
          ALIGNMENT=0.5, $
          CHARTHICK=lcharthick, $
          CHARSIZE=legcharsize*textsize, $
          /DEVICE
        IF (jg GT 0) AND (jl GT 0) THEN BEGIN
            IF jg GT 0 THEN BEGIN
                xyouts,xleg, $
                  tt(1,1), $
                  'GAIN', $
                  ORIENTATION=90, $
                  ALIGNMENT=1.0, $
                  CHARTHICK=lcharthick, $
                  CHARSIZE=legcharsize*textsize, $
                  /DEVICE
            ENDIF
            IF jl GT 0 THEN BEGIN
                xyouts,xleg, $
                  tt(1,0), $
                  'LOSS', $
                  ORIENTATION=90, $
                  ALIGNMENT=0.0, $
                  CHARTHICK=lcharthick, $
                  CHARSIZE=legcharsize*textsize, $
                  /DEVICE
            ENDIF
        ENDIF
    ENDIF
    IF showlegend EQ 4 THEN BEGIN
        multfac=1
        IF N_ELEMENTS(!P.MULTI) GT 3 THEN BEGIN
            IF !P.MULTI[2] GT 1 THEN multfac=0.5
        ENDIF
        textsize=xcharsize*multfac<dy/(1.5*dyc)
        IF textsize EQ 0 THEN textsize=1
        IF N_ELEMENTS(legcharthick) EQ 0 THEN BEGIN
            legcharthick=0.5*!P.CHARTHICK
            xlcharsize=!P.CHARSIZE
            IF xlcharsize EQ 0 THEN xlcharsize=1
            IF (!P.CHARTHICK NE 0) THEN $
              legcharthick=textsize/xlcharsize*!P.CHARTHICK
        ENDIF
        lcharthick=legcharthick
;
        j=0
        jl=0
        jg=0
        textlenmax=0
        FOR i=0,2*maxlevel DO BEGIN
            IF usedlevels[i] THEN BEGIN
                lcolor=clevels[i]
                lxf=dx+0.5*dxc
                lyf=0.5*dy-0.5*dyc
                IF i LT maxlevel THEN BEGIN
                    text=STRTRIM(STRING(maxlevelm-i+lowlevelexpl),2)
                    jl=jl+1
                ENDIF ELSE IF i EQ maxlevel THEN BEGIN
                    text=' '
                ENDIF ELSE BEGIN
                    text=STRTRIM(STRING(i-maxlevelp+lowlevelexpg),2)
                    jg=jg+1
                    lyf=lyf-dy
                ENDELSE
                textlenmax=MAX([textlenmax,STRLEN(text)])
                tcolor=!P.COLOR
                xyouts,tt(0,0)+lxf, $
                  tt(1,0)+(j+0.5)*dy+lyf, $
                  text, $
                  ORIENTATION=0, $
                  ALIGNMENT=0, $
                  CHARTHICK=lcharthick, $
                  CHARSIZE=textsize, $
                  /DEVICE, $
                  COLOR=tcolor
                j=j+1
            ENDIF
        ENDFOR
        xleg=tt(0,0)+dx+(1.5+textlenmax)*dxc*textsize/charsize+1.2*dyc
        xyouts,xleg, $
          0.5*(tt(1,0)+tt(1,1)), $
          ' log(!i !n'+unitstring2+'!i !n)', $
          ORIENTATION=90, $
          ALIGNMENT=0.5, $
          CHARTHICK=lcharthick, $
          CHARSIZE=textsize, $
          /DEVICE
        IF (jg GT 0) AND (jl GT 0) THEN BEGIN
            IF jg GT 0 THEN BEGIN
                xyouts,xleg, $
                  tt(1,1), $
                  'GAIN', $
                  ORIENTATION=90, $
                  ALIGNMENT=1.0, $
                  CHARTHICK=lcharthick, $
                  CHARSIZE=textsize, $
                  /DEVICE
            ENDIF
            IF jl GT 0 THEN BEGIN
                xyouts,xleg, $
                  tt(1,0), $
                  'LOSS', $
                  ORIENTATION=90, $
                  ALIGNMENT=0.0, $
                  CHARTHICK=lcharthick, $
                  CHARSIZE=textsize, $
                  /DEVICE
            ENDIF
        ENDIF
    ENDIF
ENDIF

multi_save2=!P.multi
!P.MULTI=multi_save
x=ptime(nstart:nend)
y=mass[nstart:nend]*fac[nstart:nend]-offset[nstart:nend]
IF ylog THEN y=ALOG10(y)
IF spaghetti THEN BEGIN
    xyz=CONVERT_COORD(x,y,/DATA,/TO_NORMAL)
    y=xyz[1,*]
ENDIF
IF spaghetti THEN BEGIN
    ygridred=ygrid/(ABS(yrange[1]-yrange[0]))
ENDIF ELSE BEGIN
    ygridred=ygrid
ENDELSE
IF N_ELEMENTS(totsmooth) EQ 0 THEN totsmooth=0
IF totsmooth GT 0 THEN BEGIN
    y=SMOOTH(y, totsmooth, /EDGE_TRUNCATE)
ENDIF
reduce,x,y,XRES=xgrid,YRES=ygridred,NREM=nrem
in=N_ELEMENTS(x)
IF verbose GE 1 THEN PRINT,' [PLOTCONV] '+STRING(in)+' mass points (reduction by '+STRING((1.D0*(in+nrem))/in)+' )'

IF N_ELEMENTS(totmasscolor) EQ 0 THEN totmasscolor=!P.COLOR
PLOTS,x,y, $
  NOCLIP=0, $
  THICK=totmassthick, $
  LINE=0, $
  COLOR=totmasscolor, $
  NORMAL=spaghetti

IF spaghetti THEN BEGIN
    spaghetti,ptime,ptime, $
      XXFRAC=xxfrac, $
      XXRANGE=xxrange, $
      XXANO=xxano, $
      XXNOTICK=xxnotick, $
      YRANGE=yrange, $
      XXTICKINTERVAL=xxtickinterval, $
      XXTICKFORMAT=xxtickformat, $
      XXTITLE=xxtitle, $
      XXLABEL=xxlabel, $
      XMARGIN=xmargin, $
      YMARGIN=ymargin, $
      XTITLE=xtitle, $
      YTITLE=ytitle, $
      TITLE=title, $
      XTANGLE=xtangle, $
      /NOERASE,/NODATA
ENDIF ELSE BEGIN
    PLOT,x,y,$
      XTITLE=xtitle, $
      YTITLE=ytitle, $
      /XSTYLE, $
      XRANGE=xrange, $
      YRANGE=yrange, $
      /YSTYLE, $
      XCHARSIZE=xcharsize, $
      YCHARSIZE=ycharsize, $
      XMARGIN=xmargin, $
      YMARGIN=ymargin, $
      XTICKFORMAT=xtickformat, $
      YTICKFORMAT=ytickformat, $
      /NOERASE, $
      TITLE=title
ENDELSE

IF N_ELEMENTS(convlegxy) EQ 2 THEN BEGIN
    leg=['convection','semiconv.','neutral','overshoot.','thermohal.']
    nnleg=N_ELEMENTS(leg)
    lines=REPLICATE(0,nnleg)
    IF convection THEN lines[0]=1
    IF semiconv THEN lines[1]=1
    IF neutral THEN lines[2]=1
    IF overshoot THEN lines[3]=1
    IF thermohal THEN lines[4]=1
    nlines=TOTAL(lines)

    IF N_ELEMENTS(convlegframe) EQ 0 THEN convlegframe=0
    LEGENDE,10,/RIGHT,/TOP, $
      XPOS=convlegxy[0],YPOS=convlegxy[1], $
      LINEHEIGHT=1.0, $
      DRAWFRAME=convlegframe,FRAMELINES=nlines, $
      FRAMELEFT=7.5,FRAMETOP=0.5

    FOR i=0,nnleg-1 DO BEGIN
        noframe=1
        IF lines[i] EQ 1 THEN BEGIN
            CASE i OF
                0: BEGIN
                    hatch=convhatch
                    c=color[47]
                    noframe=0
                END
                1: BEGIN
                    hatch=semihatch
                    c=color[31]
                END
                2: BEGIN
                    hatch=neuthatch
                    c=color[95]
                END
                3: BEGIN
                    hatch=oshthatch
                    c=color[79]
                END
                4: BEGIN
                    hatch=thalhatch
                    c=color[127]
                END
            ENDCASE

            n=N_ELEMENTS(hatch(*,0))
            FOR j=0,n-2 DO BEGIN
                LEGENDE_COL,c,'',/NONEWLINE,/LINE_FILL,/NOFRAME, $
                  ORIENTATION=hatch(j,0), SPACING=hatch(j,1), THICK=hatch(j,2)
            ENDFOR
            j=n-1
            LEGENDE_COL,c,leg[i],/LINE_FILL, $
              FRAMETHICK=hatch(j,2), $
              NOFRAME=noframe, $
              FRAMECOLOR=c, $
              ORIENTATION=hatch(j,0), $
              SPACING=hatch(j,1), $
              THICK=hatch(j,2)
        ENDIF
    ENDFOR
ENDIF

!P.multi=multi_save2

IF showtime EQ 1 THEN BEGIN
    PRINT,' [PLOTCONV] plot completed in '+STRING(SYSTIME(/SECONDS)-starttime)+' seconds.'
ENDIF

IF select EQ 1 THEN BEGIN
    selectloopsection:
    select,region,verbose=0,CODE=code
    IF N_ELEMENTS(list) EQ 0 THEN BEGIN
        list=PTR_NEW()
        llist={xrange:DBLARR(2),yrange:DBLARR(2),P:!P,X:!X,Y:!Y,xoffset:xoffset,yoffset:yoffset,image:PTR_NEW(),previous:PTR_NEW()}
    ENDIF
    CASE code OF
        2: BEGIN
            WHILE PTR_VALID(list) DO BEGIN
                last=(*list).previous
                PTR_FREE,(*list).image
                PTR_FREE,list
                list=TEMPORARY(last)
            ENDWHILE
            RETURN
        END
        1: BEGIN
            IF (region[0,0] EQ region[0,1]) OR (region[0,0] EQ region[0,1]) THEN GOTO,selectloopsection

            last=PTR_NEW(llist)
            (*last).xrange=xrange
            (*last).yrange=yrange
            (*last).image=PTR_NEW(tvrd(/TRUE))
            (*last).P=!P
            (*last).X=!X
            (*last).Y=!Y
            (*last).xoffset=xoffset
            (*last).yoffset=yoffset
            IF PTR_VALID(list) THEN (*last).previous=list
            list=TEMPORARY(last)

            xrange=region[0,0:1]+xoffset
            yrange=region[1,0:1]+yoffset
            xoffset=0
            yoffset=0
            clear,nstart
            clear,nend

            PRINT,' [PLOTCONV] XRANGE=['+STRTRIM(STRING(xrange[0],FORMAT="(E21.14)"),2)+','+STRTRIM(STRING(xrange[1],FORMAT="(E21.14)"),2)+']'
            PRINT,' [PLOTCONV] YRANGE=['+STRTRIM(STRING(yrange[0],FORMAT="(E21.14)"),2)+','+STRTRIM(STRING(yrange[1],FORMAT="(E21.14)"),2)+']'
            GOTO,selectloop
        END
        4: BEGIN
            IF (PTR_VALID(list)) THEN BEGIN
                xrange=(*list).xrange
                yrange=(*list).yrange
                !P=(*list).P
                !X=(*list).X
                !Y=(*list).Y
                xoffset=(*list).xoffset
                yoffset=(*list).yoffset
                clear,nstart
                clear,nend
                TV,*(*list).image,/TRUE
                PTR_FREE,(*list).image
                last=list
                list=(*list).previous
                PTR_FREE,last

                xrange1=xrange+xoffset
                yrange1=yrange+yoffset

                PRINT,' [PLOTCONV] XRANGE=['+STRTRIM(STRING(xrange1[0],FORMAT="(E21.14)"),2)+','+STRTRIM(STRING(xrange1[1],FORMAT="(E21.14)"),2)+']'
                PRINT,' [PLOTCONV] YRANGE=['+STRTRIM(STRING(yrange1[0],FORMAT="(E21.14)"),2)+','+STRTRIM(STRING(yrange1[1],FORMAT="(E21.14)"),2)+']'
            ENDIF ELSE BEGIN
;                xrange=xrange+xoffset
;                yrange=yrange+yoffset
;                PRINT,' [PLOTCONV] XRANGE=['+STRTRIM(STRING(xrange[0],FORMAT="(E21.14)"),2)+','+STRTRIM(STRING(xrange[1],FORMAT="(E21.14)"),2)+']'
;                PRINT,' [PLOTCONV] YRANGE=['+STRTRIM(STRING(yrange[0],FORMAT="(E21.14)"),2)+','+STRTRIM(STRING(yrange[1],FORMAT="(E21.14)"),2)+']'
;                GOTO,selectloop
            ENDELSE
            GOTO,selectloopsection
        END
;         8: BEGIN
;             xrange=xrange+xoffset
;             yrange=yrange+(yrange[1]-yrange[0])*0.5+yoffset
;             xoffset=0
;             yoffset=0
;             clear,nstart
;             clear,nend

;             PRINT,' [PLOTCONV] XRANGE=['+STRTRIM(STRING(xrange[0],FORMAT="(E21.14)"),2)+','+STRTRIM(STRING(xrange[1],FORMAT="(E21.14)"),2)+']'
;             PRINT,' [PLOTCONV] YRANGE=['+STRTRIM(STRING(yrange[0],FORMAT="(E21.14)"),2)+','+STRTRIM(STRING(yrange[1],FORMAT="(E21.14)"),2)+']'
;             GOTO,selectloop

;         END
;         16: BEGIN

;             xrange=xrange+xoffset
;             yrange=yrange-(yrange[1]-yrange[0])*0.5+yoffset
;             xoffset=0
;             yoffset=0
;             clear,nstart
;             clear,nend

;             PRINT,' [PLOTCONV] XRANGE=['+STRTRIM(STRING(xrange[0],FORMAT="(E21.14)"),2)+','+STRTRIM(STRING(xrange[1],FORMAT="(E21.14)"),2)+']'
;             PRINT,' [PLOTCONV] YRANGE=['+STRTRIM(STRING(yrange[0],FORMAT="(E21.14)"),2)+','+STRTRIM(STRING(yrange[1],FORMAT="(E21.14)"),2)+']'
;             GOTO,selectloop

;         END
        ELSE: BEGIN
        END
    ENDCASE
    PRINT,'[LOADCONV] ERROR: Unknown mouse key ',code
    GOTO,selectloopsection
ENDIF


IF (ps NE '') OR (pdf NE '') THEN BEGIN
   CLOSEPS
ENDIF

END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


PRO plotmultislab,i,i1,mrec, $
                  timerec,facrec,offsetrec,datay0,datay1, $
                  clevels,color, $
                  maxlevel,maxlevelm,maxlevelp,showlevels,usedlevels,cm,radius,spaghetti,ylog, $
                  levelsign,x,xr,xd,xdr,nx,nxd,nnx,nnxd

  IF cm EQ 0 THEN BEGIN
     nlevel=nnx [i1]-nnx [i]
  ENDIF ELSE BEGIN
     nlevel=nnxd[i1]-nnxd[i]
  ENDELSE
  FOR k=0,MIN([nlevel,maxlevel])-1 DO BEGIN
     IF levelsign GT 0 THEN BEGIN
        k1=maxlevelp+k
     ENDIF ELSE BEGIN
        k1=maxlevelm-k
     ENDELSE
     IF showlevels[k1] THEN BEGIN
        usedlevels[k1]=1
        IF cm EQ 0 THEN BEGIN
           ilevel=nnx[i]+k
           j0=nx[ilevel]
           j1=nx[ilevel+1]-1
        ENDIF ELSE BEGIN
           ilevel=nnxd[i]+k
           j0=nxd[ilevel]
           j1=nxd[ilevel+1]-1
        ENDELSE
        FOR j=j0,j1 DO BEGIN
           IF cm EQ 0 THEN BEGIN
              IF radius EQ 0 THEN BEGIN
                 massrec=x [mrec,j]
              ENDIF ELSE BEGIN
                 massrec=xr[mrec,j]
              ENDELSE
           ENDIF ELSE BEGIN
              IF radius EQ 0 THEN BEGIN
                 massrec=xd [mrec,j]
              ENDIF ELSE BEGIN
                 massrec=xdr[mrec,j]
              ENDELSE
           ENDELSE           
           massrec=massrec*facrec-offsetrec
           IF ylog THEN massrec=ALOG10(massrec)
           massrec>= datay0
           massrec<= datay1
           IF spaghetti THEN BEGIN
              xyz=CONVERT_COORD(timerec,massrec,/DATA,/TO_NORMAL,/DOUBLE)
              massrec=xyz[1,*]
           ENDIF
           IF (massrec[0] NE massrec[1]) OR (massrec[2] NE massrec[3]) THEN BEGIN
              POLYFILL,timerec,massrec,COLOR=color[clevels[k1]],NOCLIP=0,NORMAL=spaghetti
           ENDIF
        ENDFOR
     ENDIF
  ENDFOR
END


;-----------------------------------------------------------------------
;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;-----------------------------------------------------------------------

PRO plothatchslab, $
   i,mrec, $
   timerec,facrec,offsetrec,datay0,datay1,convlow, $
   radius,spaghetti,ylog, $  
   hatch,xcolor,frame,nx,x,xr

  nhatch=N_ELEMENTS(hatch[*,0])
  FOR k=nx[i],nx[i+1]-1 DO BEGIN
     IF radius EQ 0 THEN BEGIN
        massrec=x [mrec,k]
     ENDIF ELSE BEGIN
        massrec=xr[mrec,k]
     ENDELSE
     massrec=massrec*facrec-offsetrec
     IF ylog THEN massrec=ALOG10(massrec)
     massrec>= datay0
     massrec<= datay1
     IF spaghetti THEN BEGIN
        xyz=CONVERT_COORD(timerec,massrec,/DATA,/TO_NORMAL,/DOUBLE)
        massrec=xyz[1,*]
     ENDIF
     IF (massrec[0] NE massrec[1]) OR (massrec[2] NE massrec[3]) THEN BEGIN
        FOR ih=0,nhatch-1 DO BEGIN
           POLYFILL,timerec,massrec,/LINE_FILL,ORIENTATION=hatch[ih,0],SPACING=hatch[ih,1],NOCLIP=1,COLOR=xcolor,THICK=hatch[ih,2],NORMAL=spaghetti
        ENDFOR
        IF frame THEN BEGIN
           FOR il=0,1 DO BEGIN
              PLOTS,timerec[1:2],[1,1]*massrec[il],NOCLIP=0,COLOR=xcolor,THICK=0,NORMAL=spaghetti
           ENDFOR
        ENDIF
     ENDIF
  ENDFOR
END

;-----------------------------------------------------------------------
;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;-----------------------------------------------------------------------

PRO SELCONV

DEVICE, GET_GRAPHICS=old, SET_GRAPHICS=6
col = !D.N_COLORS-1

IF !X.TYPE EQ 0 THEN datax=!X.CRANGE ELSE datax=10D0^!X.CRANGE
IF !Y.TYPE EQ 0 THEN datay=!Y.CRANGE ELSE datay=10D0^!Y.CRANGE
eckpunkt=ROUND(CONVERT_COORD(datax,datay,/DATA,/TO_DEVICE))


REPEAT BEGIN
    CURSOR, x0, y0, 3, /DEVICE
    button = !ERR
ENDREP UNTIL button EQ 1

x1=x0
y1=y0
cx=x0
cy=Y0

PLOTS,[x0,x0,x1,x1,x0],[y0,y1,y1,y0,y0],THICK=1,COLOR=col,/DEVICE
REPEAT BEGIN
    cx0=x1
    cy0=y1
    CURSOR, cx, cy, /CHANGE, /DEVICE
    CURSOR, cx, cy, 0, /DEVICE
    button = !MOUSE.BUTTON
    IF (cx LT 0) AND (cy LT 0) THEN BEGIN
;        button=1
        cx=cx0
        cy=cy0
    ENDIF
    repos=0

    IF cx LT eckpunkt[0,0] THEN BEGIN
        cx=eckpunkt[0,0]
        repos=1
    ENDIF ELSE IF cx GT eckpunkt[0,1] THEN BEGIN
        cx=eckpunkt[0,1]
        repos=1
    ENDIF
    IF cy LT eckpunkt[1,0] THEN BEGIN
        cy=eckpunkt[1,0]
        repos=1
    ENDIF ELSE IF cy GT eckpunkt[1,1] THEN BEGIN
        cy=eckpunkt[1,1]
        repos=1
    ENDIF
    PLOTS,[x0,x0,x1,x1,x0],[y0,y1,y1,y0,y0],THICK=1,COLOR=col,/DEVICE
    IF (button AND 4) EQ 4 THEN BEGIN
    dx=cx-cx0
    dy=cy-cy0
        IF (dx LT -x0+eckpunkt[0,0]) THEN BEGIN
            repos=1
            dx=-x0+eckpunkt[0,0]
        ENDIF ELSE IF (dx GT eckpunkt[0,1]-x0) THEN BEGIN
            repos=1
            dx=eckpunkt[0,1]-x0
        ENDIF
        IF (dy LT -y0+eckpunkt[1,0]) THEN BEGIN
            repos=1
            dy=-y0+eckpunkt[1,0]
        ENDIF ELSE IF (dy GT eckpunkt[1,1]-y0) THEN BEGIN
            repos=1
            dy=eckpunkt[1,1]-y0
        ENDIF
        x0=x0+dx
        y0=y0+dy
        x1=x1+dx
        y1=y1+dy
    ENDIF ELSE BEGIN
        x1=cx
        y1=cy
    ENDELSE
    PLOTS,[x0,x0,x1,x1,x0],[y0,y1,y1,y0,y0],THICK=1,COLOR=col,/DEVICE
    IF repos THEN TVCRS,x1,y1
ENDREP UNTIL button EQ 0
PLOTS,[x0,x0,x1,x1,x0],[y0,y1,y1,y0,y0],THICK=1,COLOR=col,/DEVICE

DEVICE, SET_GRAPHICS=old

cx0=MIN([x0,x1])
cx1=MAX([x0,x1])
cy0=MIN([y0,y1])
cy1=MAX([y0,y1])

region=CONVERT_COORD([cx0,cx1],[cy0,cy1],/DEVICE,/TO_DATA)
region=region(0:1,0:1)

PRINT,FORMAT="(A,3(E25.15))",'x ',region[0,*],region[0,1]-region[0,0]
PRINT,FORMAT="(A,3(E25.15))",'y ',region[1,*],region[1,1]-region[1,0]


END

;-----------------------------------------------------------------------
;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;-----------------------------------------------------------------------

PRO setzerotime,time0, MODEL=model0, RESTORE=restore, DMODEL=dmodel0, DTIME0=dtime0,SECONDS=seconds

@physconst
@compile_opt

COMMON conv, nmodellmax,nnergmax,nergmax,nconvmax,nnerg,nerg,erg,nconv,conv,convr,convtype,time,timecc,modellnr,modells
COMMON conv14,eni,enk,enp,ent,epro,enn,enr,ensc,enes,enc,enpist 
COMMON conv15,enid,enkd,enpd,entd,eprod,xlumn,enrd,enscd,enesd,encd,enpistd

COMMON conv8, radius0,ergr,erkr,nukr,nucr,minvers,maxvers
COMMON conv24,dt


COMMON conv_setzorotime,saved_time,saved_timecc, saved_time0, saved_model0

IF N_ELEMENTS(restore) EQ 0 THEN restore=0
IF restore EQ 1 THEN BEGIN
   IF N_ELEMENTS(saved_time)   NE 0 THEN time  =saved_time
   IF N_ELEMENTS(saved_timecc) NE 0 THEN timecc=saved_timecc
   clear, saved_time0
   clear, saved_model0
   RETURN
ENDIF

n=N_ELEMENTS(time)

IF N_ELEMENTS(seconds) EQ 0 THEN seconds=0

IF minvers LT 10403 THEN BEGIN 
   IF N_ELEMENTS(saved_time) NE 0 THEN time=saved_time

   dtx=time[1:n-1]-time[0:n-2]

   lim=1.d-15
   ddtx=dtx/time[1:n-1]
   x=WHERE(ddtx LT lim)
   IF x[0] NE -1 THEN BEGIN
      dtei=(eni[x+1]-eni[x])/(enid[x+1]*SEC)
      dtx[x]=dtei
   ENDIF
ENDIF ELSE BEGIN
   dtx=dt/SEC
ENDELSE

IF (N_ELEMENTS(dtime0) NE 0) AND (N_ELEMENTS(saved_time0) NE 0) THEN BEGIN
   IF seconds THEN BEGIN
      time0=saved_time0*SEC+dtime0
   ENDIF ELSE BEGIN
      time0=saved_time0+dtime0
   ENDELSE
ENDIF
IF (N_ELEMENTS(dmodel0) NE 0) AND (N_ELEMENTS(saved_model0) NE 0) THEN BEGIN
   model0=saved_model0+dmodel0
ENDIF
IF N_ELEMENTS(model0) EQ 0 THEN BEGIN
   IF N_ELEMENTS(time0) EQ 0 THEN time0=0.D0
   IF seconds THEN BEGIN
      i=(WHERE(time GE time0/SEC))[0]
   ENDIF ELSE BEGIN
      i=(WHERE(time GE time0))[0]
   ENDELSE
ENDIF ELSE BEGIN
   i=(WHERE(modellnr GE model0))[0]
ENDELSE
IF i EQ -1 THEN BEGIN 
   i=n-1
   PRINT,' [SETZEROTIME] WARNING: using last model.'
ENDIF
PRINT,' [SETZEROTIME] using model '+STRTRIM(STRING(modellnr[i],FORMAT="(I)"),2)+" ("+STRTRIM(STRING(time[i]),2)+" yr)"

newtime=DBLARR(n)
newtime[i]=0
IF i LT n-1 THEN newtime[i+1:n-1]=TOTAL(dtx[i:n-2],/CUMULATIVE,/DOUBLE)
IF i GT 0   THEN newtime[0:i-1]=-REVERSE(TOTAL(REVERSE(dtx[0:i-1]),/CUMULATIVE,/DOUBLE))

IF N_ELEMENTS(saved_time) EQ 0 THEN BEGIN
   saved_time=time
   saved_timecc=timecc
ENDIF

saved_time0=time[i]
saved_model0=modellnr[i]

time=newtime
timecc=time[n-1]-time

END

;-----------------------------------------------------------------------
;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;-----------------------------------------------------------------------

PRO convkonv,VERBOSE=verbose,SHOWTIME=showtime

COMMON conv, nmodellmax,nnergmax,nergmax,nconvmax,nnerg,nerg,erg,nconv,conv,convr,convtype,time,timecc,modellnr,modells
COMMON konv, nkonvmax,nsemimax,nneutmax,noshtmax,nthalmax,nkonv,nsemi,nneut,nosht,nthal,konv,semi,neut,osht,thal,konvr,semir,neutr,oshtr,thalr
COMMON konv2, xmstar,rstar
COMMON conv23,xmacc

starttime=SYSTIME(/SECONDS)

IF N_ELEMENTS(showtime) EQ 0 THEN showtime=1
IF N_ELEMENTS(verbose) EQ 0 THEN verbose=0
IF (verbose GE 2) THEN PRINT,' [CONVKONV] computing convective regions ...'

nkonvmax=1L
nsemimax=1L
nneutmax=1L
noshtmax=1L
nthalmax=1L

nktot=0L
nstot=0L
nntot=0L
notot=0L
nttot=0L
FOR i=0L,modells-1 DO BEGIN
    nk=0L
    ns=0L
    nn=0L
    no=0L
    nt=0L
    FOR k=0L,nconv[i]-1 DO BEGIN
        CASE convtype[k,i] OF
            1B : nk=nk+1
            2B : ns=ns+1
            3B : nn=nn+1
            4B : no=no+1
            5B : nt=nt+1
            ELSE:
        ENDCASE
    ENDFOR
    nkonvmax=MAX([nkonvmax,nk])
    nsemimax=MAX([nsemimax,ns])
    nneutmax=MAX([nneutmax,nn])
    noshtmax=MAX([noshtmax,no])
    nthalmax=MAX([nthalmax,nt])
    nktot=nktot+nk
    nstot=nstot+ns
    nntot=nntot+nn
    notot=notot+no
    nttot=nttot+nt
ENDFOR

xmstar=DBLARR(modells)
rstar=DBLARR(modells)

nkonv=LONARR(modells+1)
nsemi=LONARR(modells+1)
nneut=LONARR(modells+1)
nosht=LONARR(modells+1)
nthal=LONARR(modells+1)

konv=DBLARR(2,MAX([1,nktot]))
semi=DBLARR(2,MAX([1,nstot]))
neut=DBLARR(2,MAX([1,nntot]))
osht=DBLARR(2,MAX([1,notot]))
thal=DBLARR(2,MAX([1,nttot]))

konvr=DBLARR(2,MAX([1,nktot]))
semir=DBLARR(2,MAX([1,nstot]))
neutr=DBLARR(2,MAX([1,nntot]))
oshtr=DBLARR(2,MAX([1,notot]))
thalr=DBLARR(2,MAX([1,nttot]))

nk=0L
ns=0L
nn=0L
no=0L
nt=0L

nkonv[0]=nk
nsemi[0]=ns
nneut[0]=nn
nosht[0]=no
nthal[0]=nt

FOR i=0L,modells-1L DO BEGIN
    nconvi1=nconv[i]-1
    FOR k=0L,nconvi1 DO BEGIN
        IF k EQ 0 THEN BEGIN
            dm=[0,conv[k,i]]
            dr=[0,convr[k,i]]
        ENDIF ELSE BEGIN
            dm=conv[[k-1,k],i]
            dr=convr[[k-1,k],i]
        ENDELSE

        CASE convtype[k,i] OF
            1B : BEGIN
                konv [0:1,nk]=dm
                konvr[0:1,nk]=dr
                nk=nk+1L
            END
            2B : BEGIN
                semi [0:1,ns]=dm
                semir[0:1,ns]=dr
                ns=ns+1L
            END
            3B : BEGIN
                neut [0:1,nn]=dm
                neutr[0:1,nn]=dr
                nn=nn+1L
            END
            4B : BEGIN
                osht [0:1,no]=dm
                oshtr[0:1,no]=dr
                no=no+1L
            END
            5B : BEGIN
                thal [0:1,nt]=dm
                thalr[0:1,nt]=dr
                nt=nt+1L
            END
            ELSE:
        ENDCASE

        nkonv[i+1]=nk
        nsemi[i+1]=ns
        nneut[i+1]=nn
        nosht[i+1]=no
        nthal[i+1]=nt

    ENDFOR

    rstar[i]=convr[nconvi1,i]
    xmstar[i]=conv[nconvi1,i]

ENDFOR

; free array data
nconv=0
conv=0
convr=0
convtype=0

; add surface mass
xmstar+=xmacc

IF showtime EQ 1 THEN BEGIN
    PRINT,' [CONVKONV] data transformed in '+time2human(SYSTIME(/SECONDS)-starttime)+'.'
ENDIF

END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO centraldata, convfile, $
                 OUTFILE=outfile

@compile_opt
@physconst

IF N_ELEMENTS(convfile) NE 0 THEN loadconv,convfile

COMMON loadconv, fileinfo

IF N_ELEMENTS(outfile) EQ 0 THEN outfile=''
IF outfile EQ '' THEN BEGIN
    unit=-1
ENDIF ELSE BEGIN
    OPENW,unit,outfile,/GET_LUN
ENDELSE

getconvdata, $
   MODELLNR=modellnr, $
   TIME=time, $
   CCTIME=cctime, $
   DN=dn, $
   TN=tn, $
   PN=pn, $
   ABUN=abun, $
   NET=net

abun=map19(abun,net,IONS=ions)
ions=ions[0:20]


x=WHERE(net EQ 1)
IF x[0] NE -1 THEN BEGIN
   abun[1,x]+=abun[2,x]
ENDIF
imap=[0,1,3+indgen(18)]
ions=ions[imap]
abun=abun[imap,*]


netid=['APPROX','QSE','NSE']

ann=['cycle', $
     'time', $
     'time till core collapse', $
     'central density', $
     'central temperature', $
     'central pressure', $
     'NETWORK', $
     ions]

info=GET_LOGIN_INFO()
host=info.machine_name
user=info.user_name

version='10000'
comment=''
formatcomment=''

s=comment+'VERSION '+version+formatcomment+' -- '+SYSTIME(/UTC)+' UTC -- created by '+user+' on '+host+' from file '+fileinfo.name
PRINTF,unit,s

s=STRING(ann,FORMAT='(A9,5(A25),A10,'+STRTRIM(STRING(N_ELEMENTS(ions)),2)+'(A25))')
PRINTF,unit,s

FOR i=0L,N_ELEMENTS(net)-2 DO BEGIN
   s=''
   s=s+STRING(modellnr[i], $
              time[i]*SEC, $
              cctime[i]*SEC, $
              dn[i], $
              tn[i], $
              pn[i], $
              netid[net[i]-1], $
              FORMAT='(I9,5(E25.16),A10)')
   FOR j=0,N_ELEMENTS(ions)-1 DO BEGIN
      s=s+STRING(abu2string(abun[j,i]),FORMAT='(A25)')
   ENDFOR
OUTPUT:
    PRINTF,unit,s
 ENDFOR


endofoutput:
IF unit NE -1 THEN BEGIN 
   CLOSE, unit
   FREE_LUN,unit
ENDIF


END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO getconvdata, $
   TN=tnx, $
   DN=dnx, $
   PN=pnx, $
   EN=enx, $
   STOT=stotx, $
   YE=yex, $
   ABAR=abarx, $
   ETA=etax, $
   SNX=snx, $
   SNN=snnx, $
   GAMMA1=gamma1x, $
   GAMMA2=gamma2x, $
   GS1=gs1x, $
   GS2=gs2x, $
   NET=netx, $
   NHIZ=nhizx, $
   ABUN=abunx, $
   LN=lnx, $
   AW=awx, $
   NUC=nucx, $
   TIME=timex, $
   CCTIME=timeccx, $
   MODELLNR=modellnrx, $
   ENIT   =enix, $    
   ENKT   =enkx, $    
   ENPT   =enpx, $    
   ENTT   =entx, $    
   EPROT  =eprox, $   
   ENNT   =ennx, $    
   ENRT   =enrx, $    
   ENSCT  =enscx, $   
   ENEST  =enesx, $   
   ENCT   =encx, $    
   ENPISTT=enpistx, $ 
   ENID   =enidx, $   
   ENKD   =enkdx, $   
   ENPD   =enpdx, $   
   ENTD   =entdx, $   
   EPROD  =eprodx, $  
   XLUMN  =xlumnx, $  
   ENRD   =enrdx, $   
   ENSCD  =enscdx, $  
   ENESD  =enesdx, $  
   ENCD   =encdx, $   
   ENPISTD=enpistdx, $
   XLUM1  =xlumx, $   
   XLUM0  =xlum0x, $  
   ENTLOSS=entlossx, $
   ENILOSS=enilossx, $
   ENKLOSS=enklossx, $
   ENPLOSS=enplossx, $
   ENRLOSS=enrlossx, $
   ANGIT=angitx, $
   ANGLT=angltx

COMMON conv, nmodellmax,nnergmax,nergmax,nconvmax,nnerg,nerg,erg,nconv,conv,convr,convtype,time,timecc,modellnr,modells
COMMON conv4, tn,dn,pn,en,stot,ye,abar,eta,sn,snn,gamma1,gamma2,gs1,gs2,net,nhiz,abun,ln,aw,lnnuc
COMMON conv8, radius0,ergr,erkr,nukr,nucr,minvers,maxvers
COMMON conv14,eni,enk,enp,ent,epro,enn,enr,ensc,enes,enc,enpist 
COMMON conv15,enid,enkd,enpd,entd,eprod,xlumn,enrd,enscd,enesd,encd,enpistd
COMMON conv16,xlum,xlum0,entloss,eniloss,enkloss,enploss,enrloss
COMMON conv22,angit,anglt

n=N_ELEMENTS(time)

tnx=tn[0:n-1]
dnx=dn[0:n-1]
pnx=pn[0:n-1]
enx=en[0:n-1]
stotx=stot[0:n-1]
yex=ye[0:n-1]
abarx=abar[0:n-1]
etax=eta[0:n-1]
snx=sn[0:n-1]
snnx=snn[0:n-1]
gamma1x=gamma1[0:n-1]
gamma2x=gamma2[0:n-1]
gs1x=gs1[0:n-1]
gs2x=gs2[0:n-1]
netx=net[0:n-1]
nhizx=nhiz
abunx=abun[*,0:n-1]
IF N_ELEMENTS(ln) NE 0 THEN lnx=ln[0:n-1]
modellnrx=modellnr[0:n-1]

IF N_ELEMENTS(aw) NE 0 THEN awx=aw[0:n-1]
IF N_ELEMENTS(lnnuc) NE 0 THEN nucx=lnnuc[0:n-1]

IF minvers GE 10401 THEN BEGIN
   enix    =eni[0:n-1]
   enkx    =enk[0:n-1]
   enpx    =enp[0:n-1]
   entx    =ent[0:n-1]
   eprox   =epro[0:n-1]
   ennx    =enn[0:n-1]
   enrx    =enr[0:n-1]
   enscx   =ensc[0:n-1]
   enesx   =enes[0:n-1]
   encx    =enc[0:n-1]
   enpistx =enpist[0:n-1]
   enidx   =enid[0:n-1]
   enkdx   =enkd[0:n-1]
   enpdx   =enpd[0:n-1]
   entdx   =entd[0:n-1]
   eprodx  =eprod[0:n-1]
   xlumnx  =xlumn[0:n-1]
   enrdx   =enrd[0:n-1]
   enscdx  =enscd[0:n-1]
   enesdx  =enesd[0:n-1]
   encdx   =encd[0:n-1]
   enpistdx=enpistd[0:n-1]
   xlumx   =xlum[0:n-1]
   xlum0x  =xlum0[0:n-1]
   entlossx=entloss[0:n-1]
   enilossx=eniloss[0:n-1]
   enklossx=enkloss[0:n-1]
   enplossx=enploss[0:n-1]
   enrlossx=enrloss[0:n-1]
   angitx=angit[0:n-1]
   angltx=anglt[0:n-1]
ENDIF

timex=time
timeccx=timecc

END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO loadconv,name0, $
             FIRSTMODELL=firstmodell, $
             LASTMODELL=lastmodell, $
             STEPMODELL=stepmodell, $
             REMOVEZEROTIME=removezerotime, $
             VERBOSE=verbose, $
             SHOWTIME=showtime, $
             COMPCONV=compconv, $
             RELOAD=reload
@physconst

;Version 10100
;      WRITE(43) nvers,modell,time,nconv,nnfak,nnfac,nnvak,nber,
;     &     (nfak(i),i=1,nnfak),(nfac(i),i=1,nnfac),(nvak(i),i=1,nnvak),
;     &     (yzip(i),i=1,nconv),(xmc(i),i=1,nconv),
;     &     (ber(i),i=1,nber),
;     &     (((fak(i,j,k),i=1,2),j=1,nfak(k)),k=1,nnfak),
;     &     (((fac(i,j,k),i=1,2),j=1,nfac(k)),k=1,nnfac),
;     &     (((vak(i,j,k),i=1,2),j=1,nvak(k)),k=1,nnvak)
;Version 10200
;      WRITE(43) nvers,modell,time,nconv,nnfak,nnfac,nnvak,nber,
;     &     (nfak(i),i=1,nnfak),(nfac(i),i=1,nnfac),(nvak(i),i=1,nnvak),
;     &     (yzip(i),i=1,nconv),(rc(i),i=1,nconv),(rc(i),i=1,nconv),
;     &     (ber(i),i=1,nber),
;     &     (((fak(i,j,k),i=1,2),j=1,nfak(k)),k=1,nnfak),
;     &     (((fac(i,j,k),i=1,2),j=1,nfac(k)),k=1,nnfac),
;     &     (((vak(i,j,k),i=1,2),j=1,nvak(k)),k=1,nnvak)
;Version 10300
;       WRITE(43) nvers,ncyc,timesec,nconv,nnfak,nnfac,nnvak,nber,
;      &     (nfak(i),i=1,nnfak),(nfac(i),i=1,nnfac),(nvak(i),i=1,nnvak),
;      &     (yzip(i),i=1,nconv),(xmc(i),i=1,nconv),(rc(i),i=1,nconv),
;      &     (ber(i),i=1,nber),
;      &     (((fak(i,j,jj),i=1,2),j=1,nfak(jj)),jj=1,nnfak),
;      &     (((fac(i,j,jj),i=1,2),j=1,nfac(jj)),jj=1,nnfac),
;      &     (((vak(i,j,jj),i=1,2),j=1,nvak(jj)),jj=1,nnvak),
;      &     tc_cnv,dc_cnv,pc_cnv,ec_cnv,sc_cnv,ye_cnv,ab_cnv,
;      &     et_cnv,sn_cnv,su_cnv,g1_cnv,g2_cnv,s1_cnv,s2_cnv,
;      &     an_cnv,(abun_cnv(i),i=1,nhiz)
;Version 10301
;       WRITE(43) nvers,ncyc,timesec,nconv,nnfak,nnfac,nnvak,nber,
;      &     (nfak(i),i=1,nnfak),(nfac(i),i=1,nnfac),(nvak(i),i=1,nnvak),
;      &     (yzip(i),i=1,nconv),(xmc(i),i=1,nconv),(rc(i),i=1,nconv),
;      &     (ber(i),i=1,nber),
;      &     (((fak(i,j,jj),i=1,2),j=1,nfak(jj)),jj=1,nnfak),
;      &     (((fac(i,j,jj),i=1,2),j=1,nfac(jj)),jj=1,nnfac),
;      &     (((vak(i,j,jj),i=1,2),j=1,nvak(jj)),jj=1,nnvak),
;      &     tc_cnv,dc_cnv,pc_cnv,ec_cnv,sc_cnv,ye_cnv,ab_cnv,
;      &     et_cnv,sn_cnv,su_cnv,g1_cnv,g2_cnv,s1_cnv,s2_cnv,
;      &     an_cnv,(abun_cnv(i),i=1,nhiz),
;      &     xn_cnv
;Version 10302
;       WRITE(43) nvers,ncyc,timesec,nconv,nnfak,nnfac,nnvak,nber,
;      &     (nfak(i),i=1,nnfak),(nfac(i),i=1,nnfac),(nvak(i),i=1,nnvak),
;      &     (yzip(i),i=1,nconv),(xmc(i),i=1,nconv),(rc(i),i=1,nconv),
;      &     (ber(i),i=1,nber),
;      &     (((fak(i,j,jj),i=1,2),j=1,nfak(jj)),jj=1,nnfak),
;      &     (((fac(i,j,jj),i=1,2),j=1,nfac(jj)),jj=1,nnfac),
;      &     (((vak(i,j,jj),i=1,2),j=1,nvak(jj)),jj=1,nnvak),
;      &     tc_cnv,dc_cnv,pc_cnv,ec_cnv,sc_cnv,ye_cnv,ab_cnv,
;      &     et_cnv,sn_cnv,su_cnv,g1_cnv,g2_cnv,s1_cnv,s2_cnv,
;      &     an_cnv,(abun_cnv(i),i=1,nhiz),
;      &     xn_cnv,
;      &     aw_cnv
;Version 10303
;       WRITE(43) nvers,ncyc,timesec,nconv,nnfak,nnfac,nnvak,nber,
;      &     (nfak(i),i=1,nnfak),(nfac(i),i=1,nnfac),(nvak(i),i=1,nnvak),
;      &     (yzip(i),i=1,nconv),(xmc(i),i=1,nconv),(rc(i),i=1,nconv),
;      &     (ber(i),i=1,nber),
;      &     (((fak(i,j,jj),i=1,2),j=1,nfak(jj)),jj=1,nnfak),
;      &     (((fac(i,j,jj),i=1,2),j=1,nfac(jj)),jj=1,nnfac),
;      &     (((vak(i,j,jj),i=1,2),j=1,nvak(jj)),jj=1,nnvak),
;      &     tc_cnv,dc_cnv,pc_cnv,ec_cnv,sc_cnv,ye_cnv,ab_cnv,
;      &     et_cnv,sn_cnv,su_cnv,g1_cnv,g2_cnv,s1_cnv,s2_cnv,
;      &     an_cnv,(abun_cnv(i),i=1,nhiz),
;      &     xn_cnv,
;      &     aw_cnv,
;      &     summ0,levcnv,minloss,mingain,minnucl
;Version 10304
;       WRITE(43) nvers,ncyc,timesec,nconv,nnfak,nnfac,nnvak,nber,
;      &     (nfak(i),i=1,nnfak),(nfac(i),i=1,nnfac),(nvak(i),i=1,nnvak),
;      &     (yzip(i),i=1,nconv),(xmc(i),i=1,nconv),(rc(i),i=1,nconv),
;      &     (ber(i),i=1,nber),
;      &     (((fak(i,j,jj),i=1,2),j=1,nfak(jj)),jj=1,nnfak),
;      &     (((fac(i,j,jj),i=1,2),j=1,nfac(jj)),jj=1,nnfac),
;      &     (((vak(i,j,jj),i=1,2),j=1,nvak(jj)),jj=1,nnvak),
;      &     tc_cnv,dc_cnv,pc_cnv,ec_cnv,sc_cnv,ye_cnv,ab_cnv,
;      &     et_cnv,sn_cnv,su_cnv,g1_cnv,g2_cnv,s1_cnv,s2_cnv,
;      &     an_cnv,(abun_cnv(i),i=1,nhiz),
;      &     xn_cnv,
;      &     aw_cnv,
;      &     summ0,levcnv,minloss,mingain,minnucl,
;      &     en_cnv
;Version 10400
;       WRITE(43) nvers,ncyc,timesec,nconv,
;      &     nnuc,nnuk,nnucd,nnukd,ncoord,
;      &     idx_kind_len,nuc_kind_len,
;      &     (nuc(i),i=1,nnuc),(nuk(i),i=1,nnuk),
;      &     (nucd(i),i=1,nnucd),(nukd(i),i=1,nnukd),
;      &     (yzip(i),i=1,nconv),(xmc(i),i=1,nconv),(rc(i),i=1,nconv),
;      &     (xmcoord(i),i=1,ncoord),(rncoord(i),i=1,ncoord),
;      &     (inuc(i),i=1,nnuc),(inuk(i),i=1,nnuk),
;      &     (inucd(i),i=1,nnucd),(inukd(i),i=1,nnukd),
;      &     levcnv,minloss,mingain,minnucl,minnucg,
;      &     minlossd,mingaind,minnucld,minnucgd,
;      &     tc_cnv,dc_cnv,pc_cnv,ec_cnv,sc_cnv,ye_cnv,ab_cnv,
;      &     et_cnv,sn_cnv,su_cnv,g1_cnv,g2_cnv,s1_cnv,s2_cnv,
;      &     xn_cnv,aw_cnv,en_cnv,summ0,radius0,
;      &     an_cnv,(abun_cnv(i),i=1,nhiz)
;Version 10401
;       WRITE(43) nvers,ncyc,timesec,nconv,
;      &     nnuc,nnuk,nneu,nnucd,nnukd,nneud,
;      &     ncoord,
;      &     idx_kind_len,nuc_kind_len,
;      &     (nuc(i),i=1,nnuc),
;      &     (nuk(i),i=1,nnuk),
;      &     (neu(i),i=1,nneu),
;      &     (nucd(i),i=1,nnucd),
;      &     (nukd(i),i=1,nnukd),
;      &     (neud(i),i=1,nneud),
;      &     (yzip(i),i=1,nconv),(xmc(i),i=1,nconv),(rc(i),i=1,nconv),
;      &     (xmcoord(i),i=1,ncoord),(rncoord(i),i=1,ncoord),
;      &     (inuc(i),i=1,nnuc),
;      &     (inuk(i),i=1,nnuk),
;      &     (ineu(i),i=1,nneu),
;      &     (inucd(i),i=1,nnucd),
;      &     (inukd(i),i=1,nnukd),
;      &     (ineud(i),i=1,nneud),
;      &     levcnv,
;      &     minloss,mingain,minnucl,minnucg,minneul,minneug,
;      &     minlossd,mingaind,minnucld,minnucgd,minneuld,minneugd,
;      &     tc_cnv,dc_cnv,pc_cnv,ec_cnv,sc_cnv,ye_cnv,ab_cnv, 
;      &     et_cnv,sn_cnv,su_cnv,g1_cnv,g2_cnv,s1_cnv,s2_cnv,
;      &     aw_cnv,summ0,radius0,
;      &     an_cnv, (abun_cnv(i),i=1,nhiz),
;      &     eni_cnv    ,
;      &     enk_cnv    ,
;      &     enp_cnv    ,
;      &     ent_cnv    ,
;      &     epro_cnv   ,
;      &     enn_cnv    ,
;      &     enr_cnv    ,
;      &     ensc_cnv   ,
;      &     enes_cnv   ,
;      &     enc_cnv    ,
;      &     enpist_cnv ,
;      &     enid_cnv   ,
;      &     enkd_cnv   ,
;      &     enpd_cnv   ,
;      &     entd_cnv   ,
;      &     eprod_cnv  ,
;      &     xlumn_cnv  ,
;      &     enrd_cnv   ,
;      &     enscd_cnv  ,
;      &     enesd_cnv  ,
;      &     encd_cnv   ,
;      &     enpistd_cnv,
;      &     xlum_cnv   ,
;      &     xlum0_cnv  ,
;      &     entloss_cnv,
;      &     eniloss_cnv,
;      &     enkloss_cnv,
;      &     enploss_cnv,
;      &     enrloss_cnv,
;      &     angit_cnv,
;      &     anglt_cnv
;Version 10402
;       WRITE(43) nvers,ncyc,timesec,nconv,
;      &     nnuc,nnuk,nneu,nnucd,nnukd,nneud,
;      &     ncoord,
;      &     idx_kind_len,nuc_kind_len,
;      &     (nuc(i),i=1,nnuc),
;      &     (nuk(i),i=1,nnuk),
;      &     (neu(i),i=1,nneu),
;      &     (nucd(i),i=1,nnucd),
;      &     (nukd(i),i=1,nnukd),
;      &     (neud(i),i=1,nneud),
;      &     (yzip(i),i=1,nconv),(xmc(i),i=1,nconv),(rc(i),i=1,nconv),
;      &     (xmcoord(i),i=1,ncoord),(rncoord(i),i=1,ncoord),
;      &     (inuc(i),i=1,nnuc),
;      &     (inuk(i),i=1,nnuk),
;      &     (ineu(i),i=1,nneu),
;      &     (inucd(i),i=1,nnucd),
;      &     (inukd(i),i=1,nnukd),
;      &     (ineud(i),i=1,nneud),
;      &     levcnv,
;      &     minloss,mingain,minnucl,minnucg,minneul,minneug,
;      &     minlossd,mingaind,minnucld,minnucgd,minneuld,minneugd,
;      &     tc_cnv,dc_cnv,pc_cnv,ec_cnv,sc_cnv,ye_cnv,ab_cnv, 
;      &     et_cnv,sn_cnv,su_cnv,g1_cnv,g2_cnv,s1_cnv,s2_cnv,
;      &     aw_cnv,summ0,radius0,
;      &     an_cnv, (abun_cnv(i),i=1,nhiz),
;      &     eni_cnv    ,
;      &     enk_cnv    ,
;      &     enp_cnv    ,
;      &     ent_cnv    ,
;      &     epro_cnv   ,
;      &     enn_cnv    ,
;      &     enr_cnv    ,
;      &     ensc_cnv   ,
;      &     enes_cnv   ,
;      &     enc_cnv    ,
;      &     enpist_cnv ,
;      &     enid_cnv   ,
;      &     enkd_cnv   ,
;      &     enpd_cnv   ,
;      &     entd_cnv   ,
;      &     eprod_cnv  ,
;      &     xlumn_cnv  ,
;      &     enrd_cnv   ,
;      &     enscd_cnv  ,
;      &     enesd_cnv  ,
;      &     encd_cnv   ,
;      &     enpistd_cnv,
;      &     xlum_cnv   ,
;      &     xlum0_cnv  ,
;      &     entloss_cnv,
;      &     eniloss_cnv,
;      &     enkloss_cnv,
;      &     enploss_cnv,
;      &     enrloss_cnv,
;      &     angit_cnv,
;      &     anglt_cnv,
;      &     xmacc_cnv
;Version 10403
;       WRITE(43) nvers,ncyc,timesec,dt,nconv,
;      &     nnuc,nnuk,nneu,nnucd,nnukd,nneud,
;      &     ncoord,
;      &     idx_kind_len,nuc_kind_len,
;      &     (nuc(i),i=1,nnuc),
;      &     (nuk(i),i=1,nnuk),
;      &     (neu(i),i=1,nneu),
;      &     (nucd(i),i=1,nnucd),
;      &     (nukd(i),i=1,nnukd),
;      &     (neud(i),i=1,nneud),
;      &     (yzip(i),i=1,nconv),(xmc(i),i=1,nconv),(rc(i),i=1,nconv),
;      &     (xmcoord(i),i=1,ncoord),(rncoord(i),i=1,ncoord),
;      &     (inuc(i),i=1,nnuc),
;      &     (inuk(i),i=1,nnuk),
;      &     (ineu(i),i=1,nneu),
;      &     (inucd(i),i=1,nnucd),
;      &     (inukd(i),i=1,nnukd),
;      &     (ineud(i),i=1,nneud),
;      &     levcnv,
;      &     minloss,mingain,minnucl,minnucg,minneul,minneug,
;      &     minlossd,mingaind,minnucld,minnucgd,minneuld,minneugd,
;      &     tc_cnv,dc_cnv,pc_cnv,ec_cnv,sc_cnv,ye_cnv,ab_cnv, 
;      &     et_cnv,sn_cnv,su_cnv,g1_cnv,g2_cnv,s1_cnv,s2_cnv,
;      &     aw_cnv,summ0,radius0,
;      &     an_cnv, (abun_cnv(i),i=1,nhiz),
;      &     eni_cnv    ,
;      &     enk_cnv    ,
;      &     enp_cnv    ,
;      &     ent_cnv    ,
;      &     epro_cnv   ,
;      &     enn_cnv    ,
;      &     enr_cnv    ,
;      &     ensc_cnv   ,
;      &     enes_cnv   ,
;      &     enc_cnv    ,
;      &     enpist_cnv ,
;      &     enid_cnv   ,
;      &     enkd_cnv   ,
;      &     enpd_cnv   ,
;      &     entd_cnv   ,
;      &     eprod_cnv  ,
;      &     xlumn_cnv  ,
;      &     enrd_cnv   ,
;      &     enscd_cnv  ,
;      &     enesd_cnv  ,
;      &     encd_cnv   ,
;      &     enpistd_cnv,
;      &     xlum_cnv   ,
;      &     xlum0_cnv  ,
;      &     entloss_cnv,
;      &     eniloss_cnv,
;      &     enkloss_cnv,
;      &     enploss_cnv,
;      &     enrloss_cnv,
;      &     angit_cnv,
;      &     anglt_cnv,
;      &     xmacc_cnv



COMMON conv, nmodellmax,nnergmax,nergmax,nconvmax,nnerg,nerg,erg,nconv,conv,convr,convtype,time,timecc,modellnr,modells
COMMON conv2, nnerkmax,nerkmax,nnerk,nerk,erk,nbermax,nber,ber
COMMON conv3, nnnukmax,nnukmax,nnnuk,nnuk,nuk
COMMON conv4, tn,dn,pn,en,stot,ye,abar,eta,sn,snn,gamma1,gamma2,gs1,gs2,net,nhiz,abun,ln,aw,lnnuc
COMMON conv5, nlerg,nlerk,nlnuk
COMMON conv6, summ0,levcnv,minloss,mingain,minnucl,minnucg
COMMON conv7, nnnucmax,nnucmax,nnnuc,nnuc,nuc,nlnuc
COMMON conv8, radius0,ergr,erkr,nukr,nucr,minvers,maxvers
COMMON conv9, nnergdmax,nergdmax,nnergd,nergd,ergd,ergdr,nlergd
COMMON conv10,nnerkdmax,nerkdmax,nnerkd,nerkd,erkd,erkdr,nlerkd
COMMON conv11,nnnukdmax,nnukdmax,nnnukd,nnukd,nukd,nukdr,nlnukd
COMMON conv12,nnnucdmax,nnucdmax,nnnucd,nnucd,nucd,nucdr,nlnucd
COMMON conv13,minlossd,mingaind,minnucld,minnucgd
COMMON conv14,eni,enk,enp,ent,epro,enn,enr,ensc,enes,enc,enpist 
COMMON conv15,enid,enkd,enpd,entd,eprod,xlumn,enrd,enscd,enesd,encd,enpistd
COMMON conv16,xlum,xlum0,entloss,eniloss,enkloss,enploss,enrloss
COMMON conv17,minneul,minneug,minneuld,minneugd
COMMON conv18,nnneudmax,nneudmax,nnneud,nneud,neud,neudr,nlneud
COMMON conv19,nnnevdmax,nnevdmax,nnnevd,nnevd,nevd,nevdr,nlnevd
COMMON conv20,nnneumax,nneumax,nnneu,nneu,neu,neur,nlneu
COMMON conv21,nnnevmax,nnevmax,nnnev,nnev,nev,nevr,nlnev
COMMON conv22,angit,anglt
COMMON conv23,xmacc
COMMON conv24,dt

COMMON loadconv, fileinfo

starttime=SYSTIME(/SECONDS)

IF N_ELEMENTS(verbose) EQ 0 THEN verbose=2
IF N_ELEMENTS(showtime) EQ 0 THEN showtime=0
IF verbose GE 2 THEN showtime=1

IF N_ELEMENTS(reload) EQ 0 THEN reload=0

IF N_ELEMENTS(lastmodell) EQ 0 THEN lastmodell=LONG(2UL^31-1)
IF N_ELEMENTS(firstmodell) EQ 0 THEN firstmodell=LONG(-2UL^31)
IF N_ELEMENTS(stepmodell) EQ 0 THEN stepmodell=1L
IF N_ELEMENTS(removezerotime) EQ 0 THEN removezerotime=1
stepmodell=MAX([1L,stepmodell])

ext='.cnv'
getfile,ext,name0,fileinfo,compress,reload
IF reload EQ 0 THEN RETURN

;; IF N_ELEMENTS(name0) EQ 0 THEN name='' ELSE name=name0
;; IF (name EQ '') AND (N_ELEMENTS(filename) NE 0) THEN name=filename
;; IF N_ELEMENTS(name) EQ 0 THEN name='*.cnv*'
;; xxx=FINDFILE(name,COUNT=xxx_count)
;; IF (xxx_count EQ 0) AND (STRLOWCASE(STRMID(name,3,4,/reverse)) EQ '.cnv') THEN BEGIN
;;     name=name+'.gz'
;;     xxx=FINDFILE(name,COUNT=xxx_count)
;; ENDIF
;; IF (xxx_count NE 1) OR (name EQ '') THEN BEGIN
;;    PRINT,' [LOADCONV] COULD NOT FIND FILE '+name
;;    name=DIALOG_PICKFILE(/NOCONFIRM,/READ,/MUST_EXIST,FILTER='*.cnv*')
;;    IF name EQ '' THEN RETURN
;; ENDIF ELSE BEGIN
;;    name=xxx(0)
;; ENDELSE
;; IF N_ELEMENTS(filename) EQ 0 THEN filename=''
;; IF (name EQ filename) AND (reload EQ 0) THEN BEGIN
;;    PRINT,' [LOADCONV] NOT RELOADING FILE '+name
;;    RETURN
;; ENDIF
;; filename=name
;; compress=STRLOWCASE(STRMID(STRTRIM(filename,2),2,3,/REVERSE_OFFSET)) EQ '.gz'

;.......................................................................
; auto-detect endian
OPENR,unit,fileinfo.name,/GET_LUN,COMPRESS=compress
l1=0UL
OK=1
READU,unit,l1
ON_IOERROR, file_eof
xeof=1
IF l1+4L GE 2UL^31 THEN BEGIN
    xeof=0
    goto,file_eof
ENDIF
POINT_LUN,unit,l1+4L
xeof=0
file_eof:
if xeof EQ 1 THEN OK=0
l2=0UL
IF OK THEN BEGIN
    OK=0
    READU,unit,l2
    IF l2 EQ l1 THEN OK=1
ENDIF
IF OK EQ 0 THEN BEGIN
    CLOSE,unit
    OPENR,unit,fileinfo.name,/SWAP_ENDIAN,COMPRESS=compress
    l1=0UL
    OK=1
    READU,unit,l1
    ON_IOERROR, file_eof1
    xeof=1
    POINT_LUN,unit,l1+4L
    xeof=0
    file_eof1: if xeof EQ 1 THEN OK=0
    l2=0UL
    IF OK THEN BEGIN
        READU,unit,l2
        IF l2 NE l1 THEN OK=0
    ENDIF
    IF OK EQ 1 THEN BEGIN
        IF verbose GE 2 THEN BEGIN
            PRINT,' [LOADCONV] swapping endian.'
        ENDIF
    ENDIF ELSE BEGIN
        PRINT," [LOADCONV] ERROR: can't determine endian."
        PRINT," [LOADCONV] TERMINATING!"
        RETURN
    ENDELSE
ENDIF ELSE BEGIN
    POINT_LUN,unit,0
ENDELSE
;.......................................................................

x=fstat(unit)
xsize=x.size
IF compress THEN xsize=9999999999999LL

IF verbose GE 2 THEN BEGIN
    PRINT,' [LOADCONV] loading file '+fileinfo.name
    IF compress THEN sc=' (compressed)' ELSE sc=''
    PRINT,' [LOADCONV] filesize '+byte2human(x.size)+sc
ENDIF

minvers=2L^30
maxvers=0L

nvers=-1L
minvers=LONG(2LL^31-1)
maxvers=-1L
modell=0L
xtime=0.0D0
xdt=0.D0
mnconv=-1L

mnber=-1L
mncoord=-1L

nnfak=-1L
nnfac=-1L
nnvak=-1L
nnvac=-1L
nnfeu=-1L
nnfev=-1L
nnfakd=-1L
nnfacd=-1L
nnvakd=-1L
nnvacd=-1L
nnfeud=-1L
nnfevd=-1L

;mnnuc=-1L
;mnnuk=-1L
;mnneu=-1L
;mnnucd=-1L
;mnnukd=-1L
;mnneud=-1L

IF verbose GE 2 THEN PRINT," [LOADCONV] determining model parameters ..."

nnselinc=16384L
nnsel=nnselinc
sel=LON64ARR(nnsel)
selmod=LONARR(nnsel)
nsel=0L

nerglim=128

nloadbytes=0LL

nmodellmax=1L

nnergmax=1L
nnerkmax=1L
nnnukmax=1L
nnnucmax=1L
nnneumax=1L
nnnevmax=1L
nnergdmax=1L
nnerkdmax=1L
nnnukdmax=1L
nnnucdmax=1L
nnneudmax=1L
nnnevdmax=1L

nergmax=1L
nerkmax=1L
nnukmax=1L
nnucmax=1L
nneumax=1L
nnevmax=1L
nergdmax=1L
nerkdmax=1L
nnukdmax=1L
nnucdmax=1L
nneudmax=1L
nnevdmax=1L

nerxmax=1L
nnerxmax=1L

nconvmax=1L

; pre version 10400
nbermax=0L


i=0L
pos=0LL
done=0

merg=0L
merk=0L
mnuk=0L
mnuc=0L
mneu=0L
mnev=0L
mergd=0L
merkd=0L
mnukd=0L
mnucd=0L
mneud=0L
mnevd=0L

lerg=0L
lerk=0L
lnuk=0L
lnuc=0L
lneu=0L
lnev=0L
lergd=0L
lerkd=0L
lnukd=0L
lnucd=0L
lneud=0L
lnevd=0L

idx_kind_len=4L
nuc_kind_len=2L

mber=0L
first=1

lasttime=SYSTIME(/SECONDS)

modell0=-1
ON_IOERROR,EOF
WHILE (NOT EOF(unit)) AND (modell LT lastmodell) AND (NOT done) DO BEGIN
    recsize=0L
    IF pos+4LL GT xsize THEN BEGIN
        done=1
        GOTO,endofloop
    ENDIF
    POINT_LUN,-unit,cur_pos
    IF cur_pos LT pos THEN BEGIN
        temp=BYTARR(pos-cur_pos)
        READU,unit,temp
        temp=0
    ENDIF ELSE IF cur_pos GT pos THEN BEGIN
        POINT_LUN,unit,pos
    ENDIF
    READU,unit,recsize
    recsize+=8L
    IF pos+recsize GT xsize THEN BEGIN
        done=1
        GOTO,endofloop
     ENDIF
    READU,unit,nvers,modell,xtime
    minvers<=nvers
    maxvers>=nvers
    IF first EQ 1 THEN BEGIN
        IF verbose GE 2 THEN BEGIN
            PRINT,' [LOADCONV] version '+STRING(nvers,FORMAT='(I5)')
        ENDIF
        first=0
    ENDIF ELSE BEGIN
        IF modell GT modell0+1L THEN BEGIN
            PRINT,' [LOADCONV] FILE ERROR? Model '+STRING(modell0,FORMAT='(I8)')+' followed by model '+STRING(modell,FORMAT='(I8)')
        ENDIF
     ENDELSE

    IF modell mod stepmodell NE 0 THEN GOTO,countnext
    IF modell GE firstmodell THEN BEGIN

       IF nvers GE 10403 THEN READU,unit,xdt
       READU,unit,mnconv

        nconvmax>=mnconv
        
        IF (nvers GE 10400) THEN BEGIN
           CASE nvers OF
              10400 : BEGIN
                 kx=[0,1,3,4]
              END
              ELSE: BEGIN
                 kx=[0,1,2,3,4,5]
              END
           ENDCASE
           nk=N_ELEMENTS(kx)
           mnnx=LONARR(nk)
           READU,unit,mnnx, $
                 mncoord,idx_kind_len,nuc_kind_len

            nuc_type=3
            IF (nuc_kind_len) EQ 4 THEN nuc_type=2
            IF (nuc_kind_len) EQ 2 THEN nuc_type=1

            FOR ki=0,nk-1 DO BEGIN
               k=kx[ki]
               mnnux=mnnx[ki]
               
                IF mnnux GT 0 THEN BEGIN
                    mmnux=MAKE_ARRAY(mnnux,TYPE=nuc_type,/NOZERO)
                    READU,unit,mmnux

                    nnfax=MAX(mmnux)
                    IF (nnfax GT nerglim) THEN BEGIN
                        xx=WHERE(mmnux GE nerglim)
                        IF xx[0] NE -1 THEN BEGIN
                            mmnux+=0S
                            mmnux[xx]-=256
                        ENDIF
                        nnfax=MAX(mmnux)
                    ENDIF
                    nnfay=-MIN(mmnux)

                    FOR kk=0,1 DO BEGIN
                        IF kk EQ 0 THEN nnfaz=nnfax ELSE nnfaz=nnfay

                        IF nnfaz GT 0 THEN BEGIN
                            CASE 2*k+kk OF
                                0: BEGIN
                                    nerzmax=nergmax
                                    merz=merg
                                END
                                1: BEGIN
                                    nerzmax=nerkmax
                                    merz=merk
                                END
                                2: BEGIN
                                    nerzmax=nnukmax
                                    merz=mnuk
                                END
                                3: BEGIN
                                    nerzmax=nnucmax
                                    merz=mnuc
                                END
                                4: BEGIN
                                    nerzmax=nneumax
                                    merz=mneu
                                END
                                5: BEGIN
                                    nerzmax=nnevmax
                                    merz=mnev
                                END
                                6: BEGIN
                                    nerzmax=nergdmax
                                    merz=mergd
                                END
                                7: BEGIN
                                    nerzmax=nerkdmax
                                    merz=merkd
                                END
                                8: BEGIN
                                    nerzmax=nnukdmax
                                    merz=mnukd
                                END
                                9: BEGIN
                                    nerzmax=nnucdmax
                                    merz=mnucd
                                END
                               10: BEGIN
                                    nerzmax=nneudmax
                                    merz=mneud
                                END
                               11: BEGIN
                                    nerzmax=nnevdmax
                                    merz=mnevd
                                END
                            ENDCASE

                            nfaz=LONARR(nnfaz)
                            ifaz0=-1
                            FOR j=0,mnnux-1 DO BEGIN
                                IF kk EQ 0 THEN BEGIN
                                    ifaz=(mmnux[j]>0)-1
                                ENDIF ELSE BEGIN
                                    ifaz=((-mmnux[j])>0)-1
                                ENDELSE
                                FOR jj=ifaz0+1,ifaz DO BEGIN
                                    nfaz[jj]+=1
                                ENDFOR
                                ifaz0=ifaz
                            ENDFOR
                            FOR j=0,nnfaz-1 DO BEGIN
                                nerzmax>=nfaz[j]
                                merz+=nfaz[j]
                            ENDFOR
                            nerxmax>=nerzmax

                            CASE 2*k+kk OF
                                0: BEGIN
                                    nergmax =nerzmax
                                    merg    =merz
                                END
                                1: BEGIN
                                    nerkmax =nerzmax
                                    merk    =merz
                                END
                                2: BEGIN
                                    nnukmax =nerzmax
                                    mnuk    =merz
                                END
                                3: BEGIN
                                    nnucmax =nerzmax
                                    mnuc    =merz
                                END
                                4: BEGIN
                                    nneumax =nerzmax
                                    mneu    =merz
                                END
                                5: BEGIN
                                    nnevmax =nerzmax
                                    mnev    =merz
                                END
                                6: BEGIN
                                    nergdmax=nerzmax
                                    mergd   =merz
                                END
                                7: BEGIN
                                    nerkdmax=nerzmax
                                    merkd   =merz
                                END
                                8: BEGIN
                                    nnukdmax=nerzmax
                                    mnukd   =merz
                                END
                                9: BEGIN
                                    nnucdmax=nerzmax
                                    mnucd   =merz
                                END
                               10: BEGIN
                                    nneudmax=nerzmax
                                    mneud   =merz
                                END
                               11: BEGIN
                                    nnevdmax=nerzmax
                                    mnevd   =merz
                                END
                            ENDCASE
                        ENDIF
                    ENDFOR
                ENDIF ELSE BEGIN
                    nnfax=0
                    nnfay=0
                ENDELSE

                CASE k OF
                    0:BEGIN
                        nnfak =nnfax
                        nnfac =nnfay
                    END
                    1:BEGIN
                        nnvak =nnfax
                        nnvac =nnfay
                    END
                    2:BEGIN
                        nnfeu =nnfax
                        nnfev =nnfay
                    END
                    3:BEGIN
                        nnfakd=nnfax
                        nnfacd=nnfay
                    END
                    4:BEGIN
                        nnvakd=nnfax
                        nnvacd=nnfay
                    END
                    5:BEGIN
                        nnfeud=nnfax
                        nnfevd=nnfay
                    END
                ENDCASE
                nnerxmax>=nnfax
                nnerxmax>=nnfay
            ENDFOR
        ENDIF ELSE BEGIN
            READU,unit,nnfak,nnfac,nnvak,mnber

            mnber2=mnber/2
            nbermax>=mnber2
            mber+=mnber2

            IF nnfak GT 0 THEN BEGIN
                nfak=LONARR(nnfak,/NOZERO)
                READU,unit,nfak
                FOR j=0,nnfak-1 DO BEGIN
                    nergmax>=nfak[j]
                    merg+=nfak[j]
                ENDFOR
            ENDIF
            IF nnfac GT 0 THEN BEGIN
                nfac=LONARR(nnfac,/NOZERO)
                READU,unit,nfac
                FOR j=0,nnfac-1 DO BEGIN
                    nerkmax>=nfac[j]
                    merk+=nfac[j]
                ENDFOR
            ENDIF
            IF nnvak GT 0 THEN BEGIN
                nvak=LONARR(nnvak,/NOZERO)
                READU,unit,nvak
                FOR j=0,nnvak-1 DO BEGIN
                    nnukmax>=nvak[j]
                    mnuk+=nvak[j]
                ENDFOR
            ENDIF

        ENDELSE

        nnergmax >=nnfak
        nnerkmax >=nnfac
        nnnukmax >=nnvak
        nnnucmax >=nnvac
        nnneumax >=nnfeu
        nnnevmax >=nnfev
        nnergdmax>=nnfakd
        nnerkdmax>=nnfacd
        nnnukdmax>=nnvakd
        nnnucdmax>=nnvacd
        nnneudmax>=nnfeud
        nnnevdmax>=nnfevd

        lerg +=nnfak
        lerk +=nnfac
        lnuk +=nnvak
        lnuc +=nnvac
        lneu +=nnfeu
        lnev +=nnfev
        lergd+=nnfakd
        lerkd+=nnfacd
        lnukd+=nnvakd
        lnucd+=nnvacd
        lneud+=nnfeud
        lnevd+=nnfevd

        i=i+1
        IF (modell MOD 100 EQ 0) AND (verbose GE 3) THEN BEGIN
            PRINT," [LOADCONV] model ",modell
        ENDIF

;.... section for selection management
        IF nsel GT 0 THEN BEGIN
            IF modell LE selmod[nsel-1] THEN BEGIN
                isel=nsel
                REPEAT BEGIN
                    isel-=1
                ENDREP UNTIL (modell EQ selmod[isel]) OR (isel EQ 0)
                IF (isel EQ 0) AND (modell NE selmod[isel]) THEN BEGIN
                    PRINT,' [LOADCONV] -----------------------------'
                    PRINT,' [LOADCONV] FILE ERROR: ABORDING.'
                    PRINT,' [LOADCONV] model to read    = '+STRING(modell,FORMAT="(I8)")
                    PRINT,' [LOADCONV] first read model = '+STRING(selmod[isel],FORMAT="(I8)")
                    PRINT,' [LOADCONV] -----------------------------'
                    RETURN
                ENDIF
                PRINT,' [LOADCONV] removing redundant models '+STRING(selmod(isel))+'...'+STRING(selmod(nsel-1))
                nsel=isel
            ENDIF
        ENDIF

        IF nsel EQ nnsel THEN BEGIN
            nnsel+=nnselinc
            seltmp=LON64ARR(nnsel)
            seltmp[0:nsel-1]=sel[0:nsel-1]
            sel=seltmp
            seltmp=LONARR(nnsel)
            seltmp[0:nsel-1]=selmod[0:nsel-1]
            selmod=seltmp
            seltmp=0L ; free memory
        ENDIF

        sel[nsel]=pos
        selmod[nsel]=modell
        nsel+=1
        nloadbytes+=recsize
    ENDIF
    GOTO,countnext
countnext:
    pos+=recsize
    modell0=modell
    GOTO,endofloop
EOF:
    done=1
endofloop:
    IF (verbose GE 1) AND NOT compress THEN BEGIN
       curtime=SYSTIME(/SECONDS)
       IF (curtime-lasttime GT 5) THEN BEGIN
          PRINT," [LOADCONV] ETA: "+TIME2HUMAN((xsize-pos)*(curtime-starttime)/(pos>1))+'.  Time scanning so far: '+TIME2HUMAN(curtime-starttime)
          lasttime=curtime
       ENDIF
    ENDIF
ENDWHILE
nmodellmax=nsel+1
lastpos=pos
scantime=SYSTIME(/SECONDS)

PRINT,' [LOADCONV] data scanned in '+time2human(scantime-starttime)+'.'

IF minvers NE maxvers THEN BEGIN
    PRINT,' [LOADCONV] WARNING: Different versions in one file!'
ENDIF

IF verbose GE 3 THEN BEGIN
; this is outdated and needs updating
    PRINT,' [LOADCONV] saving ',nmodellmax*(nnergmax*nergmax+nnerkmax*nerkmax+nnnukmax*nnukmax),merg+merk+mnuk,nmodellmax*(nnergmax*nergmax+nnerkmax*nerkmax+nnnukmax*nnukmax)*1.D0/(merg+merk+mnuk)
    PRINT,' [LOADCONV] saving ',nmodellmax*(nnergmax+nnerkmax+nnnukmax),lerg+lerk+lnuk,nmodellmax*(nnergmax+nnerkmax+nnnukmax)*1.D0/(lerg+lerk+lnuk)
ENDIF

ON_IOERROR,NULL

IF nerkmax GT 24 THEN BEGIN
    PRINT,' [LOADCONV] WARNING: nerkmax is ',nerkmax
ENDIF

nnerg  =LONARR(nmodellmax,/NOZERO)
 nerg  =LONARR(MAX([lerg+1L,1L]),/NOZERO)
  erg  =DBLARR(2,MAX([merg,1L]),/NOZERO)
  ergr =DBLARR(2,MAX([merg,1L]),/NOZERO)
nlerg  =LONARR(MAX([nnergmax,1L])) ; do zero!

nnerk  =LONARR(nmodellmax,/NOZERO)
 nerk  =LONARR(MAX([lerk+1L,1L]),/NOZERO)
  erk  =DBLARR(2,MAX([merk,1L]),/NOZERO)
  erkr =DBLARR(2,MAX([merk,1L]),/NOZERO)
nlerk  =LONARR(MAX([nnerkmax,1L])) ; do zero!

nnnuk  =LONARR(nmodellmax,/NOZERO)
 nnuk  =LONARR(MAX([lnuk+1L,1L]),/NOZERO)
  nuk  =DBLARR(2,MAX([mnuk,1L]),/NOZERO)
  nukr =DBLARR(2,MAX([mnuk,1L]),/NOZERO)
nlnuk  =LONARR(MAX([nnnukmax,1L])) ; do zero!

nnnuc  =LONARR(nmodellmax,/NOZERO)
 nnuc  =LONARR(MAX([lnuc+1L,1L]),/NOZERO)
  nuc  =DBLARR(2,MAX([mnuc,1L]),/NOZERO)
  nucr =DBLARR(2,MAX([mnuc,1L]),/NOZERO)
nlnuc  =LONARR(MAX([nnnucmax,1L])) ; do zero!

nnneu  =LONARR(nmodellmax,/NOZERO)
 nneu  =LONARR(MAX([lneu+1L,1L]),/NOZERO)
  neu  =DBLARR(2,MAX([mneu,1L]),/NOZERO)
  neur =DBLARR(2,MAX([mneu,1L]),/NOZERO)
nlneu  =LONARR(MAX([nnneumax,1L])) ; do zero!

nnnev  =LONARR(nmodellmax,/NOZERO)
 nnev  =LONARR(MAX([lnev+1L,1L]),/NOZERO)
  nev  =DBLARR(2,MAX([mnev,1L]),/NOZERO)
  nevr =DBLARR(2,MAX([mnev,1L]),/NOZERO)
nlnev  =LONARR(MAX([nnnevmax,1L])) ; do zero!

nnergd =LONARR(nmodellmax,/NOZERO)
 nergd =LONARR(MAX([lergd+1L,1L]),/NOZERO)
  ergd =DBLARR(2,MAX([mergd,1L]),/NOZERO)
  ergdr=DBLARR(2,MAX([mergd,1L]),/NOZERO)
nlergd =LONARR(MAX([nnergdmax,1L])) ; do zero!

nnerkd =LONARR(nmodellmax,/NOZERO)
 nerkd =LONARR(MAX([lerkd+1L,1L]),/NOZERO)
  erkd =DBLARR(2,MAX([merkd,1L]),/NOZERO)
  erkdr=DBLARR(2,MAX([merkd,1L]),/NOZERO)
nlerkd =LONARR(MAX([nnerkdmax,1L])) ; do zero!

nnnukd =LONARR(nmodellmax,/NOZERO)
 nnukd =LONARR(MAX([lnukd+1L,1L]),/NOZERO)
  nukd =DBLARR(2,MAX([mnukd,1L]),/NOZERO)
  nukdr=DBLARR(2,MAX([mnukd,1L]),/NOZERO)
nlnukd =LONARR(MAX([nnnukdmax,1L])) ; do zero!

nnnucd =LONARR(nmodellmax,/NOZERO)
 nnucd =LONARR(MAX([lnucd+1L,1L]),/NOZERO)
  nucd =DBLARR(2,MAX([mnucd,1L]),/NOZERO)
  nucdr=DBLARR(2,MAX([mnucd,1L]),/NOZERO)
nlnucd =LONARR(MAX([nnnucdmax,1L])) ; do zero!

nnneud =LONARR(nmodellmax,/NOZERO)
 nneud =LONARR(MAX([lneud+1L,1L]),/NOZERO)
  neud =DBLARR(2,MAX([mneud,1L]),/NOZERO)
  neudr=DBLARR(2,MAX([mneud,1L]),/NOZERO)
nlneud =LONARR(MAX([nnneudmax,1L])) ; do zero!

nnnevd =LONARR(nmodellmax,/NOZERO)
 nnevd =LONARR(MAX([lnevd+1L,1L]),/NOZERO)
  nevd =DBLARR(2,MAX([mnevd,1L]),/NOZERO)
  nevdr=DBLARR(2,MAX([mnevd,1L]),/NOZERO)
nlnevd =LONARR(MAX([nnnevdmax,1L])) ; do zero!

nconv    =INTARR(nmodellmax,/NOZERO)
 conv    =DBLARR(MAX([nconvmax,1L]),nmodellmax,/NOZERO)
 convr   =DBLARR(MAX([nconvmax,1L]),nmodellmax,/NOZERO)
 convtype=BYTARR(MAX([nconvmax,1L]),nmodellmax,/NOZERO)

time=DBLARR(nmodellmax,/NOZERO)
IF maxvers GE 10403 THEN BEGIN
   dt=DBLARR(nmodellmax,/NOZERO)
ENDIF

; this is for version prior to 10400
; the file stores information about area of maximum energy generation
IF mber GT 0 THEN BEGIN
    nber=LONARR(nmodellmax,/NOZERO)
    ber=DBLARR(2,mber,/NOZERO)
ENDIF

modellnr=LONARR(nmodellmax,/NOZERO)

IF maxvers GE 10300 THEN BEGIN
; central data arrays
    tn=DBLARR(nmodellmax,/NOZERO)
    dn=DBLARR(nmodellmax,/NOZERO)
    pn=DBLARR(nmodellmax,/NOZERO)
    en=DBLARR(nmodellmax,/NOZERO)
    stot=DBLARR(nmodellmax,/NOZERO)
    ye=DBLARR(nmodellmax,/NOZERO)
    abar=DBLARR(nmodellmax,/NOZERO)
    eta=DBLARR(nmodellmax,/NOZERO)
    sn=DBLARR(nmodellmax,/NOZERO)
    snn=DBLARR(nmodellmax,/NOZERO)
    gamma1=DBLARR(nmodellmax,/NOZERO)
    gamma2=DBLARR(nmodellmax,/NOZERO)
    gs1=DBLARR(nmodellmax,/NOZERO)
    gs2=DBLARR(nmodellmax,/NOZERO)
    net=LONARR(nmodellmax,/NOZERO)

    nhiz=20L
    abun=DBLARR(nhiz,nmodellmax,/NOZERO)
ENDIF
IF maxvers GE 10301 AND minvers LT 10401 THEN BEGIN
; and neutrino luminosity
    ln=DBLARR(nmodellmax,/NOZERO)
ENDIF
IF maxvers GE 10302 THEN BEGIN
; and central rotation
    aw=DBLARR(nmodellmax,/NOZERO)
ENDIF
IF minvers GE 10303 THEN BEGIN
; and mass at base of problem
    summ0=DBLARR(nmodellmax,/NOZERO)
    levcnv=LONARR(nmodellmax,/NOZERO)
    mingain=LONARR(nmodellmax,/NOZERO)
    minloss=LONARR(nmodellmax,/NOZERO)
    minnucl=LONARR(nmodellmax,/NOZERO)
ENDIF ELSE BEGIN
    summ0=REPLICATE(0.0D0,nmodellmax)
    levcnv=REPLICATE(1,nmodellmax)
    mingain=REPLICATE(-1,nmodellmax)
    minloss=REPLICATE(-1,nmodellmax)
    minnucl=REPLICATE(-1,nmodellmax)
ENDELSE
IF maxvers GE 10304 AND minvers LT 10401 THEN BEGIN
; and total nuclear energy generation
    lnnuc=DBLARR(nmodellmax,/NOZERO)
ENDIF

IF minvers LT 10400 THEN BEGIN
    radius0 =REPLICATE(0.0D0,nmodellmax)

    minnucg =REPLICATE(-1,nmodellmax)

    minnucgd=REPLICATE(-1,nmodellmax)
    mingaind=REPLICATE(-1,nmodellmax)
    minlossd=REPLICATE(-1,nmodellmax)
    minnucld=REPLICATE(-1,nmodellmax)
ENDIF ELSE BEGIN
    radius0=DBLARR(nmodellmax,/NOZERO)

    iifaz =INTARR(2,nerxmax ,nnerxmax )

    minnucg =LONARR(nmodellmax,/NOZERO)

    minnucgd=LONARR(nmodellmax,/NOZERO)
    mingaind=LONARR(nmodellmax,/NOZERO)
    minlossd=LONARR(nmodellmax,/NOZERO)
    minnucld=LONARR(nmodellmax,/NOZERO)
ENDELSE
IF minvers LT 10401 THEN BEGIN
   minneul =LONARR(nmodellmax,/NOZERO)
   minneug =LONARR(nmodellmax,/NOZERO)
   minneuld=LONARR(nmodellmax,/NOZERO)
   minneugd=LONARR(nmodellmax,/NOZERO)
ENDIF ELSE BEGIN
    minneul =REPLICATE(-1,nmodellmax)
    minneug =REPLICATE(-1,nmodellmax)
    minneuld=REPLICATE(-1,nmodellmax)
    minneugd=REPLICATE(-1,nmodellmax)
; many more
    eni    =DBLARR(nmodellmax,/NOZERO)
    enk    =DBLARR(nmodellmax,/NOZERO)
    enp    =DBLARR(nmodellmax,/NOZERO)
    ent    =DBLARR(nmodellmax,/NOZERO)
    epro   =DBLARR(nmodellmax,/NOZERO)
    enn    =DBLARR(nmodellmax,/NOZERO)
    enr    =DBLARR(nmodellmax,/NOZERO)
    ensc   =DBLARR(nmodellmax,/NOZERO)
    enes   =DBLARR(nmodellmax,/NOZERO)
    enc    =DBLARR(nmodellmax,/NOZERO)
    enpist =DBLARR(nmodellmax,/NOZERO)
    enid   =DBLARR(nmodellmax,/NOZERO)
    enkd   =DBLARR(nmodellmax,/NOZERO)
    enpd   =DBLARR(nmodellmax,/NOZERO)
    entd   =DBLARR(nmodellmax,/NOZERO)
    eprod  =DBLARR(nmodellmax,/NOZERO)
    xlumn  =DBLARR(nmodellmax,/NOZERO)
    enrd   =DBLARR(nmodellmax,/NOZERO)
    enscd  =DBLARR(nmodellmax,/NOZERO)
    enesd  =DBLARR(nmodellmax,/NOZERO)
    encd   =DBLARR(nmodellmax,/NOZERO)
    enpistd=DBLARR(nmodellmax,/NOZERO)
    xlum   =DBLARR(nmodellmax,/NOZERO)
    xlum0  =DBLARR(nmodellmax,/NOZERO)
    entloss=DBLARR(nmodellmax,/NOZERO)
    eniloss=DBLARR(nmodellmax,/NOZERO)
    enkloss=DBLARR(nmodellmax,/NOZERO)
    enploss=DBLARR(nmodellmax,/NOZERO)
    enrloss=DBLARR(nmodellmax,/NOZERO)
    angit  =DBLARR(nmodellmax,/NOZERO)
    anglt  =DBLARR(nmodellmax,/NOZERO)
ENDELSE
xmacc=DBLARR(nmodellmax)

IF (verbose GE 2) THEN BEGIN
    PRINT," [LOADCONV] reading models ("+byte2human(nloadbytes)+') ...'
ENDIF

; some initialization for layer data
lerg =0L
lerk =0L
lnuk =0L
lnuc =0L
lneu =0L
lnev =0L
lergd=0L
lerkd=0L
lnukd=0L
lnucd=0L
lneud=0L
lnevd=0L

merg =0L
merk =0L
mnuk =0L
mnuc =0L
mneu =0L
mnev =0L
mergd=0L
merkd=0L
mnukd=0L
mnucd=0L
mneud=0L
mnevd=0L

nnerg [0]=lerg
nnerk [0]=lerk
nnnuk [0]=lnuk
nnnuc [0]=lnuc
nnneu [0]=lneu
nnnev [0]=lnev
nnergd[0]=lergd
nnerkd[0]=lerkd
nnnukd[0]=lnukd
nnnucd[0]=lnucd
nnneud[0]=lneud
nnnevd[0]=lnevd

nerg [0]=merg
nerk [0]=merk
nnuk [0]=mnuk
nnuc [0]=mnuc
nneu [0]=mneu
nnev [0]=mnev
nergd[0]=mergd
nerkd[0]=merkd
nnukd[0]=mnukd
nnucd[0]=mnucd
nneud[0]=mneud
nnevd[0]=mnevd

IF mber GT 0 THEN BEGIN
    mber=0L
    nber [0]=mber
ENDIF

lasttime=SYSTIME(/SECONDS)

FOR i=0L,nsel-1L DO BEGIN
    pos=sel[i]
    POINT_LUN,-unit,cur_pos
    IF cur_pos LT pos THEN BEGIN
        temp=BYTARR(pos-cur_pos)
        READU,unit,temp
        temp=0
    ENDIF ELSE IF cur_pos GT pos THEN BEGIN
        POINT_LUN,unit,pos
    ENDIF
    recsize=0L
    READU,unit,recsize,nvers,modell,xtime

    time[i]=xtime
    i1=i+1L
    modellnr[i]=modell

    IF nvers GE 10403 THEN BEGIN 
       READU,unit,xdt
       dt[i]=xdt
    ENDIF

    READU,unit,mnconv
    nconv[i]=mnconv

    minvers<=nvers
    maxvers>=nvers

    IF nvers GE 10400 THEN BEGIN
       CASE nvers OF
          10400 : BEGIN
             kx=[0,1,3,4]
          END
          ELSE: BEGIN
             kx=[0,1,2,3,4,5]
          END
       ENDCASE
       nk=N_ELEMENTS(kx)
       mnnx=LONARR(nk)
       READU,unit,mnnx, $
             mncoord,idx_kind_len,nuc_kind_len

        nuc_type=3
        IF (nuc_kind_len) EQ 4 THEN nuc_type=2
        IF (nuc_kind_len) EQ 2 THEN nuc_type=1
        
        mmnuxn=MAX(mnnx)
        IF mmnuxn GT 0 THEN BEGIN
           mmnuxx=MAKE_ARRAY(mmnuxn,nk,TYPE=nuc_type,/NOZERO)
        ENDIF
        FOR ki=0,nk-1  DO BEGIN
           k=kx[ki]
           mnnux=mnnx[ki]
           IF mnnux GT 0 THEN BEGIN
              mmnux=MAKE_ARRAY(mnnux,TYPE=nuc_type,/NOZERO)
              READU,unit,mmnux
              mmnuxx[0:mnnux-1,ki]=mmnux[0:mnnux-1]
            ENDIF
        ENDFOR
    ENDIF ELSE BEGIN
        READU,unit,nnfak,nnfac,nnvak,mnber

        nlon=0L
        merg0=merg
        IF nnfak GT 0 THEN BEGIN
            nx=LONARR(nnfak,/NOZERO)
            READU,unit,nx
            FOR j=0L,nnfak-1L DO BEGIN
                merg+=nx[j]
                lerg+=1L
                nerg[lerg]=merg
                nlerg[j]+=nx[j]
            ENDFOR
            nlon=nlon+merg-merg0
        ENDIF

        merk0=merk
        IF nnfac GT 0 THEN BEGIN
            nx=LONARR(nnfac,/NOZERO)
            READU,unit,nx
            FOR j=0L,nnfac-1L DO BEGIN
                merk+=nx[j]
                lerk+=1L
                nerk[lerk]=merk
                nlerk[j]+=nx[j]
            ENDFOR
            nlon+=merk-merk0
        ENDIF

        mnuk0=mnuk
        IF nnvak GT 0L THEN BEGIN
            nx=LONARR(nnvak,/NOZERO)
            READU,unit,nx
            FOR j=0L,nnvak-1L DO BEGIN
                mnuk+=nx[j]
                lnuk+=1L
                nnuk[lnuk]=mnuk
                nlnuk[j]+=nx[j]
            ENDFOR
            nlon+=mnuk-mnuk0
        ENDIF

    ENDELSE

; read convection data
    IF mnconv GT 0L THEN BEGIN
        xmc=DBLARR(mnconv,/NOZERO)
        yzip=REPLICATE(' ',mnconv)
        READU,unit,yzip,xmc
        conv[0:mnconv-1,i]=xmc
        FOR j=0,mnconv-1 DO BEGIN
            CASE yzip[j] OF
                'C' : iconvtype=1B
                'S' : iconvtype=2B
                'N' : iconvtype=3B
                'O' : iconvtype=4B
                'T' : iconvtype=5B
                ELSE: iconvtype=0B
            ENDCASE
        convtype[j,i]=iconvtype
        ENDFOR
        IF nvers GE 10200 THEN BEGIN
            READU,unit,xmc
            convr[0:mnconv-1,i]=xmc
        ENDIF
    ENDIF

    IF nvers GE 10400 THEN BEGIN

        idx_type=3
        IF (idx_kind_len) EQ 4 THEN idx_type=2
        IF (idx_kind_len) EQ 2 THEN idx_type=1

        IF mncoord GT 0 THEN BEGIN
            xmcoord=DBLARR(mncoord,/NOZERO)
            rncoord=DBLARR(mncoord,/NOZERO)
            READU,unit,xmcoord,rncoord

            FOR ki=0,nk-1 DO BEGIN
               k=kx[ki]
               mnnux=mnnx[ki]
               IF mnnux GT 0 THEN mmnux=mmnuxx[0:mnnux-1,ki]
                IF mnnux GT 0 THEN BEGIN
                    minux=MAKE_ARRAY(mnnux,TYPE=idx_type,/NOZERO)
                    READU,unit,minux
;;                     CASE k OF
;;                         0:minuc =minux
;;                         1:minuk =minux
;;                         2:mineu =minux
;;                         3:minucd=minux
;;                         4:minukd=minux
;;                         5:mineud=minux
;;                     ENDCASE

                    nnfax=MAX(mmnux)
                    IF (nnfax GT nerglim) THEN BEGIN
                        xx=WHERE(mmnux GE nerglim)
                        IF xx[0] NE -1 THEN BEGIN
                            mmnux+=0S
                            mmnux[xx]-=256
                        ENDIF
                        nnfax=MAX(mmnux)
                    ENDIF
                    nnfay=-MIN(mmnux)

                    FOR kk=0,1 DO BEGIN
                        IF kk EQ 0 THEN BEGIN
                            nnfaz=nnfax
                        ENDIF ELSE BEGIN
                            nnfaz=nnfay
                        ENDELSE

                        IF nnfaz GT 0 THEN BEGIN
                            nfaz=LONARR(nnfaz)
                            ifaz0=-1
                            FOR j=0,mnnux-1 DO BEGIN
                                IF kk EQ 0 THEN BEGIN
                                    ifaz=(mmnux[j]>0)-1
                                ENDIF ELSE BEGIN
                                    ifaz=((-mmnux[j])>0)-1
                                ENDELSE
                                FOR jj=ifaz0+1,ifaz DO BEGIN
                                    iifaz[0,nfaz[jj],jj]=minux[j]-1
                                ENDFOR
                                FOR jj=ifaz0,ifaz+1,-1 DO BEGIN
                                    iifaz[1,nfaz[jj],jj]=minux[j]-1
                                    nfaz[jj]+=1
                                ENDFOR
                                ifaz0=ifaz
                            ENDFOR

                            CASE 2*k+kk OF
                                0: BEGIN
                                    FOR j=0,nnfaz-1 DO BEGIN
                                        merg1=merg+nfaz[j]-1L
                                        nfaz1=nfaz[j]-1L
                                        erg [0:1,merg:merg1]=xmcoord[iifaz[0:1,0:nfaz1,j]]
                                        ergr[0:1,merg:merg1]=rncoord[iifaz[0:1,0:nfaz1,j]]
                                        merg+=nfaz[j]
                                        lerg+=1L
                                        nerg[lerg]=merg
                                        nlerg[j]+=nfaz[j]
                                    ENDFOR
                                END
                                1: BEGIN
                                    FOR j=0,nnfaz-1 DO BEGIN
                                        merk1=merk+nfaz[j]-1L
                                        nfaz1=nfaz[j]-1L
                                        erk [0:1,merk:merk1]=xmcoord[iifaz[0:1,0:nfaz1,j]]
                                        erkr[0:1,merk:merk1]=rncoord[iifaz[0:1,0:nfaz1,j]]
                                        merk+=nfaz[j]
                                        lerk+=1L
                                        nerk[lerk]=merk
                                        nlerk[j]+=nfaz[j]
                                    ENDFOR
                                END
                                2: BEGIN
                                    FOR j=0,nnfaz-1 DO BEGIN
                                        mnuk1=mnuk+nfaz[j]-1L
                                        nfaz1=nfaz[j]-1L
                                        nuk [0:1,mnuk:mnuk1]=xmcoord[iifaz[0:1,0:nfaz1,j]]
                                        nukr[0:1,mnuk:mnuk1]=rncoord[iifaz[0:1,0:nfaz1,j]]
                                        mnuk+=nfaz[j]
                                        lnuk+=1L
                                        nnuk[lnuk]=mnuk
                                        nlnuk[j]+=nfaz[j]
                                    ENDFOR
                                END
                                3: BEGIN
                                    FOR j=0,nnfaz-1 DO BEGIN
                                        mnuc1=mnuc+nfaz[j]-1L
                                        nfaz1=nfaz[j]-1L
                                        nuc [0:1,mnuc:mnuc1]=xmcoord[iifaz[0:1,0:nfaz1,j]]
                                        nucr[0:1,mnuc:mnuc1]=rncoord[iifaz[0:1,0:nfaz1,j]]
                                        mnuc+=nfaz[j]
                                        lnuc+=1L
                                        nnuc[lnuc]=mnuc
                                        nlnuc[j]+=nfaz[j]
                                    ENDFOR
                                END
                                4: BEGIN
                                    FOR j=0,nnfaz-1 DO BEGIN
                                        mneu1=mneu+nfaz[j]-1L
                                        nfaz1=nfaz[j]-1L
                                        neu [0:1,mneu:mneu1]=xmcoord[iifaz[0:1,0:nfaz1,j]]
                                        neur[0:1,mneu:mneu1]=rncoord[iifaz[0:1,0:nfaz1,j]]
                                        mneu+=nfaz[j]
                                        lneu+=1L
                                        nneu[lneu]=mneu
                                        nlneu[j]+=nfaz[j]
                                    ENDFOR
                                END
                                5: BEGIN
                                    FOR j=0,nnfaz-1 DO BEGIN
                                        mnev1=mnev+nfaz[j]-1L
                                        nfaz1=nfaz[j]-1L
                                        nev [0:1,mnev:mnev1]=xmcoord[iifaz[0:1,0:nfaz1,j]]
                                        nevr[0:1,mnev:mnev1]=rncoord[iifaz[0:1,0:nfaz1,j]]
                                        mnev+=nfaz[j]
                                        lnev+=1L
                                        nnev[lnev]=mnev
                                        nlnev[j]+=nfaz[j]
                                    ENDFOR
                                END
                                6: BEGIN
                                    FOR j=0,nnfaz-1 DO BEGIN
                                        mergd1=mergd+nfaz[j]-1L
                                        nfaz1=nfaz[j]-1L
                                        ergd [0:1,mergd:mergd1]=xmcoord[iifaz[0:1,0:nfaz1,j]]
                                        ergdr[0:1,mergd:mergd1]=rncoord[iifaz[0:1,0:nfaz1,j]]
                                        mergd+=nfaz[j]
                                        lergd+=1L
                                        nergd[lergd]=mergd
                                        nlergd[j]+=nfaz[j]
                                    ENDFOR
                                END
                                7: BEGIN
                                    FOR j=0,nnfaz-1 DO BEGIN
                                        merkd1=merkd+nfaz[j]-1L
                                        nfaz1=nfaz[j]-1L
                                        erkd [0:1,merkd:merkd1]=xmcoord[iifaz[0:1,0:nfaz1,j]]
                                        erkdr[0:1,merkd:merkd1]=rncoord[iifaz[0:1,0:nfaz1,j]]
                                        merkd+=nfaz[j]
                                        lerkd+=1L
                                        nerkd[lerkd]=merkd
                                        nlerkd[j]+=nfaz[j]
                                    ENDFOR
                                END
                                8: BEGIN
                                    FOR j=0,nnfaz-1 DO BEGIN
                                        mnukd1=mnukd+nfaz[j]-1L
                                        nfaz1=nfaz[j]-1L
                                        nukd [0:1,mnukd:mnukd1]=xmcoord[iifaz[0:1,0:nfaz1,j]]
                                        nukdr[0:1,mnukd:mnukd1]=rncoord[iifaz[0:1,0:nfaz1,j]]
                                        mnukd+=nfaz[j]
                                        lnukd+=1L
                                        nnukd[lnukd]=mnukd
                                        nlnukd[j]+=nfaz[j]
                                    ENDFOR
                                END
                                9: BEGIN
                                    FOR j=0,nnfaz-1 DO BEGIN
                                        mnucd1=mnucd+nfaz[j]-1L
                                        nfaz1=nfaz[j]-1L
                                        nucd [0:1,mnucd:mnucd1]=xmcoord[iifaz[0:1,0:nfaz1,j]]
                                        nucdr[0:1,mnucd:mnucd1]=rncoord[iifaz[0:1,0:nfaz1,j]]
                                        mnucd+=nfaz[j]
                                        lnucd+=1L
                                        nnucd[lnucd]=mnucd
                                        nlnucd[j]+=nfaz[j]
                                    ENDFOR
                                END
                               10: BEGIN
                                    FOR j=0,nnfaz-1 DO BEGIN
                                        mneud1=mneud+nfaz[j]-1L
                                        nfaz1=nfaz[j]-1L
                                        neud [0:1,mneud:mneud1]=xmcoord[iifaz[0:1,0:nfaz1,j]]
                                        neudr[0:1,mneud:mneud1]=rncoord[iifaz[0:1,0:nfaz1,j]]
                                        mneud+=nfaz[j]
                                        lneud+=1L
                                        nneud[lneud]=mneud
                                        nlneud[j]+=nfaz[j]
                                    ENDFOR
                                END
                               11: BEGIN
                                    FOR j=0,nnfaz-1 DO BEGIN
                                        mnevd1=mnevd+nfaz[j]-1L
                                        nfaz1=nfaz[j]-1L
                                        nevd [0:1,mnevd:mnevd1]=xmcoord[iifaz[0:1,0:nfaz1,j]]
                                        nevdr[0:1,mnevd:mnevd1]=rncoord[iifaz[0:1,0:nfaz1,j]]
                                        mnevd+=nfaz[j]
                                        lnevd+=1L
                                        nnevd[lnevd]=mnevd
                                        nlnevd[j]+=nfaz[j]
                                    ENDFOR
                                END
                            ENDCASE
                        ENDIF
                    ENDFOR
                ENDIF
            ENDFOR
        ENDIF
    ENDIF ELSE BEGIN
        IF mnber GT 0 THEN BEGIN
            mnber2=mnber/2
            xber=DBLARR(2,mnber2,/NOZERO)
            READU,unit,xber
            ber[0:1,mber:mber+mnber2-1L]=xber[0:1,0:mnber2-1L]
            mber=mber+mnber2
        ENDIF
        nber[i1]=mber

        IF nlon GT 0 THEN BEGIN
            x=DBLARR(2,nlon,/NOZERO)
            READU,unit,x
            l=0L

            j=merg-merg0
            IF j GT 0 THEN erg[0:1,merg0:merg-1L]=x[0:1,l:l+j-1L]
            l=l+j

            j=merk-merk0
            IF j GT 0 THEN erk[0:1,merk0:merk-1L]=x[0:1,l:l+j-1L]
            l=l+j

            j=mnuk-mnuk0
            IF j GT 0 THEN nuk[0:1,mnuk0:mnuk-1L]=x[0:1,l:l+j-1L]
            l=l+j

;         FOR j=0,nnfac-1 DO BEGIN
; ##### ---> should make fix in convsort.f/convutil.f
; ; to fix a bug in E15.cnv:
;             llx=0
; ; normal
;             FOR k=0,MIN([nerk(i,j),nerkmax])-1 DO BEGIN
; ; error handling
;                 IF (x(l+1) EQ 0) OR (llx GT 0) THEN BEGIN
;                     llx=llx+1
;                 ENDIF ELSE BEGIN
; ; normal case
;                     erk(i,j,k,0:1)=x(l:l+1)/XMSUN
;                 ENDELSE
; ; also normal
;                 l=l+2
;             ENDFOR
; ; also correct nerk
;             nerk(i,j)=nerk(i,j)-llx
; ; END of error handling
;         ENDFOR
        ENDIF
    ENDELSE

;  update top-level indices
        nnerg[i1]=lerg
        nnerk[i1]=lerk
        nnnuk[i1]=lnuk
        nnnuc[i1]=lnuc
        nnneu[i1]=lneu
        nnnev[i1]=lnev
        nnergd[i1]=lergd
        nnerkd[i1]=lerkd
        nnnukd[i1]=lnukd
        nnnucd[i1]=lnucd
        nnneud[i1]=lneud
        nnnevd[i1]=lnevd

    IF nvers GE 10400 THEN BEGIN
            CASE nvers OF
               10400: nxn=9
               ELSE: nxn=13
            ENDCASE
            nx=LONARR(nxn,/NOZERO)
            READU,unit,nx
            l=0
            levcnv  [i]=nx[l] & l=l+1
            mingain [i]=nx[l] & l=l+1
            minloss [i]=nx[l] & l=l+1
            minnucl [i]=nx[l] & l=l+1
            minnucg [i]=nx[l] & l=l+1
            IF nvers GE 10401 THEN BEGIN
               minneul [i]=nx[l] & l=l+1
               minneug [i]=nx[l] & l=l+1
            ENDIF
            mingaind[i]=nx[l] & l=l+1
            minlossd[i]=nx[l] & l=l+1
            minnucld[i]=nx[l] & l=l+1
            minnucgd[i]=nx[l] & l=l+1
            IF nvers GE 10401 THEN BEGIN
               minneuld[i]=nx[l] & l=l+1
               minneugd[i]=nx[l] & l=l+1
            ENDIF

            CASE nvers OF
               10400: nxn=20
               10401: nxn=20-2+31
               ELSE: nxn=20-2+32
            ENDCASE
            x=DBLARR(nxn+nhiz,/NOZERO)
            READU,unit,x
            l=0L
            tn     [i]=x[l] & l=l+1
            dn     [i]=x[l] & l=l+1
            pn     [i]=x[l] & l=l+1
            en     [i]=x[l] & l=l+1
            stot   [i]=x[l] & l=l+1
            ye     [i]=x[l] & l=l+1
            abar   [i]=x[l] & l=l+1
            eta    [i]=x[l] & l=l+1
            sn     [i]=x[l] & l=l+1
            snn    [i]=x[l] & l=l+1
            gamma1 [i]=x[l] & l=l+1
            gamma2 [i]=x[l] & l=l+1
            gs1    [i]=x[l] & l=l+1
            gs2    [i]=x[l] & l=l+1
            IF nvers LT 10401 THEN BEGIN
               ln     [i]=x[l] & l=l+1
            ENDIF
            aw     [i]=x[l] & l=l+1
            IF nvers LT 10401 THEN BEGIN 
               lnnuc  [i]=x[l] & l=l+1
            ENDIF
            summ0  [i]=x[l] & l=l+1
            radius0[i]=x[l] & l=l+1
            net    [i]=ROUND(x[l]) & l=l+1
            abun[0:nhiz-1,i]=x[l:l+nhiz-1] & l=l+nhiz

            IF nvers GE 10401 THEN BEGIN
               eni    [i]=x[l] & l=l+1
               enk    [i]=x[l] & l=l+1
               enp    [i]=x[l] & l=l+1
               ent    [i]=x[l] & l=l+1
               epro   [i]=x[l] & l=l+1
               enn    [i]=x[l] & l=l+1
               enr    [i]=x[l] & l=l+1
               ensc   [i]=x[l] & l=l+1
               enes   [i]=x[l] & l=l+1
               enc    [i]=x[l] & l=l+1
               enpist [i]=x[l] & l=l+1
               enid   [i]=x[l] & l=l+1
               enkd   [i]=x[l] & l=l+1
               enpd   [i]=x[l] & l=l+1
               entd   [i]=x[l] & l=l+1
               eprod  [i]=x[l] & l=l+1
               xlumn  [i]=x[l] & l=l+1
               enrd   [i]=x[l] & l=l+1
               enscd  [i]=x[l] & l=l+1
               enesd  [i]=x[l] & l=l+1
               encd   [i]=x[l] & l=l+1
               enpistd[i]=x[l] & l=l+1
               xlum   [i]=x[l] & l=l+1
               xlum0  [i]=x[l] & l=l+1
               entloss[i]=x[l] & l=l+1
               eniloss[i]=x[l] & l=l+1
               enkloss[i]=x[l] & l=l+1
               enploss[i]=x[l] & l=l+1
               enrloss[i]=x[l] & l=l+1
               angit  [i]=x[l] & l=l+1
               anglt  [i]=x[l] & l=l+1
            ENDIF
            IF nvers GE 10402 THEN BEGIN
               xmacc  [i]=x[l] & l=l+1
            ENDIF
    ENDIF ELSE BEGIN
        IF nvers GE 10300 THEN BEGIN
            x=DBLARR(15+nhiz,/NOZERO)
            READU,unit,x
            l=0L
            tn    [i]=x[l] & l=l+1
            dn    [i]=x[l] & l=l+1
            pn    [i]=x[l] & l=l+1
            en    [i]=x[l] & l=l+1
            stot  [i]=x[l] & l=l+1
            ye    [i]=x[l] & l=l+1
            abar  [i]=x[l] & l=l+1
            eta   [i]=x[l] & l=l+1
            sn    [i]=x[l] & l=l+1
            snn   [i]=x[l] & l=l+1
            gamma1[i]=x[l] & l=l+1
            gamma2[i]=x[l] & l=l+1
            gs1   [i]=x[l] & l=l+1
            gs2   [i]=x[l] & l=l+1
            net   [i]=ROUND(x[l]) & l=l+1
            abun[0:nhiz-1,i]=x[l:l+nhiz-1] & l=l+nhiz
        ENDIF
        IF nvers GE 10301 THEN BEGIN
            x=DBLARR(1,/NOZERO)
            READU,unit,x
            l=0
            ln    [i]=x[l] & l=l+1
        ENDIF
        IF nvers GE 10302 THEN BEGIN
            x=DBLARR(1,/NOZERO)
            READU,unit,x
            l=0
            aw    [i]=x[l] & l=l+1
        ENDIF
        IF nvers GE 10303 THEN BEGIN
            x=DBLARR(1,/NOZERO)
            nx=LONARR(4,/NOZERO)
            READU,unit,x,nx
            l=0
            summ0  [i]=x[l] & l=l+1
            l=0
            levcnv [i]=nx[l] & l=l+1
            mingain[i]=nx[l] & l=l+1
            minloss[i]=nx[l] & l=l+1
            minnucl[i]=nx[l] & l=l+1

            minnucg[i]=minnucl[i]
        ENDIF
        IF nvers GE 10304 THEN BEGIN
            x=DBLARR(1,/NOZERO)
            READU,unit,x
            l=0
            lnnuc  [i]=x[l] & l=l+1
        ENDIF
    ENDELSE

    IF (i MOD 100 EQ 0) AND (verbose GE 3) THEN PRINT," [LOADCONV] model ",modell
    IF (verbose GE 1) THEN BEGIN
       curtime=SYSTIME(/SECONDS)
       IF (curtime-lasttime GT 10) THEN BEGIN
          PRINT," [LOADCONV] ETA: "+TIME2HUMAN((lastpos-cur_pos)*(curtime-scantime)/(cur_pos>1))+'.  Time loading so far: '+TIME2HUMAN(curtime-scantime)
          lasttime=curtime
       ENDIF
    ENDIF
ENDFOR
CLOSE,unit
FREE_LUN,unit

modells=nsel

XMSUNI=1.D0/XMSUN
RSUNI=1.D0/RSUN

; may be obsolete
IF mber GT 0 THEN ber*=XMSUNI

conv *=XMSUNI
convr*=RSUNI

erg *=XMSUNI
erk *=XMSUNI
nuk *=XMSUNI
nuc *=XMSUNI
neu *=XMSUNI
nev *=XMSUNI
ergd*=XMSUNI
erkd*=XMSUNI
nukd*=XMSUNI
nucd*=XMSUNI
neud*=XMSUNI
nevd*=XMSUNI

ergr *=RSUNI
erkr *=RSUNI
nukr *=RSUNI
nucr *=RSUNI
neur *=RSUNI
nevr *=RSUNI
ergdr*=RSUNI
erkdr*=RSUNI
nukdr*=RSUNI
nucdr*=RSUNI
neudr*=RSUNI
nevdr*=RSUNI

mingain [nmodellmax-1]=mingain [nmodellmax-2]
minloss [nmodellmax-1]=minloss [nmodellmax-2]
minnucg [nmodellmax-1]=minnucg [nmodellmax-2]
minnucl [nmodellmax-1]=minnucl [nmodellmax-2]
minneug [nmodellmax-1]=minneug [nmodellmax-2]
minneul [nmodellmax-1]=minneul [nmodellmax-2]
mingaind[nmodellmax-1]=mingaind[nmodellmax-2]
minlossd[nmodellmax-1]=minlossd[nmodellmax-2]
minnucgd[nmodellmax-1]=minnucgd[nmodellmax-2]
minnucld[nmodellmax-1]=minnucld[nmodellmax-2]
minneugd[nmodellmax-1]=minneugd[nmodellmax-2]
minneuld[nmodellmax-1]=minneuld[nmodellmax-2]

IF nvers GE 10402 THEN xmacc*=XMSUNI

IF nvers GE 10300 THEN PRINT," [LOADCONV] loaded central property data."

timecc=DBLARR(nmodellmax)
timecc(nmodellmax-1L)=0.0D0
zerotime=time(modells-1L)
FOR i=modells-2L,0L,-1L DO BEGIN
    IF time[i] GT time[i+1] THEN zerotime=zerotime+time[i]
    timecc[i]=zerotime-time[i]
ENDFOR

IF removezerotime THEN BEGIN
    zerotime=0.0D0
    time0=time[0]
    FOR i=1L,modells-1 DO BEGIN
        IF time[i] LT time0 THEN BEGIN
            zerotime=time[i-1]
            IF (verbose GE 1) THEN PRINT,' [LOADCONV] @ model='+STRING(modellnr[i])+' zerotime was set to '+STRING(zerotime)
        ENDIF
        time0=time[i]
        time[i]=time0+zerotime
    ENDFOR
ENDIF

SECI=1.D0/SEC

time=time[0:modells-1]*SECI
timecc=timecc[0:modells-1]*SECI

IF (verbose GE 1) THEN BEGIN 
   PRINT,' [LOADCONV] first model read: '+STRING(modellnr[0])+'; time='+time2human(time[0]*SEC)
   PRINT,' [LOADCONV]  last model read: '+STRING(modell     )+';  dtn='+time2human(timecc[modells-2]*SEC)
ENDIF

IF (showtime EQ 1) THEN BEGIN
   loadtime=SYSTIME(/SECONDS)
   PRINT,' [LOADCONV] data loaded in '+time2human(loadtime-starttime)+'.'
ENDIF

IF N_ELEMENTS(compconv) EQ 0 THEN compconv=1
IF compconv EQ 1 THEN BEGIN
    convkonv,VERBOSE=verbose,SHOWTIME=showtime
ENDIF

COMMON conv_setzorotime,saved_time
clear,saved_time
clear,saved_timecc

END


