PRO plotlayer,nxmax,nstart,nend,nydata,xdata0,ydata,color, $
              line_fill,orientation,spacing,linethick,frame, $
              NSTEP=nstep, $
              XGRID=xgrid, $
              YGRID=ygrid, $
              RECTANGULAR=rectangular, $
              YLOW=ylow, $
              YHIGH=yhigh, $
              LOWCUT=lowcut, $
              HICUT=hicut, $
              OFFSET=offset0, $
              FAC=fac0, $
              XNORMAL=xnormal, $
              YLOG=ylog

;RETURN ; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

COMMON plotlayer,npol,maxpol,nvert,nrem,nvertraw,nremraw

IF N_ELEMENTS(color) EQ 0 THEN color=0
IF N_ELEMENTS(frame) EQ 0 THEN frame=0
IF N_ELEMENTS(nstep) EQ 0 THEN nstep=1L
IF N_ELEMENTS(line_fill) EQ 0 THEN line_fill=0
IF N_ELEMENTS(orientation) EQ 0 THEN orientation=0
IF N_ELEMENTS(spacing) EQ 0 THEN spacing=0
IF N_ELEMENTS(linethick) EQ 0 THEN linethick=0

IF N_ELEMENTS(xgrid) EQ 0 THEN xgrid=0
IF N_ELEMENTS(ygrid) EQ 0 THEN ygrid=0

IF N_ELEMENTS(rectangular) EQ 0 THEN rectangular=1
IF rectangular NE 0 THEN rectangular=1

IF N_ELEMENTS(npol) EQ 0 THEN npol=0L
IF N_ELEMENTS(maxpol) EQ 0 THEN maxpol=200000L
IF N_ELEMENTS(nvert) EQ 0 THEN nvert=0L 
IF N_ELEMENTS(nrem) EQ 0 THEN nrem=0L
IF N_ELEMENTS(nvertraw) EQ 0 THEN nvertraw=0L 
IF N_ELEMENTS(nremraw) EQ 0 THEN nremraw=0L

IF N_ELEMENTS(lowcut) EQ 0 THEN lowcut=-1.D99
IF N_ELEMENTS(hicut) EQ 0 THEN hicut=+1.D99

IF N_ELEMENTS(xnormal) EQ 0 THEN xnormal=0

IF !X.TYPE EQ 0 THEN BEGIN 
    datax=!X.CRANGE 
ENDIF ELSE BEGIN 
    PRINT,' [PLOTLAYER] ERROR: log x-axis not supported'
    RETURN
    datax=10D0^!X.CRANGE
ENDELSE
IF xnormal THEN BEGIN 
    datax=!X.WINDOW
ENDIF
datax0=MIN(datax,MAX=datax1)
xdata=(xdata0>datax0)<datax1

IF !Y.TYPE EQ 0 THEN BEGIN 
    datay=!Y.CRANGE 
ENDIF ELSE BEGIN 
    PRINT,' [PLOTLAYER] ERROR: log y-axis not supported'
    RETURN
    datay=10D0^!Y.CRANGE
ENDELSE
IF N_ELEMENTS(ylow)  NE 0 THEN datay[0]=MAX([datay[0],ylow])
IF N_ELEMENTS(yhigh) NE 0 THEN datay[1]=MIN([datay[1],yhigh])
datay0=MIN(datay,MAX=datay1)
IF xnormal THEN BEGIN 
    ygridred=ygrid/(ABS(datay1-datay0))
ENDIF ELSE BEGIN
    ygridred=ygrid
ENDELSE
ns=MAX([1,ABS(nstep)])
nst=ns
x=DBLARR(4L*(nend-nstart+1)+1,/NOZERO)
y=DBLARR(4L*(nend-nstart+1)+1,/NOZERO)
x0=DBLARR((nend-nstart+1)+1,/NOZERO)
ix0=LONARR((nend-nstart+1)+1,/NOZERO)
y0=DBLARR((nend-nstart+1)+1,/NOZERO)
y1=DBLARR((nend-nstart+1)+1,/NOZERO)
nullarr=REPLICATE(0L,nxmax+1)
onearr=REPLICATE(1L,nxmax+1)
iistart=REPLICATE(-1L,nxmax+1)
iihigh=-1L
ovr=DBLARR(nxmax^2)
ovrk=LONARR(nxmax^2)
ovrm=LONARR(nxmax^2)

; scaling
IF N_ELEMENTS(fac0) EQ 0 THEN fac=1.D0 ELSE fac=fac0
IF N_ELEMENTS(offset0) EQ 0 THEN offset=0.D0 ELSE offset=offset0
IF rectangular THEN BEGIN
    nscale=nend+2
ENDIF ELSE BEGIN
    nscale=nend+1
ENDELSE
IF N_ELEMENTS(fac) LT nscale THEN fac=REPLICATE(fac,nscale)
IF N_ELEMENTS(offset) LT nscale THEN offset=REPLICATE(offset,nscale)
facm=DBLARR(nend+1)
offsetm=DBLARR(nend+1)
IF rectangular THEN BEGIN
    facm[nstart:nend]=0.5D0*(fac[nstart:nend]+fac[nstart+1:nend+1])
    offsetm[nstart:nend]=0.5D0*(offset[nstart:nend]+offset[nstart+1:nend+1])
ENDIF ELSE BEGIN
    facm=fac
    offsetm=offset
    fac=0L
    offset=0L
ENDELSE

; rectange buffer
bufinit=2048L
bufgrow=1.2D0
nyy=nxmax+1
yy=PTRARR(nyy)
yybufsize=REPLICATE(-1L,nyy)
yybufpos=REPLICATE(-1L,nyy)

IF (frame EQ 3) AND rectangular THEN BEGIN
; outline
; large array is done with pointers
    linenummax=nxmax*2L
    linebuf=PTRARR(linenummax)
    linebufinit=2048L
    linebufgrow=1.2D0
    linebufpos=LONARR(3L,linenummax,/NOZERO)
    nlines=0L
    curlines=DBLARR(2L*nxmax,/NOZERO)
    icurlines=LONARR(2L*nxmax,/NOZERO)
    jcurlines=LONARR(2L*nxmax,/NOZERO)
    ncurlines=0L
    newlines=DBLARR(2L*nxmax,/NOZERO)
    inewlines=LONARR(2L*nxmax,/NOZERO)
    jnewlines=LONARR(2L*nxmax,/NOZERO)
    nnewlines=0L
ENDIF

FOR i=nstart+0L,nend+1L DO BEGIN
    IF ((i-nstart) mod ns NE 0) AND (i LT nend+rectangular) THEN GOTO,end_of_i_loop
    IF ((i-nstart) mod ns NE 0) THEN ns=(i-nstart) mod nst
    IF (NOT rectangular) AND (i EQ nstart) THEN GOTO,end_of_i_loop
    iiused=nullarr
    knew=onearr
    j=0L
    IF (i LE nend) THEN BEGIN
        iydata1=nydata[i+1]
        iydata0=nydata[i]
        npoly=iydata1-iydata0        
        if npoly GT 0 THEN BEGIN 
; ==== NOTE ====
; currently scaling is done for the center coordinate to be used by
; the the polygon finder.  If not rectangular==0 this is already
; stored in fac and offser, otherwise we just use the mean (defined above).
            poly=(ydata[0:1,iydata0:iydata1-1] > lowcut < hicut)*facm[i]-offsetm[i]
            IF ylog NE 0 THEN poly=ALOG10(poly>1.d-99)
            IF facm[i] LT 0 THEN BEGIN
; remove this when scaling is moved!!!
                nn=iydata1-iydata0
                poly=poly[[1,0],*]
                poly=poly[*,nn-1-INDGEN(nn)]
             ENDIF
        ENDIF

        nvertraw=nvertraw+npoly
; remove invisible data points
        nd=0L
        FOR k=0L,npoly-1 DO BEGIN
            tmp=poly[0:1,k] >datay0 <datay1
            IF tmp[0] EQ tmp[1] THEN BEGIN
                nd=nd+1
            ENDIF ELSE BEGIN
                poly[0:1,k-nd]=tmp[0:1]
            ENDELSE            
         ENDFOR
        npoly=npoly-nd
        nremraw=nremraw+nd        
; first step of data reduction if ygrid is set
        IF ygrid GT 0 THEN BEGIN
            nd=0L
            FOR k=1L,npoly-1 DO BEGIN
                knd1=k-nd-1
                IF (poly[0,k]-poly[0,knd1] LT ygrid) OR  $
; actually the use of "AND" is more accurate, however much less efficient...
;                IF (poly[0,k]-poly[0,knd1] LT ygrid) AND  $
                  (poly[1,k]-poly[1,knd1] LT ygrid) THEN BEGIN
                    poly[1,knd1]=poly[1,k]
                    nd=nd+1
                ENDIF ELSE IF nd NE 0 THEN BEGIN
                    poly[0:1,k-nd]=poly[0:1,k]
                ENDIF                
            ENDFOR
            npoly=npoly-nd
            nremraw=nremraw+nd
         ENDIF
; compute overlap regions
        FOR k=0L,npoly-1 DO BEGIN
            FOR m=0L,iihigh DO BEGIN
                IF (iistart[m] GE 0) AND (i-iistart[m] LT maxpol*nst) THEN BEGIN
                    overlap=MIN([poly[1,k],(*yy[m])[1,yybufpos[m]]])-MAX([poly[0,k],(*yy[m])[0,yybufpos[m]]])
                    IF overlap GT 0 THEN BEGIN
                        jj=0L
                        jjj=j
                        WHILE jj LE j-1 DO BEGIN
                            IF ovr[jj] LT overlap THEN BEGIN
                                jjj=jj
                                jj=j-1
                            ENDIF
                            jj=jj+1
                        ENDWHILE
                        IF jjj LT j THEN BEGIN
                            ovr[jjj+1:j]=ovr[jjj:j-1]
                            ovrm[jjj+1:j]=ovrm[jjj:j-1]
                            ovrk[jjj+1:j]=ovrk[jjj:j-1]
                        ENDIF
                        ovr[jjj]=overlap
                        ovrm[jjj]=m
                        ovrk[jjj]=k
                        j=j+1
                    ENDIF
                ENDIF
            ENDFOR
        ENDFOR
    ENDIF
; connect overlapping polygons (put to same m)
    FOR l=0L,j-1 DO BEGIN
        k=ovrk[l]
        m=ovrm[l]
        IF (iiused[m] EQ 0) AND (knew[k] EQ 1) THEN BEGIN
            iiused[m]=1L
            knew[k]  =0L
            ii=yybufpos[m]+1
            IF (ii GE yybufsize[m]) THEN BEGIN
                yybufsize[m]=ROUND(yybufsize[m]*bufgrow*0.25D0)*4L
                temp_buf=PTR_NEW(DBLARR(2,yybufsize[m]),/NO_COPY)
                (*temp_buf)[0:1,0:ii-1]=(*yy[m])[0:1,0:ii-1]
                PTR_FREE,yy[m]
                yy[m]=temp_buf
            ENDIF
            (*yy[m])[0:1,ii] = poly[0:1,k]
            yybufpos[m]=ii
        ENDIF
    ENDFOR
    FOR m=0L,iihigh DO BEGIN
; end of polygon
        IF (iistart[m] GE 0) AND (iiused[m] EQ 0) THEN BEGIN
; get all x and y coordinates
            nnd=0L
            nj=0L
            IF (NOT rectangular) THEN BEGIN
                x0[nj]=xdata[iistart[m]-nst]
                ix0[nj]=iistart[m]-nst
                nj=nj+1
            ENDIF
            ibufpos=0L
            FOR j=iistart[m],i-ns,nst DO BEGIN
                x0[nj]=xdata[j]
                ix0[nj]=j
                y0[nj]=(*yy[m])[0,ibufpos]
                y1[nj]=(*yy[m])[1,ibufpos]
                ibufpos=ibufpos+1
                nj=nj+1
            ENDFOR
            IF rectangular THEN BEGIN
                x0[nj]=xdata[i]
                ix0[nj]=i
            ENDIF ELSE BEGIN
                y0[0]=y0[1]
                y1[0]=y1[1]
                IF (i EQ nend+1) and ((nend-nstart) mod nst NE 0) THEN BEGIN
                    j=i-1
                    x0[nj]=xdata[j]
                    ix0[nj]=j
                    y0[nj]=(*yy[m])[0,ibufpos]
                    y1[nj]=(*yy[m])[1,ibufpos]
                    ibufpos=ibufpos+1
                    nj=nj+1
                ENDIF
            ENDELSE
            IF ibufpos NE yybufpos[m]+1 THEN PRINT," [PLOTLAYER] DEBUG yybuf",ibufpos,yybufpos[m],m
; if xgrid set simplyfy too fine resolved regions
            nd=0L
            IF xgrid NE 0 THEN BEGIN
                FOR j=1L,nj-2+rectangular DO BEGIN
                    ii=j-nd
                    IF ABS(x0[j]-x0[ii-1]) LT ABS(xgrid) THEN BEGIN
                        nd=nd+1                        
                        ii=j-nd
                        y0[ii]=MIN(y0[[j,ii]])
                        y1[ii]=MAX(y1[[j,ii]])
                    ENDIF ELSE BEGIN
                        x0[ii]=x0[j]
                        ix0[ii]=ix0[j]
                        y0[ii]=y0[j]
                        y1[ii]=y1[j]
                    ENDELSE
                ENDFOR
                nj=nj-nd
                if rectangular THEN BEGIN
                    x0[nj]=x0[nj+nd]
                    ix0[nj]=ix0[nj+nd]
                ENDIF ELSE BEGIN
                    ii=nj-1
                    j=ii+nd
                    x0[ii]=x0[j]
                    ix0[ii]=ix0[j]
                    y0[ii]=y0[j]
                    y1[ii]=y1[j]                    
                ENDELSE
            ENDIF
; compute polygon
            IF rectangular THEN BEGIN
                ni=4L*nj
                nnd=4L*nd
                FOR j=0L,nj-1 DO BEGIN
                    ji=2L*j
                    jj=ni-2*(j+1)
                    j1=j+1
                    ji1=ji+1
                    jj1=jj+1
                    x[ji:ji1]=x0[j:j1]
                    x[jj:jj1]=x0[[j1,j]]
                    IF NOT ylog THEN BEGIN
; try tweaking (shearing) the rectrange (for t-dependent scaling)
                        iii=ix0[j:j1]
                        ii0=MIN(iii)
                        faci=fac[iii]/facm[ii0]
                        offseti=offset[iii]-offsetm[ii0]*faci
                        y[ji:ji1]=y0[j]*faci-offseti
                        y[jj:jj1]=y1[j]*faci[[1,0]]-offseti[[1,0]]
; this is only a quick'n dirty modification
; ========== TO DO: ===========
; to do better, the "rectange" matching for the case "rectangular"
; would need to keep seperately sheared left and right coordinates.
                    ENDIF ELSE BEGIN
                        y[ji:ji1]=y0[j]
                        y[jj:jj1]=y1[j]
                    ENDELSE
                ENDFOR
            ENDIF ELSE BEGIN
                ni=2L*nj
                nnd=2L*nd
                FOR j=0L,nj-1 DO BEGIN
                    ji=j
                    jj=ni-(j+1)
                    x[j] =x0[j]
                    x[jj]=x0[j]
                    y[j] =y0[j]
                    y[jj]=y1[j] 
                ENDFOR
            ENDELSE
;.......................................................................
; convert to normal coordiantes if necessary
            IF xnormal THEN BEGIN
                xyz=CONVERT_COORD(x[0:ni-1],y[0:ni-1],/DATA,/TO_NORMAL,/DOUBLE)
                y[0:ni-1]=xyz[1,0:ni-1]
                xyz=0
            ENDIF
;.......................................................................
; simplify polygon and grid in y-direction
; NOTE: it is assumed the there are the same number of grid points on
; the top than on the bottom! 
            nicut=ni/2
            IF ni GE 6 THEN BEGIN
                nd=0L
                IF (frame EQ 0) or ((frame EQ 3) and (rectangular EQ 1)) THEN BEGIN                    
                    x_temp=x(0:ni-1)
                    y_temp=y(0:ni-1)
                    reduce,x_temp,y_temp,XRES=xgrid,YRES=ygridred,NREM=nd
                    ni=ni-nd
                    nnd=nnd+nd
                    x[0:ni-1]=x_temp(*)
                    y[0:ni-1]=y_temp(*)
                    x_temp=0
                    y_temp=0                    
                ENDIF ELSE BEGIN
                    FOR k=0L,1L DO begin
                        j0=2L+k*ni/2
                        j1=(1+k)*ni/2-1
                        j=j0-2
                        jj=j-nd
                        x[jj:jj+1]=x[j:j+1]
                        y[jj:jj+1]=y[j:j+1]
                        IF rectangular THEN BEGIN
                            FOR j=j0,j1-1,2 DO BEGIN
                                jj=j-nd-2
                                IF (ABS(y[j]-y[jj]) LE ygridred) THEN BEGIN
                                    nd=nd+2
                                    y[jj+1]=y[j+1]
;                                IF k EQ 0 THEN BEGIN
;                                    y(jj:jj+1)=MIN(y([jj,j+1]))
;                                ENDIF ELSE BEGIN
;                                    y(jj:jj+1)=MAX(y([jj,j+1]))
;                                ENDELSE
                                    x[jj+1]=x[j+1]
                                ENDIF ELSE BEGIN
                                    jj=j-nd
                                    x[jj:jj+1]=x[j:j+1]
                                    y[jj:jj+1]=y[j:j+1]
                                ENDELSE
                            ENDFOR
                            if k EQ 0 THEN nicut=ni/2-nd
                        ENDIF ELSE BEGIN
                            FOR j=j0,j1 DO BEGIN
                                jj=j-nd-1
                                IF (ABS(y[j]-y[jj]) LE ygridred) AND (ABS(y(j)-y(jj-1)) LE ygridred) THEN BEGIN
                                    nd=nd+1
                                ENDIF
                                jj=j-nd
                                x[jj]=x[j]
                                y[jj]=y[j]
                            ENDFOR
                            if k EQ 0 THEN nicut=ni/2-nd
                        ENDELSE
                    ENDFOR                    
                    ni=ni-nd
                    nnd=nnd+nd
                ENDELSE
            ENDIF 
; NOTE: from now on polygon may have different number of grid points
; on bottom than on top!
;.......................................................................
; draw polygon
            FOR j=0L,N_ELEMENTS(orientation)-1 DO BEGIN
                IF line_fill THEN BEGIN
                    POLYFILL,x[0:ni-1],y[0:ni-1],NOCLIP=1,COLOR=color,ORIENTATION=orientation(j),SPACING=spacing(j),THICK=linethick(j),NORMAL=xnormal
                ENDIF ELSE BEGIN
                    POLYFILL,x[0:ni-1],y[0:ni-1],NOCLIP=1,COLOR=color,NORMAL=xnormal
                ENDELSE
                nvert=nvert+ni
                nrem=nrem+nnd
            ENDFOR
            
            IF (frame EQ 1) AND (rectangular) THEN BEGIN
                nii=ni/2
                FOR jj=0L,nii-1 DO BEGIN
                    j=2L*jj
                    PLOTS,x[j:j+1],y[j:j+1],NOCLIP=1,COLOR=color[0],THICK=linethick[0],NORMAL=xnormal
                ENDFOR
                nvert=nvert+ni
                nrem=nrem+nnd
            ENDIF ELSE IF (frame EQ 2) OR ((NOT rectangular) AND (frame EQ 1)) THEN BEGIN
                PLOTS,x[0:nicut-1],y[0:nicut-1],NOCLIP=1,COLOR=color[0],THICK=linethick[0],NORMAL=xnormal
                PLOTS,x[nicut:ni-1],y[nicut:ni-1],NOCLIP=1,COLOR=color[0],THICK=linethick[0],NORMAL=xnormal
                nvert=nvert+ni
                nrem=nrem+nnd
            ENDIF ELSE IF (frame EQ 3) AND (NOT rectangular) THEN BEGIN
                x[ni]=x[0]
                y[ni]=y[0]
                PLOTS,x[0:ni],y[0:ni],NOCLIP=1,COLOR=color[0],THICK=linethick[0],NORMAL=xnormal
                nvert=nvert+ni+1
                nrem=nrem+nnd                
            ENDIF;

            npol=npol+1
            iistart(m)=-1
            PTR_FREE,yy[m]
            yybufsize[m]=-1
            yybufpos[m]=-1
        ENDIF
    ENDFOR
; start new polygons
    m=0L
    IF i LE nend THEN BEGIN
        FOR k=0L,npoly-1 DO BEGIN
            IF knew(k) EQ 1 THEN BEGIN
                WHILE iistart(m) GE 0 DO m=m+1
                iistart(m)=i
                yy[m]=PTR_NEW(DBLARR(2,bufinit),/NO_COPY)
                yybufsize[m]=bufinit
                yybufpos[m]=0
                (*yy[m])[0:1,0] = poly[0:1,k]                
            ENDIF
        ENDFOR
    ENDIF
    iihigh=MAX(WHERE(iistart GE 0))

;#######################################################################
; compute contineous frames
    IF (frame EQ 3) AND rectangular THEN BEGIN

; setup
        IF i LE nend THEN npolyi=npoly ELSE npolyi=0

        k=0
        k1=+1
        IF k/2 LT npolyi THEN yk=poly[k mod 2,k/2] ELSE yk=datay1
        IF k1/2 LT npolyi THEN yk1=poly[k1 mod 2,k1/2] ELSE yk1=datay1

        j=0
        IF j LT ncurlines THEN yj=curlines(j) ELSE yj=datay1
        IF (j+1) LT ncurlines THEN yj1=curlines(j+1) ELSE  yj1=datay1

        nnewlines=0

; compute offset for second x value in xdata array
; needed for nstep GT 1
        ix2=MIN([i+ns,nend+1L])

; now the main loop
;....
        WHILE (k/2 LT npolyi) OR (j LT ncurlines) DO BEGIN

            WHILE (k1/2 LT npolyi) AND ((yk1 LT yj) OR ((yk1 EQ yj) AND (yk1 EQ datay1))) DO BEGIN             
; new lines: allocate new buffer and 
; gerenerate new line in the middel of the buffer
                linebuf[nlines]=PTR_NEW(DBLARR(2L,2*linebufinit,/NOZERO),/NO_COPY)
                linebufpos[0:2,nlines]=linebufinit+[-2,1,0]

                (*linebuf[nlines])[0:1,linebufpos[2,nlines]+[-2,-1,0,1]]=[[xdata[ix2],yk],[xdata[i],yk],[xdata[i],yk1],[xdata[ix2],yk1]]
                nlines=nlines+1
                
                newlines(nnewlines +[0,1])=[yk,yk1]
                inewlines(nnewlines+[0,1])=nlines-1
                jnewlines(nnewlines+[0,1])=linebufpos[0:1,nlines-1]
                nnewlines=nnewlines+2
                
                k=k+2
                k1=k+1
                IF k/2 LT npolyi THEN yk=poly[k mod 2,k/2] ELSE yk=datay1
                IF k1/2 LT npolyi THEN yk1=poly[k1 mod 2,k1/2] ELSE yk1=datay1
            ENDWHILE

            WHILE (k/2 LT npolyi) AND (j LT ncurlines) AND  $
              (((yk LE yj) AND (yk1 GE yj)) OR $
               ((yk GE yj) AND (yk LE yj1))) DO BEGIN
; connect: add new piece to existing line
                jj=jcurlines[j]
                ii=icurlines[j]
                IF jj GT linebufpos[2,ii] THEN jf=+1 ELSE jf=-1
                jp=(jf+1)/2

                IF yk EQ (*linebuf[ii])[1,jj] THEN BEGIN
; don't add point if horizontal line -- only change x coordinate
                    (*linebuf[ii])[0,jj]=xdata[ix2]
                    nrem=nrem+2L
                ENDIF ELSE BEGIN
                    jj0=jj+jf*[1,2]
                    IF (jj0[1] LT 0) OR (jj0[1] GE 2*linebufpos[2,ii]) THEN BEGIN
; resize array
                        linebufptr=linebuf[ii]
                        jj1=linebufpos[0:1,ii]
                        linebufolds=linebufpos[2,ii]
                        linebufnews=ROUND(linebufolds*linebufgrow*0.25D0)*4L
                        linebufoffs=(2L*linebufnews-jj1[1]-jj1[0]+1)/2L
                        linebufpos[0:1,ii]=linebufpos[0:1,ii]+linebufoffs
                        linebufpos[2,ii]=linebufnews
                        linebuf[ii]=PTR_NEW(DBLARR(2L,2L*linebufpos[2,ii],/NOZERO),/NO_COPY)
                        (*linebuf[ii])[0:1,linebufpos[0,ii]:linebufpos[1,ii]]=(*linebufptr)[0:1,jj1[0]:jj1[1]]
                        PTR_FREE,linebufptr
                        jj0=jj0+linebufoffs
                        
;.... adjust references to new array size
                        FOR l=j+1,ncurlines-1 DO BEGIN
                            IF icurlines[l] EQ ii THEN BEGIN
                                jcurlines[l]=linebufpos[1-jp,ii]
                            ENDIF
                        ENDFOR
                        FOR l=0,nnewlines-1 DO BEGIN
                            IF inewlines[l] EQ ii THEN BEGIN
                                jnewlines[l]=linebufpos[1-jp,ii]
                            ENDIF
                        ENDFOR
                    ENDIF

                    (*linebuf[ii])[0:1,jj0]= [[xdata[i],yk],[xdata[ix2],yk]]
                    linebufpos[jp,ii]=jj0[1]
                ENDELSE

                newlines[nnewlines]=yk
                inewlines[nnewlines]=ii
                jnewlines[nnewlines]=linebufpos[jp,ii]
                nnewlines=nnewlines+1
  
                k=k+1
                k1=k+1
                IF k/2 LT npolyi THEN yk=poly[k mod 2,k/2] ELSE yk=datay1
                IF k1/2 LT npolyi THEN yk1=poly[k1 mod 2,k1/2] ELSE yk1=datay1
                
                j=j+1
                IF j LT ncurlines THEN yj=curlines[j] ELSE yj=datay1
                IF (j+1) LT ncurlines THEN yj1=curlines[j+1] ELSE  yj1=datay1
            ENDWHILE
        
            WHILE ((j+1) LT ncurlines) AND ((yj1 LT yk) OR ((yj1 EQ yk) AND (yk EQ datay1))) DO BEGIN
                ii=icurlines[j]
                ii1=icurlines[j+1]
                IF (ii NE ii1) THEN BEGIN
; contact lines: store ii1 to ii
;.... setup
                    jj=jcurlines[j]
                    IF jj GT linebufpos[2,ii] THEN jf=+1 ELSE jf=-1
                    jp=(jf+1)/2
                    jj1=jcurlines[j+1]
                    IF jj1 GT linebufpos[2,ii1] THEN jf1=+1 ELSE jf1=-1
                    jp1=(jf1+1)/2
;.... determine ii1 source location
                    jj1_start=linebufpos[0,ii1]
                    jj1_end=linebufpos[1,ii1]
                    jj1n=jj1_end-jj1_start+1
                    linebufptr1=linebuf[ii1]
;.... determine ii source location
                    ll=linebufpos[0,ii]
                    lh=linebufpos[1,ii]
                    ln=lh-ll+1
                    linebufptr=linebuf[ii]
;.... create new buffer                    
                    lnn=ln+jj1n
                    lnn0=lnn/2+linebufinit
                    linebufptr0=PTR_NEW(DBLARR(2L,2L*lnn0,/NOZERO),/NO_COPY)
                    lln=lnn0-1-lnn/2
                    lhn=lln+lnn-1
;.... first copy ii data
                    IF jf EQ 1 THEN jn=lln ELSE jn=lhn
                    jj=jn+jf*(ln-1)
                    jm=jj
                    IF jm LT jn THEN swap,jm,jn
                    (*linebufptr0)[0:1,jn:jm]=(*linebufptr)[0:1,ll:lh]
;.... determine ii1 destination
                    jj_start=jj+jf
                    jj_end=jj+jf*jj1n
                    IF jf EQ -1 THEN swap,jj_start,jj_end
;.... copy data from ii1
                    IF jf*jf1 EQ 1 THEN BEGIN
                        (*linebufptr0)[0:1,jj_start:jj_end]=REVERSE((*linebufptr1)[0:1,jj1_start:jj1_end],2)
                    ENDIF ELSE BEGIN
                        (*linebufptr0)[0:1,jj_start:jj_end]=(*linebufptr1)[0:1,jj1_start:jj1_end]
                    ENDELSE
                    linebufpos[0:2,ii]=[lln,lhn,lnn0]
                    linebuf[ii]=linebufptr0
                    PTR_FREE,linebufptr,linebufptr1

;.... redirect references to added part to new line
;.... and new end point of old line
                    FOR l=j+2,ncurlines-1 DO BEGIN
                        IF icurlines[l] EQ ii THEN BEGIN
                            jcurlines[l]=linebufpos[1-jp,ii]
                        ENDIF
                        IF icurlines[l] EQ ii1 THEN BEGIN
                            icurlines[l]=ii
                            jcurlines[l]=linebufpos[jp,ii]
                        ENDIF
                    ENDFOR
                    FOR l=0,nnewlines-1 DO BEGIN
                        IF inewlines[l] EQ ii THEN BEGIN
                            jnewlines[l]=linebufpos[1-jp,ii]
                        ENDIF
                        IF inewlines[l] EQ ii1 THEN BEGIN
                            inewlines[l]=ii
                            jnewlines[l]=linebufpos[jp,ii]
                        ENDIF
                    ENDFOR
;.... prepare removal                    
                    iremove=ii1
                ENDIF ELSE BEGIN

;.... draw line ....
                    ll=linebufpos[0,ii]
                    lh=linebufpos[1,ii]
                    ln=lh-ll+1
                    
;.... set up line buffer
                    temp=DBLARR(2L,ln+1,/NOZERO)
                    temp[0:1,0:ln-1]=(*linebuf[ii])[0:1,ll:lh]
;.... close line path          
                    temp[0:1,ln]=temp[0:1,0]
;.... put to normal coordiantes if necessary
                    IF xnormal THEN BEGIN
                        xyz=CONVERT_COORD(temp[0,*],temp[1,*],/DATA,/TO_NORMAL)
                        temp[1,*]=xyz[1,*]
                        xyz=0
                    ENDIF
;.... compress 
                    reduce,temp,XRES=xgrid,YRES=ygridred,NREM=ld
;.... the plot
                    PLOTS,temp[0,*],temp[1,*],NOCLIP=1,COLOR=color(0),THICK=linethick[0],NORMAL=xnormal
                    nvert=nvert+ln-ld+1
                    nrem=nrem+ld
;..... free memory
                    PTR_FREE,linebuf[ii]
                    temp=0

;..... prepare removal
                    iremove=ii
                ENDELSE                                

;.... remove deleted line from stack 
                FOR l=iremove+1,nlines-1 DO BEGIN
                    linebuf[l-1]=linebuf[l]
                    linebufpos[0:2,l-1]=linebufpos[0:2,l]
                ENDFOR
                nlines=nlines-1
;.... adjust all relevant references
                FOR l=j+2,ncurlines-1 DO BEGIN
                    IF icurlines[l] GT iremove THEN BEGIN
                        icurlines[l]=icurlines[l]-1
                    ENDIF
                ENDFOR
                FOR l=0,nnewlines-1 DO BEGIN
                    IF inewlines[l] GT iremove THEN BEGIN
                        inewlines[l]=inewlines[l]-1
                    ENDIF
                ENDFOR
;.... prepare for next cycle
                j=j+2
                IF j LT ncurlines THEN yj=curlines[j] ELSE yj=datay1
                IF (j+1) LT ncurlines THEN yj1=curlines[j+1] ELSE  yj1=datay1
            ENDWHILE
        ENDWHILE
        
        
; at the end: copy new to current
        curlines=newlines
        ncurlines=nnewlines
        icurlines=inewlines
        jcurlines=jnewlines
    ENDIF

end_of_i_loop: 
ENDFOR


END


; ======================================================================

PRO test_layer

nkonvmax=2
nstart=0
nend=5

nstep=1

nkonv=intarr(nend+2)
nkonv(*)=0

timex=indgen(7)

konv=dindgen(2,nkonvmax)

konv=[[4,9,2,7,7,8],[8,11,5,10,9,10]]

konv=TRANSPOSE(konv)

nkonv(1:2)=2
nkonv(4:5)=1
nkonv(1:nend+1)=total(nkonv(0:nend),/cum)

plot,[-0.5,6.5],[0,11],/nodata,/xs
plotlayer,nkonvmax,nstart,nend,nkonv,timex,konv,!P.color,1,45.,.3,2,3,NSTEP=nstep,/rectangular,XGRID=.1,YGRID=.1


END
 
