PRO scaleaxis,x,IEND=iend,ISTART=istart,TITLE=title,VARIABLE=variable,UNIT=unit, $
              X0=x0,RESCALE=rescale,RANGE=range,SWAPRANGE=swaprange,LIMIT=limit, $
              POWERRANGE=powerrange,POWERFACTOR=powerfactor,LOGARITHMIC=logarithmic, $
              LOGMIN=logmin,REUSE=reuse,SETRANGE=setrange,SETX0=setx0, $
              LARGESUBSCRIPTS=largesubscripts

IF N_ELEMENTS(istart) EQ 0 THEN istart=0
IF N_ELEMENTS(iend) EQ 0 THEN iend=N_ELEMENTS(x)-1
IF N_ELEMENTS(rescale) EQ 0 THEN rescale=0
IF N_ELEMENTS(title) EQ 0 THEN title='?'
IF N_ELEMENTS(swaprange) EQ 0 THEN swaprange=0
IF N_ELEMENTS(limit) EQ 0 THEN limit=1000.0D0
IF N_ELEMENTS(powerrange) EQ 0 THEN BEGIN
    IF N_ELEMENTS(powerfactor) EQ 0 THEN BEGIN
        powerrange=1
    ENDIF ELSE BEGIN
        powerrange=1
    ENDELSE
ENDIF
IF N_ELEMENTS(reuse) EQ 0 THEN reuse=0
IF N_ELEMENTS(logarithmic) EQ 0 THEN logarithmic=0
IF N_ELEMENTS(logmin) EQ 0 THEN logmin=0
IF N_ELEMENTS(setrange) EQ 0 THEN setrange=0
IF N_ELEMENTS(setx0) EQ 0 THEN setx0=0
IF N_ELEMENTS(x0) EQ 0 THEN x0=0
IF N_ELEMENTS(largesubscripts) EQ 0 THEN largesubscripts=0

iend=MAX([istart,iend],MIN=istart)

powerfactor=1.0D0

IF setrange AND (N_ELEMENTS(range) EQ 2) THEN BEGIN
    IF range(0) EQ range(1) THEN setrange=0
ENDIF

IF setrange AND (N_ELEMENTS(range) EQ 2) THEN BEGIN
    xmin=MIN(range,MAX=xmax)
ENDIF ELSE BEGIN
    xmin=MIN([x(istart:iend)],MAX=xmax)
ENDELSE

IF largesubscripts EQ 0 THEN BEGIN
    expcmd='!e' 
    indcmd='!i' 
ENDIF ELSE BEGIN 
    expcmd='!a'
    indcmd='!b'
ENDELSE
 
IF logarithmic THEN BEGIN
    i=1+MAX([0,FIX(ALOG10(MAX([1,ABS(logmin)])))])
    IF logmin LT 0 THEN i=i+1
    format="(I"+STRING(i,FORMAT="(I5)")+")"
    IF N_ELEMENTS(variable) NE 0 AND N_ELEMENTS(unit) NE 0 THEN BEGIN
        title='log( ('+variable+indcmd+'last!n - '+variable+' ) / '+unit+' + 10'+expcmd+STRING(logmin,FORMAT=format)+'!n )'
    ENDIF ELSE BEGIN
        title='log( ('+title+')'+indcmd+'last!n - '+title+' + 10'+expcmd+STRING(logmin,FORMAT=format)+'!n )'
    ENDELSE
    IF rescale THEN BEGIN
        x=ALOG10(xmax-x+10.0D0^logmin)
    ENDIF
ENDIF ELSE IF (ABS(xmax)+ABS(xmin))/ABS(xmax-xmin) GT limit THEN BEGIN
    xpwr=xmax-xmin
    IF xpwr EQ 0.0D0 THEN xpwr=1.D-14*ABS(xmax+xmin)
    IF xpwr EQ 0.0D0 THEN xpwr=1.D0
    xpwr=FLOOR(ALOG10(xpwr))
    xmag=10.0D0^xpwr
    IF NOT setx0 THEN x0=xmin-(xmin mod xmag)+xmag
    x0pwr=FLOOR(ALOG10(ABS(x0)))
    IF x0 GT 0.0D0 THEN BEGIN
        title=title+' - '
    ENDIF ELSE BEGIN
        title=title+' + '
    ENDELSE
    IF (xpwr GE 0) AND (xpwr LE 5) AND (x0pwr LT 9) THEN BEGIN ; do not need floating point
        format="(I"+STRING(1+ABS(x0pwr),FORMAT="(I4)")+")"
        title=title+STRING(ABS(x0),FORMAT=format)
    ENDIF ELSE IF (x0pwr GT -2) AND (xpwr LT 3) THEN BEGIN
        format="(F"+STRING(2+ABS(x0pwr)+ABS(xpwr),FORMAT="(I4)")+"."+STRING(ABS(xpwr),FORMAT="(I4)")+")"
        title=title+STRING(ABS(x0),FORMAT=format)
    ENDIF ELSE BEGIN
        xpwr1=ABS(xpwr-x0pwr)+1
        format="(F"+STRING(MAX([1+xpwr1,3]),FORMAT="(I4)")+"."+STRING(MAX([xpwr1-1,1]),FORMAT="(I4)")+")"
        title=title+STRING(ABS(x0)*0.1D0^x0pwr,FORMAT=format)
        IF (x0pwr NE 0) THEN BEGIN
            digits=1+FLOOR(ALOG10(ABS(x0pwr)))
            IF x0pwr LT 0 THEN digits=digits+1
            format="(I"+STRING(digits,FORMAT="(I4)")+")"
            title=title+" * 10"+expcmd+STRING(x0pwr,FORMAT=format)+"!n"        
        ENDIF
    ENDELSE
    IF rescale THEN x=x-x0
    IF powerrange EQ 1 THEN BEGIN
        powerfactor=xmag
        IF xpwr NE 0 THEN BEGIN
            x=x/xmag
            digits=1+FLOOR(ALOG10(ABS(xpwr)))
            IF xpwr GT 0 THEN digits=digits+1
            format="(I"+STRING(digits,FORMAT="(I4)")+")"
            title="( "+title+" ) * 10"+expcmd+STRING(-xpwr,FORMAT=format)+"!n"
        ENDIF
    ENDIF
ENDIF ELSE BEGIN
    x0=0.0D0
ENDELSE

IF swaprange THEN BEGIN
    range=[xmax,xmin]
ENDIF ELSE BEGIN
    range=[xmin,xmax]
ENDELSE

range=(range-x0)/powerfactor

END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
