PRO select,region,VERBOSE=verbose,CODE=code

IF N_ELEMENTS(verbose) EQ 0 THEN verbose=0

col = RGB(255,PALETTE=255)

IF !X.TYPE EQ 0 THEN datax=!X.CRANGE ELSE datax=10D0^!X.CRANGE
IF !Y.TYPE EQ 0 THEN datay=!Y.CRANGE ELSE datay=10D0^!Y.CRANGE
eckpunkt=ROUND(CONVERT_COORD(datax,datay,/DATA,/TO_DEVICE))

REPEAT BEGIN
    CURSOR, x0, y0, 3, /DEVICE
    button = !MOUSE.BUTTON
ENDREP UNTIL (button NE 0)

code=button
IF button NE 1 THEN BEGIN
    RETURN
ENDIF

DEVICE, GET_GRAPHICS=old, SET_GRAPHICS=6

x1=x0
y1=y0
cx=x0
cy=Y0

PLOTS,[x0,x0,x1,x1,x0],[y0,y1,y1,y0,y0],THICK=1,COLOR=col,/DEVICE
REPEAT BEGIN
    cx0=x1
    cy0=y1
    CURSOR, cx, cy, /CHANGE, /DEVICE
    CURSOR, cx, cy, 0, /DEVICE
    button = !MOUSE.BUTTON
    IF (cx LT 0) AND (cy LT 0) THEN BEGIN
;        button=1
        cx=cx0
        cy=cy0
    ENDIF
    repos=0

    IF cx LT eckpunkt[0,0] THEN BEGIN 
        cx=eckpunkt[0,0]
        repos=1
    ENDIF ELSE IF cx GT eckpunkt[0,1] THEN BEGIN 
        cx=eckpunkt[0,1]
        repos=1
    ENDIF 
    IF cy LT eckpunkt[1,0] THEN BEGIN 
        cy=eckpunkt[1,0]
        repos=1
    ENDIF ELSE IF cy GT eckpunkt[1,1] THEN BEGIN 
        cy=eckpunkt[1,1]
        repos=1
    ENDIF
    PLOTS,[x0,x0,x1,x1,x0],[y0,y1,y1,y0,y0],THICK=1,COLOR=col,/DEVICE
    IF (button AND 4) EQ 4 THEN BEGIN
    dx=cx-cx0
    dy=cy-cy0
        IF (dx LT -x0+eckpunkt[0,0]) THEN BEGIN
            repos=1
            dx=-x0+eckpunkt[0,0]
        ENDIF ELSE IF (dx GT eckpunkt[0,1]-x0) THEN BEGIN
            repos=1
            dx=eckpunkt[0,1]-x0
        ENDIF
        IF (dy LT -y0+eckpunkt[1,0]) THEN BEGIN
            repos=1
            dy=-y0+eckpunkt[1,0]
        ENDIF ELSE IF (dy GT eckpunkt[1,1]-y0) THEN BEGIN
            repos=1
            dy=eckpunkt[1,1]-y0
        ENDIF
        x0=x0+dx
        y0=y0+dy
        x1=x1+dx
        y1=y1+dy
    ENDIF ELSE BEGIN
        x1=cx
        y1=cy
    ENDELSE
    PLOTS,[x0,x0,x1,x1,x0],[y0,y1,y1,y0,y0],THICK=1,COLOR=col,/DEVICE
    IF repos THEN TVCRS,x1,y1
ENDREP UNTIL button EQ 0
PLOTS,[x0,x0,x1,x1,x0],[y0,y1,y1,y0,y0],THICK=1,COLOR=col,/DEVICE

DEVICE, SET_GRAPHICS=old

cx0=MIN([x0,x1])
cx1=MAX([x0,x1])
cy0=MIN([y0,y1])
cy1=MAX([y0,y1])

region=CONVERT_COORD([cx0,cx1],[cy0,cy1],/DEVICE,/TO_DATA)
region=region(0:1,0:1)

IF verbose EQ 1 THEN BEGIN
    PRINT,FORMAT="(A,3(E25.15))",'x ',region[0,*],region[0,1]-region[0,0]
    PRINT,FORMAT="(A,3(E25.15))",'y ',region[1,*],region[1,1]-region[1,0]
ENDIF

END
