FUNCTION time2human, $
   xsize0, $
   NUMERIC=numeric, $
   UNIT=unit, $
   SCALE=scale, $
   DIGITS=digits, $
   CUT=cut

IF N_ELEMENTS(digits) EQ 0 THEN digits=2
IF N_ELEMENTS(cut) EQ 0 THEN cut=1

@physconst

xsize=ABS(xsize0)
su='s'
IF xsize GT 99.49999D0 THEN BEGIN
    xsize/=60.D0
    su='min'
ENDIF
IF xsize0 GT 60*59.49999D0 THEN BEGIN
    xsize/=60.D0
    su='h'
ENDIF
IF xsize0 GT 24*60*99.49999D0 THEN BEGIN
    xsize/=24.D0
    su='d'
ENDIF
IF xsize0 GT sec THEN BEGIN
    xsize/=(sec/day)
    su='yr'
ENDIF
IF xsize0 GT sec*999.49999D0 THEN BEGIN
    xsize/=1000.D0
    su='kyr'
ENDIF
IF xsize0 GT sec*999.49999D3 THEN BEGIN
    xsize/=1000.D0
    su='Myr'
ENDIF
IF xsize0 GT sec*999.49999D6 THEN BEGIN
    xsize/=1000.D0
    su='Gyr'
ENDIF

IF ABS(xsize0) LT 0.99949999D0 THEN BEGIN
   xsize*=1.D3
   su='ms'
ENDIF
IF ABS(xsize0) LT 0.99949999D-3 THEN BEGIN
   xsize*=1.D3
   su='\mu s'
ENDIF
IF ABS(xsize0) LT 0.99949999D-6 THEN BEGIN
   xsize*=1.D3
   su='ns'
ENDIF
IF ABS(xsize0) LT 0.99949999D-9 THEN BEGIN
   xsize*=1.D3
   su='ps'
ENDIF
IF ABS(xsize0) LT 0.99949999D-12 THEN BEGIN
   xsize*=1.D3
   su='fs'
ENDIF

sv=STRTRIM(STRING(ABS(xsize),FORMAT="(F20.15)"),2)
i=STRPOS(sv,'.')
l=(digits+1)>(i+1)
format="(F"+STRTRIM(STRING(ROUND(l)),2)+"."+STRTRIM(STRING(ROUND(l-i-1)),2)+")"
sv=STRTRIM(STRING(ABS(xsize),FORMAT=format),2)

IF STRMID(sv,0,1) EQ '*' THEN BEGIN
   i+=1
   l=(digits+1)>(i+1)
   format="(F"+STRTRIM(STRING(ROUND(l)),2)+"."+STRTRIM(STRING(ROUND(l-i-1)),2)+")"
   sv=STRTRIM(STRING(ABS(xsize),FORMAT=format),2)
ENDIF

IF cut EQ 1 THEN BEGIN
   IF i LT l THEN BEGIN
      WHILE STRMID(sv,STRLEN(sv)-1,1) EQ '0' DO BEGIN
         sv=STRMID(sv,0,STRLEN(sv)-1)
      ENDWHILE
   ENDIF
   IF STRMID(sv,STRLEN(sv)-1,1) EQ '.' THEN BEGIN
      sv=STRMID(sv,0,STRLEN(sv)-1)
   ENDIF
ENDIF

IF xsize0 LT 0 THEN sv='-'+sv

unit=su
numeric=xsize
scale=xsize0/xsize
RETURN,sv+' '+su
END

