PRO diag_mult,a,v,dim,ERROR=error,IN=a0

error=0

sv=SIZE(v)
IF sv[0] GT 1 THEN BEGIN
    PRINT,' [DIAG_MULT] ERROR: input vector needs to be a vector.'
    error=1
    RETURN
ENDIF

IF N_ELEMENTS(dim) EQ 0 THEN dim=1

IF N_ELEMENTS(a0) NE 0 THEN a=a0

sa=SIZE(a)
IF sa[0] LT dim-2 THEN BEGIN
    PRINT,' [DIAG_MULT] ERROR: input matrix dimesions.'
    error=1
    RETURN
ENDIF
IF sa[dim] NE sv[1] THEN BEGIN
   IF sv[0] EQ 1 THEN BEGIN
      a*=v[0]
      PRINT,' [DIAG_MULT] WARNING: doing scalar multiplication.'         
   ENDIF ELSE BEGIN
      PRINT,' [DIAG_MULT] ERROR: incompatible size.'         
      error=1
   ENDELSE
   RETURN
ENDIF

CASE dim OF
   1: BEGIN
      IF sa[0] GT dim THEN BEGIN
         n1=sa[1:dim]
         n2=PRODUCT(sa[dim+1:sa[0]],/INTEGER)
         a=REFORM(a,[n1,n2],/OVERWRITE)
      ENDIF
      FOR i=0L,N_ELEMENTS(v)-1 DO BEGIN         
         a[i,*]*=v[i]
      ENDFOR
      a=REFORM(a,sa[1:sa[0]],/OVERWRITE)
   END
;   2: BEGIN
;      IF sa[0] GT dim THEN BEGIN
;         n1=sa[1:dim]
;         n2=PRODUCT(sa[dim+1:sa[0]],/INTEGER)
;         a=REFORM(a,[n1,n2],/OVERWRITE)
;      ENDIF
;      FOR i=0L,N_ELEMENTS(v)-1 DO BEGIN
;         a[*,i,*]*=v[i]
;      ENDFOR
;      a=REFORM(a,sa[1:sa[0]],/OVERWRITE)
;   END
;   3: BEGIN
   ELSE: BEGIN
      n0=PRODUCT(sa[1:dim-1:sa[0]],/INTEGER)
      n1=sa[dim]
      IF sa[0] GT dim THEN BEGIN
         n2=PRODUCT(sa[dim+1:sa[0]],/INTEGER)
         n=[n0,n1,n2]
      ENDIF ELSE BEGIN
         n=[n0,n1]
      ENDELSE
      a=REFORM(a,n,/OVERWRITE)
      FOR i=0L,N_ELEMENTS(v)-1 DO BEGIN
         a[*,i,*]*=v[i]
      ENDFOR
      a=REFORM(a,sa[1:sa[0]],/OVERWRITE)
   END
;   ELSE: BEGIN
;      PRINT,' [DIAG_MULT] ERROR dimension.'
;   END   
ENDCASE

END

