FUNCTION isocolors,n,TABLE=table,PALETTE=palette, $
                   HUE=hue,$ 
                   SATURATION=saturation, $
                   MIN=min, $
                   MAX=max

IF N_ELEMENTS(hue) EQ 0 THEN hue=1
IF N_ELEMENTS(saturation) EQ 0 THEN saturation=1
IF N_ELEMENTS(min) EQ 0 THEN min=0
IF N_ELEMENTS(max) EQ 0 THEN max=360

IF !D.N_COLORS LE 256 THEN BEGIN
    IF N_ELEMENTS(palette) EQ 0 THEN palette=-1
    IF palette GE -1 THEN BEGIN
        H=REPLICATE(hue,n)
        S=REPLICATE(saturation,n)
        V=min+(max-min)*(DINDGEN(n)/n)
        ipalette=palette
        IF ipalette[0] EQ -1 THEN ipalette=REPLICATE(-1,n)
        IF N_ELEMENTS(ipalette) NE n THEN ipalette=ipalette+INDGEN(n)
        FOR i=0,N_ELEMENTS(ipalette)-1 DO BEGIN
            x=hsv_color(h[i],s[i],v[i],PALETTE=ipalette[i])
            ipalette[i]=x
        ENDFOR
        c=ipalette
    ENDIF ELSE BEGIN
        IF N_ELEMENTS(table) EQ 0 THEN table=1
        IF table THEN ncolors=!D.TABLE_SIZE ELSE ncolors=256
        c=1+ROUND((DINDGEN(n)/n)*(ncolors-2))
    ENDELSE
ENDIF ELSE BEGIN
    H=REPLICATE(hue,n)
    S=REPLICATE(saturation,n)
    V=min+(max-min)*(DINDGEN(n)/n)
    c=HSV_COLOR(H,S,V)
ENDELSE

RETURN,c
END
