
FUNCTION calcvmu,yps

COMMON isotopes, nisotopes, isotopes

vmu=TOTAL(yps(0:nisotopes-1)/isotopes(0:nisotopes-1).a*(1.0D0+isotopes(0:nisotopes-1).z))

RETURN,vmu
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FUNCTION calceion,yps

COMMON isotopes, nisotopes, isotopes

eion=TOTAL(yps(0:nisotopes-1)/isotopes(0:nisotopes-1).a*isotopes(0:nisotopes-1).eion)*9.6485308989D11

RETURN,eion
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO SAHA,t,ro,yps,eion,vmu

COMMON isotopes, nisotopes, isotopes


@physconst

AA=8.0188096D-09
BOLEV=8.6170804D-05
CHI=[13.595D0,24.58D0,54.414D0]

n=N_ELEMENTS(t)

IF N_ELEMENTS(eion) LT n THEN eion=DBLARR(n)
IF N_ELEMENTS(vmu) LT n THEN vmu=DBLARR(n)

mis=0
; t< 3.D5

FOR i=0,n-1 DO BEGIN
    IF ro(i) GT 3.D-3 THEN BEGIN
;    IF t(i) GT 3.D+5 THEN BEGIN
        vmu(i)=calcvmu(yps(i,*))
        eion(i)=calceion(yps(i,*))
        mis=i+1
    ENDIF
ENDFOR

yxe=DBLARR(n)
xk=DBLARR(3)
xn=DBLARR(3)


FOR k=mis,n-1 DO BEGIN

    YXE(K)=0.D0
    FOR i=0,nisotopes-1 DO BEGIN
        YXE(K)=YXE(K)+YPS(K,I)/isotopes(i).a
    ENDFOR
;     FIRST APPROXIMATION OF EE FOR THE ITERATION OF THE SAHA EQUATION
    IF (K EQ MIS) THEN EE=(1.D0+(YPS(K,1)+YPS(K,2)))/(2.D0*YXE(K))
    DENO=4.D0*(YPS(K,1)+YPS(K,2))+YPS(K,3)+YPS(K,4)
    XH=4.D0*(YPS(K,1)+YPS(K,2))/DENO
    XHE=(YPS(K,3)+YPS(K,4))/DENO
    B=AA/YXE(K)
    RKMU=RK*YXE(K)
;     CALCULATION OF VMU ; THE OPERATION IS REPEATED 3 TIMES IN ORDER
;     TO OBTAIN THE DERIVATIVES IN RO AND T
         
    ROKI=RO(K)
    TKI=T(K)
    CC=B*SQRT(TKI)^3/ROKI
    TKEVI=1.0D0/(BOLEV*TKI)
    XK(0)=0.5D0*CC*EXP(-CHI(0)*TKEVI)
    XK(1)=2.0D0*CC*EXP(-CHI(1)*TKEVI)
    XK(2)=0.5D0*CC*EXP(-CHI(2)*TKEVI)
;     EXPRESSION OF THE NH, NHE, NHE+ IN SIMPLIFIED FORM

    ITSA=0
    DD=1.
    WHILE (ITSA LT 2) OR (DD GT 1.D-7) OR ((ITSA LT 45) AND (DD GT 1.D-7)) DO BEGIN
        ITSA=ITSA+1
        xx=XK(1)/(EE^2 + EE*XK(1) + XK(1)*XK(2))
        XN(0)=XK(0)/(EE + XK(0))
        XN(1)=EE*xx
        XN(2)=XK(2)*xx
;     EQUATION OF SAHA
        IF (ITSA GT 1) THEN VVEE=VEE
        VEE=EE
        EE=XH*XN(0) + XHE*(XN(1) + 2.D0*XN(2))
        DD=ABS(1.0D0-EE/VEE)
        IF (ITSA GT 50) THEN BEGIN
            PRINT,' [IONISE] k=',k,' mis=',mis,' DD=',DD,' EE=',EE,' VEE=',VEE
            RETURN
        ENDIF
;     ACCELERATION WITH THE AITKEN INTERPOLATION
        IF (ITSA GT 1) AND (DD GT 1.D-7) THEN BEGIN
            IF (EE LT 0.2D0) AND (VEE LT 0.2D0) THEN BEGIN
                EE=0.5D0*(EE+VEE)
            ENDIF ELSE BEGIN
                EE=EE -(EE-VEE)^2/(EE-2.D0*VEE+VVEE)
            ENDELSE
        ENDIF
    ENDWHILE
    VMU(k)=YXE(K)*(1+EE)
    xx=XK(1)/(EE^2 + EE*XK(1) + XK(1)*XK(2))
    XN(0)=XK(1)/(EE + XK(1))
    XN(1)=EE*xx
    XN(2)=XK(2)*xx
    
    EION(k)=RKMU*(XH*CHI(0)*XN(0) + XHE*(CHI(1)*XN(1) + (CHI(1)+CHI(2))*XN(2)))/BOLEV


;    PRINT,'ITSA=',ITSA
ENDFOR

END


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FUNCTION isotope_name2index,name

COMMON isotopes, nisotopes, isotopes

IF N_ELEMENTS(nisotopes) EQ 0 THEN BEGIN
    PRINT,'loading isotope mapping table'
    isotopes
;    PRINT,'Keine Isotopentafel geladen'
;    RETURN,-1
ENDIF

IF (N_ELEMENTS(name) EQ 0) THEN BEGIN
    name=isotopes(0).name
    PRINT,'Kein Isotop angegeben; verwende stattdessen ',name
    RETURN,0
ENDIF

x=SIZE(name)
IF x(x(0)+1) NE 7 THEN RETURN,name

k=-1
i=0
WHILE (i LT nisotopes) AND (k EQ -1) DO BEGIN
    IF (STRUPCASE(isotopes(i).name) EQ STRUPCASE(name)) THEN k=i
    IF (k EQ -1) THEN BEGIN
        j=1
        IF isotopes(i).a GT 9 THEN j=2
        IF isotopes(i).a GT 99 THEN j=3
        format="(I"+STRING(j,FORMAT="(I1)")+")"
        namex=isotopes(i).Symbol+STRING(isotopes(i).a,FORMAT=format)
        IF (STRUPCASE(namex) EQ STRUPCASE(name)) THEN k=i
        namex=STRING(isotopes(i).a,FORMAT=format)+isotopes(i).Symbol
        IF (STRUPCASE(namex) EQ STRUPCASE(name)) THEN k=i

        namex='x'+isotopes(i).Symbol+STRING(isotopes(i).a,FORMAT=format)
        IF (STRUPCASE(namex) EQ STRUPCASE(name)) THEN k=i+nisotopes
        namex=STRING(isotopes(i).a,FORMAT=format)+isotopes(i).Symbol+'x'
        IF (STRUPCASE(namex) EQ STRUPCASE(name)) THEN k=i+nisotopes
    ENDIF
    i=i+1
ENDWHILE

CASE STRUPCASE(name) OF
  STRUPCASE('xnint') : k=2*nisotopes
  STRUPCASE('u') : k=2*nisotopes+1
  STRUPCASE('r') : k=2*nisotopes+2
  STRUPCASE('ro') : k=2*nisotopes+3
  STRUPCASE('t') : k=2*nisotopes+4
  STRUPCASE('tsurf') : k=2*nisotopes+4
  STRUPCASE('sl') : k=2*nisotopes+5
  STRUPCASE('e') : k=2*nisotopes+6
  STRUPCASE('al') : k=2*nisotopes+7
  STRUPCASE('vu') : k=2*nisotopes+8
  STRUPCASE('vr') : k=2*nisotopes+9
  STRUPCASE('vro') : k=2*nisotopes+10
  STRUPCASE('vt') : k=2*nisotopes+11
  STRUPCASE('vsl') : k=2*nisotopes+12
  STRUPCASE('ai') : k=2*nisotopes+13
  STRUPCASE('aw') : k=2*nisotopes+14
  STRUPCASE('xm') : k=2*nisotopes+15
  STRUPCASE('s') : k=2*nisotopes+16
  STRUPCASE('awk') : k=2*nisotopes+17
  STRUPCASE('awawk') : k=2*nisotopes+18
  STRUPCASE('cappa') : k=2*nisotopes+19
  STRUPCASE('gamma') : k=2*nisotopes+20
  STRUPCASE('uterm') : k=2*nisotopes+21
  STRUPCASE('dms') : k=2*nisotopes+22
  STRUPCASE('urot') : k=2*nisotopes+23
  STRUPCASE('uesc') : k=2*nisotopes+24
  STRUPCASE('lwind') : k=2*nisotopes+25
  STRUPCASE('pwind') : k=2*nisotopes+26
  STRUPCASE('time') : k=2*nisotopes+27
  STRUPCASE('xj') : k=2*nisotopes+28
  STRUPCASE('aldot') : k=2*nisotopes+29
  STRUPCASE('awc') : k=2*nisotopes+30
  STRUPCASE('awawc') : k=2*nisotopes+31
  STRUPCASE('omega') : k=2*nisotopes+32
  STRUPCASE('didr') : k=2*nisotopes+33
  STRUPCASE('xi') : k=2*nisotopes+34
  STRUPCASE('djdr') : k=2*nisotopes+35
  STRUPCASE('dmj') : k=2*nisotopes+36
  STRUPCASE('ifac') : k=2*nisotopes+37
  STRUPCASE('enbind') : k=2*nisotopes+38
  STRUPCASE('lambda') : k=2*nisotopes+39
  STRUPCASE('diff') : k=2*nisotopes+40
  STRUPCASE('d1') : k=2*nisotopes+41
  STRUPCASE('d2') : k=2*nisotopes+42
  STRUPCASE('d3') : k=2*nisotopes+43
  STRUPCASE('d4') : k=2*nisotopes+44
  STRUPCASE('d5') : k=2*nisotopes+45
  STRUPCASE('dg') : k=2*nisotopes+46
  STRUPCASE('ae') : k=2*nisotopes+47
  STRUPCASE('egrav') : k=2*nisotopes+48
  STRUPCASE('tkh') : k=2*nisotopes+49
  STRUPCASE('tes') : k=2*nisotopes+50
  STRUPCASE('conv') : k=2*nisotopes+51
  STRUPCASE('c') : k=2*nisotopes+52
  STRUPCASE('n') : k=2*nisotopes+53
  STRUPCASE('o') : k=2*nisotopes+54
  STRUPCASE('he') : k=2*nisotopes+55
  STRUPCASE('li') : k=2*nisotopes+56
  STRUPCASE('be') : k=2*nisotopes+57
  STRUPCASE('b') : k=2*nisotopes+58
  STRUPCASE('ne') : k=2*nisotopes+59
  STRUPCASE('mg') : k=2*nisotopes+60
  STRUPCASE('si') : k=2*nisotopes+61
  STRUPCASE('j/m^(5/3)') : k=2*nisotopes+62
  STRUPCASE('j/m^(2/3)') : k=2*nisotopes+63
  STRUPCASE('teff') : k=2*nisotopes+64
  STRUPCASE('reff') : k=2*nisotopes+65
  STRUPCASE('mag') : k=2*nisotopes+66
  STRUPCASE('ror3') : k=2*nisotopes+67
  STRUPCASE('press') : k=2*nisotopes+68
  STRUPCASE('h') : k=2*nisotopes+69
ELSE:
ENDCASE

IF (k EQ -1) THEN PRINT,name,' nicht gefunden'

RETURN,k
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO isotopes

COMMON isotopes, nisotopes, isotopes

nisotopes=35
isotopes=REPLICATE({isotope,name : '',Symbol : '', A : 0L, Z : 0L, eion : 1.0D0},nisotopes)

isotopes( 0)={isotope,name:'n'   ,Symbol:'n' ,A:1 ,Z:0 ,eion:0.00D0}
isotopes( 1)={isotope,name:'p'   ,Symbol:'H' ,A:1 ,Z:1 ,eion:1.36D1}
isotopes( 2)={isotope,name:'d'   ,Symbol:'H' ,A:2 ,Z:1 ,eion:1.36D1}
isotopes( 3)={isotope,name:'He3' ,Symbol:'He',A:3 ,Z:2 ,eion:6.90D1}
isotopes( 4)={isotope,name:'He4' ,Symbol:'He',A:4 ,Z:2 ,eion:6.90D1}
isotopes( 5)={isotope,name:'Li6' ,Symbol:'Li',A:6 ,Z:3 ,eion:2.03D2}
isotopes( 6)={isotope,name:'Li7' ,Symbol:'Li',A:7 ,Z:3 ,eion:2.03D2}
isotopes( 7)={isotope,name:'Be7' ,Symbol:'Be',A:7 ,Z:4 ,eion:3.98D2}
isotopes( 8)={isotope,name:'Be9' ,Symbol:'Be',A:9 ,Z:4 ,eion:3.98D2}
isotopes( 9)={isotope,name:'B8'  ,Symbol:'B' ,A:8 ,Z:5 ,eion:6.70D2}
isotopes(10)={isotope,name:'B10' ,Symbol:'B' ,A:10,Z:5 ,eion:6.70D2}
isotopes(11)={isotope,name:'B11' ,Symbol:'B' ,A:11,Z:5 ,eion:6.70D2}
isotopes(12)={isotope,name:'C11' ,Symbol:'C' ,A:11,Z:6 ,eion:1.03D3}
isotopes(13)={isotope,name:'C12' ,Symbol:'C' ,A:12,Z:6 ,eion:1.03D3}
isotopes(14)={isotope,name:'C13' ,Symbol:'C' ,A:13,Z:6 ,eion:1.03D3}
isotopes(15)={isotope,name:'N12' ,Symbol:'N' ,A:12,Z:7 ,eion:1.49D3}
isotopes(16)={isotope,name:'N14' ,Symbol:'N' ,A:14,Z:7 ,eion:1.49D3}
isotopes(17)={isotope,name:'N15' ,Symbol:'N' ,A:15,Z:7 ,eion:1.49D3}
isotopes(18)={isotope,name:'O16' ,Symbol:'O' ,A:16,Z:8 ,eion:2.04D3}
isotopes(19)={isotope,name:'O17' ,Symbol:'O' ,A:17,Z:8 ,eion:2.04D3}
isotopes(20)={isotope,name:'O18' ,Symbol:'O' ,A:18,Z:8 ,eion:2.04D3}
isotopes(21)={isotope,name:'Ne20',Symbol:'Ne',A:20,Z:10,eion:3.51D3}
isotopes(22)={isotope,name:'Ne21',Symbol:'Ne',A:21,Z:10,eion:3.51D3}
isotopes(23)={isotope,name:'Ne22',Symbol:'Ne',A:22,Z:10,eion:3.51D3}
isotopes(24)={isotope,name:'Na23',Symbol:'Na',A:23,Z:11,eion:4.42D3}
isotopes(25)={isotope,name:'Mg24',Symbol:'Mg',A:24,Z:12,eion:5.57D3}
isotopes(26)={isotope,name:'Mg25',Symbol:'Mg',A:25,Z:12,eion:5.57D3}
isotopes(27)={isotope,name:'Mg26',Symbol:'Mg',A:26,Z:12,eion:5.57D3}
isotopes(28)={isotope,name:'Al27',Symbol:'Al',A:27,Z:13,eion:6.60D3}
isotopes(29)={isotope,name:'Si28',Symbol:'Si',A:28,Z:14,eion:7.88D3}
isotopes(30)={isotope,name:'Si29',Symbol:'Si',A:29,Z:14,eion:7.88D3}
isotopes(31)={isotope,name:'Si30',Symbol:'Si',A:30,Z:14,eion:7.88D3}
isotopes(32)={isotope,name:'Fe56',Symbol:'Fe',A:56,Z:26,eion:3.00D4}
isotopes(33)={isotope,name:'F19' ,Symbol:'F' ,A:19,Z:9 ,eion:2.71D3}
isotopes(34)={isotope,name:'Al26',Symbol:'Al',A:26,Z:13,eion:6.60D3}

END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FUNCTION str_isotope,index,LARGESUBSCRIPTS=large

COMMON isotopes, nisotopes, isotopes

IF N_ELEMENTS(index) EQ 0 THEN index='1H'
IF N_ELEMENTS(large) EQ 0 THEN large=0

str_large=large
@strings

; don't modify input ...
isotope=index

; if string then convert to index
x=SIZE(isotope)
IF x(x(0)+1) EQ 7 THEN isotope=isotope_name2index(isotope)

UP=str_exp
DOWN=str_ind

IF isotope LT nisotopes THEN BEGIN
    s=UP+STRING(isotopes(isotope).A,FORMAT='(I2)')+'!N'+isotopes(isotope).Symbol
ENDIF ELSE BEGIN
    CASE STRUPCASE(isotope) OF
        2*nisotopes+4: s=str_teff+' / K'
        2*nisotopes+5: s='L / '+str_lsun
        2*nisotopes+23: s='v / km/s'
        2*nisotopes+52: s='C'
        2*nisotopes+53: s='N'
        2*nisotopes+54: s='O'
        2*nisotopes+55: s='He'
        2*nisotopes+56: s='Li'
        2*nisotopes+57: s='Be'
        2*nisotopes+58: s='B'
        2*nisotopes+59: s='Ne'
        2*nisotopes+60: s='Mg'
        2*nisotopes+61: s='Si'
        ELSE: s=''
    ENDCASE
ENDELSE

RETURN,s

END
