FUNCTION latexion,x,l,MATH=math,NOZERO=nozero,PROTONS=protons,MANUAL=manual

IF N_ELEMENTS(x) EQ 0 THEN x='He99'
IF N_ELEMENTS(l) EQ 0 THEN l=11
IF N_ELEMENTS(manual) EQ 0 THEN manual=0
IF N_ELEMENTS(math) EQ 0 THEN math=0

t=SIZE(x,/TNAME)
IF (t NE 'STRING') THEN x=idxion(x)
iondecompose,x,a,el

a=STRING(a,FORMAT="(A3)")
el=STRING(el,FORMAT="(A2)")

IF manual EQ 1 THEN BEGIN
    s='$^{'+a+'}$&'+el
ENDIF ELSE BEGIN
    s="\I{"+a+"}{"+el+"}"
ENDELSE

flen=STRTRIM(STRING(l),2)

IF N_ELEMENTS(nozero) EQ 0 THEN nozero=0
IF (nozero EQ 1) AND (x EQ '') THEN BEGIN
    s='-'
ENDIF

s=STRING(s,FORMAT="(A"+flen+")")

IF (math EQ 1) and NOT manual THEN s='$'+s+'$'

RETURN,s
END
