PRO dumpdata,dir,name

COMMON stern, nmodells, modells, modell_version

cd,dir

x=findfile(name+'#*')
n=N_ELEMENTS(x)

ii=strpos(x,'#')
cycle=REPLICATE('',n)
FOR i=0,n-1 DO BEGIN
    cycle[i]=STRTRIM(strmid(x[i],ii[i]+1,99),2)
ENDFOR

FOR i=0,n-1 DO BEGIN
    print,cycle[i]
    presndata,x[i],/time,outfile=name+'%'+cycle[i]
ENDFOR


END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------


PRO yielddump,cut

IF N_ELEMENTS(cut) EQ 0 THEN cut=1

getdump,'xm',xm
jz=N_ELEMENTS(xm)
jn=jz-cut+1

getdump,'ionsb',ion
in=N_ELEMENTS(ion)

mtot=0.0D0
yr=DBLARR(in)
yt=DBLARR(in)
FOR j=0,jn-1 DO BEGIN
    jj=j+cut
    jj1=jj-1
    getdump,'xb'+STRTRIM(STRING(jj),2),xb
    yt=yt+xb*xm[jj1]
    mtot=mtot+xm[jj1]
ENDFOR

; add wind...
getdump,'xmlost',mwind
mtot=mtot+mwind
getdump,'xwindb',bw
yt=yt+bw

; compute abundances
yt=yt/mtot
; maxradio,ion,map,ions,/STABLE,/SOLPROD,/MASS
; maxradio,ion,map,ions,/STABLE,/MASS

maxradio,ion,map,ions,/STABLE,/SOLPROD

y=yt#map

; yieldplot,y,ions,/logy,COLOR=RGB(1.,0.,0.)
yieldplot,y,ions,/logy,YR=[-1,2]

END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

PRO showdump

@physconst

getdump,'angjt',xj
getdump,'zm_sun',zm
getdump,'ionh1',h1
getdump,'ionhe4',he4

xj=xj*1.D50
FOR i=0,N_ELEMENTS(zm)-1 DO BEGIN
    PRINT,i,zm(i),xj(i),h1(i),he4(i),FORMAT="(I4,4(E12.3))"
ENDFOR

END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

PRO plotdump,x,y,OVERPLOT=overplot,XTITLE=xtitle,YTITLE=ytitle, $
             COLOR=color,LINE=line,PSYM=psym, $
             XRANGE=xrange,YRANGE=yrange,XLOG=xlog,YLOG=ylog,$
             XSTYLE=xstyle,YSTYLE=ystyle,SHORTNAME=shortname,$
             XMULT=xmult,YMULT=ymult,THICK=thick,YMAX_VALUE=ymax_value,$
             XMARGIN=xmargin,YMARGIN=ymargin,$
             LOGX=logx,LOGY=logy,$
             XCHARSIZE=xcharsize,YCHARSIZE=ycharsize,$
             TITLE=title


getdump,x,xv,NAME=xname,SHORTNAME=xshortname
getdump,y,yv,NAME=yname,SHORTNAME=yshortname

IF N_ELEMENTS(xv) EQ 0 THEN RETURN
IF N_ELEMENTS(yv) EQ 0 THEN RETURN

IF N_ELEMENTS(logx) EQ 0 THEN logx=0
IF N_ELEMENTS(logy) EQ 0 THEN logy=0

IF N_ELEMENTS(shortname) EQ 0 THEN shortname=0
IF shortname THEN BEGIN
    xname=xshortname
    yname=yshortname
ENDIF
IF logx THEN xname='log(!i !n'+xname+'!i !n)'
IF logy THEN yname='log(!i !n'+yname+'!i !n)'

IF N_ELEMENTS(xtitle) EQ 0 THEN xtitle=xname
IF N_ELEMENTS(ytitle) EQ 0 THEN ytitle=yname
IF N_ELEMENTS(title) EQ 0 THEN title=' '
IF N_ELEMENTS(overplot) EQ 0 THEN overplot=0
IF N_ELEMENTS(color) EQ 0 THEN color=0
IF N_ELEMENTS(line) EQ 0 THEN line=0
IF N_ELEMENTS(psym) EQ 0 THEN psym=0
IF N_ELEMENTS(xlog) EQ 0 THEN xlog=0
IF N_ELEMENTS(ylog) EQ 0 THEN ylog=0
IF N_ELEMENTS(xmargin) EQ 0 THEN xmargin=!X.MARGIN
IF N_ELEMENTS(ymargin) EQ 0 THEN ymargin=!Y.MARGIN
IF N_ELEMENTS(xrange) EQ 0 THEN BEGIN 
    xrange=[0,0]
ENDIF ELSE BEGIN
    IF N_ELEMENTS(xstyle) EQ 0 THEN xstyle=1
ENDELSE
IF N_ELEMENTS(yrange) EQ 0 THEN BEGIN 
    yrange=[0,0]
ENDIF ELSE BEGIN
    IF N_ELEMENTS(ystyle) EQ 0 THEN ystyle=1
ENDELSE
IF N_ELEMENTS(xstyle) EQ 0 THEN xstyle=0
IF N_ELEMENTS(ystyle) EQ 0 THEN ystyle=0
IF N_ELEMENTS(xmult) EQ 0 THEN xmult=1
IF N_ELEMENTS(ymult) EQ 0 THEN ymult=1
IF N_ELEMENTS(thick) EQ 0 THEN thick=!P.THICK
IF N_ELEMENTS(ymax_value) EQ 0 THEN ymax_value=1.D199
IF N_ELEMENTS(xcharsize) EQ 0 THEN xcharsize=0
IF N_ELEMENTS(ycharsize) EQ 0 THEN ycharsize=0

valid=WHERE(yv LT ymax_value)
if valid(0) EQ -1 THEN BEGIN
    PRINT,' [PLOTDUMP] NO VALID DATA POINTS'
    RETURN
ENDIF
xv=xv(valid)
yv=yv(valid)

xv=xv*xmult
yv=yv*ymult

IF logx THEN xv=ALOG10(xv)
IF logy THEN yv=ALOG10(yv)

IF not overplot THEN BEGIN
    PLOT,xv,yv,XTITLE=xtitle,ytitle=ytitle,TITLE=title,XRANGE=xrange,YRANGE=yrange,XLOG=xlog,YLOG=ylog,XSTYLE=xstyle,YSTYLE=ystyle,/NODATA,XMARGIN=xmargin,YMARGIN=ymargin,XCHARSIZE=xcharsize,YCHARSIZE=ycharsize
ENDIF
OPLOT,xv,yv,COLOR=color,LINE=line,PSYM=psym,THICK=thick,NOCLIP=0

END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

FUNCTION getionlist, EXTENDED=extended

IF N_ELEMENTS(extended) EQ 0 THEN extended=0

IF extended EQ 1 THEN BEGIN
    x=['nt1','h1','pn1','he3','he4','c12','n14','o16','ne20','mg24', $  
       'si28','s32','ar36','ca40','ti44','cr48','fe52','fe54','ni56','fe56', $ 
       "'fe'", 'ye','yq','eb0','yf']
ENDIF ELSE BEGIN
    x=['nt1','h1','pn1','he3','he4','c12','n14','o16','ne20','mg24', $  
       'si28','s32','ar36','ca40','ti44','cr48','fe52','fe54','ni56','fe56', $ 
       "'fe'"]
ENDELSE    

RETURN,x
END


;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

PRO printdump,x

getdump,x,v,NAME=name,SHORTNAME=shortname

PRINT,shortname,': '
PRINT,v
PRINT,' (',name,')'

END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

; helper function

FUNCTION CenterDumpVariable,x

@compile_opt

COMMON kepcenter, centerdump,centerjm

IF centerdump EQ 1 THEN BEGIN
    y=0.5D0*(x[0:centerjm-1]+x[1:centerjm])
ENDIF ELSE IF centerdump EQ -1 THEN BEGIN
    y=x[1:centerjm]
ENDIF ELSE IF centerdump EQ -2 THEN BEGIN
    y=x[0:centerjm]
ENDIF ELSE  BEGIN
    y=x[0:centerjm-1]
ENDELSE

RETURN,y
END

;.......................................................................

PRO cmpdumpp,d1,d2

COMMON kepdata, $
   jm,head,pdum,npdum,qdum,nqdum,ym,rn,rd,un,xln, $
   qln,qld,difi,netnum,xm,dn,tn,td,en,pn,zn,etan,sn,snn,abar, $
   zbar,xkn,xnei,stot,angj,angdg,angd1,angd2,angd3,angd4,angd5, $
   dsold,tsold,ppn,netnumb,zlimnuc,timen,dtimen,dnold,tnold,ymb, $
   sburn,etab,pbuf,ppnb,ions,ionsb,wind,windb,aion,aionb,iconv, $
   numi,ionn,zion,numib,ionnb,zionb,$
   nbmax,nabmax,nzbmax,nibmax,burnamax,burnmmax,ibcmax, $
   bfvisc,bfdiff,bfbr,bfbt, $
   bfviscef,bfdiffef,angdgeff,difieff, $
   zm_grid,pist,npist,snw,snwcrsi,snwcrsd,$
   xmburn,fc12mult,snadv

loaddump,d1
p1=pdum
np1=npdum
loaddump,d2
p2=pdum
np2=npdum

n1=N_ELEMENTS(p1)
n2=N_ELEMENTS(p2)

IF n1 NE n1 THEN BEGIN 
   PRINT,' [CMPDUMPP] number of parameters differ:',n1,n2
ENDIF
n=MIN(n1,n1)

x=WHERE((p1[0:n-1] NE p2[0:n-1]) AND (np1[0:n-1] NE np2[0:n-1]))

IF x[0] EQ -1 THEN BEGIN
   PRINT,' [CMPDUMPP] Parameters are EQUAL'
ENDIF ELSE BEGIN
   FOR i=0,N_ELEMENTS(x)-1 DO BEGIN
      PRINT,' [CMPDUMPP] '+STRING(x[i])+': '+string(p1[x[i]])+STRING(p2[x[i]])+STRING(np1[x[i]])+STRING(np2[x[i]])      
   ENDFOR
ENDELSE

END

;.......................................................................

PRO getdump,x_in,retval,NAME=name,SHORTNAME=shortname,CENTER=center, $
            MULT=mult,ABUNDANCE=abundance,SILENT=silent,ERROR=error

COMMON kepdata, $
   jm,head,pdum,npdum,qdum,nqdum,ym,rn,rd,un,xln, $
   qln,qld,difi,netnum,xm,dn,tn,td,en,pn,zn,etan,sn,snn,abar, $
   zbar,xkn,xnei,stot,angj,angdg,angd1,angd2,angd3,angd4,angd5, $
   dsold,tsold,ppn,netnumb,zlimnuc,timen,dtimen,dnold,tnold,ymb, $
   sburn,etab,pbuf,ppnb,ions,ionsb,wind,windb,aion,aionb,iconv, $
   numi,ionn,zion,numib,ionnb,zionb,$
   nbmax,nabmax,nzbmax,nibmax,burnamax,burnmmax,ibcmax, $
   bfvisc,bfdiff,bfbr,bfbt, $
   bfviscef,bfdiffef,angdgeff,difieff, $
   zm_grid,pist,npist,snw,snwcrsi,snwcrsd,$
   xmburn,fc12mult,snadv

COMMON kepcalc, zm,angi,angw,ange,angwk,angek,angwwk,angeek
COMMON kepcenter, centerdump,centerjm

@physconst
@strings

x=STRTRIM(x_in,2)

IF N_ELEMENTS(mult) EQ 0 THEN mult=1
IF N_ELEMENTS(abundance) EQ 0 THEN abundance=0
IF N_ELEMENTS(silent) EQ 0 THEN silent=0

IF N_ELEMENTS(center) EQ 0 THEN center=1
centerdump=center
centerjm=jm

error=0

IF N_ELEMENTS(x) NE 1 THEN BEGIN
    PRINT,' [GETDUMP] Name of data has to be specified and must not be an array.'
    RETURN
ENDIF

sizev=SIZE(x)
IF sizev(1) NE 7 THEN BEGIN
    print,' [GETDUMP] Data request has to be of type string.'
    RETURN
ENDIF

name='not found'
y=STRLOWCASE(x)

IF STRMID(y,0,2) EQ 'p ' THEN BEGIN
    p=LONG(STRMID(y,1,STRLEN(y)-1))
    v=pdum(p)
    name='changeable parameter (real*8)'
    shortname='p '+STRING(p)
ENDIF 

IF STRMID(y,0,3) EQ 'np ' THEN BEGIN
    p=LONG(STRMID(y,2,STRLEN(y)-2))
    v=npdum(p)
    name='changeable parameter (int*4)'
    shortname='p '+STRING(p)
ENDIF 

IF STRMID(y,0,2) EQ 'q ' THEN BEGIN
    q=LONG(STRMID(y,1,STRLEN(y)-1))
    v=qdum(q)
    name='edit parameter (real*8)'
    shortname='q '+STRING(q)
ENDIF 

IF STRMID(y,0,3) EQ 'nq ' THEN BEGIN
    q=LONG(STRMID(y,2,STRLEN(y)-2))
    v=nqdum(q)
    name='edit parameter (int*4)'
    shortname='q '+STRING(q)
ENDIF 

IF name EQ 'not found' THEN BEGIN
; array for zonal values start at 0
CASE y OF
    'jm' : BEGIN v=jm & name='number of grid points' & shortname='jm' & END
    'xm': BEGIN v=xm(1:jm) & name='mass of shell / g' & shortname='!4d!3m / g' & END
    'xm_sun': BEGIN v=xm(1:jm)/XMSUN & name='mass of shell / solar masses' & shortname='!4d!3m / '+str_msun & END
    'rn': BEGIN v=CenterDumpVariable(rn) & name='radius / cm' & shortname='r / cm' & END
    'rn_sun': BEGIN v=CenterDumpVariable(rn)/RSUN & name='radius / solar radii' & shortname='r / '+str_rsun & END
    'un': BEGIN v=CenterDumpVariable(un) & name='velocity / cm s!e-1!n' & shortname='u / cm s!e-1!n' & END
    'dn': BEGIN v=dn(1:jm) & name='density / g cm!e3!n' & shortname='!4q!3 / g cm!e-3!n' & END
    'tn': BEGIN v=tn(1:jm) & name='temperature / Kelvin' & shortname='T / K' & END
    'en': BEGIN v=en(1:jm) & name='specific energy / erg g!e-1!n' & shortname='e / erg g!e-1!n' & END
    'pn': BEGIN v=pn(1:jm) & name='pressure  / erg g!e-1!n' & shortname='P / erg g!e-1!n' & END
    'sn': BEGIN v=sn(1:jm) & name='nuclear energy generation rate / erg g!e-1! s!e-1!n' & shortname='epsilon / erg g!e-1!n s!e-1!n' & END
    'snn': BEGIN v=snn(1:jm) & name='net nuclear energy generation rate / erg g!e-1!n s!e-1!n' & shortname='epsilon_n / erg g!e-1!n s!e-1!n' & END
    'snw': BEGIN v=snw(1:jm) & name='WIMP energy deposition rate / erg g!e-1!n s!e-1!n' & shortname='epsilon_w / erg g!e-1!n s!e-1!n' & END
    'snwcrsi': BEGIN v=snwcrsi(1:jm) & name='WIMP spin-independent capture rate / erg g!e-1!n s!e-1!n' & shortname='CR_SI / erg g!e-1!n s!e-1!n' & END
    'snwcrsd': BEGIN v=snwcrsd(1:jm) & name='WIMP spin-dependent capture rate / erg g!e-1!n s!e-1!n' & shortname='CR_SD / erg g!e-1!n s!e-1!n' & END
    'abar': BEGIN v=abar(1:jm) & name='mean moelcular weight / g mol!e-1!n' & shortname='abar / g mol!e-1!n' & END
    'zbar': BEGIN v=zbar(1:jm) & name='mean atomic charge' & shortname='zbar / g mol!e-1!n' & END
    'xkn': BEGIN v=xkn(1:jm) & name='opacity  / cm!e2!n g!e-1!n ' & shortname='eta / cm!e2!n g!e-1!n' & END
    'stot': BEGIN v=stot(1:jm) & name='entropy per barion / k!iB!n ' & shortname='s / k!iB!n barion!e-1!n' & END
    'etan': BEGIN v=etan(1:jm) & name='electron degenracy parameter' & shortname='!4e!3' & END
    'xln': BEGIN v=CenterDumpVariable(xln) & name='luminosity / erg s!e-1!n' & shortname='L / erg s!e-1!n'+str_lsun & END
    'xln_sun': BEGIN v=CenterDumpVariable(xln)/XLSUN & name='luminosity / solar luminosities' & shortname='L / '+str_lsun & END
    'y': BEGIN v=CenterDumpVariable(ym/(4*!DPI*rn^2)) & name='column depth / g/cm!a-2!n' & shortname='y / g cm!a-2!n' & END
    'ym': BEGIN v=CenterDumpVariable(ym) & name='exterior mass coordinate / g' & shortname='m!i-!n / g' & END
    'ym_sun': BEGIN v=CenterDumpVariable(ym)/XMSUN & name='exterior mass coordinate / solar masses' & shortname='m!i-!n / '+str_msun & END
    'zm': BEGIN v=CenterDumpVariable(zm) & name='interior mass coordinate / g' & shortname='m / g' & END
    'zm_sun': BEGIN v=CenterDumpVariable(zm)/XMSUN & name='interior mass coordinate / solar masses' & shortname='m / '+str_msun & END
    'zm_grid': BEGIN v=CenterDumpVariable(zm_grid) & name='grid mass coordinate / g' & shortname='m / '+str_msun & END

    'rn3dn': BEGIN v=CenterDumpVariable(rn)^3*dn(1:jm)/XMSUN & name='density * radius cubed / solar masses' & shortname=str_rho+' r!e3!n / '+str_msun & END

    'angj': BEGIN v=angj(1:jm) & name='specific angular momentum / cm!a2!n s!a-1!n' & shortname='j / cm!a2!n s!a-1!n' & END
    'angw': BEGIN v=angw(1:jm) & name='angular velocity / rad s!a-1!n' & shortname='!4x!3 / rad s!a-1!n' & END
    'ange': BEGIN v=ange(1:jm) & name='specific rotational energy / erg g!e-1!n' & shortname='e!iROT!n / erg g!e-1!n' & END
    'angi': BEGIN v=angi(1:jm) & name='momentum of inertia / g cm!e2!n' & shortname='i / cm!e2!n' & END
    'angi50': BEGIN v=angi(1:jm)*1.D-50 & name='momentum of inertia / 10!e50!n cm!e2!n' & shortname='i / 10!e50!n g cm!e2!n' & END

    'angwk': BEGIN v=angwk(1:jm) & name='keplerian angular velocity / s!e-1!n' & shortname='!4x!3!ik!n / s!e-1!n' & END
    'angwwk': BEGIN v=angwwk(1:jm) & name='angular velocity / keplerian angular velocity' & shortname='!4x!3 / !4x!3!ik!n' & END
    'angek': BEGIN v=angek(1:jm) & name='keplerian rotational energy / erg g!e-1!n' & shortname='e!iKEP!n / erg g!e-1!n' & END
    'angeek': BEGIN v=angeek(1:jm) & name='rotational energy / keplerian rotational energy' & shortname='e / e!iKEP!n' & END

    'xmlost': BEGIN v=qdum[88] & name='mass lost in wind / g' & shortname='xmlost (q 88)' & END
    'wind': BEGIN v=wind & name='isotope moles in wind' & shortname='wind moles' & END
    'xwind': BEGIN v=wind*aion & name='isotope mass in wind' & shortname='wind mass' & END
    'windb': BEGIN v=windb & name='BURN isotope moles in wind' & shortname='BURN wind moles' & END
    'xwindb': BEGIN v=windb*aionb & name='BURN isotopes mass in wind' & shortname='BURN wind mass' & END

    'ions': BEGIN v=STRTRIM(ions,2) & name='ion names' & shortname='ions' & END
    'ionsb': BEGIN v=STRTRIM(ionsb,2) & name='burn ion names' & shortname='ionsb' & END
    'idxb': BEGIN v=ionidx(aionb,zionb) & name='burn ion index' & shortname='idxb' & END

    'aion': BEGIN v=aion & name='ion atomic mass' & shortname='aion' & END
    'aionb': BEGIN v=aionb & name='burn ion atomic mass' & shortname='aionb' & END

    'zion': BEGIN v=zion & name='ion charge number' & shortname='zion' & END
    'zionb': BEGIN v=zionb & name='burn ion charge number' & shortname='zionb' & END

    'netnum': BEGIN v=netnum(1:jm) & name='APPROX network number' & shortname='netnum' & END
    'netnumb': BEGIN v=netnum(1:jm) & name='BURN network number' & shortname='netnumb' & END

    'etab': BEGIN 
        nisob=numib(0)
        neut=ppnb(0:nisob-1,1:jm)##(aionb(0:nisob-1)-zionb(0:nisob-1))
        prot=ppnb(0:nisob-1,1:jm)##zionb(0:nisob-1)
        v=neut-prot/(neut+prot)
        name='BURN neutron excess'
        shortname='etab'        
    END
    'xmburn': BEGIN v=xmburn[*] & name='flame burn data' & shortname='xmburn' & END
    'fc12mult': BEGIN v=fc12mult[1:jm] & name='zonal flame C12 multiplier' & shortname='fC12mult' & END
    'pistt' : BEGIN v=pist[*,0] & name='piston time / seconds' & shortname='t_pist / s' & END
    'pistr' : BEGIN v=pist[*,1] & name='piston radius / cm' & shortname='r_pist / cm' & END

    'nbmax'   : BEGIN v=nbmax    & name='nbmax   ' & shortname='nbmax   ' & END
    'nabmax'  : BEGIN v=nabmax   & name='nabmax  ' & shortname='nabmax  ' & END
    'nzbmax'  : BEGIN v=nzbmax   & name='nzbmax  ' & shortname='nzbmax  ' & END
    'nibmax'  : BEGIN v=nibmax   & name='nibmax  ' & shortname='nibmax  ' & END
    'burnamax': BEGIN v=burnamax & name='burnamax' & shortname='burnamax' & END
    'burnmmax': BEGIN v=burnmmax & name='burnmmax' & shortname='burnmmax' & END
    'ibcmax'  : BEGIN v=ibcmax   & name='ibcmax  ' & shortname='ibcmax  ' & END
        
    'iconv': BEGIN v=iconv(1:jm) 
                   name='convective sentinal'
                   shortname='iconv'
             END
               
    'kconv': BEGIN v=REPLICATE(0,jm)
                FOR i=1,jm DO BEGIN
                    i1=i-1
                    IF iconv(i) EQ 'conv    ' THEN v(i1)=1
                    IF iconv(i) EQ 'osht    ' THEN v(i1)=2
                    IF iconv(i) EQ 'semi    ' THEN v(i1)=3
                    IF iconv(i) EQ 'thal    ' THEN v(i1)=4
                    IF iconv(i) EQ 'neut    ' THEN v(i1)=5
                ENDFOR
                name='numeric convective status'
                shortname='kconv'
            END
               
    'xconv': BEGIN v=REPLICATE(0.0D0,jm)
                FOR i=1,jm DO BEGIN
                    i1=i-1
                    IF iconv(i) EQ 'conv    ' THEN v(i1)=1.0D0
                    IF iconv(i) EQ 'osht    ' THEN v(i1)=0.9D0
                    IF iconv(i) EQ 'semi    ' THEN v(i1)=0.5D0
                    IF iconv(i) EQ 'thal    ' THEN v(i1)=0.2D0
                    IF iconv(i) EQ 'neut    ' THEN v(i1)=0.1D0
                ENDFOR
                name='convective status'
                shortname='xconv'
            END
               
    'conv': BEGIN v=REPLICATE('radiative',jm)  ; initialize for debug
                FOR i=1,jm DO BEGIN
                    i1=i-1
                    IF iconv(i) EQ 'conv    ' THEN v(i1)='convective'
                    IF iconv(i) EQ 'osht    ' THEN v(i1)='overshooting'
                    IF iconv(i) EQ 'semi    ' THEN v(i1)='semiconvective'
                    IF iconv(i) EQ 'thal    ' THEN v(i1)='thermohaline'
                    IF iconv(i) EQ 'neut    ' THEN v(i1)='neutral'
                ENDFOR
                name='convective status'
                shortname='xconv'
            END
               
    't/w': BEGIN 
                xrot=DBLARR(jm+1)
                xpot=DBLARR(jm+1)
                xrot(0)=0
                xpot(0)=0
                FOR i=1,jm DO BEGIN
                    xrot(i)=xrot(i-1)+ange(i)*xm(i)
                    xpot(i)=xpot(i-1)+2.0D0*angek(i)*xm(i)
                ENDFOR
                v=xrot(1:jm)/xpot(1:jm)
                v(0:5)=v(6)
                name='integrated rotational energy / potential energy' 
                shortname='T / W'
            END
    't/w_ext': BEGIN 
                xrot=DBLARR(jm+1)
                xpot=DBLARR(jm+1)
                xrot(jm)=0
                xpot(jm)=0
                FOR i=jm,1,-1 DO BEGIN
                    xrot(i-1)=xrot(i)+ange(i)*xm(i)
                    xpot(i-1)=xpot(i)+2.0D0*angek(i)*xm(i)
                ENDFOR
                v=xrot(0:jm-1)/xpot(0:jm-1)
                v(0:5)=v(6)
                name='external integrated rotational energy / external potential energy' 
                shortname='(T / W)'+str_ind+'ext!n'
            END
    'j/m^(2/3)': BEGIN
                v=DBLARR(jm+1,/NOZERO)
                x23=(2.D0/3.D0)
                v=angw*rn^2*x23/zm^x23
                v(0)=v(1)
                v=CenterDumpVariable(v)
                name='(j / cm!e2!n/s) / ( (m / g)!a(2/3)!n )' 
                shortname='j / m!e(2/3)!n (cgs units)'
             END
    'j/m^(5/3)': BEGIN
                v=DBLARR(jm+1,/NOZERO) 
                v(0)=0 
                FOR i=1,jm DO BEGIN
                    v(i)=v(i-1)+angj(i)*xm(i)
                ENDFOR
                v=v/zm^(5.D0/3.D0)
                v(0)=v(1)
                v=CenterDumpVariable(v)
                name='(J / erg s) / ( (m / g)!a(5/3)!n )' 
                shortname='J / m!e(5/3)!n (cgs units)'
             END

    'angjeq': BEGIN
                v=angj(1:jm)*1.5D0 
                name='specific equatorial angular momentum / cm!a2!n s!a-1!n' 
                shortname='j!ieq!n / cm!a2!n s!a-1!n'
             END
    'angjt': BEGIN
                v=DBLARR(jm,/NOZERO) 
                v(0)=0.5*angj(1)*xm(1) 
                FOR i=1,jm-1 DO BEGIN
                    v(i)=v(i-1)+0.5*(angj(i-1)*xm(i-1)+angj(i)*xm(i))
                ENDFOR
                v=v*1.D-50
                name='total angular momentum / 10!e50!n erg s' 
                shortname='J!i50!n / erg s'
             END
    'angja': BEGIN
                v=DBLARR(jm,/NOZERO) 
                m=DBLARR(jm,/NOZERO) 
                v(0)=0.5*angj(1)*xm(1) 
                m(0)=0.5*xm(1)+pdum[61]
                FOR i=1,jm-1 DO BEGIN
                    v(i)=v(i-1)+0.5*(angj(i-1)*xm(i-1)+angj(i)*xm(i))
                    m(i)=m(i-1)+0.5*(xm(i-1)+xm(i))
                ENDFOR
                v=v/m
                name='average specific angular momentum / erg s g!e-1!n' 
                shortname='j!iav!n / erg s g!e-1!n' 
             END    
    'angjam': BEGIN
                v=DBLARR(jm,/NOZERO) 
                m=DBLARR(jm,/NOZERO) 
                v(0)=0.5*angj(1)*xm(1) 
                m(0)=0.5*xm(1)                 
                FOR i=1,jm-1 DO BEGIN
                    v(i)=v(i-1)+0.5*(angj(i-1)*xm(i-1)+angj(i)*xm(i))
                    m(i)=m(i-1)+0.5*(xm(i-1)+xm(i))
                ENDFOR
                v=v/m^2
                name='average specific angular momentum per mass / erg s g!e-2!n' 
                shortname='j!iav!n/m / erg s g!e-2!n'
             END
    
    'angjm': BEGIN
                m=DBLARR(jm,/NOZERO) 
                m(0)=0.5*xm(1)+pdum[61]
                FOR i=1,jm-1 DO BEGIN
                    m(i)=m(i-1)+0.5*(xm(i-1)+xm(i))
                ENDFOR
                v=angj(1:jm)/m
                name='specific angular momentum per mass / erg s g!e-2!n' 
                shortname='j/m / erg s g!e-2!n'
             END
    
    'anglst': BEGIN
                 a=DBLARR(jm,/NOZERO) 
                 m=DBLARR(jm,/NOZERO) 
                 a(0)=0.5*angj(1)*xm(1) 
                 m(0)=0.5*xm(1)+pdum[61]
                 FOR i=1,jm-1 DO BEGIN
                     a(i)=a(i-1)+0.5*(angj(i-1)*xm(i-1)+angj(i)*xm(i))
                     m(i)=m(i-1)+0.5*(xm(i-1)+xm(i))
                 ENDFOR
                 a=a/m*CLIGHT/GRAV
                 eps=1.D-7
                 x=WHERE(a GE (1.D0-eps)*m)
                 if x(0) EQ -1 then x=0
                 a(x)=m(x)*(1.D0-eps)
                 x13=1.0D0/3.0D0
                 Z1=1+(1-a^2/M^2)^x13*((1+a/M)^x13+(1-a/M)^x13)
                 Z2=sqrt(3*a^2/M^2+Z1^2)
                 r=M*(3+Z2-sqrt((3-Z1)*(3+Z1+2*Z2)))
                 L=sqrt(M*r)*(r^2 - 2*a*sqrt(M*r)+a^2)/(r*sqrt(r^2-3*M*r+2*a*sqrt(M*r)))
                 v=L*GRAV/clight
                 v(x)=SQRT(4./3.)*zm(x)*GRAV/CLIGHT                 
                 nx=N_ELEMENTS(x)
                 IF nx GE 2 THEN BEGIN
                     IF x(0) EQ 0 AND x(1) EQ 1 THEN v(0)=-1
                     IF x(nx-1) EQ jm-1 AND x(nx-2) EQ jm-2 THEN v(jm-1)=-1
                     FOR i=1,nx-2 DO BEGIN
                         IF (x(i-1)+1 EQ x(i+1)-1) THEN v(x(i))=-1
                     ENDFOR
                 ENDIF
                 name='j(J_below) of last stable orbit / erg s g!e-1!n' 
                 shortname='j!ilst!n(J) / erg s g!e-1!n' 
              END
    'angabh': BEGIN
                 a=DBLARR(jm,/NOZERO) 
                 m=DBLARR(jm,/NOZERO) 
                 a(0)=0.5*angj(1)*xm(1) 
                 m(0)=0.5*xm(1)+pdum[61]
                 FOR i=1,jm-1 DO BEGIN
                     a(i)=a(i-1)+0.5*(angj(i-1)*xm(i-1)+angj(i)*xm(i))
                     m(i)=m(i-1)+0.5*(xm(i-1)+xm(i))
                 ENDFOR
                 a=a/m*CLIGHT/GRAV
                 v=a
                 name='black hole spin parameter' 
                 shortname='a' 
              END
    'anglsts': BEGIN
                 v=SQRT(12.D0)*zm*GRAV/CLIGHT
                 v=CenterDumpVariable(v)
                 name='j of last stable orbit of Schwarzschild BH / cm!e2!n/s' 
                 shortname='j!ilst,S!n / cm!e2!n/s' 
              END
    'anglstk': BEGIN
                 v=SQRT(4.D0/3.D0)*zm*GRAV/CLIGHT
                 v=CenterDumpVariable(v)
                 name='j of last stable orbit of Kerr BH / cm!e2!n/s' 
                 shortname='j!ilst,S!n / cm!e2!n/s' 
              END 
    'uesc': BEGIN
              m=pdum[61]
              v=DBLARR(jm+1)
              v[0]=SQRT(2.D0*GRAV*m/rn[0])
              FOR i=1,jm DO BEGIN
                 m=m+xm[i-1]
                 v[i]=SQRT(2.D0*GRAV*m/rn[i])
              ENDFOR   
              name='local escape velocity / cm/s'
              shortname='u!iesc!n / cm/s' 
              v=CenterDumpVariable(v)
            END 

    'difi': BEGIN v=CenterDumpVariable(difi) & name='(semi)convective diffusion coefficient / cm!e2!n s!e-1!n' & shortname='D!iCONV!n / cm!e2!n s!e-1!n' & END
    'angdg': BEGIN v=CenterDumpVariable(angdg) & name='rotational diffusion coefficient / cm!e2!n s!e-1!n' & shortname='D!iROT!n / cm!e2!n s!e-1!n' & END
    'angd1': BEGIN v=CenterDumpVariable(angd1) & name='dynamical shear instabillity / cm!e2!n s!e-1!n' & shortname='D!iDS!n / cm!e2!n s!e-1!n' & END
    'angd2': BEGIN v=CenterDumpVariable(angd2) & name='Solberg-Hoiland instabillity / cm!e2!n s!e-1!n' & shortname='D!iSH!n / cm!e2!n s!e-1!n' & END
    'angd3': BEGIN v=CenterDumpVariable(angd3) & name='secular shear instabillity / cm!e2!n s!e-1!n' & shortname='D!iSS!n / cm!e2!n s!e-1!n' & END
    'angd4': BEGIN v=CenterDumpVariable(angd4) & name='Eddington-Sweet circulation / cm!e2!n s!e-1!n' & shortname='D!iES!n / cm!e2!n s!e-1!n' & END
    'angd5': BEGIN v=CenterDumpVariable(angd5) & name='GSF instabillity / cm!e2!n s!e-1!n' & shortname='D!iGSF!n / cm!e2!n s!e-1!n' & END

    'bfdiff': BEGIN v=CenterDumpVariable(bfdiff) & name='magnetic induced diffusion / cm!e2!n s!e-1!n' & shortname='D!iGSF!n / cm!e2!n s!e-1!n' & END
    'bfvisc': BEGIN v=CenterDumpVariable(bfvisc) & name='magnetic induced viscosity / cm!e2!n s!e-1!n' & shortname='D!iGSF!n / cm!e2!n s!e-1!n' & END

    'bfbr': BEGIN v=CenterDumpVariable(bfbr) & name='radial magnetic field / Gauss' & shortname='B!ir!n / G' & END
    'bfbt': BEGIN v=CenterDumpVariable(bfbt) & name='torodial magnetic field / Gauss' & shortname='B!i!4f!3!n / G' & END

    'difi_m': BEGIN v=difi*(4.D0*!DPi*rn^2*dn)^2*SEC/XMSUN^2   & name='(semi)convective diffusion coefficient / M_sun!e2!n yr!e-1!n' & shortname='D!iCONV!n / M_sun!e2!n yr!e-1!n' & END
    'angdg_m': BEGIN v=angdg*(4.D0*!DPi*rn^2*dn)^2*SEC/XMSUN^2 & name='rotational diffusion coefficient / M_sun!e2!n yr!e-1!n' & shortname='D!iROT!n / M_sun!e2!n yr!e-1!n' & END
    'angd1_m': BEGIN v=angd1*(4.D0*!DPi*rn^2*dn)^2*SEC/XMSUN^2 & name='dynamical shear instabillity / M_sun!e2!n yr!e-1!n' & shortname='D!iDS!n / M_sun!e2!n yr!e-1!n' & END
    'angd2_m': BEGIN v=angd2*(4.D0*!DPi*rn^2*dn)^2*SEC/XMSUN^2 & name='Solberg-Hoiland instabillity / M_sun!e2!n yr!e-1!n' & shortname='D!iSH!n / M_sun!e2!n yr!e-1!n' & END
    'angd3_m': BEGIN v=angd3*(4.D0*!DPi*rn^2*dn)^2*SEC/XMSUN^2 & name='secular shear instabillity / M_sun!e2!n yr!e-1!n' & shortname='D!iSS!n / M_sun!e2!n yr!e-1!n' & END
    'angd4_m': BEGIN v=angd4*(4.D0*!DPi*rn^2*dn)^2*SEC/XMSUN^2 & name='Eddington-Sweet circulation / M_sun!e2!n yr!e-1!n' & shortname='D!iES!n / M_sun!e2!n yr!e-1!n' & END
    'angd5_m': BEGIN v=angd5*(4.D0*!DPi*rn^2*dn)^2*SEC/XMSUN^2 & name='GSF instabillity / M_sun!e2!n yr!e-1!n'           & shortname='D!iGSF!n / M_sun!e2!n yr!e-1!n' & END

    'tkh': BEGIN
                v=CenterDumpVariable(GRAV*zm^2/(rn*xln))/SEC
                name='Kelvin-Helmholtz time-scale / yr' 
                shortname='t!iKH!n / yr'
             END
    'tkh*': BEGIN
                v=CenterDumpVariable(xln)
                v=v-zm(1:jm)*(sn(1:jm)-snn(1:jm))
                v=CenterDumpVariable(GRAV*zm^2/rn)/(v*SEC)                
                name='modified Kelvin-Helmholtz time-scale / yr' 
                shortname='t!iKH!n / yr'
             END
    'tes': BEGIN
                v=CenterDumpVariable(GRAV^2*zm^3/(rn^4*xln))
                v=v/angw(1:jm)^2/SEC
                name='Eddington-Sweet time-scale / yr' 
                shortname='t!iES!n / yr'
             END
    'tes*': BEGIN
                v=CenterDumpVariable(xln)
                v=v-zm(1:jm)*(sn(1:jm)-snn(1:jm))
                v=CenterDumpVariable(GRAV^2*zm^3/(rn^4))/(v*SEC)
                v=v/angw(1:jm)^2
                name='modified Eddington-Sweet time-scale / yr' 
                shortname='t!iES!n / yr'
             END

    'time': BEGIN
                v=pdum[2]+pdum[315]
                name='total time / s' 
                shortname='time / s'
             END

;     *   'ionnt1',    'ionh1',    'ionpn1',   'ionhe3',   'ionhe4', 
;     2   'ionc12',    'ionn14',   'iono16',   'ionne20',  'ionmg24',  
;     *   'ionsi28',   'ions32',   'ionar36',  'ionca40',  'ionti44', 
;     3   'ioncr48',   'ionfe52',  'ionfe54',  'ionni56',  'ionfe56', 
;     *   'ion''fe''', 'ionye',    'ionyq',    'ioneb0',   'ionyf' /  
; array for abundance start at 1
;    'ionnt1'  : BEGIN v=ppn(0,1:jm) & name='neuton mass fraction' & shortname='!e1!nn' & END
;    'ionh1'   : BEGIN v=ppn(1,1:jm) & name='hydrogen mass fraction' & shortname='!e1!nH' & END
;    'ionpn1'  : BEGIN v=ppn(2,1:jm) & name='proton mass fraction' & shortname='!e1!np' & END
;    'ionhe3'  : BEGIN v=ppn(3,1:jm)*3 & name='helium 3 mass fraction' & shortname='!e4!nHe' & END
;    'ionhe4'  : BEGIN v=ppn(4,1:jm)*4 & name='helium 4 mass fraction' & shortname='!e4!nHe' & END
;    'ionc12'  : BEGIN v=ppn(5,1:jm)*12 & name='carbon mass fraction' & shortname='!e12!nC' & END
;    'ionn14'  : BEGIN v=ppn(6,1:jm)*14 & name='nitrogen mass fraction' & shortname='!e14!nN' & END
;    'iono16'  : BEGIN v=ppn(7,1:jm)*16 & name='oxygen mass fraction' & shortname='!e16!nO' & END
;    'ionne20' : BEGIN v=ppn(8,1:jm)*20 & name='neon mass fraction' & shortname='!e20!nNe' & END
;    'ionmg24' : BEGIN v=ppn(9,1:jm)*24 & name='magnesium mass fraction' & shortname='!e24!nMg' & END
;    'ionsi28' : BEGIN v=ppn(10,1:jm)*28 & name='silicium mass fraction' & shortname='!e28!nSi' & END
;    'ions32'  : BEGIN v=ppn(11,1:jm)*32 & name='sulfur mass fraction' & shortname='!e32!nS' & END
;    'ionar36' : BEGIN v=ppn(12,1:jm)*36 & name='argon mass fraction' & shortname='!e36!nAr' & END
;    'ionca40' : BEGIN v=ppn(13,1:jm)*40 & name='calcium mass fraction' & shortname='!e40!nCa' & END
;    'ionti44' : BEGIN v=ppn(14,1:jm)*44 & name='titanium mass fraction' & shortname='!e44!nTi' & END
;    'ioncr48' : BEGIN v=ppn(15,1:jm)*48 & name='cromium mass fraction' & shortname='!e48!nCr' & END
;    'ionfe52' : BEGIN v=ppn(16,1:jm)*52 & name='iron 52 mass fraction' & shortname='!e52!nFe' & END
;    'ionfe54' : BEGIN v=ppn(17,1:jm)*54 & name='iron 54 mass fraction' & shortname='!e54!nFe' & END
;    'ionni56' : BEGIN v=ppn(18,1:jm)*56 & name='ni 56 mass fraction' & shortname='!e56!nNi' & END
;    'ion"fe"' : BEGIN v=1.0D0-ppn(0,1:jm)-ppn(1,1:jm)-ppn(2,1:jm)-ppn(3,1:jm)*3-ppn(4,1:jm)*4-ppn(5,1:jm)*12-ppn(6,1:jm)*14-ppn(7,1:jm)*16-ppn(8,1:jm)*20-ppn(9,1:jm)*24-ppn(10,1:jm)*28-ppn(11,1:jm)*32-ppn(12,1:jm)*36-ppn(13,1:jm)*40-ppn(14,1:jm)*44-ppn(15,1:jm)*48-ppn(16,1:jm)*52-ppn(17,1:jm)*54-ppn(18,1:jm)*56
;                      name='"iron" mass fraction' & shortname='"fe"' & END
ELSE: BEGIN
; find APPROX/QSE/NSE network "isotopes"
    IF (STRMID(y,0,3) EQ 'ion') THEN BEGIN
        imax=nqdum(14)
        netmin=MAX([1,MIN(netnum(1:jm))])
        netmax=MAX(netnum(1:jm))
        ntmp=0
        tmp=DBLARR(jm)
        FOR i=netmin,netmax DO BEGIN
            ion=STRTRIM(ions[ionn[0:imax-1,i-1]-1])
            neti=WHERE(netnum[1:jm] EQ i)
            ii=WHERE(y EQ ("ion"+ion))    
            ii=ii(0)
            IF (ii GE 0) AND (neti(0) GE 0) THEN BEGIN
                ntmp+=N_ELEMENTS(neti)
                neti=neti
                tmp[neti]=ppn[ii,neti+1]
                ionname=ion[ii]
                ionmass=aion[ionn[ii,i-1]-1]
            ENDIF
        ENDFOR        
        IF ntmp GT 0 THEN BEGIN
            v=tmp
            tmp=0
            IF ionmass EQ 0 THEN ionmass=1
            c1=STRMID(ionname,1,1)
            IF ((c1 EQ '1') OR (c1 EQ '2') OR (c1 EQ '3') OR (c1 EQ '4') OR (c1 EQ '5') OR (c1 EQ '6') OR (c1 EQ '7') OR (c1 EQ '8') OR (c1 EQ '9')) THEN BEGIN
                massstr=STRMID(ionname,1,3)
                mass=LONG(massstr)
                element=STRMID(ionname,0,1)
            ENDIF ELSE BEGIN
                c1=STRMID(ionname,2,1)
                IF ((c1 EQ '1') OR (c1 EQ '2') OR (c1 EQ '3') OR (c1 EQ '4') OR (c1 EQ '5') OR (c1 EQ '6') OR (c1 EQ '7') OR (c1 EQ '8') OR (c1 EQ '9')) THEN BEGIN
                    massstr=STRMID(ionname,2,3)
                    mass=LONG(massstr)
                    element=STRMID(ionname,0,2)
                ENDIF ELSE BEGIN
                    mass=0
                    massstr=''
                    element=ionname
                ENDELSE
            ENDELSE
            IF massstr NE '' THEN BEGIN
                IF STRLEN(element) GT 1 THEN BEGIN 
                    element=STRUPCASE(STRMID(element,0,1))+STRLOWCASE(STRMID(element,1,1))
                ENDIF ELSE BEGIN
                    element=STRUPCASE(STRMID(element,0,1))
                ENDELSE
            ENDIF
            IF ionname EQ 'nt1' THEN element='n'
            IF ionname EQ 'pn1' THEN element='p'
            IF ionname EQ "'fe'" THEN element="'Fe'"
            IF massstr NE '' THEN BEGIN
                shortname='!a'+massstr+'!n'+element
            ENDIF ELSE BEGIN
                shortname=element
            ENDELSE
            IF abundance THEN BEGIN
                name=shortname+' abundance'
            ENDIF ELSE BEGIN
                name=shortname+' mass fraction'
                v*=ionmass
            ENDELSE
        ENDIF
    ENDIF

; find BURN isotopes
    imaxb=nqdum(53)
    IF (STRMID(y,0,3) EQ 'iso') AND (imaxb GT 0) THEN BEGIN
        iso=STRTRIM(ionsb(0:imaxb-1))
        ii=WHERE(y EQ ("iso"+iso))    
        ii=ii[0]
        IF ii GE 0 THEN BEGIN
            v=REFORM(ppnb[ii,1:jm])
            iso=iso[ii]
            c1=STRMID(iso,1,1)
            IF ((c1 EQ '1') OR (c1 EQ '2') OR (c1 EQ '3') OR (c1 EQ '4') OR (c1 EQ '5') OR (c1 EQ '6') OR (c1 EQ '7') OR (c1 EQ '8') OR (c1 EQ '9')) THEN BEGIN
                massstr=STRMID(iso,1,3)
                mass=LONG(massstr)
                element=STRMID(iso,0,1)
            ENDIF ELSE BEGIN
                massstr=STRMID(iso,2,3)
                mass=LONG(massstr)
                element=STRMID(iso,0,2)
            ENDELSE
            IF STRLEN(element) GT 1 THEN BEGIN 
                element=STRUPCASE(STRMID(element,0,1))+STRLOWCASE(STRMID(element,1,1))
            ENDIF ELSE BEGIN
                element=STRUPCASE(STRMID(element,0,1))
            ENDELSE
            IF iso EQ 'nt1' THEN element='n'
            shortname='!a'+massstr+'!n'+element
            IF abundance THEN BEGIN
                name=shortname+' abundance'
            ENDIF ELSE BEGIN
                name=shortname+' mass fraction'
                v=v*mass
            ENDELSE
        ENDIF
    ENDIF

; get zone composition
    IF (STRMID(y,0,2) EQ 'xa')  OR $
       (STRMID(y,0,2) EQ 'ya') THEN BEGIN
        izone=long(STRMID(y,2,999))
        IF izone LE 0 THEN izone=jm-izone
        IF izone GT jm THEN BEGIN 
            PRINT,' [GETDUMP] WARNING: zone '+STRING(izone)+' is out of range.'
            izone=jm
        ENDIF
        v=ppn(*,izone)
        IF (STRMID(y,0,2) EQ 'xa') THEN BEGIN 
            v=v(*)*aion(*)
            name="zone "+STRING(izone,"(I4)")+" APPROX mass fractions"
        ENDIF ELSE BEGIN
            name="zone "+STRING(izone,"(I4)")+" APPROX abundance"
        ENDELSE
        shortname='zone '+STRING(izone,"(I4)")
    ENDIF
    
; get zone composition
    IF (imaxb GT 0) AND $
      (((STRMID(y,0,2) EQ 'xb') AND (y NE 'xbind')) OR $
      ((STRMID(y,0,2) EQ 'yb') AND (y NE 'ybind'))) THEN BEGIN
        izone=long(STRMID(y,2,999))
        IF izone LE 0 THEN izone=jm-izone
        IF izone GT jm THEN BEGIN 
            PRINT,' [GETDUMP] WARNING: zone '+STRING(izone)+' is out of range.'
            izone=jm
        ENDIF
        v=ppnb(*,izone)
        IF (STRMID(y,0,2) EQ 'xb') THEN BEGIN 
            v=v(*)*aionb(*)
            name="zone "+STRING(izone,"(I4)")+" BURN mass fractions"
        ENDIF ELSE BEGIN
            name="zone "+STRING(izone,"(I4)")+" BURN abundance"
        ENDELSE
        shortname='zone '+STRING(izone,"(I4)")
    ENDIF
    
END
ENDCASE
ENDIF

if N_ELEMENTS(v) EQ 0 THEN BEGIN
    v=-1
    error=1
    IF NOT silent THEN PRINT,' [GETDUMP] "',x,'" NOT FOUND!'
    RETURN
ENDIF

IF SIZE(v,/TYPE) NE 7 THEN BEGIN
    v=v*mult
ENDIF

retval=v

END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

PRO wind,B=b

@physconst

IF KEYWORD_SET(b) THEN BEGIN
    getdump,'ionsb',ions
    getdump,'windb',wind
    getdump,'nq 53',nions
    getdump,'aionb',aion
ENDIF ELSE BEGIN
    getdump,'ions',ions
    getdump,'wind',wind
    getdump,'nq 14',nions
    getdump,'aion',aion
ENDELSE

ilen=MAX(STRLEN(STRTRIM(ions)))

x=0.0D0
PRINT,'wind mass in solar masses'
FOR i=0,nions-1 DO BEGIN
    y=wind(i)*aion(i)/XMSUN
    PRINT,'Y[',STRMID(ions(i),0,ilen),']=',y
    x=x+y
ENDFOR
PRINT,'total=',x

END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

PRO yield,iso

@physconst

getdump,iso,v
IF N_ELEMENTS(v) EQ 0 THEN RETURN
getdump,'xm_sun',xm,CENTER=0

x=TOTAL(v*xm)

print,iso+':',x,' M_sun'

END


;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

PRO fecore

@physconst

getdump,'ions',ions
getdump,'nq 14',nions
getdump,'aion',aion

getdump,'zm_sun',xm,CENTER=0
n=N_ELEMENTS(xm)
mheavy=DBLARR(n)

FOR i=0,nions-1 DO BEGIN
    IF aion(i) GT 40 THEN BEGIN
        getdump,'ion'+STRTRIM(ions(i)),xi
        mheavy=mheavy+xi
    ENDIF
ENDFOR

plot,xm,mheavy

x=where(mheavy GE 0.5)
n=N_ELEMENTS(x)-1
print,n+2,":",xm(x(n)+1)/xmsun*1.9892d+33

END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

PRO isorat,xm

COMMON readdump, filename

IF N_ELEMENTS(xm) EQ 0 THEN xm=0

getdump,'zm_sun',v

n=0
FOR i=0,N_ELEMENTS(v)-1 DO BEGIN
    IF v(i) LE xm THEN n=i
ENDFOR

getdump,'isoc12',v
c12=v(n)
getdump,'isoc13',v
c13=v(n)

getdump,'ison14',v
n14=v(n)
getdump,'ison15',v
n15=v(n)

getdump,'isoo16',v
o16=v(n)
getdump,'isoo17',v
o17=v(n)
getdump,'isoo18',v
o18=v(n)

getdump,'isof19',v
f19=v(n)

getdump,'isone20',v
ne20=v(n)
getdump,'isone21',v
ne21=v(n)
getdump,'isone22',v
ne22=v(n)

getdump,'isona23',v
na23=v(n)

getdump,'isomg24',v
mg24=v(n)
getdump,'isomg25',v
mg25=v(n)
getdump,'isomg26',v
mg26=v(n)

getdump,'isoal27',v
al27=v(n)

getdump,'isosi28',v
si28=v(n)
getdump,'isosi29',v
si29=v(n)
getdump,'isosi30',v
si30=v(n)


print,'======================'

print,filename

print,'----------------------'
print,'mass fractions'
print,'----------------------'

PRINT,'c12',c12,FORMAT='(A10,E12.3)'
PRINT,'c13',c13,FORMAT='(A10,E12.3)'

PRINT,'n14',n14,FORMAT='(A10,E12.3)'
PRINT,'n15',n15,FORMAT='(A10,E12.3)'

PRINT,'o16',o16,FORMAT='(A10,E12.3)'
PRINT,'o17',o17,FORMAT='(A10,E12.3)'
PRINT,'o18',o18,FORMAT='(A10,E12.3)'

PRINT,'f19',f19,FORMAT='(A10,E12.3)'

PRINT,'ne20',ne20,FORMAT='(A10,E12.3)'
PRINT,'ne21',ne21,FORMAT='(A10,E12.3)'
PRINT,'ne22',ne22,FORMAT='(A10,E12.3)'

PRINT,'na23',na23,FORMAT='(A10,E12.3)'

PRINT,'mg24',mg24,FORMAT='(A10,E12.3)'
PRINT,'mg25',mg25,FORMAT='(A10,E12.3)'
PRINT,'mg26',mg26,FORMAT='(A10,E12.3)'

PRINT,'al27',al27,FORMAT='(A10,E12.3)'

PRINT,'si28',si28,FORMAT='(A10,E12.3)'
PRINT,'si29',si29,FORMAT='(A10,E12.3)'
PRINT,'si30',si30,FORMAT='(A10,E12.3)'

print,''
print,'----------------------'
print,'abundance ratios'
print,'----------------------'

PRINT,'c12/c13',c12*13/(12*c13),FORMAT='(A10,E12.3)'
PRINT,'n14/n15',n14*15/(14*n15),FORMAT='(A10,E12.3)'

PRINT,'o16/o17',o16*17/(16*o17),FORMAT='(A10,E12.3)'
PRINT,'o16/o18',o16*18/(16*o18),FORMAT='(A10,E12.3)'

PRINT,'ne20/ne21',ne20*21/(20*ne21),FORMAT='(A10,E12.3)'
PRINT,'ne20/ne22',ne20*22/(20*ne22),FORMAT='(A10,E12.3)'

PRINT,'mg24/mg25',mg24*25/(24*mg25),FORMAT='(A10,E12.3)'
PRINT,'mg24/mg26',mg24*26/(24*mg26),FORMAT='(A10,E12.3)'

PRINT,'si28/si29',si28*29/(28*si29),FORMAT='(A10,E12.3)'
PRINT,'si28/si30',si28*30/(28*si30),FORMAT='(A10,E12.3)'

si28s=6.530e-4
si29s=3.426e-5
si30s=2.352e-5

print,'----------------------'
PRINT,'delta si29',((si29/si28)/(si29s/si28s)-1)*1.D3,FORMAT='(A10,E12.3)'
PRINT,'delta si30',((si30/si28)/(si30s/si28s)-1)*1.D3,FORMAT='(A10,E12.3)'
print,'======================'

END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

PRO dumpydot,educts,VERBOSE=verbose,ISOTOPE_ALL=isotope_all, $
             ISOTOPE_PROD=isotope_prod,ISOTOPE_DEST=isotope_dest, $
             REACTION=reaction,XRANGE=xrange,YRANGE=yrange, $
             RESREACT=resreact, $
             MSORT=msort,NMAX=nmax

COMMON nuclear, rate
IF N_ELEMENTS(rate) EQ 0 THEN nuclear,/SILENT

IF N_ELEMENTS(educts) EQ 0 THEN educts='C14'
IF N_ELEMENTS(xrange) EQ 0 THEN xrange=[0,0]
IF N_ELEMENTS(yrange) EQ 0 THEN yrange=[1.D-30,1]

IF N_ELEMENTS(verbose) EQ 0 THEN verbose=1
IF N_ELEMENTS(isotope_all) EQ 0 THEN isotope_all=0
IF N_ELEMENTS(isotope_prod) EQ 0 THEN isotope_prod=0
IF N_ELEMENTS(isotope_dest) EQ 0 THEN isotope_dest=0
IF N_ELEMENTS(reaction) EQ 0 THEN reaction=0
IF N_ELEMENTS(resreact) EQ 0 THEN resreact=0
IF N_ELEMENTS(msort) EQ 0 THEN msort=-1
IF N_ELEMENTS(nmax) EQ 0 THEN nmax=100000L

;findrates,educts,INDEX=index,VERBOSE=0,ISOTOPE_ALL=isotope_all, $
;             ISOTOPE_PROD=isotope_prod,ISOTOPE_DEST=isotope_dest,REACTION=reaction

nindex=N_ELEMENTS(index)
edall=rate.EDUCTS(index)
IF resreact THEN BEGIN
    reactall=rate.RATE(index)
ENDIF ELSE BEGIN
    reactall=edall
ENDELSE
edsel=UNIQ(reactall,SORT(reactall))
react=reactall(edsel)
ed=edall(edsel)
nreact=N_ELEMENTS(ed)

nidx=INTARR(nreact)
nidx_max=0
midx=INTARR(nindex)
nmidx=0
FOR i=0,nreact-1 DO BEGIN
    iidx=index(WHERE(reactall EQ react(i)))
    nidx(i)=N_ELEMENTS(iidx)
    nidx_max=MAX([nidx_max,nidx(i)])
    midx(nmidx:nmidx+nidx(i)-1)=iidx(0:nidx(i)-1)
    nmidx=nmidx+nidx(i)
ENDFOR
idx=LONARR(nreact,nidx_max)
nmidx=0
FOR i=0,nreact-1 DO BEGIN
    idx(i,0:nidx(i)-1)=midx(nmidx:nmidx+nidx(i)-1)
    nmidx=nmidx+nidx(i)
ENDFOR

riso=STRARR(nreact,3)
nriso=INTARR(nreact)

FOR i=0,nreact-1 DO BEGIN
;    getiso,ed(i),iso,niso
    riso(i,0:niso-1)=iso(0:niso-1)
    nriso(i)=niso
ENDFOR

FOR i=0,nreact*3-1 DO BEGIN
    CASE riso(i) OF
        'n': riso(i)='nt1'
        'p': riso(i)='h1'
        'd': riso(i)='h2'
        't': riso(i)='h3'
        'T': riso(i)='h3'
        'Al-6': riso(i)='al26'
        ELSE:
    ENDCASE
ENDFOR

xiso=riso(UNIQ(riso,SORT(riso)))
xiso=xiso(WHERE(xiso NE ''))
nxiso=N_ELEMENTS(xiso)

getdump,'tn',tn
getdump,'dn',dn
getdump,'zm_sun',zm
nz=N_ELEMENTS(tn)
IF msort GE 0 THEN BEGIN
    nsort=0
    FOR i=0,N_ELEMENTS(zm)-1 DO BEGIN
        IF zm(i) LT msort THEN BEGIN
            nsort=i
        ENDIF
    ENDFOR
ENDIF

y=DBLARR(nxiso,nz)
found=INTARR(nxiso)
iriso=INTARR(nreact,3)
lrvalid=REPLICATE(1,nreact)
iriso(*)=0

FOR i=0,nxiso-1 DO BEGIN
    getdump,'iso'+xiso(i),v,ERROR=error,/ABUNDANCE,/SILENT
    ridx=WHERE(riso EQ xiso(i))
    IF error THEN BEGIN
        y(i,*)=0
        found(i)=0
        lrvalid(ridx MOD nreact) = 0
    ENDIF ELSE BEGIN
        y(i,*)=v
        found(i)=1
        iriso(ridx)=i
    ENDELSE
ENDFOR

irvalid=WHERE(lrvalid)
IF irvalid(0) EQ -1 THEN BEGIN
    PRINT,' [DUMPYDOT] NO VALID REACTION'
    RETURN
ENDIF
nreact=N_ELEMENTS(irvalid)
ed=ed(irvalid)
iriso=iriso(irvalid,0:2)
idx=idx(irvalid,0:nidx_max-1)
nidx=nidx(irvalid)
react=react(irvalid)

LEGENDE,/LEFT,/TOP

c=isocolors(nreact)
l=REPLICATE(0,nreact)
IF nreact GT 5 THEN BEGIN
    c=isocolors(5)
    c=c(INDGEN(nreact) MOD 5)
    l=[0,2,3,4,5]
    l=l(INDGEN(nreact)/5)
ENDIF

PLOT,zm,[1,1],/yl,YRANGE=yrange,XRANGE=xrange,/NODATA,/XSTYLE,/YSTYLE,XTITLE='mass / solar masses',YTITLE='Y_dot / mol/s'

IF msort GE 0 THEN BEGIN
    speed=DBLARR(nreact)
    FOR i=0,nreact-1 DO BEGIN
;        getydot,ed(i),tn(nsort),dn(nsort),y(iriso(i,0),nsort),y(iriso(i,1),nsort),y(iriso(i,2),nsort),YDOT=ydot,/FROM_INDEX,INDEX=idx(i,0:nidx(i)-1),VERBOSE=0
        speed(i)=ydot
    ENDFOR
    x=REVERSE(SORT(speed))
    ed=ed(x)
    iriso(*,*)=iriso(x,*)
    nidx=nidx(x)
    react=react(x)
    idx(*,*)=idx(x,*)
    nreact=MIN([nmax,nreact])
ENDIF

FOR i=0,nreact-1 DO BEGIN 
;    getydot,ed(i),tn,dn,y(iriso(i,0),*),y(iriso(i,1),*),y(iriso(i,2),*),YDOT=ydot,/FROM_INDEX,INDEX=idx(i,0:nidx(i)-1)
    OPLOT,zm,ydot,COLOR=c(i),LINE=l(i)
    LEGENDE_LINE,l(i),react(i),COLOR=c(i)
ENDFOR

END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

PRO plot_mass_and_abundance,iso,XRANGE=xrange,YLOG=ylog

IF N_ELEMENTS(ylog) EQ 0 THEN ylog=1
IF N_ELEMENTS(xrange) EQ 0 THEN xrange=[0,0]
IF N_ELEMENTS(iso) EQ 0 THEN iso='isoc12'

getdump,iso,v,abundance=0,NAME=vn
getdump,iso,va,abundance=1,NAME=van
getdump,'zm_sun',zm,NAME=zmn

c=isocolors(1)
PLOT,zm,v,XTITLE=zmn,YTITLE=vn,XMARGIN=[10,10],YSTYLE=8,YLOG=ylog,/NODATA,XRANGE=xrange
OPLOT,zm,v,COLOR=c(0)

weight=MAX(v)/MAX(va)
crange=!Y.CRANGE
IF !Y.TYPE EQ 1 THEN crange=10.D0^crange
crange=crange/weight
AXIS,YAXIS=1,YRANGE=crange,YLOG=ylog,YTITLE=van,/YSTYLE

END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

PRO multi,a,b,XRANGE=xrange,YRANGE=yrange,COLLECT=collect, $
          CREATE=create,MSORT=msort,NMAX=nmax

COMMON dumpmulti,created
IF N_ELEMENTS(created) EQ 0 THEN created=0

IF N_ELEMENTS(b) EQ 0 THEN b=a
IF N_ELEMENTS(collect) EQ 0 THEN collect=1
IF N_ELEMENTS(create) EQ 0 THEN create=NOT created

IF N_ELEMENTS(xrange) EQ 0 THEN xrange=[0,0]
IF N_ELEMENTS(yrange) EQ 0 THEN yrange=[1.D-30,1]

IF create THEN spectrum

IF create THEN WINDOW,0,TITLE='isotope' ELSE wset,0

bb=b
CASE bb OF
    'n': bb='nt1'
    'p': bb='h1'
    'd': bb='h2'
    't': bb='h3'
    'T': bb='h3'
    'Al-6': bb='al26'
    ELSE:
ENDCASE
plot_mass_and_abundance,'iso'+bb,XRANGE=xrange,/YLOG

IF create THEN WINDOW,6,TITLE='destruction to ...' ELSE wset,6
dumpydot,a,/ISOTOPE_DEST,/RESREACT,XRANGE=xrange,YRANGE=yrange,MSORT=msort,NMAX=nmax

IF collect THEN BEGIN
    IF create THEN WINDOW,2,TITLE='destruction' ELSE wset,2
    dumpydot,a,/ISOTOPE_DEST ,XRANGE=xrange,YRANGE=yrange,MSORT=msort,NMAX=nmax
ENDIF

IF create THEN WINDOW,3,TITLE='production' ELSE wset,3
dumpydot,a,/ISOTOPE_PROD,XRANGE=xrange,YRANGE=yrange,MSORT=msort,NMAX=nmax

created=created OR create
END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

FUNCTION dbl2long,x,ARRAY=array
COMMON endian,little_endian

IF N_ELEMENTS(array) EQ 0 THEN array=0

IF SIZE(x,/TYPE) NE 5 THEN BEGIN
    PRINT,'[dbl2long] ERROR: WRONG DATA TYPE'
    STOP
ENDIF

s=SIZE(x)
ns=N_ELEMENTS(s)
s[ns-2]=3

y=MAKE_ARRAY(SIZE=s)

IF little_endian THEN lp=1 ELSE lp=0

IF (array EQ 1) THEN BEGIN
    llp=[lp,1-lp]
    FOR i=0,s(ns-1)-1 DO BEGIN
        y(i)=LONG(x[i/2],4*llp[i mod 2])
    ENDFOR
ENDIF ELSE BEGIN
    FOR i=0,s(ns-1)-1 DO BEGIN
        y[i]=LONG(x[i],lp*4)
    ENDFOR
ENDELSE


RETURN,y
END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

PRO jplot

plotdump,'zm_sun','angj',/yl,ymult=1.5,YRANGE=[1.D14,1.D20],/XSTYLE
plotdump,'zm_sun','anglsts',ymult=1./3,/over,line=3
plotdump,'zm_sun','anglsts',/over,line=2
plotdump,'zm_sun','anglst',/over,line=1

legende,5,/LEFT,/BOTTOM,LINEHEIGHT=1.5
legende_line,0,'j!beq!n'
legende_line,3,'j!blso,Kerr!n'
legende_line,2,'j!blso,Schw.!n'
legende_line,1,'j!blso!n(J!bbelow!n)'

END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------

PRO loaddump,name,SILENT=silent,VERBOSE=verbose, ENDIAN=endian
;ENDIAN sets whether the fild is big endian(1) or small endian(0)

COMMON readdump, filename
COMMON kepdata, $
   jm,head,pdum,npdum,qdum,nqdum,ym,rn,rd,un,xln, $
   qln,qld,difi,netnum,xm,dn,tn,td,en,pn,zn,etan,sn,snn,abar, $
   zbar,xkn,xnei,stot,angj,angdg,angd1,angd2,angd3,angd4,angd5, $
   dsold,tsold,ppn,netnumb,zlimnuc,timen,dtimen,dnold,tnold,ymb, $
   sburn,etab,pbuf,ppnb,ions,ionsb,wind,windb,aion,aionb,iconv, $
   numi,ionn,zion,numib,ionnb,zionb,$
   nbmax,nabmax,nzbmax,nibmax,burnamax,burnmmax,ibcmax, $
   bfvisc,bfdiff,bfbr,bfbt, $
   bfviscef,bfdiffef,angdgeff,difieff, $
   zm_grid,pist,npist,snw,snwcrsi,snwcrsd,$
   xmburn,fc12mult,snadv


COMMON kepcalc, zm,angi,angw,ange,angwk,angek,angwwk,angeek
COMMON endian,little_endian


@physconst

IF (N_ELEMENTS(name) EQ 0) AND (N_ELEMENTS(filename) NE 0) THEN name=filename
IF N_ELEMENTS(name) EQ 0 THEN name='xxxz'
IF !VERSION.RELEASE NE '6.0' THEN BEGIN
   xxx=FINDFILE(name,COUNT=xxx_count)
   IF (xxx_count EQ 0) OR (name EQ '') THEN BEGIN
      PRINT,' [LOADUMP] cannont find restart dump ',name
      name=DIALOG_PICKFILE(/NOCONFIRM,/READ,/MUST_EXIST,FILTER='*')
      IF name EQ '' THEN RETURN
   ENDIF
ENDIF
filename=name

IF N_ELEMENTS(silent) EQ 0 THEN silent=0
IF N_ELEMENTS(verbose) EQ 0 THEN verbose=1
IF silent THEN verbose=0

; determine if on little or big endian system
i=1L
BYTEORDER,i,/LSWAP,/SWAP_IF_BIG_ENDIAN
little_endian=(i EQ 1L)
IF N_ELEMENTS(endian) EQ 0 THEN endian=1
endian:
compress=STRLOWCASE(STRMID(STRTRIM(filename,2),2,3,/REVERSE_OFFSET)) EQ '.gz'
IF endian EQ 1 THEN BEGIN 
    OPENR,unit,filename,/GET_LUN,/SWAP_IF_LITTLE_ENDIAN,COMPRESS=compress
ENDIF ELSE BEGIN
    OPENR,unit,filename,/GET_LUN,/SWAP_IF_BIG_ENDIAN,COMPRESS=compress
ENDELSE

IF verbose EQ 1 THEN BEGIN
    xstat=fstat(unit)
    IF compress EQ 1 THEN s=', compressed' ELSE s=''
    PRINT,' [LOADDUMP] loading '+filename+' ('+byte2human(xstat.size)+s+')' 
ENDIF

recsize=0L
readu,unit,recsize
; check for endian-ness
ok=1
 IF (recsize GT 512L) or (recsize LE 0) THEN ok=0
IF OK EQ 1 THEN BEGIN
    POINT_LUN,unit,4+recsize
    recsize1=0L
    READU,unit,recsize1
    IF recsize NE recsize1 THEN ok=0 
    POINT_LUN,unit,4    
ENDIF
IF ok EQ 0 THEN BEGIN
    PRINT,' [LOADDUMP] ##############################'
    PRINT,' [LOADDUMP] ###     W A R N I N G      ###'
    PRINT,' [LOADDUMP] ##############################'
    PRINT,' [LOADDUMP] ###    Changing endian!    ###'
    PRINT,' [LOADDUMP] ##############################'
    PRINT,' [LOADDUMP] ###     W A R N I N G      ###'
    PRINT,' [LOADDUMP] ##############################'
    endian=1-endian
    CLOSE,unit
    FREE_LUN,unit
    GOTO, endian
ENDIF

ndata=recsize/8
pos1=recsize+8L

hdum=0.0D0
nhead=2*(ndata-1)
head=lonarr(nhead)
READU,unit,hdum,head

; restore parametrs

lenhead0=head(0)
jmz0    =head(1)
jmzb0   =head(2)
nburn0  =head(3)
iratioz0=head(4)
nvar0   =head(5)
nheadz0 =head(6)
nhead0  =head(7)
nparmz0 =head(8)
nparm0  =head(9)
nqparmz0=head(10)
nqparm0 =head(11)
nniz0   =head(12)
nhiz0   =head(13)
nitz0   =head(14)
nnizb0  =head(15)
nhizb0  =head(16)
nitzb0  =head(17)
nreacz0 =head(18)
ndtz0   =head(19)
ndt0    =head(20)
npistz0 =head(21)
nyez0   =head(22)
nsubz0  =head(23)
nsub0   =head(24)
nzonei0 =head(25)
nzonec0 =head(26)
nzoneb0 =head(27)
nsmall0 =head(28)
nsmallc0=head(29)
imax0   =head(30)
imaxb0  =head(31)
nreac0  =head(32)
jmsave  =head(33)
lencom0 =head(34)
lencomc0=head(35)
nedtcom0=head(36)
ndatqz0 =head(37)
ngridz0 =head(38)
nylibz0 =head(39)
nyoffst0=head(40)
lenshed0=head(41)
lenqhed0=head(42)
nzedz0  =head(43)
ncsavdz0=head(44)

jmsave1=jmsave+1

POINT_LUN,unit,pos1
READU,unit,recsize
pos1=pos1+4L
IF (nparmz0 NE recsize/8-1) THEN PRINT,' [LOADDUMP] ERROR pdum:',nparmz0,recsize/8-1

pdum=dblarr(nparmz0+1)
READU,unit,pdum

npdum=dbl2long(pdum)
version=pdum(66)

pos1=pos1+4L+recsize

POINT_LUN,unit,pos1
READU,unit,recsize
pos1=pos1+4L
IF (nqparmz0 NE recsize/8-1) THEN PRINT,' [LOADDUMP] ERROR qdum:',nqparmz0,recsize/8-1

qdum=dblarr(nqparmz0+1)
nqdum=lonarr(nqparmz0+1)
READU,unit,qdum
nqdum=dbl2long(qdum)
pos1=pos1+4L+recsize

POINT_LUN,unit,pos1
READU,unit,recsize
pos1=pos1+4L
IF (nsmall0 NE recsize/8) THEN PRINT,' [LOADDUMP] ERROR sdum:',nsmall0,recsize/8
; read ion data
posx=1L+2*npistz0+2*nyez0
aion=DBLARR(nitz0)
zion=DBLARR(nitz0)
znumi=DBLARR(nniz0)
zionn=DBLARR(nhiz0,nniz0)
POINT_LUN,unit,pos1+posx*8L
READU,unit,aion,zion,znumi,zionn
posx=posx+(nitz0+nitz0+nniz0+nhiz0*nniz0)
numi=dbl2long(znumi,/array)
ionn=dbl2long(zionn,/array)

; read in BURN ion data
xloadb=0
IF version LT 15.995 THEN BEGIN
    aionb=DBLARR(nitzb0)
    zionb=DBLARR(nitzb0)
    znumib=DBLARR(nnizb0)
    zionnb=DBLARR(nhizb0,nnizb0)
    xloadb=1
ENDIF ELSE BEGIN
    IF imaxb0 GT 0 THEN BEGIN
        aionb=DBLARR(imaxb0)
        zionb=DBLARR(imaxb0)
        znumib=DBLARR(nnizb0)
        zionnb=DBLARR(nnizb0,imaxb0)
        xloadb=1
    ENDIF
ENDELSE
IF xloadb EQ 1 THEN BEGIN
    POINT_LUN,unit,pos1+posx*8L
    READU,unit,aionb,zionb,znumib,zionnb
    numib=dbl2long(znumib,/array)
    ionnb=dbl2long(zionnb,/array)
ENDIF

; read in piston
npist=nqdum(59)
IF npist GT 0 THEN BEGIN 
    posx=1L
    POINT_LUN,unit,pos1+posx*8L
    pist=DBLARR(npistz0,2)
    READU,unit,pist
    pist=TEMPORARY(pist[0:npist-1,0:1])
ENDIF

; read in wind,windb
IF version GE 15.1395 THEN BEGIN
; first compute position
    IF version LT 15.995D0 THEN BEGIN
        posx=1L+2*npistz0+2*nyez0 $
          +2*nitz0+nniz0+nhiz0*nniz0 $
          +2*nitzb0+nnizb0+nhizb0*nnizb0 $
          +2*ndtz0+3*(nsubz0+1)+5*nreacz0+nhiz0 $
          +5*ndatqz0+4*nzedz0
    ENDIF ELSE BEGIN
        posx=1L+2*npistz0+2*nyez0 $
          +2*nitz0+nniz0+nhiz0*nniz0 $
          +2*imaxb0+nnizb0+imaxb0*nnizb0 $
          +2*ndtz0+3*(nsubz0+1)+5*nreacz0+nhiz0 $
          +5*ndatqz0+4*nzedz0
    ENDELSE
    IF (pos1+posx*8L GE pos1+4L+recsize) THEN PRINT,' [LOADDUMP] ERROR sdum:',posx*8L,recsize
    POINT_LUN,unit,pos1+posx*8L
    wind=DBLARR(nitz0)
    READU,unit,wind
    IF imaxb0 GT 0 THEN BEGIN
        windb=DBLARR(imaxb0)
        READU,unit,windb
    ENDIF
ENDIF
; sdum currently only partly used
pos1=pos1+4L+recsize

IF version LT 15.995 THEN BEGIN
    ncdum0=nsmallc0+1+jmsave
ENDIF ELSE BEGIN
    ncdum0=nsmallc0
ENDELSE

POINT_LUN,unit,pos1
READU,unit,recsize
pos1=pos1+4L
IF (ncdum0*8L NE recsize) THEN PRINT,' [LOADDUMP] ERROR cdum:',ncdum0,recsize/8,ncdum0*8L-recsize
; ions
cdumpos=8L+3L*2L
point_lun,unit,pos1+cdumpos*8L
ions=REPLICATE('12345678',nitz0)
READU,unit,ions
; ionsb
cdumpos=8L+3L*2L+nitz0
point_lun,unit,pos1+cdumpos*8L
xloadb=0
IF version LT 15.995 THEN BEGIN
    ionsb=REPLICATE('12345678',nitzb0)
    xloadb=1
ENDIF ELSE BEGIN
    IF imaxb0 GT 0 THEN BEGIN
        ionsb=REPLICATE('12345678',imaxb0)
        xloadb=1
    ENDIF
ENDELSE
IF xloadb EQ 1 THEN BEGIN
    READU,unit,ionsb
ENDIF

; iconv
cdumpos=8L+3L*2L+nitz0+ndtz0+nreacz0+4L*2L+7L*ndatqz0 $
  +10L*nzedz0+10L*30L+7*ndatqz0+3L*2L+6L+3L*50L $
  +10L*ncsavdz0
IF version GT 15.175 THEN cdumpos=cdumpos+10L ; datapath
IF version LT 15.995 THEN BEGIN
    cdumpos=cdumpos+nitzb0
ENDIF ELSE BEGIN
    cdumpos=cdumpos+imaxb0
ENDELSE
point_lun,unit,pos1+cdumpos*8L
iconv=REPLICATE('        ',jmsave1)
READU,unit,iconv
; rest cdum currently ignored
pos1=pos1+4L+recsize

nsavez=npdum(269)
POINT_LUN,unit,pos1
READU,unit,recsize
pos1=pos1+4L
nzdum0=jmsave+1
IF (nzdum0 NE recsize/8) THEN PRINT,' [LOADDUMP] ERROR zdum:',nzdum0,recsize/8
ym     =DBLARR(jmsave1)
rn     =DBLARR(jmsave1)
rd     =DBLARR(jmsave1)   
un     =DBLARR(jmsave1)
xln    =DBLARR(jmsave1)
qln    =DBLARR(jmsave1)
qld    =DBLARR(jmsave1)
difi   =DBLARR(jmsave1)
znetnum=DBLARR(jmsave1)
xm     =DBLARR(jmsave1)
dn     =DBLARR(jmsave1)
tn     =DBLARR(jmsave1)
td     =DBLARR(jmsave1)
en     =DBLARR(jmsave1)
pn     =DBLARR(jmsave1)
zn     =DBLARR(jmsave1)
etan   =DBLARR(jmsave1)
sn     =DBLARR(jmsave1)
snn    =DBLARR(jmsave1)
abar   =DBLARR(jmsave1)
zbar   =DBLARR(jmsave1)
xkn    =DBLARR(jmsave1)
xnei   =DBLARR(jmsave1)
stot   =DBLARR(jmsave1)
angj   =DBLARR(jmsave1)
angdg  =DBLARR(jmsave1)
angd1  =DBLARR(jmsave1)
angd2  =DBLARR(jmsave1)
angd3  =DBLARR(jmsave1)
angd4  =DBLARR(jmsave1)
angd5  =DBLARR(jmsave1)
dsold  =DBLARR(jmsave1)
tsold  =DBLARR(jmsave1)
dump=LONARR(2)
READU,unit,ym,dump,rn,dump,rd,dump,un,dump,xln,dump,qln,dump,qld,dump, $
  difi,dump,znetnum,dump,xm,dump,dn,dump,tn,dump,td,dump,en,dump,pn, $
  dump,zn,dump,etan,dump,sn,dump,snn,dump,abar,dump,zbar,dump,xkn
READU,unit,dump,xnei,dump,stot,dump,angj,dump,angdg,dump,angd1,dump, $
  angd2,dump,angd3,dump,angd4,dump,angd5,dump,dsold,dump,tsold
pos1=pos1-4L+(recsize+8L)*nsavez

netnum=dbl2long(znetnum,/array)

jm=nqdum(2)
imax=nqdum(14)
nppn0=jm*imax
POINT_LUN,unit,pos1
READU,unit,recsize
pos1=pos1+4L
IF (nppn0 NE recsize/8) THEN PRINT,' [LOADDUMP] ERROR ppn:',nppn0,recsize/8
ppn=dblarr(imax,jm+1)
dump=DBLARR(imax,jm)
READU,unit,dump
ppn(*,1:jm)=dump(*,0:jm-1)
dump=0
pos1=pos1+4L+recsize

; read in magnetic field
magnet=npdum(423)
IF (magnet NE 0) AND (version GE 16.115D0) THEN BEGIN
    POINT_LUN,unit,pos1
    READU,unit,recsize
    pos1=pos1+4L
    bfvisc=DBLARR(jm)
    bfdiff=DBLARR(jm)
    READU,unit,bfvisc,bfdiff
    bfvisc=[0,bfvisc,0]
    bfdiff=[0,bfdiff,0]
    pos1=pos1+4L+recsize
ENDIF

IF (magnet NE 0) AND (version GE 16.265D0) THEN BEGIN
    POINT_LUN,unit,pos1
    READU,unit,recsize
    pos1=pos1+4L
    bfbr=DBLARR(jm)
    bfbt=DBLARR(jm)
    READU,unit,bfbr,bfbt
    bfbr=[0,bfbr,0]
    bfbt=[0,bfbt,0]
    pos1=pos1+4L+recsize
ENDIF

IF (magnet NE 0) AND (version GE 16.215D0) THEN BEGIN
    POINT_LUN,unit,pos1
    READU,unit,recsize
    pos1=pos1+4L
    bfviscef=DBLARR(jm)
    bfdiffef=DBLARR(jm)
    READU,unit,bfviscef,bfdiffef
    bfviscef=[0,bfviscef,0]
    bfdiffef=[0,bfdiffef,0]
    pos1=pos1+4L+recsize
ENDIF

IF (version GE 16.215D0) THEN BEGIN
    POINT_LUN,unit,pos1
    READU,unit,recsize
    pos1=pos1+4L
    angdgeff=DBLARR(jm)
    difieff =DBLARR(jm)
    READU,unit,angdgeff,difieff
    angdgeff=[0,angdgeff,0]
    difieff =[0,difieff ,0]
    pos1=pos1+4L+recsize
ENDIF

nflamez=50
xmburn=DBLARR(nflamez)
fc12mult=REPLICATE(1.D0,jm)
IF (version GE 16.135D0) THEN BEGIN
   sharp1=pdum(282)
   IF (sharp1 GT 0.0D0) THEN BEGIN
      POINT_LUN,unit,pos1
      READU,unit,recsize
      pos1+=4L
      READU,unit,xmburn,fc12mult
      pos1+=recsize+4L
   ENDIF
   fc12mult=[0,fc12mult]
ENDIF

imaxb=nqdum(53)
nsaveb=npdum(270)
IF ((imaxb GT 0) AND (jmzb0 GT 1) AND (nsaveb GT 0)) THEN BEGIN
    nbdum1=jmsave1
    POINT_LUN,unit,pos1
    READU,unit,recsize
    pos1=pos1+4L
    IF (nbdum1 NE recsize/8) THEN PRINT,' [LOADDUMP] ERROR bdum:',nbdum1,recsize/8
    IF (nsaveb NE 10) THEN PRINT,' [LOADDUMP] ERROR bdum:',nsaveb,10
    znetnumb=DBLARR(nbdum1)  
    zlimnuc =DBLARR(nbdum1)
    timen   =DBLARR(nbdum1)   
    dtimen  =DBLARR(nbdum1)
    dnold   =DBLARR(nbdum1)    
    tnold   =DBLARR(nbdum1)    
    ymb     =DBLARR(nbdum1)
    sburn   =DBLARR(nbdum1)     
    etab    =DBLARR(nbdum1)   
    pbuf    =DBLARR(nbdum1)
    READU,unit,znetnumb,zlimnuc,timen,dtimen, $
      dnold,tnold,ymb,sburn,etab,pbuf
    pos1=pos1+nsaveb*recsize+(nsaveb-1)*8L+4L
    netnumb=dbl2long(znetnumb,/ARRAY)
    netnumb=[0,netnumb]

    nppnb0=jm*imaxb
    POINT_LUN,unit,pos1
    READU,unit,recsize
    pos1=pos1+4L
    IF (nppnb0*8L NE recsize) THEN PRINT,' [LOADDUMP] ERROR bdum:',nppnb0,recsize/8
    ppnb=DBLARR(imaxb,jm+1)
    dump=DBLARR(imaxb,jm)
    READU,unit,dump
    ppnb(*,1:jm)=dump(*,0:jm-1)
    dump=0
    pos1=pos1+4L+recsize

    irecb=npdum(418)
    IF irecb EQ 1 THEN BEGIN
        IF (version GE 16.0395) AND (version LT 16.085) THEN BEGIN
            POINT_LUN,unit,pos1
            READU,unit,recsize
            pos1=pos1+4L
            IF (8L*imaxb NE recsize) THEN PRINT,' [LOADDUMP] ERROR burnamax:',imaxb,recsize/8,imaxb*8L-recsize        
            burnamax=DBLARR(imaxb)
            READU,unit,burnamax
            pos1=pos1+4L+recsize
            
            POINT_LUN,unit,pos1
            READU,unit,recsize
            pos1=pos1+4L
            IF (8L*imaxb NE recsize) THEN PRINT,' [LOADDUMP] ERROR burnmmax:',imaxb,recsize/8,imaxb*8L-recsize        
            burnmmax=DBLARR(imaxb)
            READU,unit,burnmmax
            pos1=pos1+4L+recsize
            
            POINT_LUN,unit,pos1
            READU,unit,recsize
            pos1=pos1+4L
            IF (4L*imaxb NE recsize) THEN PRINT,' [LOADDUMP] ERROR ibcmax(i):',imaxb,recsize/4,imaxb*4L-recsize        
            burnmmax=INTARR(imaxb)
            READU,unit,ibcmax(i)
            pos1=pos1+4L+recsize

            FOR i=0,imaxb-1 DO BEGIN
                nabmax(i)=INT(0.1+aionb(i))
                nzbmax(i)=INT(0.1+zionb(i))
                nibmax(i)=i
                ionbmax(i)=ionsb(i)
            ENDFOR
        ENDIF
        
        IF (version GE 16.085) THEN BEGIN
            POINT_LUN,unit,pos1
            READU,unit,recsize
            pos1=pos1+4L
            IF (4L NE recsize) THEN PRINT,' [LOADDUMP] ERROR nbmax:',4,', ',recsize        
            nbmax=0L
            READU,unit,nbmax
            pos1=pos1+4L+recsize

            POINT_LUN,unit,pos1
            READU,unit,recsize
            pos1=pos1+4L
            IF (4L*nbmax NE recsize) THEN PRINT,' [LOADDUMP] ERROR nabmax:',nbmax,recsize/4,nbmax*4L-recsize
            nabmax=LONARR(nbmax)
            READU,unit,nabmax
            pos1=pos1+4L+recsize

            POINT_LUN,unit,pos1
            READU,unit,recsize
            pos1=pos1+4L
            IF (4L*nbmax NE recsize) THEN PRINT,' [LOADDUMP] ERROR nzbmax:',nbmax,recsize/4,nbmax*4L-recsize
            nzbmax=LONARR(nbmax)
            READU,unit,nzbmax
            pos1=pos1+4L+recsize

            POINT_LUN,unit,pos1
            READU,unit,recsize
            pos1=pos1+4L
            IF (4L*imaxb GT recsize) THEN PRINT,' [LOADDUMP] ERROR nibmax:',imaxb,recsize/4,imaxb*4L-recsize
            nibmax=LONARR(imaxb)
            READU,unit,nibmax
            pos1=pos1+4L+recsize

            POINT_LUN,unit,pos1
            READU,unit,recsize
            pos1=pos1+4L
            IF (8L*nbmax NE recsize) THEN PRINT,' [LOADDUMP] ERROR ionbmax:',nbmax,recsize/8,nbmax*8L-recsize
            ionbmax=REPLICATE('        ',nbmax)
            READU,unit,ionbmax
            pos1=pos1+4L+recsize

            POINT_LUN,unit,pos1
            READU,unit,recsize
            pos1=pos1+4L
            IF (8L*nbmax NE recsize) THEN PRINT,' [LOADDUMP] ERROR burnamax:',nbmax,recsize/8,nbmax*8L-recsize
            burnamax=DBLARR(nbmax)
            READU,unit,burnamax
            pos1=pos1+4L+recsize

            POINT_LUN,unit,pos1
            READU,unit,recsize
            pos1=pos1+4L
            IF (8L*nbmax NE recsize) THEN PRINT,' [LOADDUMP] ERROR burnmmax:',nbmax,recsize/8,nbmax*8L-recsize
            burnmmax=DBLARR(nbmax)
            READU,unit,burnmmax
            pos1=pos1+4L+recsize

            POINT_LUN,unit,pos1
            READU,unit,recsize
            pos1=pos1+4L
            IF (4L*nbmax NE recsize) THEN PRINT,' [LOADDUMP] ERROR ibcmax:',nbmax,recsize/4,nbmax*4L-recsize
            ibcmax=LONARR(nbmax)
            READU,unit,ibcmax
            pos1=pos1+4L+recsize
        ENDIF
     ENDIF
ENDIF

wimp=pdum(496)
IF (version GE 15.755D0) AND (wimp GT 0.D0) THEN BEGIN

   POINT_LUN,unit,pos1
   READU,unit,recsize
   pos1=pos1+4L
   snw=DBLARR(jm)
   READU,unit,snw
   snw=[0,snw,0]
   pos1=pos1+4L+recsize

   POINT_LUN,unit,pos1
   READU,unit,recsize
   pos1=pos1+4L
   snwcrsi=DBLARR(jm)
   READU,unit,snwcrsi
   snwcrsi=[0,snwcrsi,0]
   pos1=pos1+4L+recsize

   POINT_LUN,unit,pos1
   READU,unit,recsize
   pos1=pos1+4L
   snwcrsd=DBLARR(jm)
   READU,unit,snwcrsd
   snwcrsd=[0,snwcrsd,0]
   pos1=pos1+4L+recsize

ENDIF

IF (version GE 16.815D0) THEN BEGIN
   POINT_LUN,unit,pos1
   READU,unit,recsize
   pos1=pos1+4L
   snadv=DBLARR(jm)
   READU,unit,snadv
   snadv=[0,snadv,0]
   pos1=pos1+4L+recsize
ENDIF

CLOSE,unit
FREE_LUN,unit

zm_grid=DBLARR(jmsave1)
zm_grid(0)=0.0D0
FOR i=1,jmsave DO zm_grid(i)=zm_grid(i-1)+xm(i)
zm=zm_grid+pdum(61)

angi=DBLARR(jmsave1)
angi(1:jmsave)=calcai(rn(0:jmsave-1),rn(1:jmsave),1.0D0)
angi(0)=1.0D0
angw=DBLARR(jmsave1)
angw=angj/angi
ange=0.5D0*angw*angj
angwk=DBLARR(jmsave1)
angwk(1:jmsave)=SQRT(GRAV*4.D0*(zm(0:jmsave-1)+zm(1:jmsave))/(rn(0:jmsave-1)+rn(1:jmsave))^3)
angwk(0)=angwk(1)
angek=0.5*angi*angwk^2
angwwk=angw/angwk
angeek=ange/angek

IF verbose GE 1 THEN BEGIN
    mtime=pdum(2)    
    IF mtime LT SEC THEN BEGIN
        s=STRING(pdum(2))+' s'
    ENDIF ELSE IF mtime LT SEC*1.D-6 THEN BEGIN
        s=STRING(pdum(2)/SEC)+' yr'
    ENDIF ELSE BEGIN
        s=STRING(pdum(2)/SEC*1.D-6)+' Myr'
    ENDELSE
    PRINT,' [LOADDUMP] Loaded model ',nqdum(4),', time=',s
    PRINT,' [LOADDUMP]      Tc=',tn(1),' K, Dc=',dn(1),' g/cm3'
    PRINT,' [LOADDUMP]      mass: ',qdum(17)/XMSUN,' Msun, initially: ',pdum(222)/XMSUN,' Msun'
    PRINT,' [LOADDUMP]      Version ',version
    IF N_ELEMENTS(ppnb) GT 0 THEN BEGIN
        PRINT,' [LOADDUMP]      burn isotopes=',imaxb
    ENDIF
ENDIF

END
