@isotopes

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO modelldata,dir,name

COMMON stern, nmodells, modells, modell_version

cd,dir

loadmodell,'mod.bin',/entropy

FOR i=0,nmodells-1 DO BEGIN
    print,modells[i].modell
    presndata,model=i,/time,outfile=name+'%'+STRTRIM(STRING(modells[i].modell),2)
ENDFOR


END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


PRO plotivt,isotope,TITLE=title,XTITLE=xtitle,YTITLE=ytitle,LINE=line,COLOR=color,PSYM=psym,OVER=over,YLOG=ylog,XRANGE=xrange,YRANGE=yrange,NODATA=nodata,NOERASE=noerase,LOGTIME=logtime,YSTYLE=ystyle,XSTYLE=xstyle,SCALE=scale,NORMALIZE=normalize,FIRST=first,LAST=last,STR_LARGE=str_large

COMMON stern, nmodells, modells, modell_version
COMMON isotopes, nisotopes, isotopes

COMMON plotivt, ivtlogtime

@strings

@physconst

spectrum
c=isocolors(255)

IF N_ELEMENTS(nmodells) EQ 0 THEN loadmodell

IF N_ELEMENTS(isotope) EQ 0 THEN isotope='p'
isotope=isotope_name2index(isotope)
IF isotope LT 0 THEN RETURN

IF N_ELEMENTS(line) EQ 0 THEN line=0 
IF N_ELEMENTS(color) EQ 0 THEN color=c(1)
IF N_ELEMENTS(psym) EQ 0 THEN psym=0 
IF N_ELEMENTS(over) EQ 0 THEN over=0 
IF N_ELEMENTS(ylog) EQ 0 THEN ylog=0 
IF N_ELEMENTS(xrange) EQ 0 THEN xrange=[0,0] 
IF N_ELEMENTS(yrange) EQ 0 THEN yrange=[0,0] 
IF N_ELEMENTS(xstyle) EQ 0 THEN xstyle=1
IF N_ELEMENTS(ystyle) EQ 0 THEN ystyle=0
IF N_ELEMENTS(nodata) EQ 0 THEN nodata=0 
IF N_ELEMENTS(noerase) EQ 0 THEN noerase=0 
IF N_ELEMENTS(scale) EQ 0 THEN scale=1 
IF N_ELEMENTS(normalize) EQ 0 THEN normalize=0 

nfirst=0
IF N_ELEMENTS(first) NE 0 THEN BEGIN
    WHILE (nfirst LT nmodells-1) AND (modells(nfirst).modell LT first) DO BEGIN
        nfirst=nfirst+1
    ENDWHILE
ENDIF

nlast=nmodells-1
IF N_ELEMENTS(last) NE 0 THEN BEGIN
    WHILE (nlast GT nfirst) AND (modells(nlast).modell GT last) DO BEGIN
        nlast=nlast-1
    ENDWHILE
ENDIF
nsel=indgen(nlast-nfirst+1)+nfirst

IF N_ELEMENTS(logtime) EQ 0 THEN BEGIN
    IF (over NE 0) AND (N_ELEMENTS(ivtlogtime) NE 0) THEN BEGIN
        uselogtime=ivtlogtime
    ENDIF ELSE BEGIN
        uselogtime=0
    ENDELSE 
ENDIF ELSE BEGIN 
    uselogtime=10.0D0^logtime
ENDELSE

IF (over EQ 0) THEN BEGIN
    ivtlogtime=uselogtime
ENDIF

IF N_ELEMENTS(xtitle) EQ 0 THEN BEGIN
    IF uselogtime EQ 0 THEN BEGIN
        xtitle='stellar age / yr'
    ENDIF ELSE BEGIN
        format="(I"+STRING(1+FIX(ALOG10(uselogtime)),FORMAT="(I2)")+")"
        xtitle='log( (t'+str_ind+'end!n - t) / yr + '+STRING(uselogtime,FORMAT=format)+' )'
        dt0=uselogtime
    ENDELSE
ENDIF

IF N_ELEMENTS(ytitle) EQ 0 THEN BEGIN 
    IF isotope LT nisotopes THEN BEGIN
        ytitle='total '+str_exp+STRING(isotopes(isotope).A,FORMAT='(I3)')+'!n'+isotopes(isotope).Symbol+' mass fraction'
    ENDIF ELSE IF isotope LT 2*nisotopes THEN BEGIN
        ytitle='surface '+str_exp+STRING(isotopes(isotope-nisotopes).A,FORMAT='(I3)')+'!n'+isotopes(isotope-nisotopes).Symbol+' mass fraction'
    ENDIF ELSE BEGIN
        CASE isotope OF
            2*nisotopes   : ytitle='average neutrons / mb'
            2*nisotopes+2 : ytitle='stellar radius / solar radii'
            2*nisotopes+7 : ytitle='log( total angular momentum / g cm'+str_exp+'2!n s'+str_exp+'-1!n )'
            2*nisotopes+13: ytitle='moment of inertia / 10'+str_exp+'50!n g cm'+str_exp+'2!n'
            2*nisotopes+15: ytitle='stellar mass / solar masses'
            2*nisotopes+28: ytitle='total angular momentum / 10'+str_exp+'50!n g cm'+str_exp+'2!n s'+str_exp+'-1!n'
            2*nisotopes+37: ytitle='moment of inertia / stellar (mass x radius'+str_exp+'2!n)'
            2*nisotopes+38: ytitle='binding energy of the envelope (10'+str_exp+'50!nerg)'
            2*nisotopes+39: ytitle='parameter lambda'
        ENDCASE
    ENDELSE
ENDIF

y=DBLARR(nmodells)
ptime=DBLARR(nmodells)
FOR j=nfirst,nlast DO BEGIN
    n=modells(j).n
    IF (j EQ 0) THEN BEGIN
        IF (normalize NE 0) THEN BEGIN
            y0=TOTAL(modells(j).dm(0:n-1)*modells(j).yps(0:n-1,isotope))/XMSUN
        ENDIF ELSE BEGIN
            y0=1.0D0
        ENDELSE
    ENDIF
    ptime(j)=modells(j).time/SEC

    IF isotope LT nisotopes THEN BEGIN
        y(j)=TOTAL(modells(j).dm(0:n-1)*modells(j).yps(0:n-1,isotope))/(XMSUN*y0)
    ENDIF ELSE IF isotope LT 2*nisotopes THEN BEGIN
        y(j)=modells(j).yps(n-1,isotope-nisotopes)
    ENDIF ELSE BEGIN
        CASE isotope-2*nisotopes OF
            0 : y(j)=TOTAL(modells(j).dm(0:n-1)*modells(j).xnint(0:n-1))*1.0D-27/(XMSUN*modells(j).gms)
            2 : y(j)=modells(j).r(modells(j).n-1)/RSUN
            7 : y(j)=ALOG10(TOTAL(modells(j).al(0:n-1)))
            13: y(j)=TOTAL(modells(j).ai(0:n-1))*1.D-50
            15: y(j)=modells(j).xm(n-1)/xmsun
            28: y(j)=1.D-50*TOTAL(modells(j).al(0:n-1))
            37: y(j)=TOTAL(modells(j).ai(0:n-1))/(modells(j).xm(n-1)*modells(j).r(n-1)^2)
            38: BEGIN
                    y(j)=0.0D0
                    i=n-1
                    WHILE (modells(j).yps(i,1) GT 0.1D0) AND (i GT 1) DO BEGIN
                        y(j)=y(j)+GRAV*(modells(j).xm(i)+modells(j).xm(i-1))*modells(j).dm(i-1)/(modells(j).r(i)+modells(j).r(i-1))
                        i=i-1
                    ENDWHILE
                    y(j)=y(j)*1.D-50
                END
            39: BEGIN
                    y(j)=0.0D0
                    i=n-1
                    WHILE (modells(j).yps(i,1) GT 0.1D0) AND (i GT 1) DO BEGIN
                        y(j)=y(j)+GRAV*(modells(j).xm(i)+modells(j).xm(i-1))*modells(j).dm(i-1)/(modells(j).r(i)+modells(j).r(i-1))
                        i=i-1
                    ENDWHILE
                    i=MIN([n-1,i+1])
;                    y(j)=modells(j).r(i)/RSUN
                    y(j)=GRAV*modells(j).xm(i)*modells(j).gms*XMSUN/(modells(j).r(n-1)*y(j))
                END
        ENDCASE
    ENDELSE
ENDFOR

IF (uselogtime NE 0) THEN BEGIN
    ptime(nsel)=ALOG10(ptime(nlast)-ptime(nsel)+dt0)
    xrange=ptime([nfirst,nlast])
ENDIF ELSE BEGIN
    scaleaxis,ptime,istart=nfirst,iend=nlast,TITLE=xtitle,/RESCALE,RANGE=xrange,SETRANGE=1,POWERRANGE=0
ENDELSE

showmodels=0
IF N_ELEMENTS(title) EQ 0 THEN BEGIN
    title=str_exp+'models!n'
    showmodels=1
ENDIF
y=y*scale

IF over EQ 0 THEN BEGIN
    PLOT,ptime(nsel),y(nsel),TITLE=title,XTITLE=xtitle,YTITLE=ytitle,YLOG=ylog,XRANGE=xrange,YRANGE=yrange,/NODATA,NOERASE=noerase,XSTYLE=xstyle,YSTYLE=ystyle
ENDIF

IF nodata EQ 0 THEN BEGIN
    psymdot
    IF modells(nfirst).modell LE 0 THEN BEGIN
        oplot,[ptime(nfirst)],[y(nfirst)],psym=8,COLOR=color,/noclip
    ENDIF
    OPLOT,ptime(nsel),y(nsel),LINE=line,COLOR=color,PSYM=psym
    IF nlast GE nmodells-1 THEN BEGIN
        oplot,[ptime(nlast)],[y(nlast)],psym=8,COLOR=color,/noclip
    ENDIF
ENDIF

IF showmodels THEN BEGIN
    ch=CONVERT_COORD([!D.X_CH_SIZE,!D.X_CH_SIZE],/DEVICE,/TO_NORMAL)
    IF !X.TYPE EQ 0 THEN datax=!X.CRANGE ELSE datax=10D0^!X.CRANGE
    IF !Y.TYPE EQ 0 THEN datay=!Y.CRANGE ELSE datay=10D0^!Y.CRANGE
    eckpunkt=CONVERT_COORD(datax,datay,/DATA,/TO_NORMAL)
    tx=[eckpunkt(0,0),eckpunkt(0,1)]
    ty=eckpunkt(1,1)+[0.5,1.5]*ch(1)
    tt=CONVERT_COORD(tx,ty,/NORMAL,/TO_DATA)
    dtt=tt(1,1)-tt(1,0)
    FOR i=nfirst,nlast DO BEGIN
        ndtt=1+(i mod 10 EQ 0)+(i mod 100 EQ 0) + (i mod 1000 EQ 0) + (i mod 10000 EQ 0)
        ttx=dtt*ndtt*0.25
        OPLOT,ptime(i)*[1,1],tt(1,0)+[0,ttx],/NOCLIP,THICK=0
    ENDFOR
ENDIF

RETURN
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO plotiivt,LOGTIME=logtime,YRANGE=yrange

COMMON isotopes, nisotopes, isotopes

spectrum

IF (N_ELEMENTS(yrange) EQ 0) THEN yrange=[1D-10,1]

pdata =['1H'  ,'4He' ,'12C' ,'13C' ,'14N' ,'15N' ,'16O' ,'17O' ,'18O']
c=isocolors(255)
pcolor=c(1+255*FINDGEN(N_ELEMENTS(pdata))/N_ELEMENTS(pdata))

plotivt,'p',/ylog,YRANGE=yrange,ytitle='total isotope mass fraction',/NODATA,LOGTIME=logtime
legende,3,/RECHTS,/UNTEN,ypos=.05


FOR i=0,N_ELEMENTS(pdata)-1  DO BEGIN
    isotope=isotope_name2index(pdata(i))
    plotivt,pdata(i),LOGTIME=logtime,color=pcolor(i),/over
    legende_line,0,str_exp+STRING(isotopes(isotope).A,FORMAT='(I3)')+'!n'+isotopes(isotope).Symbol,COLOR=pcolor(i)
ENDFOR

RETURN
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO printiso,igrid,MODELL=modell,NR=nr,TOTAL=total,ELEMENT=element,PERCENT=percent,SPECIAL=special

COMMON stern, nmodells, modells, modell_version
COMMON isotopes, nisotopes, isotopes

IF N_ELEMENTS(nmodells) EQ 0 THEN loadmodell
IF N_ELEMENTS(total) EQ 0 THEN total=0
IF N_ELEMENTS(element) EQ 0 THEN element=0
IF N_ELEMENTS(percent) EQ 0 THEN percent=0
IF N_ELEMENTS(special) EQ 0 THEN special=0

IF N_ELEMENTS(nr) EQ 0 THEN nr=nmodells-1
nr=MIN([MAX([0,nr]),nmodells-1])
IF N_ELEMENTS(modell) NE 0 THEN BEGIN
    FOR i=nmodells-1,0,-1 DO BEGIN
        IF modells(i).modell GE modell THEN nr=i
    ENDFOR
ENDIF

IF N_ELEMENTS(igrid) EQ 0 THEN igrid=modells(nr).n-1
igrid=MIN([MAX([igrid,1]),modells(nr).n-1])

cs=['C12','O16','Ne20','Ne12','Ne22','Na23','Mg24','Mg25','Mg26']
ns=N_ELEMENTS(cs)
is=intarr(ns)
xs=dblarr(ns)

FOR i=0,nisotopes-1 DO BEGIN
    IF total THEN BEGIN
        x=0
        FOR j=0,igrid DO BEGIN
            x=x+modells(nr).yps(j,i)*modells(nr).dm(j)/XMSUN
        ENDFOR
    ENDIF ELSE BEGIN
        x=modells(nr).yps(igrid,i)
    ENDELSE
    IF special EQ 1 THEN BEGIN
        FOR j=0,ns-1 DO BEGIN
            IF isotopes(i).name EQ cs(j) THEN BEGIN
                is(j)=i
                xs(j)=x
            ENDIF
        ENDFOR
    ENDIF
    IF (NOT element) AND (NOT special) THEN BEGIN
        IF percent THEN BEGIN
            PRINT,isotopes(i).name,x*1.D2,FORMAT="('X(',A6,')=',F5.2)"
        ENDIF ELSE BEGIN
            PRINT,isotopes(i).name,x,FORMAT="('X(',A6,')=',D12.5)"
        ENDELSE
    ENDIF
ENDFOR

IF special EQ 1 THEN BEGIN
    f=STRING(ns,FORMAT="(I)")    
    PRINT,cs,FORMAT="("+f+"('& ',A4,'  '))"
    PRINT,xs*1.D2,FORMAT="("+f+"('& ',F5.2,' '))"
ENDIF

IF element THEN BEGIN
    PRINT,'NOT YET IMPLEMENTED'
ENDIF


END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO plotivm,isotope,MODELL=modell,NR=nr0,XTITLE=xtitle,YTITLE=ytitle, $
            LINE=line,COLOR=color,PSYM=psym,OVER=over,YLOG=ylog, $
            XRANGE=xrange,YRANGE=yrange,NODATA=nodata,NOERASE=noerase, $
            RADIUS=radius,YSTYLE=ystyle,XSTYLE=xstyle,SCALE=scale, $
            XDATA=x,YDATA=y,XSEL=xsel,THICK=thick,XCHARSIZE=xcharsize, $
            YCHARSIZE=ycharsize,XMARGIN=xmargin,YMARGIN=ymargin, $
            GRID=grid,TITLE=title,LOGY=logy,NOPLOT=noplot, $
            STR_LARGE=str_large, F_ROT=f_rot

COMMON stern, nmodells, modells, modell_version
COMMON isotopes, nisotopes, isotopes

@strings

@physconst

IF N_ELEMENTS(nmodells) EQ 0 THEN loadmodell

IF N_ELEMENTS(isotope) EQ 0 THEN isotope='p'
isotope=isotope_name2index(isotope)
IF isotope LT 0 THEN RETURN

IF N_ELEMENTS(nr0) EQ 0 THEN nr=nmodells-1 ELSE nr=nr0
nr=MIN([MAX([0,nr]),nmodells-1])
IF N_ELEMENTS(modell) NE 0 THEN BEGIN
    FOR i=nmodells-1,0,-1 DO BEGIN
        IF modells(i).modell GE modell THEN nr=i
    ENDFOR
ENDIF

c=isocolors(255)

IF N_ELEMENTS(f_rot) EQ 0 THEN f_rot=1/30.
IF N_ELEMENTS(title) EQ 0 THEN title=' ' 
IF N_ELEMENTS(line) EQ 0 THEN line=0 
IF N_ELEMENTS(color) EQ 0 THEN color=c(1)
IF N_ELEMENTS(psym) EQ 0 THEN psym=0 
IF N_ELEMENTS(over) EQ 0 THEN over=0 
IF N_ELEMENTS(noplot) EQ 0 THEN noplot=0 
IF N_ELEMENTS(ylog) EQ 0 THEN ylog=0 
IF N_ELEMENTS(logy) EQ 0 THEN logy=0 
IF N_ELEMENTS(xrange) EQ 0 THEN xrange=[0,0] ELSE IF N_ELEMENTS(xstyle) EQ 0 THEN xstyle=1
IF N_ELEMENTS(yrange) EQ 0 THEN yrange=[0,0] ELSE IF N_ELEMENTS(ystyle) EQ 0 THEN ystyle=1 
IF N_ELEMENTS(xstyle) EQ 0 THEN xstyle=0 
IF N_ELEMENTS(ystyle) EQ 0 THEN ystyle=0 
IF N_ELEMENTS(nodata) EQ 0 THEN nodata=0 
IF N_ELEMENTS(noerase) EQ 0 THEN noerase=0 
IF N_ELEMENTS(scale) EQ 0 THEN scale=1 
IF N_ELEMENTS(grid) EQ 0 THEN grid=0
IF N_ELEMENTS(radius) EQ 0 THEN radius=0
IF radius EQ 1 THEN BEGIN
    xtitle_default='radius / solar radii'
ENDIF ELSE IF radius EQ 2 THEN BEGIN
    xtitle_default='radius / stellar radius'
ENDIF ELSE IF grid EQ 1 THEN BEGIN
    xtitle_default='grid point'
ENDIF ELSE BEGIN
    xtitle_default='mass / solar masses'
ENDELSE
IF N_ELEMENTS(thick) EQ 0 THEN thick=!P.THICK
IF N_ELEMENTS(xmargin) EQ 0 THEN xmargin=!X.MARGIN
IF N_ELEMENTS(ymargin) EQ 0 THEN ymargin=!Y.MARGIN
IF N_ELEMENTS(xcharsize) EQ 0 THEN xcharsize=0
IF N_ELEMENTS(ycharsize) EQ 0 THEN ycharsize=0
IF N_ELEMENTS(xtitle) EQ 0 THEN xtitle='(GENERATE)'
IF N_ELEMENTS(ytitle) EQ 0 THEN ytitle='(GENERATE)'

IF xtitle EQ '(GENERATE)' THEN xtitle=xtitle_default
IF ytitle EQ '(GENERATE)' THEN BEGIN 
    IF isotope LT nisotopes THEN BEGIN
        ytitle=str_exp+STRING(isotopes(isotope).A,FORMAT='(I3)')+'!n'+isotopes(isotope).Symbol+' mass fraction'
    ENDIF ELSE BEGIN
        CASE isotope OF
            2*nisotopes+ 0 : ytitle='neutrons / mb'
            2*nisotopes+ 1 : ytitle='velocity / cm s'+str_exp+'-1!n'
            2*nisotopes+ 2 : ytitle='radius / solar radii'
            2*nisotopes+ 3 : ytitle='density / g cm'+str_exp+'-3!n'
            2*nisotopes+ 4 : ytitle='temperature / K'
            2*nisotopes+ 5 : ytitle='luminosity / solar luminosities'
            2*nisotopes+ 6 : ytitle='inner energy density / erg g'+str_exp+'-1!n'
            2*nisotopes+ 7 : ytitle='specific angular momentum / cm'+str_exp+'2!n s'+str_exp+'-1!n'
            2*nisotopes+ 8 : ytitle='old velocity'
            2*nisotopes+ 9 : ytitle='old radius'
            2*nisotopes+10 : ytitle='old density'
            2*nisotopes+11 : ytitle='old temperature'
            2*nisotopes+12 : ytitle='old luminosity'
            2*nisotopes+13 : ytitle='specific momentum of inertia / cm'+str_exp+'2!n'
            2*nisotopes+14 : ytitle='angular velocity / s'+str_exp+'-1!n'
            2*nisotopes+15 : ytitle='mass / solar masses'
            2*nisotopes+16 : ytitle='entropy / baryon'
            2*nisotopes+17 : ytitle='keplerian angular velocity / s'+str_exp+'-1!n'
            2*nisotopes+18 : ytitle='angular velocity / keplerian angular velocity'
            2*nisotopes+23 : ytitle='rotational velocity / cm s'+str_exp+'-1!n'
            2*nisotopes+24 : ytitle='escape velocity / cm s'+str_exp+'-1!n'
            2*nisotopes+28 : ytitle='angular momentum coordinate / 10'+str_exp+'50!n erg s'
            2*nisotopes+33 : ytitle='dI/dr / 10'+str_exp+'50!n cm g'
            2*nisotopes+34 : ytitle='momentum of inertia coordinate / 10'+str_exp+'50!n cm'+str_exp+'2!n g'
            2*nisotopes+35 : ytitle='dJ/dr / 10'+str_exp+'50!n g cm s'+str_exp+'-1!n'
            2*nisotopes+40 : ytitle='conv. diff. coef. / (solar masses)**2/yr'
            2*nisotopes+41 : ytitle='DS diff. coef. / (solar masses)**2/yr'
            2*nisotopes+42 : ytitle='SH diff. coef. / (solar masses)**2/yr'
            2*nisotopes+43 : ytitle='SS diff. coef. / (solar masses)**2/yr'
            2*nisotopes+44 : ytitle='ES diff. coef. / (solar masses)**2/yr'
            2*nisotopes+45 : ytitle='GSF diff. coef. / (solar masses)**2/yr'
            2*nisotopes+46 : ytitle='total diffusion coefficient / '+str_msun+str_exp+'2!n'+str_space+'yr'+str_exp+'-1!n'
            2*nisotopes+47 : ytitle='total rotational energy coordinate / 10**50 erg'
            2*nisotopes+48 : ytitle='total binding energy coordinate / 10**50 erg'
            2*nisotopes+49 : ytitle='Kelvin-Helmholtz time-scale / yr'
            2*nisotopes+50 : ytitle='Eddington-Sweet time-scale / yr'
            2*nisotopes+51 : ytitle='conv=1, sem=.5'
            2*nisotopes+52 : ytitle='C'
            2*nisotopes+53 : ytitle='N'
            2*nisotopes+54 : ytitle='O'
            2*nisotopes+55 : ytitle='He'
            2*nisotopes+56 : ytitle='Li'
            2*nisotopes+57 : ytitle='Be'
            2*nisotopes+58 : ytitle='B'
            2*nisotopes+59 : ytitle='Ne'
            2*nisotopes+60 : ytitle='Mg'
            2*nisotopes+61 : ytitle='Si'
            2*nisotopes+62 : ytitle='J / m!a(5/3)!n'
            2*nisotopes+63 : ytitle='j / m!a(2/3)!n'
            2*nisotopes+67 : ytitle=str_rho+' r!a3!n / '+str_Msun
            2*nisotopes+68 : ytitle='P / dyn cm!a2!n'
            ELSE: BEGIN
                PRINT,'ISOTOPE NOT FOUND: ',isotope
                RETURN
            END            
        ENDCASE
    ENDELSE
    IF logy THEN BEGIN
        ytitle='log('+str_space+ytitle+str_space+')'
    ENDIF
ENDIF

n=modells(nr).n
x=DBLARR(n)
IF radius EQ 1 THEN BEGIN
    x(0:n-1) = modells(nr).r(0:n-1)/RSUN
ENDIF ELSE IF radius EQ 2 THEN BEGIN
    x(0:n-1) = modells(nr).r(0:n-1)/modells(nr).r(n-1)
ENDIF ELSE IF grid EQ 1 THEN BEGIN
    x(0:n-1) = indgen(n)
ENDIF ELSE BEGIN
    x(0:n-1) = modells(nr).xm(0:n-1)/XMSUN
ENDELSE
y=DBLARR(n)
IF isotope LT nisotopes THEN BEGIN
    y(0:n-1)=modells(nr).yps(0:n-1,isotope)
ENDIF ELSE BEGIN
    CASE isotope OF
        2*nisotopes+ 0 : y(0:n-1)=modells(nr).xnint(0:n-1)/1D27
        2*nisotopes+ 1 : y(0:n-1)=modells(nr).u(0:n-1)
        2*nisotopes+ 2 : y(0:n-1)=modells(nr).r(0:n-1)/RSUN
        2*nisotopes+ 3 : y(0:n-1)=modells(nr).ro(0:n-1)
        2*nisotopes+ 4 : y(0:n-1)=modells(nr).t(0:n-1)
        2*nisotopes+ 5 : y(0:n-1)=modells(nr).sl(0:n-1)/XLSUN
        2*nisotopes+ 6 : y(0:n-1)=modells(nr).e(0:n-1)
        2*nisotopes+ 7 : BEGIN y(0:n-2)=modells(nr).al(0:n-2)/(modells(nr).dm(0:n-2)) & y(n-1)=y(n-2) & END
        2*nisotopes+ 8 : y(0:n-1)=modells(nr).vu(0:n-1)
        2*nisotopes+ 9 : y(0:n-1)=modells(nr).vr(0:n-1)/RSUN
        2*nisotopes+10 : y(0:n-1)=modells(nr).vro(0:n-1)
        2*nisotopes+11 : y(0:n-1)=modells(nr).vt(0:n-1)
        2*nisotopes+12 : y(0:n-1)=modells(nr).vsl(0:n-1)/XLSUN
        2*nisotopes+13 : BEGIN y(0:n-2)=modells(nr).ai(0:n-2)/(modells(nr).dm(0:n-2)) & y(n-1)=y(n-2) & END
        2*nisotopes+14 : y(0:n-1)=modells(nr).aw(0:n-1)
        2*nisotopes+15 : y(0:n-1)=modells(nr).xm(0:n-1)/XMSUN
        2*nisotopes+16 : y(0:n-1)=modells(nr).entrop(0:n-1)
        2*nisotopes+17 : y(0:n-1)=SQRT(GRAV*modells(nr).xm(0:n-1)/modells(nr).r(0:n-1)^3)
        2*nisotopes+18 : y(0:n-1)=modells(nr).aw(0:n-1)/SQRT(GRAV*modells(nr).xm(0:n-1)/modells(nr).r(0:n-1)^3)
        2*nisotopes+23 : y(0:n-1)=modells(nr).aw(0:n-1)*modells(nr).r(0:n-1)
        2*nisotopes+24 : y(0:n-1)=SQRT(2.0D0*GRAV*modells(nr).xm(0:n-1)/modells(nr).r(0:n-1))
        2*nisotopes+28 : BEGIN y(0)=0.0D0 & FOR i=1,n-1 DO y(i)=y(i-1)+modells(nr).al(i-1)*1.0D-50 & END
        2*nisotopes+33 : y(0:n-1)=0.67*4*!DPi*modells(nr).r(0:n-1)^4*modells(nr).ro(0:n-1)*1.D-50
        2*nisotopes+34 : BEGIN y(0)=0.0D0 & FOR i=1,n-1 DO y(i)=y(i-1)+modells(nr).ai(i-1)*1.0D-50 & END
        2*nisotopes+35 : BEGIN y(0:n-2)=modells(nr).al(0:n-2)/(modells(nr).dm(0:n-2))*4*!DPi*modells(nr).ro(0:n-2)*(modells(nr).r(0:n-2)^5+modells(nr).r(1:n-1)^5)^(0.4)*1D-50 & y(n-1)=y(n-2) & END
        2*nisotopes+40 : y(0:n-1)=modells(nr).diff(0:n-1)*(modells(nr).xm(n-1))^2*SEC/XMSUN^2
        2*nisotopes+41 : y(0:n-1)=modells(nr).d(0,0:n-1)*(4.D0*!DPI*modells(nr).r(0:n-1)^2*modells(nr).ro(0:n-1))^2*SEC/XMSUN^2
        2*nisotopes+42 : y(0:n-1)=modells(nr).d(1,0:n-1)*(4.D0*!DPI*modells(nr).r(0:n-1)^2*modells(nr).ro(0:n-1))^2*SEC/XMSUN^2
        2*nisotopes+43 : y(0:n-1)=modells(nr).d(2,0:n-1)*(4.D0*!DPI*modells(nr).r(0:n-1)^2*modells(nr).ro(0:n-1))^2*SEC/XMSUN^2
        2*nisotopes+44 : y(0:n-1)=modells(nr).d(3,0:n-1)*(4.D0*!DPI*modells(nr).r(0:n-1)^2*modells(nr).ro(0:n-1))^2*SEC/XMSUN^2
        2*nisotopes+45 : y(0:n-1)=modells(nr).d(4,0:n-1)*(4.D0*!DPI*modells(nr).r(0:n-1)^2*modells(nr).ro(0:n-1))^2*SEC/XMSUN^2
        2*nisotopes+46 : y(0:n-1)=(f_rot*modells(nr).dg(0:n-1)*(4.D0*!DPI*modells(nr).r(0:n-1)^2*modells(nr).ro(0:n-1))^2+modells(nr).diff(0:n-1)*(modells(nr).xm(n-1))^2)*SEC/XMSUN^2
        2*nisotopes+47 : BEGIN y(0)=0 & FOR i=1,n-1 DO y(i)=y(i-1)+0.5*modells(nr).al(i-1)*modells(nr).aw(i-1)*1.D-50 & END
        2*nisotopes+48 : BEGIN y(0)=0 & FOR i=1,n-1 DO y(i)=y(i-1)+GRAV*modells(nr).dm(i)*(modells(nr).xm(i)+modells(nr).xm(i-1))/(modells(nr).r(i)+modells(nr).r(i-1))*1.D-50 & END
        2*nisotopes+49 : y(0:n-1)=GRAV*modells(nr).xm(0:n-1)^2/(modells(nr).sl(0:n-1)*modells(nr).r(0:n-1))/SEC
        2*nisotopes+50 : y(0:n-1)=GRAV^2*modells(nr).xm(0:n-1)^3/(modells(nr).sl(0:n-1)*modells(nr).r(0:n-1)^4*modells(nr).aw(0:n-1)^2)/SEC
        2*nisotopes+51 : BEGIN y(0:n-1)=0 & xc=WHERE(modells(nr).yzi(0:n-1) EQ 'C') & IF xc(0) NE -1 THEN y(xc)=1. & xc=WHERE(modells(nr).yzi(0:n-1) EQ 'S') & IF xc(0) NE -1 THEN y(xc)=.5 & END
        2*nisotopes+52 : y(0:n-1)=TOTAL(modells(nr).yps(0:n-1,12:14),2)
        2*nisotopes+53 : y(0:n-1)=TOTAL(modells(nr).yps(0:n-1,15:17),2)
        2*nisotopes+54 : y(0:n-1)=TOTAL(modells(nr).yps(0:n-1,18:20),2)
        2*nisotopes+55 : y(0:n-1)=TOTAL(modells(nr).yps(0:n-1,3:4),2)
        2*nisotopes+56 : y(0:n-1)=TOTAL(modells(nr).yps(0:n-1,5:6),2)
        2*nisotopes+57 : y(0:n-1)=TOTAL(modells(nr).yps(0:n-1,7:8),2)
        2*nisotopes+58 : y(0:n-1)=TOTAL(modells(nr).yps(0:n-1,9:11),2)
        2*nisotopes+59 : y(0:n-1)=TOTAL(modells(nr).yps(0:n-1,21:23),2)
        2*nisotopes+60 : y(0:n-1)=TOTAL(modells(nr).yps(0:n-1,25:27),2)
        2*nisotopes+61 : y(0:n-1)=TOTAL(modells(nr).yps(0:n-1,29:31),2)
        2*nisotopes+62 : BEGIN y(0)=0 & FOR i=1,n-1 DO y(i)=y(i-1)+modells(nr).al(i-1) & y=y/modells(nr).xm^(5.D0/3.D0) & y(0)=y(1) & END
        2*nisotopes+63 : BEGIN y(0:n-2)=modells(nr).aw(0:n-2)*modells(nr).r(1:n-1)^2*2./3./modells(nr).xm(1:n-1)^(2.D0/3.D0) & y(n-1)=y(n-2) & END
        2*nisotopes+67 : BEGIN y(0:n-2)=modells(nr).ro(0:n-2)*(modells(nr).r(0:n-2)^3+modells(nr).r(1:n-1)^3)/XMSUN & y(n-1)=y(n-2) & END
        2*nisotopes+68 : y(0:n-1)=modells(nr).p(0:n-1)
    ENDCASE
ENDELSE

y=y*scale
IF logy THEN BEGIN
    y=ALOG10(y)
ENDIF

n0=0
n1=n-1
IF N_ELEMENTS(xsel) EQ 2 THEN BEGIN
    WHILE x(n0) LT xsel(0) DO n0=n0+1
    WHILE x(n1) GT xsel(1) DO n1=n1-1
ENDIF

xdata=y
ydata=y

IF noplot THEN RETURN

spectrum

IF over EQ 0 THEN BEGIN
    PLOT,x(n0:n1),y(n0:n1),XTITLE=xtitle,YTITLE=ytitle,YLOG=ylog,XRANGE=xrange,YRANGE=yrange,/NODATA,NOERASE=noerase,YSTYLE=ystyle,XSTYLE=xstyle,XCHARSIZE=xcharsize,YCHARSIZE=ycharsize,XMARGIN=xmargin,YMARGIN=ymargin,TITLE=title
ENDIF

IF nodata EQ 0 THEN BEGIN
    OPLOT,x(n0:n1),y(n0:n1),LINE=line,COLOR=color,PSYM=psym,THICK=thick
ENDIF

END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO plotiivm,MODELL=modell,NR=nr,RADIUS=radius,YRANGE=yrange,XRANGE=xrange,YLOG=ylog,YTITLE=ytitle,DATA=data,STR_LARGE=str_large

COMMON isotopes, nisotopes, isotopes

IF N_ELEMENTS(large) NE 0 THEN str_large=large
@strings

IF N_ELEMENTS(xrange) EQ 0 THEN xrange=[0,0]
IF N_ELEMENTS(yrange) EQ 0 THEN yrange=[1D-10,1]
IF N_ELEMENTS(ylog) EQ 0 THEN ylog=1
spectrum

IF N_ELEMENTS(data) EQ 0 THEN data=0


CASE data OF
    0:pdata =['1H'  ,'4He' ,'12C' ,'13C' ,'14N' ,'15N' ,'16O' ,'17O' ,'18O']
    1:pdata =['diff'  ,'d1' ,'d2' ,'d3' ,'d4' ,'d5' ]
    2:pdata =['4He'  ,'2H' ,'3He' ,'6Li' ,'7Li' ,'9Be' ,'10B' ,'11B']
    3:pdata =['4He'  ,'Ne20' ,'Ne21' ,'Ne22' ,'Na23' ,'Mg24' ,'Mg25', 'Mg26', 'Al26', 'Al27']
    4:pdata =['1H'  ,'3He' ,'4He' ,'12C' ,'13C' ,'14N' ,'15N' ,'16O' ,'17O' ,'18O']
ENDCASE
c=isocolors(255)
pcolor=c(1+255*FINDGEN(N_ELEMENTS(pdata))/N_ELEMENTS(pdata))

IF N_ELEMENTS(ytitle) EQ 0 THEN BEGIN
    CASE data OF
        0:ytitle='isotope mass fraction'
        1:ytitle='diffusion coefficient'
        2:ytitle='isotope mass fraction'
        3:ytitle='isotope mass fraction'
        4:ytitle='isotope mass fraction'
    ENDCASE    
ENDIF

plotivm,'p',MODELL=modell,NR=nr,YLOG=ylog,YRANGE=yrange,XRANGE=xrange,YTITLE=ytitle,/NODATA
legende,/links,/oben,ypos=0.85

FOR i=0,N_ELEMENTS(pdata)-1  DO BEGIN
    isotope=isotope_name2index(pdata(i))
    plotivm,pdata(i),MODELL=modell,NR=nr,color=pcolor(i),/over,RADIUS=radius 
    plotivm,pdata(i),MODELL=modell,NR=nr,color=pcolor(i),/over,RADIUS=radius,PSYM=3
    CASE data OF
        0: leg=str_exp+STRING(isotopes(isotope).A,FORMAT='(I3)')+'!n'+isotopes(isotope).Symbol
        1: leg=pdata(i)
        2: leg=str_exp+STRING(isotopes(isotope).A,FORMAT='(I3)')+'!n'+isotopes(isotope).Symbol
        3: leg=str_exp+STRING(isotopes(isotope).A,FORMAT='(I3)')+'!n'+isotopes(isotope).Symbol
        4: leg=str_exp+STRING(isotopes(isotope).A,FORMAT='(I3)')+'!n'+isotopes(isotope).Symbol
    ENDCASE
    legende_line,0,leg,COLOR=pcolor(i)
ENDFOR

RETURN
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO surfabu,n

COMMON stern, nmodells, modells, modell_version

xhes=0.28D0
xcs=3.4800D-03
xns=1.0300D-03
xos=9.9800D-03

i=nmodells-1
IF N_ELEMENTS(n) EQ 0 THEN n=modells.n-1

xhe=modells(i).yps(n,4) 
xc=modells(i).yps(n,13) 
xn=modells(i).yps(n,16) 
xo=modells(i).yps(n,18) 

print,'He',xhe

print,'N/C',xn/xc
print,'N/O',xn/xo
print,'C/O',xc/xo

print,'[He]',alog10((xhe)/(xhes))

print,'[N/C]',alog10((xn/xc)/(xns/xcs))
print,'[N/O]',alog10((xn/xo)/(xns/xos))
print,'[C/O]',alog10((xc/xo)/(xcs/xos))

print,'C:N:O       ','1:',xn/xc,":",xo/xc


END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO plotivmm,isotope,YRANGE=yrange,YLOG=ylog,YSTYLE=ystyle,XSTYLE=xstyle,PMODELLS=pmodells,XRANGE=xrange,PSTEP=pstep,RADIUS=radius

COMMON stern, nmodells, modells, modell_version

spectrum

IF N_ELEMENTS(pstep) EQ 0 THEN pstep=1
pstep=MAX([1,FIX(pstep)])
IF N_ELEMENTS(pmodells) EQ 0 THEN pmodells=12
pmodells=MIN([nmodells/pstep,MAX([2,pmodells])])

c=isocolors(255)
x=isotope

plotivm,x,MODELL=modell,NR=nmodells-1+(1-pmodells)*pstep,/NODATA,YRANGE=yrange,YLOG=ylog,YSTYLE=ystyle,XSTYLE=xstyle,XRANGE=xrange,RADIUS=radius
;LEGENDE,14,/RECHTS,/oben
LEGENDE,2,/RECHTS,/oben
FOR j=1,pmodells DO BEGIN 
    x=isotope 
    color=c(1+FIX((255./pmodells)*(j-1)))
    nr=nmodells-1+(j-pmodells)*pstep
    plotivm,x,NR=nr,COLOR=color,/over,RADIUS=radius
    tyr=modells(nr).time/3.1556926D7
    timeexp=MAX([0,FIX(ALOG10(tyr))])
    timeman=tyr*10.0D0^(-timeexp)
;    LEGENDE_LINE,0,STRING(timeman,FORMAT='(F8.6)')+'x10'+str_exp+STRING(timeexp,FORMAT='(I1)')+'!n yr',COLOR=color
;    LEGENDE_LINE,0,STRING(j,FORMAT='(I2)'),COLOR=color
ENDFOR

END


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO eenv,x,xm

@physconst

COMMON stern, nmodells, modells, modell_version

IF N_ELEMENTS(x) EQ 0 THEN x=1.D-1
IF N_ELEMENTS(xm) EQ 0 THEN xm=0

i1h=isotope_name2index('1H')
i4he=isotope_name2index('4He')
im=nmodells-1

n=modells(im).n-1
i=n
e=0.0D0
xe=DBLARR(n+1)
xee=DBLARR(n+1)
xek=DBLARR(n+1)
xeg=DBLARR(n+1)
xer=DBLARR(n+1)
xei=DBLARR(n+1)
xep=DBLARR(n+1)
xej=DBLARR(n+1)

WHILE (i GT 1) AND (modells(im).yps(i-1,i1h) GT x) AND (modells(im).xm(i-1) GT xm*XMSUN)  DO BEGIN
    i=i-1
;WHILE (i GE 0) DO BEGIN
;    vmu=calcvmu(modells(im).yps(i,*))
;    eion=calceion(modells(im).yps(i,*))

    SAHA,modells(im).t(i),modells(im).ro(i),modells(im).yps(i:i,*),eion,vmu

    ee=0.0D0
;gas energy
    xeg(i)=1.5*RK*modells(im).T(i)*vmu
;radiation energy
    xer(i)=ARAD/modells(im).ro(i)*modells(im).T(i)^4
;(radial) kinetic energy
    xek(i)=0.125D0*(modells(im).u(i+1)+modells(im).u(i))^2
;rotation energy
    IF (modells(im).dm(i)) GT 0.0D0 THEN BEGIN
        xej(i)=modells(im).aw(i+1)*modells(im).al(i+1)*0.5D0/modells(im).dm(i)
    ENDIF
;recombination energy
    xei(i)=eion
;gravitation
    xep(i)=-GRAV*modells(im).xm(i)*(2.0D0/(modells(im).r(i+1)^3+modells(im).r(i)^3))^(1.0D0/3.0D0)
    
    ee=xeg(i)+xer(i)+xek(i)+xei(i)+xep(i)+xej(i)

    e=e+ee*modells(im).dm(i)
    xee(i)=ee
    xe(i)=e/1d50

ENDWHILE

i=max([i,0])

print,'bottom of envelope is at m=',modells(im).xm(i)/XMSUN,' M_sun'
print,'bottom of envelope is at X=',modells(im).yps(i,i1h)
print,'bottom of envelope is at R_i=',modells(im).r(i)/RSUN,' R_sun'
print,'mass of envelope is M_env=',modells(im).gms-modells(im).xm(i)/XMSUN,' M_sun'
print,'current stellar mass is M=',modells(im).gms,' M_sun'
print,'current stellar radius is R=',modells(im).r(n)/RSUN,' R_sun'
print,'total gravitational energy is',TOTAL(xep(0:n-1)*modells(im).dm(0:n-1)),' erg'
print,'total gas energy is',TOTAL(xeg(0:n-1)*modells(im).dm(0:n-1)),' erg'
print,'total radiation energy is',TOTAL(xer(0:n-1)*modells(im).dm(0:n-1)),' erg'
print,'total ionization energy is',TOTAL(xei(0:n-1)*modells(im).dm(0:n-1)),' erg'
print,'total kinetic energy is',TOTAL(xek(0:n-1)*modells(im).dm(0:n-1)),' erg'
print,'total rotation energy is',TOTAL(xej(0:n-1)*modells(im).dm(0:n-1)),' erg'
print,'total energy=',e,' erg'
simple=-GRAV*modells(im).gms*XMSUN*(modells(im).gms*XMSUN-modells(im).xm(i))/modells(im).r(n-1)
print,'-G M M_env/R=',simple,' erg'
print,'lambda is',simple/e


;PLOT,modells(im).xm(0:modells(im).n-2)/XMSUN,xe,/ystyle,psym=1
;PLOT,modells(im).xm(0:modells(im).n-2)/XMSUN,xee,xr=[8.5,12]

spectrum
c=isocolors(255)

PLOT,modells(im).xm(0:modells(im).n-2)/XMSUN,-xep,/ylog,yr=[1.D10,1.D17],/ys,COLOR=!P.COLOR
OPLOT,modells(im).xm(0:modells(im).n-2)/XMSUN,xeg,COLOR=c(1)
OPLOT,modells(im).xm(0:modells(im).n-2)/XMSUN,xer,COLOR=c(50)
OPLOT,modells(im).xm(0:modells(im).n-2)/XMSUN,xei,COLOR=c(100)
OPLOT,modells(im).xm(0:modells(im).n-2)/XMSUN,xek,COLOR=c(150)
OPLOT,modells(im).xm(0:modells(im).n-2)/XMSUN,xej,COLOR=c(200)


LEGENDE,/LEFT,/BOTTOM
LEGENDE_LINE,0,'GRAV',COLOR=!P.COLOR
LEGENDE_LINE,0,'GAS',COLOR=c(1)
LEGENDE_LINE,0,'RAD',COLOR=c(50)
LEGENDE_LINE,0,'ION',COLOR=c(100)
LEGENDE_LINE,0,'KIN',COLOR=(150)
LEGENDE_LINE,0,'ROT',COLOR=c(200)

END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO modeldata

COMMON stern, nmodells, modells, modell_version
@physconst

m=nmodells-1
xj=0.0D0
FOR i=1,modells(m).n-1 DO BEGIN
    xj=xj+modells(m).al(i)
    PRINT,i,modells(m).xm(i)/XMSUN,xj,modells(m).yps(i,[1,4,13]),modells(m).ro(i),modells(m).r(i),FORMAT="(I4,7(E12.3))"
ENDFOR

END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO al26

COMMON stern, nmodells, modells, modell_version
COMMON isotopes, nisotopes, isotopes
@physconst


mal26=0.0D0
mf19=0.0D0

n=nmodells-1

FOR i=0,modells(n).n-2 DO BEGIN
    mal26=mal26+modells(n).yps(i,34)*modells(n).dm(i)
    mf19=mf19+modells(n).yps(i,33)*modells(n).dm(i)
ENDFOR

print,'al26',mal26/xmsun
print,'f19',mf19/xmsun


END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO loadmodell,name,FIRSTMODELL=firstmodell,LASTMODELL=lastmodell,SELECTION=selection,ENTROPY=entropy,STEPMODELL=stepmodell,RECENT=recent

;i=0 & n=modells(i).n & dwdr=dblarr(n) & dwdr(1:n-2)=(modells(i).aw(2:n-1)-modells(i).aw(0:n-3))*modells(i).r(1:n-2)/(modells(i).r(2:n-1)-modells(i).r(0:n-3)) & dwdr(2:n-3)=0.2*(dwdr(0:n-5)+dwdr(1:n-4)+dwdr(2:n-3)+dwdr(3:n-2)+dwdr(4:n-1))  

@physconst

COMMON stern, nmodells, modells, modell_version
COMMON readmodell, filename
COMMON isotopes, nisotopes, isotopes

;name='/afs/ipp-garching.mpg.de/u/aeh/g:M=20,logZ=-4,Omega=moderate,14N/mod.data'
;name='$HOME/IPP/g:M=20,logZ=-4,Omega=moderate,14N/mod.data'
;name='$HOME/Stern/rechnungen/test/mod.data'
;name='$HOME/Stern/rechnungen/Test/mod.data'
;name='$HOME/Stern/rechnungen/Test2/mod.data'
;name='$HOME/Stern/rechnungen/Test/6700'
;name='$HOME/Stern/rechnungen/Test/mod.data'
;name='$HOME/Stern/rechnungen/i:M=30,logZ=-6,Omega=0,II/mod.data'
;name='$HOME/Stern/rechnungen/h:M=30,logZ=-6,Omega=0/mod.data'
;name='$HOME/Stern/rechnungen/g:M=20,logZ=-4,Omega=moderate,14N/mod.data'
;name='$HOME/Stern/rechnungen/test/mod.data'

IF (N_ELEMENTS(name) EQ 0) AND (N_ELEMENTS(filename) NE 0) THEN name=filename
IF N_ELEMENTS(name) EQ 0 THEN name='mod.bin'
xxx=FINDFILE(name,COUNT=xxx_count)
IF (xxx_count EQ 0) OR (name EQ '') THEN BEGIN
    name=PICKFILE(/NOCONFIRM,/READ,/MUST_EXIST,FILTER='*')
    IF name EQ '' THEN RETURN
ENDIF
filename=name

IF N_ELEMENTS(lastmodell) EQ 0 THEN lastmodell=9999999L
IF N_ELEMENTS(firstmodell) EQ 0 THEN firstmodell=-9999999L
IF N_ELEMENTS(stepmodell) EQ 0 THEN stepmodell=1L
IF N_ELEMENTS(recent) EQ 0 THEN recent=0L
stepmodell=MAX([1,stepmodell])

IF N_ELEMENTS(entropy) EQ 0 THEN entropy=0

n_selection = N_ELEMENTS(selection)
IF (n_selection NE 0) THEN BEGIN
    selection=selection(SORT(selection))
    selection=selection(UNIQ(selection))
    n_selection = N_ELEMENTS(selection)
    selection_pos0=REPLICATE(-1L,n_selection)
    firstmodell=selection(0)
    lastmodell=selection(n_selection-1)
ENDIF

OPENR,unit,name,/GET_LUN,/SWAP_IF_LITTLE_ENDIAN

nvers=0L
n=0L
nsp1=0L
modell=-999999L
gms=0.0D0
time=0.0D0
dtn=0.0D0
dtneu=0.0D0
vvcmax=0.0D0
ztsp=' '
dmsv=0.0D0

PRINT,"counting models..."
nmax=0
nsp1max=0
x=fstat(unit)
pos=0L
pos0=0L
i_selection=0
nmox=5
recsize=0L
selpos=lonarr(1000)
selmod=lonarr(1000)
nmodells=0L

WHILE (pos LT x.size-48) AND (modell LT lastmodell) DO BEGIN
    point_lun,unit,pos
    READU,unit,recsize,nvers,n,nsp1,modell,gms,time,dtn
    recsize=recsize+8L
    IF (modell GE firstmodell) AND ((pos+recsize) LE x.size) THEN BEGIN
        will_read = 1
    ENDIF ELSE BEGIN
        will_read=0
    ENDELSE
    IF (will_read GT 0) AND (firstmodell GE -1) AND ((firstmodell MOD stepmodell) NE (modell MOD stepmodell)) THEN will_read=0
    IF (n_selection GT 0) AND (will_read GT 0) THEN BEGIN
        IF modell GT selection(i_selection) THEN BEGIN
            PRINT,'selected modell not found (',selection(i_selection),')'
            RETURN
        ENDIF 
        IF modell LT selection(i_selection) THEN BEGIN
            will_read = 0
        ENDIF ELSE BEGIN
            i_selection=i_selection+1
        ENDELSE
    ENDIF

    IF will_read NE 0 THEN BEGIN
        IF recent NE 0 THEN BEGIN
            nmax=n
            nsp1max=nsp1
            nmodells=1
            selpos(0)=pos
            selmod(0)=modell
        ENDIF ELSE BEGIN
            nmax=MAX([nmax,n])
            nsp1max=MAX([nsp1max,nsp1])
            selpos(nmodells)=pos
            selmod(nmodells)=modell
            nmodells=nmodells+1
        ENDELSE        
    ENDIF
    
    pos=pos+recsize
ENDWHILE

FOR i=0,nmodells-1 DO BEGIN
    PRINT,'will read model ',selmod(i),' as nr ',i
ENDFOR

modell_version=nvers
PRINT,nmodells,' models,',nsp1max, ' isotopes, ',nmax,' grid points'

modells=REPLICATE({nvers:0L,n:0L,nsp1:0L,modell:0L,gms:0.0D0, $
                   time:0.0D0,dtn:0.0D0, $
                   dtneu:0.0D0, vvcmax:0.0D0,dmsv:0.0D0, $
                   dm:DBLARR(nmax), $
                   xm:DBLARR(nmax),u:DBLARR(nmax), $
                   r:DBLARR(nmax),ro:DBLARR(nmax), $
                   t:DBLARR(nmax),sl:DBLARR(nmax), $
                   e:DBLARR(nmax),al:DBLARR(nmax), $
                   vu:DBLARR(nmax),vr:DBLARR(nmax), $
                   vro:DBLARR(nmax),vt:DBLARR(nmax), $
                   vsl:DBLARR(nmax),yzi:REPLICATE(' ',nmax), $
                   p:DBLARR(nmax),enucl:DBLARR(nmax), $
                   diff:DBLARR(nmax),dg:DBLARR(nmax), $
                   d:DBLARR(nmox,nmax),yps:DBLARR(nmax,nsp1max), $
                   xnint:DBLARR(nmax),ver:DBLARR(nsp1max), $
                   istory:LONARR(nmax),insrt:LONARR(nmax), $
                   indel:LONARR(nmax),ztsp:' ', $
                   ai:DBLARR(nmax),aw:DBLARR(nmax), $
                   entrop:DBLARR(nmax)},nmodells)

PRINT,"reading models..."
FOR i=0,nmodells-1 DO BEGIN
    pos=selpos(i)
    POINT_LUN,unit,pos
    READU,unit,recsize,nvers,n,nsp1
    recsize=recsize+8L
    if nvers EQ 10001 THEN variables=REPLICATE({vars : DBLARR(13),convs : ' ',chemics : DBLARR(nsp1),vars2 : DBLARR(1)},n)
    if nvers GE 10100 THEN variables=REPLICATE({vars : DBLARR(13),convs : ' ',diffs : DBLARR(7),chemics : DBLARR(nsp1),vars2 : DBLARR(1)},n)
    if nvers GE 10200 THEN variables=REPLICATE({vars : DBLARR(13),convs : ' ',grids : DBLARR(2),diffs : DBLARR(7),chemics : DBLARR(nsp1),vars2 : DBLARR(1)},n)
    loss=DBLARR(nsp1)
;    POINT_LUN,unit,pos+16L
    IF nvers LT 10200 THEN BEGIN
        READU,unit,modell,gms,time,dtn,variables,loss
    ENDIF ELSE BEGIN
        ivar=REPLICATE({grid : LONARR(3)},n)
        READU,unit,modell,gms,time,dtn,dtneu,vvcmax,dmsv,variables,loss,ivar,ztsp
    ENDELSE
    modells(i).nvers=nvers
    modells(i).n=n
    modells(i).nsp1=nsp1
    modells(i).modell=modell
    modells(i).gms=gms
    modells(i).time=time
    modells(i).dtn=dtn
    IF nvers LT 10201 THEN BEGIN
        modells(i).dm(0:n-1)=variables(0:n-1).vars(0)*gms*XMSUN
    ENDIF ELSE BEGIN
        modells(i).dm(0:n-1)=variables(0:n-1).vars(0)
    ENDELSE
    modells(i).u(0:n-1)=variables(0:n-1).vars(1)
    modells(i).r(0:n-1)=variables(0:n-1).vars(2)
    modells(i).ro(0:n-1)=variables(0:n-1).vars(3)
    modells(i).t(0:n-1)=variables(0:n-1).vars(4)
    modells(i).sl(0:n-1)=variables(0:n-1).vars(5)
    modells(i).e(0:n-1)=variables(0:n-1).vars(6)
    modells(i).al(0:n-1)=variables(0:n-1).vars(7)
    modells(i).vu(0:n-1)=variables(0:n-1).vars(8)
    modells(i).vr(0:n-1)=variables(0:n-1).vars(9)
    modells(i).vro(0:n-1)=variables(0:n-1).vars(10)
    modells(i).vt(0:n-1)=variables(0:n-1).vars(11)
    modells(i).vsl(0:n-1)=variables(0:n-1).vars(12)
    modells(i).yzi(0:n-1)=variables(0:n-1).convs
    FOR j=0,nsp1-1 DO BEGIN
        modells(i).yps(0:n-1,j)=variables(0:n-1).chemics(j)
    ENDFOR
    modells(i).xnint(0:n-1)=variables(0:n-1).vars2(0)
    modells(i).ver(0:nsp1-1)=loss(0:nsp1-1)

;.... updates
    IF nvers GE 10100 THEN BEGIN
        modells(i).diff(0:n-1)=variables(0:n-1).diffs(0)        
        modells(i).dg(0:n-1)=variables(0:n-1).diffs(1)
        FOR j=0,NMOX-1 DO BEGIN
            modells(i).d(j,0:n-1)=variables(0:n-1).diffs(2+j)
        ENDFOR
    ENDIF

    IF (nvers GE 10200) THEN BEGIN
        modells(i).dtneu=dtneu
        modells(i).vvcmax=vvcmax
        modells(i).dmsv=dmsv
        modells(i).p(0:n-1)=variables(0:n-1).grids(0)
        modells(i).enucl(0:n-1)=variables(0:n-1).grids(1)
        modells(i).istory(0:n-1)=ivar(0:n-1).grid(0)
        modells(i).insrt(0:n-1)=ivar(0:n-1).grid(1)
        modells(i).indel(0:n-1)=ivar(0:n-1).grid(2)
        modells(i).ztsp=ztsp
    ENDIF
    IF (nvers LT 10202) THEN BEGIN
        modells(i).al(0:n-2)=modells(i).al(1:n-1)
        modells(i).al(n-1)=1.D0
    ENDIF

    modells(i).ai(0:n-2)=calcai(modells(i).r(0:n-2),modells(i).r(1:n-1),modells(i).dm(0:n-2))
    modells(i).ai(n-1)=1D-20
    modells(i).aw(0:n-1)=modells(i).al(0:n-1)/modells(i).ai(0:n-1)
    modells(i).aw(n-1)=modells(i).aw(n-2)
    modells(i).al(n-1)=modells(i).aw(n-1)*modells(i).ai(n-1)

    modells(i).xm(0) =0.0D0
    FOR j=1,n-1 DO BEGIN
        modells(i).xm(j)=modells(i).xm(j-1)+modells(i).dm(j-1)
    ENDFOR

    PRINT,modell,'  version=',nvers
    
ENDFOR

CLOSE,unit
FREE_LUN,unit

isotopes

IF entropy THEN BEGIN
    PRINT,'computing entropie...'
    FOR i=0,nmodells-1 DO BEGIN
        FOR j=0,modells(i).n-1 DO BEGIN
            modells(i).entrop(j)=calcentropy(modells(i).yps(j,*),modells(i).t(j),modells(i).ro(j))
        ENDFOR
    ENDFOR
ENDIF

END
