FUNCTION lambda,t,a

x13=1.0D0/3.0D0
t9=t*1.D-9
t913=t9^x13

lambda=EXP(a(0)+a(1)/t9+a(2)/t913+a(3)*t913+a(4)*t9+a(5)*t913^5+a(6)*ALOG(t9))

RETURN,lambda
END

;=======================================================================


FUNCTION readtable1,file,offset

template={VERSION: 1.0, $
         DATASTART: 9L, $
         DELIMITER: 0B, $
         MISSINGVALUE: !VALUES.F_NAN, $
         COMMENTSYMBOL: '--', $
         FIELDCOUNT: [4L], $
         FIELDTYPES: [7,7,5,5], $
         FIELDNAMES: ['ref','rate','Q','a1'], $
         FIELDLOCATIONS: [0,1,16,29], $
         FIELDGROUPS: INDGEN(4)}

x=READ_ASCII(file,TEMPLATE=template)

n=N_ELEMENTS(x.A1)

p1=STRPOS(x.RATE,'(')
e=STRARR(n)
FOR i=0,n-1 DO BEGIN
    e(i)=STRMID(x.RATE(i),0,p1(i))
ENDFOR

z={REF: x.REF, $
   EDUCTS: e, $
   RATE: x.RATE, $
   A: DBLARR(n,7)}
z.A(0:n-1,0)=x.A1(0:n-1)
   
RETURN,z
END

;=======================================================================

FUNCTION readtable7,file,offset

template={VERSION: 1.0, $
         DATASTART: 11L, $
         DELIMITER: 0B, $
         MISSINGVALUE: !VALUES.F_NAN, $
         COMMENTSYMBOL: '--', $
         FIELDCOUNT: [9L], $
         FIELDTYPES: [7,7,5,5,5,5,5,5,5], $
         FIELDNAMES: ['ref','rate','a1','a2','a3','a4','a5','a6','a7'], $
         FIELDLOCATIONS: [0,8,30,43,56,69,83,96,109], $
         FIELDGROUPS: INDGEN(9)}

template.FIELDLOCATIONS(2:8)=template.FIELDLOCATIONS(2:8)+offset

x=READ_ASCII(file,TEMPLATE=template)

n=N_ELEMENTS(x.A1)

p1=STRPOS(x.RATE,' -> ')
e=STRARR(n)
FOR i=0,n-1 DO BEGIN
    e(i)=STRMID(x.RATE(i),0,p1(i))
ENDFOR

z={REF: x.REF, $
   EDUCTS: e, $
   RATE: x.RATE, $
   A: [[x.A1],[x.A2],[x.A3],[x.A4],[x.A5],[x.A6],[x.A7]]}

RETURN,z
END

;=======================================================================

PRO readtables

COMMON nuclear, rate

@nuclear_dir

offset=[0,0,3,0,3,6,9,9]
neducts=[1,1,1,2,2,2,2,3]
nproducts=[1,2,3,1,2,3,4,2]

n=0
FOR i=1,8 DO BEGIN
    PRINT,'reading table ',i,' ...'
    IF (i EQ 1) THEN BEGIN
        x=readtable1(dir+'rate'+STRING(i,FORMAT='(I1)')+'.txt',offset(i-1))
    ENDIF ELSE BEGIN
        x=readtable7(dir+'rate'+STRING(i,FORMAT='(I1)')+'.txt',offset(i-1))
    ENDELSE
    CASE (i) OF
    1: rate1=x
    2: rate2=x
    3: rate3=x
    4: rate4=x
    5: rate5=x
    6: rate6=x
    7: rate7=x
    8: rate8=x
    ENDCASE     
ENDFOR

n=N_ELEMENTS(rate1.RATE)+N_ELEMENTS(rate2.RATE)+N_ELEMENTS(rate3.RATE)+N_ELEMENTS(rate4.RATE)+N_ELEMENTS(rate5.RATE)+N_ELEMENTS(rate6.RATE)+N_ELEMENTS(rate7.RATE)+N_ELEMENTS(rate8.RATE)

rate={ $
       REF: STRARR(n), $
       EDUCTS: STRARR(n), $
       RATE: STRARR(n), $
       A: DBLARR(n,7,/NOZERO)}

n0=0
FOR i=1,8 DO BEGIN
    CASE (i) OF
        1: r=rate1
        2: r=rate2
        3: r=rate3
        4: r=rate4
        5: r=rate5
        6: r=rate6
        7: r=rate7
        8: r=rate8
    ENDCASE
    nj=N_ELEMENTS(r.RATE)-1
    n1=n0+nj

    rate.REF(n0:n1)=r.REF(0:nj)
    rate.RATE(n0:n1)=r.RATE(0:nj)
    rate.EDUCTS(n0:n1)=r.EDUCTS(0:nj)
    rate.A(n0:n1,0:6)=r.A(0:nj,0:6)

    n0=n0+nj+1
ENDFOR

END

;=======================================================================

PRO saverates

COMMON nuclear, rate

@nuclear_dir

SAVE,rate,FILENAME=dir+datfilename,/VERBOSE

END

;=======================================================================

PRO loadrates

COMMON nuclear, rate

@nuclear_dir

RESTORE,dir+datfilename,/VERBOSE

END

;=======================================================================

PRO findrates,educts,INDEX=index,VERBOSE=verbose,ISOTOPE_ALL=isotope_all, $
              ISOTOPE_PROD=isotope_prod,ISOTOPE_DEST=isotope_dest,REACTION=reaction

COMMON nuclear, rate

IF N_ELEMENTS(verbose) EQ 0 THEN verbose=1
IF N_ELEMENTS(isotope_all) EQ 0 THEN isotope_all=0
IF N_ELEMENTS(isotope_prod) EQ 0 THEN isotope_prod=0
IF N_ELEMENTS(isotope_dest) EQ 0 THEN isotope_dest=0
IF N_ELEMENTS(reaction) EQ 0 THEN reaction=0

IF educts EQ 'n' OR educts EQ 'p' OR educts EQ 'd' OR educts EQ 't' THEN BEGIN 
    IF isotope_all THEN BEGIN        
        index1=WHERE(STRPOS(rate.RATE,educts+' ') EQ 0,count1)
        index2=WHERE(STRPOS(rate.RATE,educts+'(') EQ 0,count2)
        index3=WHERE(STRPOS(rate.RATE,' '+educts) GT 0,count3)
        index4=WHERE(STRPOS(rate.RATE,')'+educts) GT 0,count4)

        index=LONARR(count1+count2+count3+count4)
        count=0
        IF count1 NE 0 THEN index(count:count+count1-1)=index1(*)
        count=count+count1
        IF count2 NE 0 THEN index(count:count+count2-1)=index2(*)
        count=count+count2
        IF count3 NE 0 THEN index(count:count+count3-1)=index3(*)
        count=count+count3
        IF count4 NE 0 THEN index(count:count+count4-1)=index4(*)
        count=count+count4
        index=index(UNIQ(index,SORT(index)))
    ENDIF ELSE IF isotope_dest THEN BEGIN
        index1=WHERE(rate.EDUCTS EQ educts,count1)
        index2=WHERE(STRPOS(rate.EDUCTS,educts+' ') EQ 0,count2)
        index3=WHERE(STRPOS(rate.EDUCTS,' '+educts) GT 0,count3)

        index=LONARR(count1+count2+count3)
        count=0
        IF count1 NE 0 THEN index(count:count+count1-1)=index1(*)
        count=count+count1
        IF count2 NE 0 THEN index(count:count+count2-1)=index2(*)
        count=count+count2
        IF count3 NE 0 THEN index(count:count+count3-1)=index3(*)
        count=count+count3
        index=index(UNIQ(index,SORT(index)))       
    ENDIF ELSE IF isotope_prod THEN BEGIN
        index=WHERE((STRPOS(rate.RATE,educts) GE 0) AND (STRPOS(rate.EDUCTS,educts) LT 0))
        index1=WHERE(STRPOS(rate.RATE,' '+educts) EQ STRLEN(rate.RATE)-2,count1)
        index2=WHERE(STRPOS(rate.RATE,')'+educts) EQ STRLEN(rate.RATE)-2,count2)
        index3=WHERE((STRPOS(rate.RATE,' '+educts+' ') GT 0) AND (STRPOS(rate.EDUCTS,' '+educts) LT 0),count3)

        index=LONARR(count1+count2+count3)
        count=0
        IF count1 NE 0 THEN index(count:count+count1-1)=index1(*)
        count=count+count1
        IF count2 NE 0 THEN index(count:count+count2-1)=index2(*)
        count=count+count2
        IF count3 NE 0 THEN index(count:count+count3-1)=index3(*)
        count=count+count3
        index=index(UNIQ(index,SORT(index)))       
    ENDIF ELSE BEGIN
        index=WHERE(rate.EDUCTS EQ educts)
    ENDELSE
ENDIF ELSE BEGIN
    IF isotope_all THEN BEGIN
        index=WHERE(STRPOS(rate.RATE,educts) GE 0)
    ENDIF ELSE IF isotope_dest THEN BEGIN
        index=WHERE(STRPOS(rate.EDUCTS,educts) GE 0)
    ENDIF ELSE IF isotope_prod THEN BEGIN
        index=WHERE((STRPOS(rate.RATE,educts) GE 0) AND (STRPOS(rate.EDUCTS,educts) LT 0))
    ENDIF ELSE IF reaction THEN BEGIN
        index=WHERE(rate.RATE EQ educts)
    ENDIF ELSE BEGIN
        index=WHERE(rate.EDUCTS EQ educts)
    ENDELSE
ENDELSE    

IF index(0) EQ -1 THEN BEGIN
    PRINT,'ERROR: ',educts,' RATE NOT FOUND'
    RETALL
ENDIF

IF verbose THEN BEGIN
    FOR i=0,N_ELEMENTS(index)-1 DO BEGIN
        PRINT,index(i),rate.REF(index(i)),rate.RATE(index(i)),FORMAT='(I5,":",2x,A7,2X,A)'
    ENDFOR
ENDIF

END

;=======================================================================

PRO getiso,educts,isotopes,nisotopes

x=educts
xiso=STRARR(10)
n=0
REPEAT BEGIN
    i=STRPOS(x,' + ')
    IF i GT 0 THEN BEGIN
        xiso(n)=STRMID(x,0,i)
        x=STRMID(x,i+3,99)
    ENDIF ELSE BEGIN
        xiso(n)=STRMID(x,0,99)        
    ENDELSE
    n=n+1
ENDREP UNTIL i LT 0

nisotopes=n
isotopes=xiso(0:nisotopes-1)

END

;=======================================================================

PRO getrate,educts,t,RATE=r,INDEX=index,ISOTOPE_ALL=isotope_all, $
            ISOTOPE_PROD=isotope_prod,ISOTOPE_DEST=isotope_dest, $
            REACTION=reaction,FROM_INDEX=from_index,VERBOSE=verbose

COMMON nuclear, rate

IF N_ELEMENTS(verbose) EQ 0 THEN BEGIN
    IF N_ELEMENTS(t) EQ 1 THEN verbose=1 ELSE verbose=0
ENDIF

IF N_ELEMENTS(from_index) EQ 0 THEN from_index=0
IF N_ELEMENTS(index) EQ 0 THEN from_index=0

IF NOT from_index THEN BEGIN
    findrates,educts,INDEX=index,VERBOSE=0,ISOTOPE_ALL=isotope_all, $
      ISOTOPE_PROD=isotope_prod,ISOTOPE_DEST=isotope_dest,REACTION=reaction
ENDIF

nt=N_ELEMENTS(t)

FOR i=0,N_ELEMENTS(index)-1 DO BEGIN
    rx=lambda(t,rate.A(index(i),*))
    IF verbose THEN BEGIN
        PRINT,index(i),rate.REF(index(i)),rate.RATE(index(i)),rx,FORMAT='(I5,":",2x,A7,2X,A30,E20.8)'
    ENDIF
    IF i EQ 0 THEN r=rx ELSE r=r+rx
ENDFOR

IF verbose THEN BEGIN
    PRINT,r,FORMAT='("total:",5X,E20.8)'
ENDIF

END

;=======================================================================

PRO getlam,educts,t,rho,LAMBDA=lam,INDEX=index,NEDUCTS=neducts,REACTION=reaction,FROM_INDEX=from_index,VERBOSE=verbose

COMMON nuclear, rate

IF N_ELEMENTS(verbose) EQ 0 THEN BEGIN
    IF N_ELEMENTS(t) EQ 1 THEN verbose=1 ELSE verbose=0
ENDIF

getrate,educts,t,RATE=r,INDEX=index,REACTION=reaction,FROM_INDEX=from_index,VERBOSE=verbose

x=rate.EDUCTS(index(0))
p=0
neducts=0
REPEAT BEGIN
    p=STRPOS(x,'+',p+1)
    neducts=neducts+1
ENDREP UNTIL p EQ -1

IF neducts EQ 1 THEN BEGIN
    FOR i=0,N_ELEMENTS(index)-1 DO BEGIN
        IF rate.REF(index(i)) EQ '*' THEN PRINT,'WARNING: need to multiply by Ye -- not implemented'
    ENDFOR
ENDIF

lam=r*rho^(neducts-1)

IF verbose THEN BEGIN
    PRINT,lam,FORMAT='("lambda:",5X,E20.8)'
ENDIF

END

;=======================================================================

PRO getydot,educts,t,rho,y1,y2,y3,YDOT=ydot,INDEX=index,REACTION=reaction,FROM_INDEX=from_index,VERBOSE=verbose

COMMON nuclear, rate

IF N_ELEMENTS(verbose) EQ 0 THEN BEGIN
    IF N_ELEMENTS(t) EQ 1 THEN verbose=1 ELSE verbose=0
ENDIF

getlam,educts,t,rho,LAMBDA=lam,INDEX=index,NEDUCTS=neducts,REACTION=reaction,FROM_INDEX=from_index,VERBOSE=verbose

ydot=lam*y1
IF neducts GT 1 THEN ydot=ydot*y2
IF neducts GT 2 THEN ydot=ydot*y3

x=rate.educts(index(0))
getiso,x,iso,niso
FOR i=0,niso-2 DO IF iso(i) EQ iso(i+1) THEN ydot=ydot/(i+2)
IF niso EQ 3 THEN IF (iso(1) NE iso(0)) AND (iso(1) EQ iso(2)) THEN ydot=ydot/2

IF verbose THEN BEGIN
    PRINT,ydot,FORMAT='("ydot:",6X,E20.8)'
ENDIF


END

;=======================================================================

PRO gettau,educts,t,rho,idx,y1,y2,y3,TAU=tau,VERBOSE=verbose

IF N_ELEMENTS(verbose) EQ 0 THEN BEGIN
    IF N_ELEMENTS(t) EQ 1 THEN verbose=1 ELSE verbose=0
ENDIF

getydot,educts,t,rho,y1,y2,y3,YDOT=ydot,VERBOSE=verbose

CASE idx OF
    1: y=y1
    2: y=y2
    3: y=y3
ENDCASE
tau=y/ydot

IF verbose THEN BEGIN
    PRINT,idx,tau,FORMAT='("tau(",(I1),"):",3X,E20.8)'
ENDIF

END


;=======================================================================

PRO nuclear, SILENT=silent

COMMON nuclear, rate

IF N_ELEMENTS(silent) EQ 0 THEN silent=0

@nuclear_dir

IF N_ELEMENTS(rate) EQ 0 THEN BEGIN
    name=dir+datfilename
    xxx=FINDFILE(name,COUNT=xxx_count)
    IF (xxx_count NE 1) THEN BEGIN
        PRINT,'[NUCLEAR] RATES IDL-DATA-FILE NOT FOUND:'
        PRINT,'[NUCLEAR] ',name
        PRINT,'[NUCLEAR] TRYING TO READ RATES FROM TABLES...'
        name=dir+'rate?.txt'
        xxx=FINDFILE(name,COUNT=xxx_count)
        IF xxx_count LT 8 THEN BEGIN
            PRINT,'[NUCLEAR] RATE TABELS NOT FOUND'
            RETURN
        ENDIF ELSE BEGIN
            readtables
            PRINT,'[NUCLEAR] DO YOU WANT TO SAVE THE RATES IN (Y/N):'
            PRINT,'[NUCLEAR] ',dir+datfilename
            c=' '
            READ,c
            IF (STRLOWCASE(c) EQ 'y') THEN saverates
        ENDELSE
    ENDIF ELSE loadrates
ENDIF

IF silent THEN RETURN

PRINT,'======================================================================='
PRINT,'NUCLEAR REACTION RATES COMPUTATION MODULE (VERSION 1.0)'
PRINT,'======================================================================='
PRINT,'FORMAT FOR EDUCTS/PRODUCTS:  I1 + I2 + ...'
PRINT,'(smaller isotopes have to be listed first)'
PRINT,'FORMAT FOR ISOTOPES: Fe56'
PRINT,'NOTE: H1 == p, H2 == d, H3 == t'
PRINT,'FORMAT FOR REACTION  I1 + I2 -> I4 + I5'
PRINT,'ISOTOPES/REACTIONS HAVE TO BE GIVEN AS A STRING (parameter educts)'
PRINT,'-----------------------------------------------------------------------'
PRINT,'FINDRATES, educts, KEYWORD=keyword'
PRINT,'        educts: isotope(s)/reaction string (input value)'
PRINT,'    keywords:'
PRINT,'        INDEX returns index of reaction(s) in list (return value)'
PRINT,'        ISOTOPE_ALL find all reactions which involve isotope educts (SWITCH)'
PRINT,'        ISOTOPE_PROD find all reactions which produce isotope educts (SWITCH)'
PRINT,'        ISOTOPE_DEST find all reactions which destroy isotope educts (SWITCH)'
PRINT,'        REACTION find the reaction(s) which are educts (SWITCH)'
PRINT,'        VERBOSE (SWITCH)'
PRINT,'-----------------------------------------------------------------------'
PRINT,'GETRATE, educts, t, KEYWORD=keyword'
PRINT,'        educts: isotope(s)/reaction string (input value)'
PRINT,'        t: temperature in K (input value)'
PRINT,'    keywords:'
PRINT,'        RATE returns total reaction rate of reaction(s) in list (return value)'
PRINT,'        INDEX returns index of reaction(s) in list (return value)'
PRINT,'        ISOTOPE_ALL find all reactions which involve isotope educts (SWITCH)'
PRINT,'        ISOTOPE_PROD find all reactions which produce isotope educts (SWITCH)'
PRINT,'        ISOTOPE_DEST find all reactions which destroy isotope educts (SWITCH)'
PRINT,'        REACTION find the reaction(s) which are educts (SWITCH)'
PRINT,'-----------------------------------------------------------------------'
PRINT,'GETLAM, educts, t, rho, KEYWORD=keyword'
PRINT,'        educts: educt isotope(s) string (input value)'
PRINT,'        t: temperature in K (input value)'
PRINT,'        rho: density in g/cm^3 (input value)'
PRINT,'    keywords:'
PRINT,'        LAMBDA returns total reaction rate of reaction(s) in list'
PRINT,'               times power of density (return value)'
PRINT,'        NEDUCTS number of educts (return value)'
PRINT,'-----------------------------------------------------------------------'
PRINT,'GETYDOT, educts, t, rho, y1, y2, y3, KEYWORD=keyword'
PRINT,'        educts: educt isotope(s) string (input value)'
PRINT,'        t: temperature in K (input value)'
PRINT,'        rho: density in g/cm^3 (input value)'
PRINT,'        y1: abundance of first educt (input value)'
PRINT,'        y2: abundance of second educt (input value, if neecessary)'
PRINT,'        y3: abundance of third educt (input value, if necessary)'
PRINT,'    keywords:'
PRINT,'        YDOT returns total ydot of reaction(s) in list'
PRINT,'               [mol/g/sec] (return value)'
PRINT,'-----------------------------------------------------------------------'
PRINT,'GETTAU, educts, t, rho, idx, y1, y2, y3, KEYWORD=keyword'
PRINT,'        educts: educt isotope(s) string (input value)'
PRINT,'        t: temperature in K (input value)'
PRINT,'        rho: density in g/cm^3 (input value)'
PRINT,'        idx: index of educt to consider (input value)'
PRINT,'        y1: abundance of first educt (input value)'
PRINT,'        y2: abundance of second educt (input value, if necessary)'
PRINT,'        y3: abundance of third educt (input value, if necessary)'
PRINT,'    keywords:'
PRINT,'        TAU returns total destruction time-scale of the IDXth isotope'
PRINT,'            due to reaction(s) in list [sec] (return value)'
PRINT,'======================================================================='
PRINT,'                                                   Alexander Heger 1998'
PRINT,'======================================================================='


END

;-----------------------------------------------------------------------
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
;-----------------------------------------------------------------------
