;-----------------------------------------------------------------------
;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;-----------------------------------------------------------------------


PRO presndata, $
   restart, $               ; dump file to read
   OUTFILE=outfile, $       ; output file name
   FLASH=flash, $           ; FLASH format output
   MAGNET=xmagnet, $        ; output magnetic
   SHORT=short, $           ; short output format
   BURN=burn, $             ; output BURN data
   INNER=inner, $           ; give inner boundary values for zone boundary values (radius, velocity, lumonosity)
   MODEL=model, $           ; model number to read (STERN)
   TIME=time, $             ; output time
   HHEZ=hhez, $             ; simple abundance output (X,Y,Z)
   SN=sn, $                 ; SN output formats for Stan - see below
   WIND=wind, $             ; add wind data
   COMPRESS=compress, $     ; compress output file
   AREAD=aread, $           ; make output file readable to all (for web)
   LUMINOSITY=luminosity, $ ; add lumonosity
   NEUTRINO=neutrino, $     ; add neutrino data
   APPROX=approx, $         ; output APPROX-19 network ions only (for mapping)
   DECISO=deciso, $         ; output BURN decayed (stable) istopes
   RADISO=radiso, $         ; output BRUN decayed radioactive+stable yields
   ALLISO=alliso, $         ; same as BURN
   ELX=elx, $               ; ouptut decayed stable element mass fractions
   ELY=ely, $               ; output decayed stable element mol fractions
   AT=at, $                 ; output file name is dump file name with "#" replaced by "@"
   DIFFUSION=diffusion      ; output diffusion coefficient


;-----------------------------------------------------------------------
; SN format parameter
; 1  Original output for Candace 
;    'ni56','ni57','co56','co57','co60','ti44'
; 2  added ions for Stan 
;    'ni56','ni57','co56','co57','co60','ti44','fe52','cr48'
; 3  same as 2 but reverse decays - do not include mass fractions in
;                                   radioactivities into elements
; 4  added more ions for Stan  
;    '22Na', '26Al', '44Ti', '48V', '48Cr', '52Mn', '52Fe',
;    '55Fe', '60Fe', '55Co', '56Co', '57Co', '60Co', '56Ni',
;                '57Ni', '59Ni',  '65Zn'
;-----------------------------------------------------------------------
  
; TODO
; 1) Output file names should reflect content - 
;    add something to name
;    enhance AT parameter
; 2) make more felxible output column selection
;    what is currently in there is a mess
;    make output precision adjustable
;    make output formmat adjustable
; 3) extra formats:
;    pf 
;    [X]
;    log eps     
;    Y for isotopes      
; 4) ADD SN output with roadiactivities not added to elements
;    (UPSTREAM: update maxradio)    

@compile_opt

IF N_ELEMENTS(restart) EQ 0 THEN restart=''
IF N_ELEMENTS(outfile) EQ 0 THEN outfile=''
IF N_ELEMENTS(flash) EQ 0 THEN flash=0
IF N_ELEMENTS(short) EQ 0 THEN short=0
IF N_ELEMENTS(burn) EQ 0 THEN burn=0
IF N_ELEMENTS(model) EQ 0 THEN model=-1
IF N_ELEMENTS(time) EQ 0 THEN time=1
IF N_ELEMENTS(hhez) EQ 0 THEN hhez=0
IF N_ELEMENTS(sn) EQ 0 THEN sn=0
IF N_ELEMENTS(deciso) EQ 0 THEN deciso=0
IF N_ELEMENTS(alliso) EQ 0 THEN alliso=0
IF N_ELEMENTS(radiso) EQ 0 THEN radiso=0
IF N_ELEMENTS(elx) EQ 0 THEN elx=0
IF N_ELEMENTS(ely) EQ 0 THEN ely=0
IF N_ELEMENTS(wind) EQ 0 THEN wind=0
IF N_ELEMENTS(compress) EQ 0 THEN compress=0
IF N_ELEMENTS(aread) EQ 0 THEN aread=1
IF N_ELEMENTS(at) EQ 0 THEN AT=0
IF N_ELEMENTS(approx) EQ 0 THEN BEGIN 
   approx=0
   IF flash EQ 1 THEN approx=1
ENDIF
IF alliso EQ 1 THEN burn=1

loadburn=0
IF burn   NE 0 THEN loadburn=1
IF sn     NE 0 THEN loadburn=1
IF elx    NE 0 THEN loadburn=1
IF ely    NE 0 THEN loadburn=1
IF alliso NE 0 THEN loadburn=1
IF radiso NE 0 THEN loadburn=1
IF deciso NE 0 THEN loadburn=1
IF burn   NE 0 THEN loadburn=1

IF model EQ -1 THEN BEGIN
    IF restart NE '' THEN loaddump,restart
    getdump,'zm',xm,CENTER=-1
    getdump,'zm_sun',xm_sun,CENTER=-1
    getdump,'rn',rn,CENTER=-1
    getdump,'dn',dn,CENTER=-1
    getdump,'tn',tn,CENTER=-1
    getdump,'pn',pn,CENTER=-1
    getdump,'en',en,CENTER=-1
    getdump,'stot',stot,CENTER=-1
    getdump,'un',un,CENTER=-1
    getdump,'angj',angj,CENTER=-1
    getdump,'abar',abar,CENTER=-1
    getdump,'zbar',zbar,CENTER=-1
    getdump,'conv',conv,CENTER=-1    
    getdump,'xkn',xkn,CENTER=-1       
    getdump,'xln',xln,CENTER=-1       

    getdump,'zm',xm0,CENTER=0
    getdump,'rn',rn0,CENTER=0
    getdump,'un',un0,CENTER=0
    getdump,'p 62',xln0
    getdump,'zm_sun',xm_sun0,CENTER=0
    
    xm0=xm0[0]
    rn0=rn0[0]
    un0=un0[0]
    xm_sun0=xm_sun0[0]

; composition
    getdump,'netnum' ,netnum
    netid=['APPROX','QSE','NSE']

    getdump,'ionnt1' ,ionnt1
    getdump,'ionh1'  ,ionh1 
    getdump,'ionpn1' ,ionpn1
    getdump,'ionhe3' ,ionhe3
    getdump,'ionhe4' ,ionhe4
    getdump,'ionc12' ,ionc12
    getdump,'ionn14' ,ionn14
    getdump,'iono16' ,iono16
    getdump,'ionne20',ionne20
    getdump,'ionmg24',ionmg24
    getdump,'ionsi28',ionsi28
    getdump,'ions32' ,ions32
    getdump,'ionar36',ionar36
    getdump,'ionca40',ionca40
    getdump,'ionti44',ionti44
    getdump,'ioncr48',ioncr48
    getdump,'ionfe52',ionfe52
    getdump,'ionfe54',ionfe54
    getdump,'ionni56',ionni56
    IF not approx THEN BEGIN
       getdump,"ionyq"  ,ionyq
       getdump,"ioneb0" ,ioneb0
       getdump,"ionyf"  ,ionyf
       getdump,"ionfe56",ionfe56
       getdump,"ion'fe'",ionfe  
    ENDIF ELSE BEGIN
       ionyq=0.D0*ionni56
       ioneb0=ionyq
       ionyf=ionyq
       ionfe56=ionyq
       ionfe=ionyq
    ENDELSE

    IF wind NE 0 THEN BEGIN
       getdump,"xwind",ionwind
       getdump,"xmlost",xmlost
       netnum =[netnum ,1]
       conv   =[conv   ,'']
       xmlost>=1.D-99
       xmlost1=TOTAL(ionwind)>1.D-99
       IF abs(1-xmlost/xmlost1) GT 1.D-10 THEN BEGIN
          PRINT,' [PRESNDATA] WIND MASS NOT CONSERVED!!!'
       ENDIF
       ionwind/=xmlost
       n=N_ELEMENTS(xm)
       xm=[xm[0:n-1],xm[n-1]+xmlost]
       xm_sun=[xm_sun[0:n-1],xm_sun[n-1]+xmlost/1.9891000D+33]
       ionnt1 =[ionnt1 ,ionwind[ 0]]
       ionh1  =[ionh1  ,ionwind[ 1]]
       ionpn1 =[ionpn1 ,ionwind[ 2]]
       ionhe3 =[ionhe3 ,ionwind[ 3]]
       ionhe4 =[ionhe4 ,ionwind[ 4]]
       ionc12 =[ionc12 ,ionwind[ 5]]
       ionn14 =[ionn14 ,ionwind[ 6]]
       iono16 =[iono16 ,ionwind[ 7]]
       ionne20=[ionne20,ionwind[ 8]]
       ionmg24=[ionmg24,ionwind[ 9]]
       ionsi28=[ionsi28,ionwind[10]]
       ions32 =[ions32 ,ionwind[11]]
       ionar36=[ionar36,ionwind[12]]
       ionca40=[ionca40,ionwind[13]]
       ionti44=[ionti44,ionwind[14]]
       ioncr48=[ioncr48,ionwind[15]]
       ionfe52=[ionfe52,ionwind[16]]
       ionfe54=[ionfe54,ionwind[17]]
       ionni56=[ionni56,ionwind[18]]
       IF N_ELEMENTS(ionyq) NE 0 THEN BEGIN
          ionyq  =[ionyq  ,-1.        ]
          ioneb0 =[ioneb0 ,-1.        ]
          ionyf  =[ionyf  ,-1.        ]
          ionfe56=[ionfe56,-1.        ]
          ionfe  =[ionfe  ,ionwind[19]]
       ENDIF
    ENDIF

; luminosity data (Bill Paxton)
    IF N_ELEMENTS(luminosity) EQ 0 THEN luminosity=0
    IF (luminosity NE 0) THEN BEGIN
        getdump,"xln",xln,CENTER=-1
    ENDIF
    
; diffusion coefficient (useful to reconstruct convective velocity)
    IF N_ELEMENTS(diffusion) EQ 0 THEN diffusion=0
    IF (diffusion NE 0) THEN BEGIN
        getdump,"difi",difi,CENTER=-1
    ENDIF

; magnetic fields
    getdump,"np 423",magnet
    IF N_ELEMENTS(xmagnet) EQ 0 THEN xmagnet=(magnet NE 0)
    IF xmagnet EQ 0 THEN magnet=0
    
    IF (magnet NE 0) THEN BEGIN
        getdump,"bfbr",bfbr,CENTER=-1
        getdump,"bfbt",bfbt,CENTER=-1
    ENDIF
    
; neutrino data (George Fuller)
    IF N_ELEMENTS(neutrino) EQ 0 THEN neutrino=0
    IF neutrino NE 0 THEN BEGIN
       getdump,'sn',snx
       getdump,'snn',snn
       enu=snn-snx
       lnu=TOTAL(enu*xm,/CUMULATIVE)
       fnu=lnu/(4.D0*!DPI*rn^2)
    ENDIF

; setup
    ionh01=ionh1
    ionh1=ionh1+ionpn1

    n=N_ELEMENTS(rn)

; get BURN abundances
    IF (loadburn GT 0) THEN BEGIN
       getdump,'q 53',imaxb
       IF imaxb EQ 0 THEN BEGIN
          PRINT,' [PRESNDATA] ==================================='
          PRINT,' [PRESNDATA] ERROR: no BURN data.  Using APPROX.'
          PRINT,' [PRESNDATA] ==================================='
          ionsb=[$
                'nt1', $
                'h1', $
                'he3', $
                'he4', $
                'c12', $
                'n14', $
                'o16', $
                'ne20', $
                'mg24', $
                'si28', $
                's32', $
                'ar36', $
                'ca40', $
                'ti44', $
                'cr48', $
                'fe52', $
                'fe54', $
                'ni56']
          nziso=N_ELEMENTS(ionh1)
          iso=[$
              [ionnt1 ], $
              [ionh1  + ionpn1 ], $
              [ionhe3 ], $
              [ionhe4 ], $
              [ionc12 ], $
              [ionn14 ], $
              [iono16 ], $
              [ionne20], $
              [ionmg24], $
              [ionsi28], $
              [ions32 ], $
              [ionar36], $
              [ionca40], $
              [ionti44], $
              [ioncr48], $
              [ionfe52], $
              [ionfe54], $
              [ionni56]]

          extra=['co56','co57','ni60','sc44','cr52','mn52','v48','ti48']
          nextra=N_ELEMENTS(extra)
          ionsb=[ionsb,extra]
          iso=[[iso],[DBLARR(nziso,nextra)]]

          iso=TRANSPOSE(TEMPORARY(iso))
          in=N_ELEMENTS(ionsb)
       ENDIF ELSE BEGIN
          getdump,'ionsb',ionsb0
          in0=N_ELEMENTS(ionsb0)
          nziso=n
          IF wind NE 0 THEN BEGIN
             getdump,'xwindb',isowind           
             nziso+=1
          ENDIF 
          iso=DBLARR(in0,nziso)
          ionsb=ionsb0
          in=0
          FOR i=0,in0-1 DO BEGIN
             IF STRLEN(STRTRIM(ionsb[i],2)) GT 0 THEN BEGIN
                getdump,'iso'+STRTRIM(ionsb0[i],2),isoi
                IF wind THEN isoi=[[isoi],[isowind[i]]]
                IF (TOTAL(isoi) GT 0.D0) OR (burn EQ 1) THEN BEGIN
                   iso[in,*]=isoi
                   ionsb[in]=ionsb0[i]
                   in=in+1
                ENDIF
             ENDIF
          ENDFOR
          iso=TEMPORARY(iso[0:in-1,0:nziso-1])
          ionsb=TEMPORARY(ionsb[0:in-1])
          
; do not show isotops below bmasslow
          getdump,"p 419",bmasslow
          x=WHERE(xm GT bmasslow)
          ii=x[0]
          IF ii GT 0 THEN BEGIN
             iso[0:in-1,0:ii]=-1
          ENDIF
       ENDELSE
    ENDIF

    angw=angj/calcai([rn0,rn[0:n-2]],rn,1.0D0)

    ye=zbar/abar

    anni=['neutrons' ,$
          'H1'  ,$
          'He3' ,$
          'He4' ,$
          'C12' ,$
          'N14' ,$
          'O16' ,$
          'Ne20',$
          'Mg24',$
          'Si28',$
          'S32' ,$
          'Ar36',$
          'Ca40',$
          'Ti44',$
          'Cr48',$
          'Fe52',$
          'Fe54',$
          'Ni56',$
          "Fe56",$
          "'Fe'" $
         ]
    
    annf=['nt1' ,$
          'h1'  ,$
          'pn1' ,$
          'he3' ,$
          'he4' ,$
          'c12' ,$
          'n14' ,$
          'o16' ,$
          'ne20',$
          'mg24',$
          'si28',$
          's32' ,$
          'ar36',$
          'ca40',$
          'ti44',$
          'cr48',$
          'fe52',$
          'fe54',$
          'ni56' $
         ]
    
    annb=['B_r','B_phi']
    
    annl=['cell outer luminosity']

    annd=['cell outer diffusion']

    annv=['specific nu loss rate', $
          'neutrino luminosity', $
          'cell outer nu flux']
    
    IF netnum[0] EQ 1 THEN BEGIN
; define variable
        ionyq  =ionh1
        ionyf  =ionh1
        ioneb0 =ionh1
        ionfe56=ionh1
        ionfe  =ionh1
    ENDIF
    
    x=WHERE(netnum EQ 1)
    IF x[0] NE -1 THEN BEGIN
        ionyq  [x]=-1.0D0
        ionyf  [x]=-1.0D0
        ioneb0 [x]=-1.0D0
        ionfe56[x]=-1.0D0
        ionfe  [x]=-1.0D0
    ENDIF
    
    x=WHERE(netnum NE 1)
    IF x[0] NE -1 THEN BEGIN
        ionn14 [x]=-1.D0
        ionhe3 [x]=-1.D0
        ionc12 [x]=-1.D0
        ionn14 [x]=-1.D0
        ionne20[x]=-1.D0
        ionfe52[x]=-1.D0
    ENDIF
    
    FOR i=0,n-1 DO BEGIN
        IF conv[i] EQ 'neutral' THEN conv[i]='radiative'
    ENDFOR

    getdump,"p 2",timesec
    getdump,"p 315",toffset

; do not add offset if time is, e.g., 2
    IF time EQ 1 THEN timesec+=toffset

ENDIF ELSE BEGIN
; STERN data

    COMMON stern, nmodells, modells, modell_version    
    COMMON readmodell, filename

    IF restart NE '' THEN BEGIN
        loadmodell,restart,/entropy
    ENDIF
    IF N_ELEMENTS(nmodells) EQ 0 THEN BEGIN
        loadmodell,/entropy
    ENDIF
    restart=filename

    n=modells[model].n-1
    xm=modells[model].xm[1:n]
    xm_sun=xm/1.9891000D+33
    rn=modells[model].r[1:n]
    dn=modells[model].ro[0:n-1]
    tn=modells[model].t[0:n-1]
    pn=modells[model].p[0:n-1]
    en=modells[model].e[0:n-1]
    stot=modells[model].entrop[0:n-1]
    un=modells[model].u[1:n]
    angw=modells[model].aw[0:n-1]

    xm0=0.0D0
    rn0=0.0D0
    un0=0.0D0

    conv=modells[model].yzi[0:n-1]
    x=WHERE(conv EQ 'C')
    IF x[0] NE -1 THEN conv[x]='convective'
    x=WHERE(conv EQ 'R')
    IF x[0] NE -1 THEN conv[x]='radiative'
    x=WHERE(conv EQ 'S')
    IF x[0] NE -1 THEN conv[x]='semiconvective'

    COMMON isotopes, nisotopes, isotopes

    niso=nisotopes
    yps=modells[model].yps[0:n-1,0:niso-1]
    y=yps#DIAG_MATRIX(1.D0/isotopes.a)

    ytot=TOTAL(y,2)
    abar=1.D0/ytot
    zbar=TOTAL(y[*,*]#DIAG_MATRIX(isotopes.z),2)/ytot

    ye=zbar/abar

    idx=ionidx(isotopes.name)
    ions=ionstr(idx,/UPCASE)

    netid='STERN'+STRTRIM(STRING(niso),2)
    netnum=REPLICATE(1,n)

    luminosity=0
    magnet=0
    burn=0
    neutrino=0
    diffusion=0

    timesec=modells[model].time
ENDELSE

IF at NE 0 THEN BEGIN
   s=''
   FOR i=1,at DO s+='@'
   i=STRPOS(restart,'#')
   outfile=STRMID(restart,0,i)+s+STRMID(restart,i+1,999)
ENDIF

IF outfile EQ '' THEN BEGIN
    unit=-1
ENDIF ELSE BEGIN
   IF (compress EQ 0) THEN compress=STRLOWCASE(STRMID(STRTRIM(outfile,2),2,3,/REVERSE_OFFSET)) EQ '.gz'
   IF (compress NE 0) AND (STRMID(outfile,2,3,/REVERSE) NE '.gz') THEN BEGIN
      outfile+='.gz'
   ENDIF   
    OPENW,unit,outfile,/GET_LUN,COMPRESS=compress
ENDELSE

anns=['cell outer total mass', $
      'cell outer radius', $
      'cell outer velocity', $
      'cell density', $
      'cell temperature', $
      'cell pressure', $
      'cell specific energy', $
      'cell specific entropy', $
      'cell angular velocity', $
      'cell A_bar', $
      'cell Y_e'] 

anne=['stability']

annn=['NETWORK']

; metal output
IF hhez NE 0 THEN BEGIN
    x=WHERE(ionh1 NE -1)
    ionX=REPLICATE(0.0D0,n)
    ionY=ionX
    ionX[x]=ionH1[x]
    ionY[x]=ionHe4[x]+ionHe3[x]
    ionZ=1.D0-ionX-ionY

    anns=[$
         'grid',$
         'mass',$
         'radius',$
         'temperature',$
         'density',$
         'velocity',$
         'X',$
         'Y',$
         'Z']
    s=STRING(anns,FORMAT='(A5,8A13)')
    PRINTF,unit,s

    FOR i=0,n-1 DO BEGIN
        s=STRING(i+1,FORMAT="(I5)")
        s=s+STRING($
          xm_sun[i], $
          rn[i], $
          tn[i], $
          dn[i], $
          un[i], $
          ionX[i], $
          ionY[i], $
          ionZ[i], $
          FORMAT='(8(E13.5))')
        PRINTF,unit,s
    ENDFOR

;    plot,xm_sun,ionz
;    oplot,xm_sun,iony,line=3
;    oplot,xm_sun,ionx,line=2

    GOTO,endofoutput
ENDIF

; short output
IF short THEN BEGIN
    anns=['grid',$
          'mass',$
          'radius',$
          'temperature',$
          'density',$
          'velocity',$
          'Ye',$
          'omega']
    s=STRING(anns,FORMAT='(A5,7A13)')
    PRINTF,unit,s
    FOR i=0,n-1 DO BEGIN
        s=STRING(i+1,FORMAT="(I5)")
        s=s+STRING($
          xm_sun[i], $
          rn    [i], $
          tn    [i], $
          dn    [i], $
          un    [i], $
          ye    [i], $
          angw  [i], $
          FORMAT='(7(E13.5))')
        PRINTF,unit,s
    ENDFOR
    GOTO,endofoutput
ENDIF

info=GET_LOGIN_INFO()
host=info.machine_name
user=info.user_name

version='10112'
comment=''

formatcomment=' '
IF flash THEN BEGIN 
   formatcomment+='FLASH '
ENDIF ELSE IF approx AND (burn EQ 0) THEN BEGIN
   formatcomment+='APPROX '
ENDIF
IF burn NE 0 THEN BEGIN 
    formatcomment+='ALLISO'
    IF burn GT 1 THEN formatcomment=formatcomment+STRTRIM(STRING(burn),2)
    formatcomment=formatcomment+' '
ENDIF
IF SN NE 0 THEN BEGIN 
    formatcomment+='SN'
    IF SN GT 1 THEN formatcomment=formatcomment+STRTRIM(STRING(SN),2)
    formatcomment=formatcomment+' '
ENDIF
IF model NE -1 THEN formatcomment+='STERN '

; some istope mappings
IF deciso NE 0 THEN BEGIN
   maxradio,ionsb,map,ionsdec,/STABLE
   ionsb=[ionsdec]
   iso##=TRANSPOSE(TEMPORARY(map))
   in=N_ELEMENTS(ionsb)   
   formatcomment+='DECISO '
ENDIF
IF radiso NE 0 THEN BEGIN
   maxradio,ionsb,map,ionsrad
   ionsb=[ionsrad]
   iso##=TRANSPOSE(TEMPORARY(map))
   in=N_ELEMENTS(ionsb) 
   formatcomment+='RADISO '   
ENDIF
IF elx NE 0 THEN BEGIN
   maxradio,ionsb,map,ionsel,$
            /ELEMENTS, $
            /KEEPALL
   ionsb=[ionsel]
   iso##=TRANSPOSE(TEMPORARY(map))
   in=N_ELEMENTS(ionsb)
   formatcomment+='EL(MASS) '
ENDIF
IF ely NE 0 THEN BEGIN
   maxradio,ionsb,map,ionsel,$
            /ELEMENTS, $
            /KEEPALL, $
            /X2Y
   ionsb=[ionsel]
   iso##=TRANSPOSE(TEMPORARY(map))
   in=N_ELEMENTS(ionsb)
   formatcomment+='EL(MOL) '
ENDIF

if formatcomment EQ ' ' THEN formatcomment=''

IF flash THEN comment='# '
s=comment+'VERSION '+version+formatcomment+' -- '+SYSTIME(/UTC)+' UTC -- created by '+user+' on '+host+' from file '+restart
IF model NE -1 THEN s=s+' -- model '+STRTRIM(STRING(modells[model].modell),2)
IF time NE 0 THEN s=s+' -- time '+STRTRIM(STRING(timesec,FORMAT="(E25.17)"),2)+' s'
PRINTF,unit,s

; SPECIAL SN OUTPUT (as requested by Stan)
; ELEMENTS + 56,57Ni, 56,57Co, 60Co, 44Ti 
; 20100422 52Fe, 48Cr added
IF sn NE 0 THEN BEGIN
   IF SN EQ 1 THEN BEGIN 
      specions=['ni56','ni57','co56','co57','co60','ti44']
   ENDIF
   IF SN EQ 2 OR SN EQ 3 THEN BEGIN
      specions=['ni56','ni57','co56','co57','co60','ti44','fe52','cr48']
   ENDIF
   IF SN EQ 4 THEN BEGIN
      specions=['22Na', '26Al', '44Ti', '48V', '48Cr', '52Mn', '52Fe', $
                '55Fe', '60Fe', '55Co', '56Co', '57Co', '60Co', '56Ni', $
                '57Ni', '59Ni',  '65Zn' ]
   ENDIF
   maxradio,ionsb,mapel,ionsel,$
            /ELEMENTS, $
            /KEEPALL
   maxradio,ionsb,mapspec,ionsspec,$
            IONLIST=specions, $
            /KEEPALL
   map=[[TEMPORARY(mapel)],[TEMPORARY(mapspec)]]
   ionsb=[ionsel,ionsspec]
   iso##=TRANSPOSE(TEMPORARY(map))
   nions=N_ELEMENTS(ionsb)
; for now manual
    IF SN EQ 3 THEN BEGIN
; reverse ni56->co56=>fe
; reverse ni57->co57=>fe       
; reverse co60=>ni       
; reverse ti44=>ca
; reverse fe52=>cr
; reverse cr48=>ti
       xni56=(WHERE(ionsb EQ "ni56"))[0]
       xni57=(WHERE(ionsb EQ "ni57"))[0]
       xco56=(WHERE(ionsb EQ "co56"))[0]
       xco57=(WHERE(ionsb EQ "co57"))[0]
       xco60=(WHERE(ionsb EQ "co60"))[0]
       xti44=(WHERE(ionsb EQ "ti44"))[0]
       xfe52=(WHERE(ionsb EQ "fe52"))[0]
       xcr48=(WHERE(ionsb EQ "cr48"))[0]
       xfe=(WHERE(ionsb EQ "fe"))[0]
       xni=(WHERE(ionsb EQ "ni"))[0]
       xca=(WHERE(ionsb EQ "ca"))[0]
       xcr=(WHERE(ionsb EQ "cr"))[0]
       xti=(WHERE(ionsb EQ "ti"))[0]
       iso[xfe,*]-=iso[xco56,*]
       iso[xfe,*]-=iso[xco57,*]
       iso[xni,*]-=iso[xco60,*]
       iso[xca,*]-=iso[xti44,*]
       iso[xcr,*]-=iso[xfe52,*]
       iso[xti,*]-=iso[xcr48,*]
       iso[xco56,*]-=iso[xni56,*]
       iso[xco57,*]-=iso[xni57,*]
    ENDIF


    anns=['grid',$
          'mass',$
          'radius',$
          'velocity', $
          'luminocity', $
          'temperature',$
          'density',$
          'opacity', $
          ionsb]
    anns_format='(A5,'+STRTRIM(STRING(N_ELEMENTS(anns)-1),2)+'(A13))'
    s=STRING(anns,anns_format)
    PRINTF,unit,s

    s=STRING(0,FORMAT="(I5)")
    s=s+STRING(xm_sun0, $
               rn0, $
               un0, $
               xln0, $
               FORMAT='(4(E13.5))')        
    PRINTF,unit,s

    data_format='('+STRTRIM(STRING(N_ELEMENTS(anns)-1),2)+'(E13.5))'
    FOR i=0,n-1 DO BEGIN
       s=STRING(i+1,FORMAT="(I5)")
       s+=STRING($
          xm_sun[i], $
          rn    [i], $
          un    [i], $
          xln   [i], $
          tn    [i], $
          dn    [i], $
          xkn   [i], $
          iso [*,i], $
          FORMAT=data_format)
       PRINTF,unit,s
    ENDFOR
    IF imaxb EQ 0 THEN BEGIN
       PRINT,' [PRESNDATA] ====================================='
       PRINT,' [PRESNDATA] WARNING: no BURN data.  Using APPROX.'
       PRINT,' [PRESNDATA] ====================================='
    ENDIF
    GOTO,endofoutput
ENDIF
; header line
s=''
IF flash THEN BEGIN
    s=s+STRING(comment,FORMAT='(A2)')
ENDIF ELSE BEGIN
    s=s+STRING('grid',FORMAT='(A6)')
ENDELSE
s=s+STRING(anns,FORMAT='(11A25)')
IF flash EQ 0 THEN BEGIN
    s=s+STRING(anne,FORMAT='(A16)')
    IF loadburn EQ 0 THEN BEGIN 
        s=s+STRING(annn,FORMAT='(A10)')
    ENDIF
ENDIF

IF loadburn THEN BEGIN
   abstot=TOTAL(iso>0,2)
   x=WHERE(abstot NE 0.D0)
   iso=iso[x,*]
   ionsb=ionsb[x]
   in=N_ELEMENTS(x)
ENDIF

IF model NE -1 THEN BEGIN
    s=s+STRING(ions,FORMAT='('+STRTRIM(STRING(N_ELEMENTS(ions)),2)+'A25)')
ENDIF ELSE IF loadburn NE 0 THEN BEGIN
    s=s+STRING(ionsb,FORMAT='('+STRTRIM(STRING(N_ELEMENTS(ionsb)),2)+'A25)')
ENDIF ELSE IF approx THEN BEGIN
    s=s+STRING(annf,FORMAT='(19A25)')
ENDIF ELSE BEGIN
    s=s+STRING(anni,FORMAT='(20A25)')
ENDELSE
IF luminosity GT 0 THEN BEGIN
    s=s+STRING(annl,FORMAT='(1A25)')    
ENDIF
IF diffusion GT 0 THEN BEGIN
    s=s+STRING(annd,FORMAT='(1A25)')    
ENDIF
IF magnet GT 0 THEN BEGIN
    s=s+STRING(annb,FORMAT='(2A25)')    
ENDIF
IF neutrino GT 0 THEN BEGIN
    s=s+STRING(annv,FORMAT='(3A25)')    
ENDIF
PRINTF,unit,s

; DATA
IF N_ELEMENTS(inner) EQ 0 THEN BEGIN
    IF rn0 EQ 0 THEN BEGIN
        inner=0
    ENDIF ELSE BEGIN
        inner=1
    ENDELSE
ENDIF
i0=0
IF inner THEN BEGIN
    i0=-1
ENDIF
IF wind NE 0 THEN BEGIN 
   i1=1 
   conv=[conv,'']
ENDIF ELSE BEGIN 
   i1=0
ENDELSE

FOR i=i0,n-1+i1 DO BEGIN
    s=''
    IF flash THEN BEGIN
       s=s+STRING("  ",FORMAT='(A2)')
    ENDIF ELSE BEGIN
       IF i EQ n THEN BEGIN
          s+='wind: '
       ENDIF ELSE BEGIN
          s+=STRING(i+1,FORMAT="(I4,': ')")
       ENDELSE
    ENDELSE
    IF i EQ -1 THEN BEGIN
       s=s+STRING( $
         xm0, $
         rn0, $
         un0, $
         FORMAT='(3(E25.16))')        
       GOTO,OUTPUT
    ENDIF
    IF i LT n THEN BEGIN
       s+=STRING($
          xm  [i], $
          rn  [i], $
          un  [i], $
          dn  [i], $
          tn  [i], $
          pn  [i], $
          en  [i], $
          stot[i], $
          angw[i], $
          abar[i], $
          ye  [i], $
          FORMAT='(11(E25.16))')
    ENDIF ELSE BEGIN
       s+=STRING(xm[i],'',FORMAT="(E25.16,A250)")
    ENDELSE
    IF flash EQ 0 THEN BEGIN
       s+=STRING(conv[i],FORMAT='(A16)')
       IF loadburn EQ 0 THEN BEGIN 
          s+=STRING(netid[netnum[i]-1],FORMAT='(A10)')
       ENDIF
    ENDIF
    IF model NE -1 THEN BEGIN
        FOR j=0,niso-1 DO BEGIN
            s=s+STRING(abu2string(yps[i,j]),FORMAT='(A25)')
        ENDFOR
    ENDIF ELSE IF loadburn NE 0 THEN BEGIN
        FOR j=0,in-1 DO BEGIN
            s=s+STRING(abu2string(iso[j,i]),FORMAT='(A25)')
        ENDFOR
    ENDIF ELSE IF approx THEN BEGIN
       IF netid[netnum[i]-1] NE 'APPROX' THEN BEGIN
          PRINT,' [PRESNDATA] ERROR - netid NE APPROX in zone ',i+1
          RETURN
       ENDIF
        s=s+STRING( $
          abu2string(ionnt1[i]), $
          abu2string(ionh01[i]), $
          abu2string(ionpn1[i]), $
          abu2string(ionhe3[i]), $
          abu2string(ionHe4[i]), $
          abu2string(ionC12[i]), $
          abu2string(ionN14[i]), $
          abu2string(ionO16[i]), $
          abu2string(ionNe20[i]), $
          abu2string(ionMg24[i]), $
          abu2string(ionSi28[i]), $
          abu2string(ionS32[i]), $
          abu2string(ionAr36[i]), $
          abu2string(ionCa40[i]), $
          abu2string(ionTi44[i]), $
          abu2string(ionCr48[i]), $
          abu2string(ionFe52[i]), $
          abu2string(ionFe54[i]), $
          abu2string(ionNi56[i]), $
          FORMAT='(19A25)')
    ENDIF ELSE BEGIN
        s=s+STRING($
          abu2string(ionnt1[i]), $
          abu2string(ionh1[i]), $
          abu2string(ionhe3[i]), $
          abu2string(ionHe4[i]), $
          abu2string(ionC12[i]), $
          abu2string(ionN14[i]), $
          abu2string(ionO16[i]), $
          abu2string(ionNe20[i]), $
          abu2string(ionMg24[i]), $
          abu2string(ionSi28[i]), $
          abu2string(ionS32[i]), $
          abu2string(ionAr36[i]), $
          abu2string(ionCa40[i]), $
          abu2string(ionTi44[i]), $
          abu2string(ionCr48[i]), $
          abu2string(ionFe52[i]), $
          abu2string(ionFe54[i]), $
          abu2string(ionNi56[i]), $
          abu2string(ionFe56[i]), $
          abu2string(ionFe[i]), $
          FORMAT='(20A25)')
     ENDELSE
    IF i LT n THEN BEGIN
       IF luminosity GT 0 THEN BEGIN
          s=s+STRING( $
            xln[i], $
            FORMAT='(1(E25.16))')    
       ENDIF
       IF diffusion GT 0 THEN BEGIN
          s=s+STRING( $
            difi[i], $
            FORMAT='(1(E25.16))')    
       ENDIF
       IF magnet GT 0 THEN BEGIN
          s=s+STRING( $
            bfbr[i], $
            bfbt[i], $
            FORMAT='(2(E25.16))')    
       ENDIF
       IF neutrino GT 0 THEN BEGIN
          s=s+STRING( $
            enu[i], $
            lnu[i], $
            fnu[i], $
            FORMAT='(3(E25.16))')    
       ENDIF
    ENDIF
OUTPUT:
    PRINTF,unit,s
ENDFOR

endofoutput:
IF unit NE -1 THEN BEGIN 
   CLOSE,unit
   FREE_LUN,unit
   IF !VERSION.RELEASE NE '6.0' THEN BEGIN
      IF aread NE 0 THEN BEGIN
         FILE_CHMOD, outfile, /A_READ 
      ENDIF
   ENDIF
ENDIF

END

;-----------------------------------------------------------------------
;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;-----------------------------------------------------------------------


; ===== COMPOSITION DATA README =====
; component   APPROX               NSE/QSE                                 UNIT
; neutrons    neutrons             neutrons                                (mass fraction) 
; H1          H1                   protons                                 (mass fraction)  
; He3         He3                  ---                                     (mass fraction) 
; He4         He4                  1 < A < 6                               (mass fraction) 
; C12         C12                  ---                                     (mass fraction)
; N14         N14                  ---                                     (mass fraction)
; O16         O16                  O16 (unburned)                          (mass fraction)
; Ne20        Ne20                 ---                                     (mass fraction)
; Mg24        Mg24                 22 < A < 29, excluding Si28             (mass fraction)
; Si28        Si28                 Si28                                    (mass fraction)  
; S32         S32                  28 < A < 36                             (mass fraction)
; Ar36        Ar36                 35 < A < 40                             (mass fraction) 
; Ca40        Ca40                 39 < A < 44                             (mass fraction) 
; Ti44        Ti44                 43 < A < 48                             (mass fraction)
; Cr48        Cr48                 47 < A < 52                             (mass fraction)  
; Fe52        Fe52                 ---                                     (mass fraction) 
; Fe54(+56)   Fe54                 A approx. 2*Z+2 Iron Peak               (mass fraction)
; Ni56        Ni56                 A < 2*Z+2 Iron Peak                     (mass fraction)
; Fe56        ---                  Fe56 only                               (mass fraction) 
; 'Fe'        ---                  A > 2*Z + 3  Iron Peak, excluding Fe56  (mass fraction)
; yq          ---                  A > 23 abundance                        (moles/g)
; yf          ---                  A > 46 + Ti46 abundance                 (moles/g)
; eb0         ---                  binding energy per nucleon              (MeV)

PRO presngrid,mode

dir0='/net/q/u/alex/kepler/'
outdir0='/web/alex/stellarevolution/'

CASE mode OF
    'solar' : BEGIN
        xmass=10.8D0+0.2D0*indgen(88)            
;        xmass=29D0+1.0D0*indgen(12)            
;        xmass=75D0+1.0D0*indgen(1)            
        dir=dir0+'sgrid/'
        outdir=outdir0+'solar/'
    END
    'ultra' : BEGIN
        xmass=11.D0+0.2D0*indgen(246)
;        xmass=75.D0+0.2D0*(0+indgen(1))
        dir=dir0+'ugrid/'
        outdir=outdir0+'ultra/'
    END
    'zero' : BEGIN
        xmass=0.1D0*(1+indgen(1000))
        dir=dir0+'znuc/'
        outdir=outdir0+'zero/'
    END
ENDCASE

n=N_ELEMENTS(xmass)

sentinel=STRMID(mode,0,1)

smass=mass_string(xmass)
run_name=sentinel+smass
dump=dir+run_name+'/'+run_name+'#presn'
outfile=outdir+sentinel+STRING(xmass,FORMAT='(F4.1)')

FOR i=0,n-1 DO BEGIN
    IF FILE_TEST(dump[i]) EQ 1 THEN BEGIN
        presndata,dump[i],OUTFILE=outfile[i]
        spawn,'chmod a+r '+outfile
        spawn,'gzip -9 '+outfile 
    ENDIF
ENDFOR

END

;-----------------------------------------------------------------------
;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;-----------------------------------------------------------------------

;   <tr>
;     <th BGCOLOR="DFDFFF">11.0</th>
;     <td width="120" align="center"><a href="solar/s11.0.gz">248 kByte</a></td>
;     <td width="120" align="center"><a href="ultra/u11.0.gz">245 kByte</a></td>
;   </tr>

PRO htmltable

xmass=0.1D0*(1+indgen(999))

n=N_ELEMENTS(xmass)

mass=STRING(xmass,FORMAT='(F4.1)')

dir0='/web/alex/stellarevolution/'
subdir=['solar','ultra','zero']
anno=['solar','10<sup>-4</sup> solar','primordial']

sentinel=STRMID(subdir,0,1)

m=N_ELEMENTS(subdir)

xsize=LONARR(m)
files=REPLICATE('',m)

PRINT,'<TABLE BORDER="1">'
PRINT,'  <TR>'
PRINT,'    <TH WIDTH="120" BGCOLOR="DFDFFF" ROWSPAN="2">mass<BR>(solar masses)</TH>'
PRINT,'    <TH WIDTH="120" BGCOLOR="FFDFDF" COLSPAN="'+STRING(m,FORMAT="(I2)")+'" ALIGN="CENTER">metallicity</TH>'
PRINT,'  </TR>'
PRINT,'  <TR>'
FOR j=0,m-1 DO BEGIN
    PRINT,'    <TH WIDTH="120" BGCOLOR="FFDFDF">'+anno[j]+'</TH>'
ENDFOR
PRINT,'  </TR>'
FOR i=0,n-1 DO BEGIN
    nfiles=0L
    FOR j=0,m-1 DO BEGIN
        files[j]=subdir[j]+'/'+sentinel[j]+mass[i]+'.gz'
        file=dir0+files[j]
        IF FILE_TEST(file) EQ 1 THEN BEGIN
            OPENR,unit,file,/GET_LUN
            xstat=FSTAT(unit)
            size=xstat.size
            CLOSE,unit
            FREE_LUN,unit
            nfiles=nfiles+1
        ENDIF ELSE BEGIN
            size=-1L
        ENDELSE
        xsize[j]=size        
    ENDFOR
    IF nfiles GT 0 THEN BEGIN
        PRINT,'  <TR>'
        PRINT,'    <TH BGCOLOR="DFDFFF">'+mass[i]+'</TH>'
        FOR j=0,m-1 DO BEGIN
            IF xsize[j] EQ -1 THEN BEGIN
                PRINT,'    <TD WIDTH="120" ALIGN="CENTER">---</TD>'
            ENDIF ELSE BEGIN
                size=byte2human(xsize[j])
                PRINT,'    <TD WIDTH="120" ALIGN="CENTER"><A HREF="'+files[j]+'">'+size+'</A></TD>'
            ENDELSE
        ENDFOR 
        PRINT,'  </TR>'
    ENDIF
ENDFOR
PRINT,'</TABLE>'

END

;-----------------------------------------------------------------------
;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;-----------------------------------------------------------------------

PRO yefiles

dir0='/net/q/u/alex/kepler/yeburn/'

runs=['s15a33','s25a33']
dirs=dir0+runs+'/'
dumps=['zams','hdep','hedep','cign','cdep','odep','sidep','presn']

FOR i=0,N_ELEMENTS(runs)-1 DO BEGIN
    cd,dirs[i]
    FOR j=0,N_ELEMENTS(dumps)-1 DO BEGIN
        presndata,runs[i]+'#'+dumps[j],OUTFILE=runs[i]+'_'+dumps[j]
    ENDFOR
ENDFOR


END

;-----------------------------------------------------------------------
;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;-----------------------------------------------------------------------

PRO thesis

dir0='/a/alex/THESIS/kepler/Link/presn/'
outdir0=dir0+'web/'

run_name=[['D15','D20'],['G15B','G20B'],['E15B','E20B'],['F15B','F20B']]

n=N_ELEMENTS(run_name)

dump=dir0+run_name+'#presn'
outfile=outdir0+run_name+'.txt'

; FOR i=0,n-1 DO BEGIN
;     IF FILE_TEST(dump[i]) EQ 1 THEN BEGIN
;         presndata,dump[i],OUTFILE=outfile[i]
;         spawn,'chmod a+r '+outfile[i]
;         spawn,'gzip -9 '+outfile[i] 
;     ENDIF
; ENDFOR

xmass=[15,20]

n=N_ELEMENTS(xmass)

mass=STRING(xmass,FORMAT='(F4.1)')

subdir=['solar','ultra','zero']
anno=['0 km/s','100 km/s','200 km/s','300 km/s']

m=N_ELEMENTS(anno)

xsize=LONARR(m)
files=REPLICATE('',m)

PRINT,'<TABLE BORDER="1">'
PRINT,'  <TR>'
PRINT,'    <TH WIDTH="120" BGCOLOR="DFDFFF" ROWSPAN="2">mass<BR>(solar masses)</TH>'
PRINT,'    <TH WIDTH="120" BGCOLOR="FFDFDF" COLSPAN="'+STRING(m,FORMAT="(I2)")+'" ALIGN="CENTER">ZAMS equatorial rotation velocity</TH>'
PRINT,'  </TR>'
PRINT,'  <TR>'
FOR j=0,m-1 DO BEGIN
    PRINT,'    <TH WIDTH="120" BGCOLOR="FFDFDF">'+anno[j]+'</TH>'
ENDFOR
PRINT,'  </TR>'
FOR i=0,n-1 DO BEGIN
    nfiles=0L
    FOR j=0,m-1 DO BEGIN
        files[j]=run_name[i,j]+'.txt.gz'
        file=outdir0+files[j]
        IF FILE_TEST(file) EQ 1 THEN BEGIN
            OPENR,unit,file,/GET_LUN
            xstat=FSTAT(unit)
            size=xstat.size
            CLOSE,unit
            FREE_LUN,unit
            nfiles=nfiles+1
        ENDIF ELSE BEGIN
            size=-1L
        ENDELSE
        xsize[j]=size        
    ENDFOR
    IF nfiles GT 0 THEN BEGIN
        PRINT,'  <TR>'
        PRINT,'    <TH BGCOLOR="DFDFFF">'+mass[i]+'</TH>'
        FOR j=0,m-1 DO BEGIN
            IF xsize[j] EQ -1 THEN BEGIN
                PRINT,'    <TD WIDTH="120" ALIGN="CENTER">---</TD>'
            ENDIF ELSE BEGIN
                size=byte2human(xsize[j])
                PRINT,'    <TD WIDTH="120" ALIGN="CENTER"><A HREF="'+files[j]+'">'+size+'</A></TD>'
            ENDELSE
        ENDFOR 
        PRINT,'  </TR>'
    ENDIF
ENDFOR
PRINT,'</TABLE>'

END

;-----------------------------------------------------------------------
;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;-----------------------------------------------------------------------
; COMMAND LIBRARY
;-----------------------------------------------------------------------

; presndata,'/u/alex/kepler/znucb0050/z25/z25D#nucleo',/BURN,O='~/Links/050_z25D@100s'
; presndata,'/u/alex/kepler/znucb0050/z25/z25D#300s'  ,/BURN,O='~/Links/znucb0050_z25D@300s'
; presndata,'/u/alex/kepler/znucb0050/z25/z25D#1000s' ,/BURN,O='~/Links/znucb0050_z25D@1000s'

; presndata,'/u/alex/kepler/znucb0050/z15/z15D#nucleo',/BURN,O='~/Links/znucb0050_z15D@100s'
; presndata,'/u/alex/kepler/znucb0050/z15/z15D#300s'  ,/BURN,O='~/Links/znucb0050_z15D@300s'
; presndata,'/u/alex/kepler/znucb0050/z15/z15D#1000s' ,/BURN,O='~/Links/znucb0050_z15D@1000s'

