FUNCTION sol_conv_iso2el, iso, MOL=mol

; this routine is to multiply a more than 2D array with the iso2el
; matrices.

@solabu_var
solabu

IF N_ELEMENTS(mol) EQ 0 THEN mol=0
IF mol EQ 0 THEN BEGIN
    mat=sol_iso2el
ENDIF ELSE BEGIN
    mat=sol_iso2el_mol
ENDELSE

x=size(iso,/DIMENSIONS)
n=PRODUCT(x[1:*],/integer)

y=[x[0],n]
el=REFORM(iso,y)##mat

x[0]=nsol_el
el=REFORM(el,x,/OVERWRITE)

RETURN,el
END

;-----------------------------------------------------------------------
;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;-----------------------------------------------------------------------

PRO solabutable, maxion, APJ=apj,OUTFILE=outfile

@solabu_var
solabu

IF N_ELEMENTS(maxion) EQ 0 THEN maxion=nsoldata

IF N_ELEMENTS(apj) EQ 0 THEN apj=1
outfileadd=''
IF apj EQ 1 THEN outfileadd='_apj'
apj_rotate=1
; apj_font='\normalsize'
; apj_fontsize='\small'
; apj_fontsize='\footnotesize'
apj_fontsize='\scriptsize'

IF apj THEN IF N_ELEMENTS(outfile) EQ 0 THEN BEGIN
   outfile='/u/alex/LaTeX/znuc/solabu'+outfileadd+'.tex'
ENDIF

caption='Adopted Solar Abundaces\lTab{solabu}'
ncol=6
nrow=maxion/ncol
IF nrow*ncol LT maxion THEN nrow+=1
lastcol=maxion-(ncol-1)*nrow

punit=-1

IF outfile NE '' THEN BEGIN
    OPENW,punit,outfile,/GET_LUN
ENDIF ELSE BEGIN
    punit=-1
ENDELSE

PRINTF,punit,'% ===================='
PRINTF,punit,'%   solar abundances'
PRINTF,punit,'% ====================='

head=''
align=''
FOR j=0,ncol-1 DO BEGIN
   IF apj THEN BEGIN
      head+='\colhead{ion} & \colhead{mass frac.} '
   ENDIF ELSE BEGIN
      head+='ion & mass frac. '
   ENDELSE
   align+='lr'
    IF j LT ncol-1 THEN BEGIN 
        head+='& ' 
        align+='|'
    ENDIF ELSE BEGIN 
       IF apj THEN BEGIN
          head+=''
       ENDIF ELSE BEGIN
          head+='\\'
       ENDELSE
    ENDELSE
ENDFOR


IF apj THEN BEGIN
   PRINTF,punit,'\begin{deluxetable}{'+align+'}'
   PRINTF,punit,'\tablecaption{'+caption+'}'
   PRINTF,punit,'\tablecolumns{'+STRTRIM(STRING(2*ncol),2)+'}'
   PRINTF,punit,'\tablewidth{0pt}'
   PRINTF,punit,'\tabletypesize{'+apj_fontsize+'}'
   IF apj_rotate EQ 1 THEN BEGIN 
      PRINTF,punit,'\rotate'          
   ENDIF
   PRINTF,punit,'\tablehead{'
   PRINTF,punit,head
   PRINTF,punit,'}'
   PRINTF,punit,'\startdata'
ENDIF ELSE BEGIN
   PRINTF,punit,'\begin{table}'
   PRINTF,punit,'\caption{'+caption+'}'
   PRINTF,punit,'\begin{tabular}{'+align+'}'
   PRINTF,punit,'\hline'
   PRINTF,punit,'\hline'
   PRINTF,punit,'\noalign{\smallskip}'
   PRINTF,punit,head
   PRINTF,punit,'\noalign{\smallskip}'
   PRINTF,punit,'\hline'
   PRINTF,punit,'\noalign{\smallskip}'
ENDELSE   

FOR i=0,nrow-1 DO BEGIN
    s=''
    FOR j=0,ncol-1 DO BEGIN
        ii=i+j*nrow
        if ii LT maxion THEN BEGIN
            s+=latexion(sol_ion[ii])
            s+=' & '
            s+=latexe(sol_abu[ii])
        ENDIF ELSE BEGIN
            s+='            & '
        ENDELSE
        IF j LT ncol-1 THEN s+=' & ' ELSE s+=' \\'
    ENDFOR
    PRINTF,punit,s
ENDFOR

IF apj THEN BEGIN
   PRINTF,punit,'\enddata'
   PRINTF,punit,'\end{deluxetable}'
ENDIF ELSE BEGIN
   PRINTF,punit,'\noalign{\smallskip}'
   PRINTF,punit,'\hline'
   PRINTF,punit,'\end{tabular}'
   PRINTF,punit,'\end{table}'
ENDELSE

IF punit NE -1 THEN BEGIN
    CLOSE,punit
    FREE_lun,punit
ENDIF

END

;-----------------------------------------------------------------------
;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;-----------------------------------------------------------------------

PRO solabu,RELOAD=reload,FILE=file

@solabu_var

common solabu_file,solabufile

;abundances normalized after 4/4/05 to Lodders (2003)
;abundances normalized after 4/3/10 to Lodders (2009)

IF N_ELEMENTS(file) EQ 0 THEN file=''

IF file EQ '' THEN BEGIN
    file=GETENV('SOLABU_DATA')
ENDIF
IF file NE '' THEN BEGIN
    files=FILE_SEARCH(file,/EXPAND_ENVIRONMENT, COUNT=count)
    IF count EQ 0 THEN BEGIN
        PRINT,' [SOLABU] ERROR: data file "'+file+'" not found'
        RETALL    
     ENDIF
    file=files[0]
ENDIF

IF file EQ '' THEN BEGIN 
    searchpaths=['./','$HOME/kepler/local_data/']
    searchfiles=['sollo03.dat','solabu.dat','sollo09.dat','solag89.dat']
    FOR i=0,N_ELEMENTS(searchpaths)-1 DO BEGIN
        FOR j=0,N_ELEMENTS(searchfiles)-1 DO BEGIN
            searchfile=searchpaths[i]+searchfiles[j]
            x=FILE_SEARCH(searchfile,COUNT=nfound)
            IF nfound EQ 1 THEN GOTO, FOUND
        ENDFOR
    ENDFOR
    GOTO, DONE
FOUND:
    file=x[0]
DONE:
END
IF N_ELEMENTS(solabufile) EQ 0 THEN solabufile=''
IF file EQ '' THEN BEGIN
    PRINT,' [SOLABU] ERROR: No abundance data file found.'
    RETALL
ENDIF
IF file NE solabufile THEN reload=1
solabufile=file

IF N_ELEMENTS(reload) EQ 0 THEN reload=0
IF N_ELEMENTS(sol_ion) EQ 0 THEN reload=1
IF reload EQ 0 THEN RETURN

PRINT,' [SOLABU] Loading solar abundance data from '+file

loadabu,file, $
        ION=sol_ion,$
        X=sol_abu, $
        Y=sol_mol, $
        A=sol_a, $
        Z=sol_z, $
        IDX=sol_idx, $
        N=nsoldata

sol_n=sol_a-sol_z

; elemental abundances
e=DBLARR(1000)
en=REPLICATE('',1000)
m=REPLICATE(0L,1000)
ez=REPLICATE(0L,1000)
em=DBLARR(1000)

j=-1
en0=' '
FOR i=0,nsoldata-1 DO BEGIN
    en1=getionel(sol_ion[i])
    IF en1 NE en0 THEN BEGIN
        j+=1
        en[j]=en1
        en0=en1
        ez[j]=sol_z[i]
    ENDIF
    e[j]+=sol_abu[i]
    em[j]+=sol_abu[i]/sol_a[i]
    m[j]=i
ENDFOR
sol_el_abu=e[0:j]
sol_el_name=en[0:j]
sol_el_map=m[0:j]
sol_el_z=ez[0:j]
sol_el_mol=em[0:j]
nsol_el=j+1

; mass number abundances
nsol_aa=MAX(sol_a)
ax=DBLARR(nsol_aa+1)

FOR i=0,nsoldata-1 DO BEGIN
    j=sol_a[i]
    ax[j]=ax[j]+sol_abu[i]
ENDFOR
aa=WHERE(ax NE 0)
ax=ax[aa]
ay=ax[*]/aa[*]
an=STRTRIM(STRING(aa,FORMAT="(I3)"),2)

sol_aa_abu=ax
sol_aa_name=an
sol_aa_a=aa
sol_aa_mol=ay
nsol_aa=N_ELEMENTS(aa)

; make matrices for mapping
sol_iso2el=BYTARR(nsol_el,nsoldata)
sol_iso2el_mol=DBLARR(nsol_el,nsoldata)
sol_iso2aa=BYTARR(nsol_aa,nsoldata)
sol_iso2aa_mol=DBLARR(nsol_aa,nsoldata)

FOR i=0,nsoldata-1 DO BEGIN
    jz=WHERE(sol_z[i] EQ sol_el_z)
    ja=WHERE(sol_a[i] EQ sol_aa_a)
    a1=1.D0/sol_a[i]
    sol_iso2el[jz,i]=1
    sol_iso2el_mol[jz,i]=a1
    sol_iso2aa[ja,i]=1
    sol_iso2aa_mol[ja,i]=a1
ENDFOR

@elements
sol_z2el=REPLICATE(-1,N_ELEMENTS(elements))
FOR i=0,nsol_el-1 DO BEGIN
    sol_z2el[sol_el_z[i]]=i
ENDFOR

END

