pro yieldplot,y,iso,$
              XRANGE=xrange,YRANGE=yrange, $
              XTITLE=xtitle,YTITLE=ytitle, $
              FONTSIZE=fontsize,DIST=dist, $
              NCGROUP=ncgroup,NCFOLD=ncfold, $
              XMARGIN=xmargin,YMARGIN=ymargin, $
              XCHARSIZE=xcharsize,YCHARSIZE=ycharsize, $
              XLOG=xlog,YLOG=ylog, $
              BW=bw,LOGY=logy, $
              THICK=thick, LINE=line, $
              TITLE=title, $
              NORM=norm, NRANGE=nrange, $
              NOERASE=noerase, NONEWFRAME=nonewframe, $
              NOLABELS=nolabelS, $
              POSITION=position, $
              DOTSIZE=dotsize, DOTTHICK=dotthick, $
              DOTFILL=dotfill, SHOWDOT=showdot, $
              SCALE=scale, $
              COLOR=color, $
              ELEMTHICK=elemthick, $
              USERSYMBOL=usersymbol

              
nx=N_ELEMENTS(iso)
IF N_ELEMENTS(y) NE nx THEN BEGIN
    PRINT,' [YIELDPLOT] "y" DIMENSION WRONG '
    PRINT,' [YIELDPLOT] REQUIRED DIMESION: '
    HELP,iso           
    PRINT,' [YIELDPLOT] DIMENSION OF ARGUMENT: '
    HELP,y
    RETURN
ENDIF

IF N_ELEMENTS(scale) EQ 0 THEN scale=1
vv=y*scale

xnorm=1.D0
IF N_ELEMENTS(nrange) EQ 0 THEN nrange=2
IF N_ELEMENTS(norm) EQ 0 THEN norm='o16'
IF norm NE '' THEN BEGIN
    inorm=WHERE(iso EQ norm)
    IF inorm(0) EQ -1 THEN BEGIN
        PRINT,' [YIELDPLOT] ERROR: norming isotope "'+norm+'" not found.'
        norm=''
    ENDIF ELSE BEGIN
        xnorm=vv(inorm)
        xnorm=xnorm(0)*[1,nrange,1.D0/nrange]
    ENDELSE
ENDIF

iondecompose,iso,a,el,/NUMA

; determine whether isotope, element, or mass plot
z=getionz(iso)
z0=MAX(z,MIN=z1)
n=a-z
n0=MAX(n,MIN=n1)
IF (n0 EQ 0) and (n1 EQ 0) THEN element=1 ELSE element=0
IF (z0 EQ 0) and (z1 EQ 0) THEN mass=1 ELSE mass=0
IF (element EQ 1) THEN BEGIN
    a=z
    el[*]=''
ENDIF

; plot setup
IF N_ELEMENTS(thick) EQ 0 THEN thick=!P.THICK
IF N_ELEMENTS(line) EQ 0 THEN line=0
IF N_ELEMENTS(xmargin) EQ 0 THEN xmargin=[10,3]
IF N_ELEMENTS(ymargin) EQ 0 THEN ymargin=[4,2]
IF N_ELEMENTS(xcharsize) EQ 0 THEN xcharsize=1
IF N_ELEMENTS(ycharsize) EQ 0 THEN ycharsize=1
IF N_ELEMENTS(xlog) EQ 0 THEN xlog=0
IF N_ELEMENTS(logy) EQ 0 THEN logy=0
IF N_ELEMENTS(ylog) EQ 0 THEN BEGIN
    IF logy EQ 0 THEN ylog=1 ELSE ylog=0
ENDIF
IF N_ELEMENTS(title) EQ 0 THEN title=''
IF N_ELEMENTS(xtitle) EQ 0 THEN BEGIN
    IF (element EQ 1) THEN BEGIN
        xtitle='charge number'
    ENDIF ELSE BEGIN
        xtitle='mass number'
    ENDELSE
ENDIF
IF N_ELEMENTS(ytitle) EQ 0 THEN ytitle='yield'

IF logy THEN BEGIN
    vv=ALOG10(vv)
    xnorm=ALOG10(xnorm)
    ytitle="log( "+ytitle+" )"
ENDIF
IF N_ELEMENTS(showdots) EQ 0 THEN BEGIN
    IF (mass EQ 1) OR (element EQ 1) THEN showdots=0 ELSE showdots=1
ENDIF

IF N_ELEMENTS(xrange) EQ 0 THEN xrange=[MIN(a)-1,MAX(a)+1]
IF N_ELEMENTS(yrange) EQ 0 THEN yrange=[0.9*MIN(vv),1.1*MAX(vv)]


IF N_ELEMENTS(noerase) EQ 0 THEN noerase=0
IF N_ELEMENTS(nonewframe) EQ 0 THEN nonewframe=0
IF nonewframe EQ 0 THEN BEGIN
    plot,xrange,yrange,/nodata,XSTYLE=5,YSTYLE=5, $
      XMARGIN=xmargin,YMARGIN=ymargin, $
      XCHARSIZE=xcharsize,YCHARSIZE=ycharsize, $
      XLOG=xlog,YLOG=ylog, $
      NOERASE=noerase,POSITION=position
    POLYFILL,xrange([0,1,1,0]),yrange([0,0,1,1]),COLOR=!P.BACKGROUND

    pmsave=!P.MULTI
    !P.MULTI[0]=!P.MULTI[0]+1
    
    plot,xrange,yrange,/nodata,/XSTYLE,/YSTYLE, $
      XTITLE=xtitle,YTITLE=ytitle, TITLE=title, $
      XMARGIN=xmargin,YMARGIN=ymargin, $
      XCHARSIZE=xcharsize,YCHARSIZE=ycharsize, $
      XLOG=xlog,YLOG=ylog, $
      /NOERASE,POSITION=position
ENDIF    


;g=[200,100,100]
;tvlct,g,g,g,2
c=[1,1,1]*!P.COLOR
l=[2,1,1]
FOR i=0,N_ELEMENTS(xnorm)-1 DO BEGIN
    oplot,xrange,[1,1]*xnorm(i),COLOR=c(i),LINE=l(i)
ENDFOR
  
nn0=CONVERT_COORD([xrange(0),yrange(0)],/DATA,/TO_NORMAL)
nn1=CONVERT_COORD([xrange(1),yrange(1)],/DATA,/TO_NORMAL)
nnm=0.5D0*(nn0+nn1)

; dot properties
IF N_ELEMENTS(dotsize) EQ 0 THEN dotsize=1.0
IF N_ELEMENTS(dotthick) EQ 0 THEN dotthick=!P.THICK
IF N_ELEMENTS(dotfill) EQ 0 THEN dotfill=1
IF N_ELEMENTS(usersymbol) EQ 0 THEN usersymbol=-1
IF usersymbol EQ -1 THEN BEGIN
    psymdot,SIZE=dotsize,FILL=dotfill,THICK=dotthick
    psym=8
ENDIF ELSE BEGIN
    psym=usersymbol
ENDELSE
IF N_ELEMENTS(elemthick) EQ 0 THEN elemthick=thick

; annotation setup
IF N_ELEMENTS(fontsize) EQ 0 THEN fontsize=1
IF N_ELEMENTS(dist) EQ 0 THEN dist=0.3*dotsize
IF !P.charsize NE 0 THEN BEGIN
    charsize=!P.charsize*fontsize
ENDIF ELSE BEGIN
    charsize=fontsize
ENDELSE
cx=!D.X_CH_SIZE*charsize
cy=!D.Y_CH_SIZE*charsize
nc0=CONVERT_COORD([0,0],/DEVICE,/TO_NORMAL)
nc1=CONVERT_COORD([cx,cy],/DEVICE,/TO_NORMAL)
nc=nc1-nc0
distd=dist*nc(1)
distx=0.7*nc(1)+2*distd
distb=0.15*nc(1)
lab=REPLICATE('',nx)
labx=DBLARR(nx)
laby=DBLARR(nx)
laba=DBLARR(nx)

; ==== color setup ===
; I guess this is something that comes from group theory:
;    ncolors should be m*ncfold-1 where m is a natural number.
IF N_ELEMENTS(bw) EQ 0 THEN bw=0
IF bw NE 0 THEN BEGIN
    IF N_ELEMENTS(darkest) EQ 0 THEN darkest=0.2
    IF N_ELEMENTS(lightest) EQ 0 THEN lightest=0.8
    spectrum,BW=bw,DARKEST=darkest,LIGHTEST=lightest
    ncolors0=8
    ncfold0=3
ENDIF ELSE BEGIN
;    spectrum
    ncolors0=11
    ncfold0=3
ENDELSE
IF N_ELEMENTS(ncolors) EQ 0 THEN ncolors=ncolors0
IF N_ELEMENTS(ncfold) EQ 0 THEN ncfold=ncfold0
IF N_ELEMENTS(color) EQ 0 THEN BEGIN
    c=isocolors(ncolors)
ENDIF ELSE BEGIN
    IF !D.N_COLORS GT 256 THEN BEGIN
        c0=color
    ENDIF ELSE BEGIN
        TVLCT,color/65536L,(color/256) mod 256, color mod 256,1
        c0=1
    ENDELSE
    c=REPLICATE(c0,ncolors)
ENDELSE
csel=(indgen(ncolors)*ncfold) mod ncolors
; PRINT,' [YIELDPLOT] colors ',csel
c=c(csel)

first=1
n=0
labn=0
FOR i=0,nx-1 DO BEGIN
   IF (first EQ 1) THEN BEGIN
       elx=el(i)
       id0=i
       first=0
       n=n+1
   ENDIF
   fin=0
   IF (i EQ nx-1) THEN BEGIN
       fin=1
   ENDIF ELSE BEGIN
       IF (el(i+1) NE elx) THEN fin=1
       IF (element EQ 1) THEN fin=0
   ENDELSE
   IF fin EQ 1 THEN BEGIN
       id1=i

; test for visabillity
       ip0=id0
       ip1=id1
       FOR j=id0,id1 DO BEGIN
           IF (a(j) LT xrange(0)) THEN ip0=ip0+1
           IF (a(j) GT xrange(1)) THEN ip1=ip1-1
       ENDFOR
       ipn=ip1-ip0+1
       FOR j=ip0,ip1 DO BEGIN
           IF (vv(j) LT yrange(0)) OR (vv(j) GT yrange(1)) $
             THEN ipn=ipn-1
       ENDFOR
       IF ipn LE 0 THEN GOTO,no_plot
       
       idn=id1-id0+1
       idr=indgen(idn)+id0


; draw lines and dots
       color=c(n mod ncolors)
       if idn GT 1 THEN BEGIN 
           oplot,a(idr),vv(idr),COLOR=color,THICK=elemthick,LINE=line
       ENDIF
       IF showdots EQ 1 THEN BEGIN
           oplot,a(idr),vv(idr),PSYM=psym,COLOR=color
       ENDIF
           
; determine label locations
       IF (mass EQ 0) AND (element EQ 0) THEN BEGIN
           iam=a(id0)+a(id1)
           FOR j=id0,id1 DO BEGIN
               IF 2*a(j) LE iam THEN idm0=j
           ENDFOR
           FOR j=id1,id0,-1 DO BEGIN
               IF 2*a(j) GE iam THEN idm1=j 
           ENDFOR
           
           dl0=[a(idm0),vv(idm0)]
           dl1=[a(idm1),vv(idm1)]
           nl0=CONVERT_COORD(dl0,/DATA,/TO_NORMAL)
           nl1=CONVERT_COORD(dl1,/DATA,/TO_NORMAL)
           nl=0.5D0*(nl0+nl1)
           align=0.5D0
           
; determine bottom/top alignment
           IF idm0 NE idm1 THEN BEGIN
               IF nl(1) LT nn0(1)+nc(1) THEN BEGIN
                   nl(0)=nl0(0)+0.5*(nl1(0)-nl0(0))*(nl1(1)-nn0(1))/(nl1(1)-nl0(1))
                   nl(1)=0.5D0*(MAX([nn0(1),nl0(1)])+MAX([nn0(1),nl1(1)]))
               ENDIF ELSE IF nl(1) GT nn1(1)-nc(1) THEN BEGIN
                   nl(0)=nl0(0)+0.5*(nl1(0)-nl0(0))*(nl1(1)-nn1(1))/(nl1(1)-nl0(1))
                   nl(1)=0.5D0*(MAX([nn1(1),nl0(1)])+MAX([nn1(1),nl1(1)]))
               ENDIF
               nl(1)=nl(1)-0.5*nc(1)+distb
           ENDIF ELSE BEGIN
               nl(1)=nl(1)+distd
               IF id0 NE id1 THEN BEGIN
                   nv0=CONVERT_COORD([a(idm0-1),vv(idm0-1)],/DATA,/TO_NORMAL)
                   nv1=CONVERT_COORD([a(idm0+1),vv(idm0+1)],/DATA,/TO_NORMAL)
                   
                   IF (((nv0(1)+nv1(1)) GT 2*nl(1)) AND (nl(1) GT nn0(1)+distx+nc(1))) $
                     OR (nl(1) GT nn1(1)-2*nc(1)) THEN BEGIN
                       nl(1)=nl(1)-distx
                   ENDIF 
               ENDIF ELSE BEGIN
                   IF ((nl(1) LT nnm(1)) AND (nl(1) GT nn0(1)+distx+nc(1))) OR $
                     (nl(1) GT nn1(1)-2*nc(1)) THEN BEGIN
                       nl(1)=nl(1)-distx
                   ENDIF 
               ENDELSE
           ENDELSE
           
; determine left/right alignment
           xyouts,0.5,0.5,elx,CHARSIZE=-charsize,WIDTH=nw,/NORMAL
           IF nl(0) LT nn0(0)+0.5D0*nw THEN align=MAX([0,(nl(0)-nn0(0))/nw])
           IF nl(0) GT nn1(0)-0.5D0*nw THEN align=MIN([1.D0,(nl(0)-(nn1(0)-nw))/nw])
           
; save output lables
           dl=CONVERT_COORD(nl,/NORMAL,/TO_DATA)
           IF (nl(0) GT nn0(0)) AND (nl(0) LT nn1(0)) AND (nl(1) GT nn0(1)) AND (nl(1) LT nn1(1) ) THEN BEGIN
               labx(labn)=dl(0)
               laby(labn)=dl(1)
               lab(labn)=elx
               laba(labn)=align
               labn=labn+1
           ENDIF
       ENDIF ELSE IF (element EQ 1) THEN BEGIN
           align=0.5D0
           dl0=[a(id0),vv(id0)]           
           dl1=[a(id1),vv(id1)]
           nl0=CONVERT_COORD(dl0,/DATA,/TO_NORMAL)
           nl1=CONVERT_COORD(dl1,/DATA,/TO_NORMAL)
           IF nl0[1] LT nl1[1] THEN BEGIN
               
           ENDIF


           
           FOR j=id0,id1 DO BEGIN

           ENDFOR
           
       ENDIF

no_plot:
       first=1
   ENDIF
ENDFOR

; output lables
IF N_ELEMENTS(nolabels) EQ 0 THEN BEGIN
    IF (mass EQ 1) OR (element EQ 1) THEN BEGIN
        nolabels=1
    ENDIF ELSE BEGIN
        nolabels=0
    ENDELSE
ENDIF
IF nolabels EQ 0 THEN BEGIN
    FOR i=0,labn-1 DO BEGIN
        xyouts,labx(i),laby(i),lab(i),ALIGNMENT=laba(i),CHARSIZE=charsize,NOCLIP=0
    ENDFOR
ENDIF

IF nonewframe EQ 0 THEN BEGIN
    !P.MULTI=pmsave
ENDIF

END

