FUNCTION isocolors,n,TABLE=table,PALETTE=palette

IF !D.N_COLORS LE 256 THEN BEGIN
    IF N_ELEMENTS(palette) EQ 0 THEN palette=-1
    IF palette GE -1 THEN BEGIN
        H=REPLICATE(1,n)
        S=REPLICATE(1,n)
        V=360*(DINDGEN(n)/n)
        ipalette=palette
        IF ipalette[0] EQ -1 THEN ipalette=REPLICATE(-1,n)
        IF N_ELEMENTS(ipalette) NE n THEN ipalette=ipalette+INDGEN(n)
        FOR i=0,N_ELEMENTS(ipalette)-1 DO BEGIN
            x=hsv_color(h[i],s[i],v[i],PALETTE=ipalette[i])
            ipalette[i]=x
        ENDFOR
        c=ipalette
    ENDIF ELSE BEGIN
        IF N_ELEMENTS(table) EQ 0 THEN table=1
        IF table THEN ncolors=!D.TABLE_SIZE ELSE ncolors=256
        c=1+ROUND((DINDGEN(n)/n)*(ncolors-2))
    ENDELSE
ENDIF ELSE BEGIN
    H=REPLICATE(1,n)
    S=REPLICATE(1,n)
    V=360*(DINDGEN(n)/n)
    c=HSV_COLOR(H,S,V)
ENDELSE

RETURN,c
END
