PRO plotlc,ZONES=xzones, $
           NSTART=nstart, $
           NEND=nend, $
           XRANGE=xrange0, $
           YRANGE=yrange0, $
           SECONDS=seconds, $
           MINUTES=minutes, $
           HOURS=hours, $
           DAYS=days, $
           YEARS=years, $
           XMARGIN=xmargin, $
           YMARGIN=ymargin, $
           YLOG=ylog, $
           XLOG=xlog, $
           T0=t0, $
           COLOR=color, $
           THICK=thick, $
           XXFRAC=xxfrac, $ ; for "sphaghetti" plots
           XXRANGE=xxrange, $
           XXANO=xxano, $
           XXNOTICK=xxnotick, $
           XXTICKINTERVAL=xxtickinterval, $
           XXTICKFORMAT=xxtickformat, $
           XXTITLE=xxtitle, $
           XXLABEL=xxlabel, $
           YSCALE=yscale, $
           XTITLE=xtitle, $
           YTITLE=ytitle, $
           LOGY=logy, $
           XOFFSET=xoffset, $
           MAXLUM=maxlum, $
           DOPRINT=doprint, $
           PRINTFILE=printfile, $
           PSYM=psym, $
           REDUCE=reduce, $
           SHOWTIME=showtime, $
           PDF=pdf, $
           MAG=mag, $
           LSUN=lsun, $
           OVERPLOT=overplot


IF N_ELEMENTS(showtime) EQ 0 THEN showtime=1
starttime=SYSTIME(/SECONDS)

COMMON lc,  nmodellmax,time,modellnr,modells,teff,radius,xlum,vphot,xlphot
COMMON lc1, ndata,ndatamax,rn,un,xln

; plotlc,t0=3.132d3,/ylog
; PSFL,"plotlc,t0=3.032d3,/ylog,yrange=[1.d38,2.d45],/xlog,xr=[1.,3.d7]","/u/alex/kepler/znuc/z25/yyy0.photo,ps"
; psfl,'plotlc,/hours,/logy,xm=[6.2,0.15],ym=[3.2,0.1],xt="time / h"','/u/alex/Plots/XRB/xrba5.lc.llog.ps'
@physconst

IF N_ELEMENTS(printfile) EQ 0 THEN printfile=''
IF printfile NE '' THEN doprint=1
IF N_ELEMENTS(doprint) EQ 0 THEN doprint=0

; output plot to file
IF N_ELEMENTS(pdf) EQ 0 THEN pdf=''
IF pdf NE '' THEN BEGIN
   openpsfl,pdf,/PDF
ENDIF


; "spaghetti" plot setip
spaghetti=0
IF N_ELEMENTS(xxfrac) GT 2 THEN spaghetti=1

IF N_ELEMENTS(psym) EQ 0 THEN psym=0

timeunit='s'
timescale=1.D0
IF N_ELEMENTS(seconds) EQ 0 THEN seconds=0
IF seconds EQ 1 THEN BEGIN
    timescale=1.D0
    timeunit='s'
ENDIF
IF N_ELEMENTS(minutes) EQ 0 THEN minutes=0
IF minutes EQ 1 THEN BEGIN
    timeunit='min'
    timescale=60.D0
ENDIF 
IF N_ELEMENTS(hours) EQ 0 THEN hours=0
IF hours EQ 1 THEN BEGIN
    timescale=3600.D0
    timeunit='h'
ENDIF
IF N_ELEMENTS(days) EQ 0 THEN days=0
IF days EQ 1 THEN BEGIN
    timescale=86400.D0
    timeunit='d'
ENDIF
IF N_ELEMENTS(years) EQ 0 THEN years=0
IF years EQ 1 THEN BEGIN
    timescale=SEC
    timeunit='yr'
ENDIF

IF N_ELEMENTS(mag) EQ 0 THEN mag=0
IF mag NE 0 THEN lsun=0
IF N_ELEMENTS(lsun) EQ 0 THEN lsun=0

IF N_ELEMENTS(nstart) EQ 0 THEN nstart=0
IF N_ELEMENTS(nend)   EQ 0 THEN nend=N_ELEMENTS(time)-1

IF N_ELEMENTS(xmargin) NE 2 THEN xmargin=[10,3]
IF N_ELEMENTS(ymargin) NE 2 THEN ymargin=[3.5,0.2]

IF N_ELEMENTS(t0) EQ 0 THEN t0=0

ptime=time[nstart:nend]/timescale-t0
ndata=nend-nstart+1

IF N_ELEMENTS(xrange0) NE 2 THEN BEGIN
    xmin=MIN(ptime,MAX=xmax)
    xrange0=[xmin,xmax]
ENDIF
xrange=xrange0

IF N_ELEMENTS(ylog) EQ 0 THEN ylog=1
IF N_ELEMENTS(xlog) EQ 0 THEN xlog=0
IF N_ELEMENTS(logy) EQ 0 THEN logy=0
IF logy EQ 1 THEN ylog=0

IF N_ELEMENTS(xzones) EQ 0 THEN xzones=ndatamax-1
zones=xzones
IF zones[0] LT 0 THEN zones=zones+ndatamax

IF N_ELEMENTS(maxlum) EQ 0 THEN maxlum=0
IF maxlum NE 0 THEN zones=indgen(MAX(ndata))

xl=xln[nstart:nend,*]

IF mag EQ 1 THEN BEGIN
   ylog=0
   logy=0
   xl=+4.77D0-ALOG10(xl/XLSUN)*2.5D0
   IF N_ELEMENTS(yrange0) NE 2 THEN BEGIN
      ymin=MIN(xl[*,zones],MAX=ymax)
      ymax=MAX([ymax,ymin+6])
      yrange0=[ymax,ymin]
   ENDIF
ENDIF

IF lsun EQ 1 THEN BEGIN
   xl/=XLSUN
ENDIF

IF logy EQ 1 THEN xl=ALOG10(xl>1.D-99)

IF N_ELEMENTS(yrange0) NE 2 THEN BEGIN
    ymin=MIN(xl[*,zones],MAX=ymax)
    IF logy THEN BEGIN
       ymin=MAX([ymin,ymax-6.D0])
    ENDIF ELSE BEGIN
       ymin=MAX([ymin,1.D-6*ymax])
    ENDELSE
    yrange0=[ymin,ymax]
ENDIF
yrange=yrange0

IF N_ELEMENTS(yscale) EQ 0 THEN yscale=1
yrange=yrange/yscale

str_large=1
@strings

ytitle1='L / erg s'+str_exp+'-1!n'
IF lsun EQ 1 THEN ytitle1='L / '+str_lsun
IF logy EQ 1 THEN ytitle1='log( '+ytitle1+' )'
IF doprint EQ 1 THEN ytitle1=ytitle1+'  R / 1!a-30!n!b !ncm'
IF mag EQ 1 THEN ytitle1='M!bbol!n'

IF N_ELEMENTS(xtitle) EQ 0 THEN xtitle='time / '+timeunit
IF N_ELEMENTS(ytitle) EQ 0 THEN ytitle=ytitle1

scaleaxis,ptime,/RESCALE,RANGE=xrange,/SETRANGE,TITLE=xtitle,LIMIT=2,POWERRANGE=0,/LARGESUBSCRIPTS

xthick=!P.THICK
IF xthick EQ 0 THEN xthick=1
t=2*xthick
IF N_ELEMENTS(thick) EQ 0 THEN t=xthick ELSE t=thick

IF N_ELEMENTS(color) EQ 0 THEN color=0
CASE color OF
    1: BEGIN
        c=RGB(1.,0.,0.)
        c=REPLICATE(c,ndatamax)
    END
    2: c=isocolors(ndatamax,/palette)
    0: BEGIN
        c=REPLICATE(!P.COLOR,ndatamax)
    END
ENDCASE

IF N_ELEMENTS(overplot) EQ 0 THEN overplot=0
IF (overplot EQ 0) THEN BEGIN
   multi_save=!P.MULTI
   PLOT,[0,1],/NODATA, YLOG=ylog, XLOG=xlog, $
        XRANGE=xrange,YRANGE=yrange, $
        XTITLE=xtitle, YTITLE=ytitle, $
        XSTYLE=5,XMARGIN=xmargin, $
        YSTYLE=5,YMARGIN=ymargin
ENDIF

maxzone=INTARR(nmodellmax)
IF maxlum NE 0 THEN BEGIN
   FOR i=0L,nmodellmax-1 DO BEGIN
      x=SORT(xl[i,*])
      IF mag NE 1 THEN x=x[N_ELEMENTS(x)-1]
      maxzone[i]=x[0]
   ENDFOR
   zones=-1
ENDIF

IF N_ELEMENTS(reduce) EQ 0 THEN reduce=1

nzones=N_ELEMENTS(zones)
;FOR i=0,ndatamax-1 DO BEGIN
FOR i=0,nzones-1 DO BEGIN
   ii=zones[i]
   x=ptime[*]
   IF maxlum NE 0 THEN BEGIN
      
; assume luminosity from zone with highest luminosity
      y=xl[*,0]
      FOR j=0L,nmodellmax-1 DO BEGIN
         y[j]=xl[j,maxzone[j]]
      ENDFOR
      
; for zones before the peak (breakout) assume L of zone at peak
        xx=SORT(y)
        if mag EQ 1 THEN xx=REVERSE(xx)
        xx=xx[N_ELEMENTS(xx)-1]
        print,' [PLOTLC] assuming surface zone '+STRTRIM(STRING(maxzone[xx]),2)+' before Model Nr '+STRTRIM(STRING(ModellNr[xx]),2)+' (ptime = '+STRTRIM(STRING(ptime[xx]),2)+')'
        FOR j=0L,xx-1 DO BEGIN
            y[j]=xl[j,maxzone[xx]]
        ENDFOR

    ENDIF ELSE BEGIN
        y=xl[*,ii]
    ENDELSE

    y=y/yscale
    jj=WHERE(x GT xrange[1])
    IF jj[0] NE -1 THEN j1=jj[0] ELSE j1=N_ELEMENTS(x)-1
    jj=WHERE(x LT xrange[0])
    IF jj[0] NE -1 THEN j0=jj[N_ELEMENTS(jj)-1] ELSE j0=0
    x=x[j0:j1]
    y=y[j0:j1]
    IF mag EQ 0 THEN BEGIN
       FOR j=1L,N_ELEMENTS(y)-1L DO BEGIN
          IF y[j] LE 0 THEN y[j]=y[j-1]
       ENDFOR
    ENDIF
    IF reduce NE 0 THEN BEGIN
        reduce,x,y,/plot,/v,truncate=0
    ENDIF

; **** some smoothing ****
;      FOR d=1L,4L DO BEGIN
;          dd=d
;          if dd EQ 4 THEN dd=1
;          FOR j=dd,N_ELEMENTS(y)-dd-1 DO BEGIN
;              dy1=(y[j]-y[j-dd])
;              dy2=(y[j+dd]-y[j])
;              dy0=dy1+dy2
;              y0=y[j-dd]+dy0*(x[j]-x[j-dd])/(x[j+dd]-x[j-dd])
;              IF (dy1*dy2 LT 0.D0) AND $
;                (ABS(y[j]-y0) GT (0.1*y[j])) AND $
;                (x[j] GT 1.d6) AND $
;                (ABS(dy1) GT ABS(dy0)) AND (ABS(dy1) GT ABS(dy0)) THEN BEGIN
;                  y[j]=0.5D0*(y[j-dd]+y[j+dd])
;                  j=j+dd
;              ENDIF 
;          ENDFOR
;      ENDFOR
;      reduce,x,y,/plot,/v

    IF doprint EQ 1 THEN BEGIN
        IF printfile NE '' THEN BEGIN
            OPENW,unit,printfile,/GET_LUN
        ENDIF ELSE BEGIN
            unit=-1
        ENDELSE
        PRINTF,unit," time (s)    L (erg/s)   R_phot (cm)"

        jj=0
        r=x
        FOR j=0L,N_ELEMENTS(ptime)-1 DO BEGIN
            IF x[jj] LE ptime[j] THEN BEGIN 
                r[jj]=radius[j]
                jj=jj+1
            ENDIF
        ENDFOR

        FOR j=0L,N_ELEMENTS(x)-1 DO BEGIN            
            PRINTF,unit,x[j],y[j],r[j], FORMAT="(3E12.5)"
        ENDFOR
        IF unit GE 0 THEN BEGIN
            CLOSE,unit
            FREE_LUN, unit
        ENDIF
    ENDIF

    OPLOT,x,y,COLOR=c[i],THICK=t,noclip=0,PSYM=psym

    IF doprint THEN BEGIN
        OPLOT,x,r*1.D30,COLOR=c[i],THICK=t,noclip=0,PSYM=psym,line=1
    ENDIF
ENDFOR


;; photosphere radius

; n=N_ELEMENTS(ptime)
; lx=DBLARR(n)

; FOR i=0L,n-1 DO BEGIN
;     idx=WHERE(rn[i,*] GE radius[i])
;     i0=idx[0]
;     r1=rn[i,i0]
;     l1=xl[i,i0]
;     IF i0 GT 0 THEN BEGIN 
;         r0=rn[i,i0-1] 
;         l0=xl[i,i0-1] 
;     ENDIF ELSE BEGIN 
;         r0=0
;         l0=0
;     ENDELSE
;     f=(radius[i]-r0)/(r1-r0)
;     lx[i]=l0+f*(l1-l0)
; ENDFOR

; x=ptime[*]
; y=lx[*]
; reduce,x,y,/plot,/v
; OPLOT,x,y,COLOR=!P.COLOR,THICK=4,LINE=1


IF (overplot EQ 0) THEN BEGIN
   multi_save2=!P.multi
   !P.MULTI=multi_save
   PLOT,[0,1],/NODATA, /NOERASE, YLOG=ylog, XLOG=xlog, $
        XRANGE=xrange,YRANGE=yrange, $
        XTITLE=xtitle, YTITLE=ytitle, $
        XSTYLE=1,XMARGIN=xmargin, $
        YSTYLE=1,YMARGIN=ymargin
   !P.multi=multi_save2
ENDIF

IF (showtime EQ 1) THEN BEGIN
    PRINT,' [PLOTLC] plot completed in '+STRING(SYSTIME(/SECONDS)-starttime)+' seconds.' 
ENDIF

IF pdf NE '' THEN BEGIN
   closeps
ENDIF

END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO getlc,name,val

COMMON lc,  nmodellmax,time,modellnr,modells,teff,radius,xlum,vphot,xlphot

val=-1

CASE name OF 
    'time' : val=time
    'xlum' : val=xlum
ENDCASE

END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO loadlc,name0, $
           FIRSTMODELL=firstmodell, $
           LASTMODELL=lastmodell, $
           STEPMODELL=stepmodell, $
           REMOVEZEROTIME=removezerotime, $
           VERBOSE=verbose, $
           SHOWTIME=showtime, $
           NSTART=nstart, $
           NEND=nend, $
           MAP=map, $
           RELOAD=reload
          

@physconst

;Version 10000 
;      WRITE(45) nvers,ncyc,timesec,teff,radius,xlum,
;     &     jj,(rn(j),un(j),xln(j),j=jm,jm-jj+1,-1)

;Version 10100
;      WRITE(45) nvers,ncyc,timesec,teff,radius,xlum,vphot,
;     &     jj,(rn(j),un(j),xln(j),j=jm,jm-jj+1,-1)

;Version 10101
;      WRITE(45) nvers,ncyc,timesec,dt,teff,radius,xlum,vphot,
;     &     jj,(rn(j),un(j),xln(j),j=jm,jm-jj+1,-1)

;Version 10102
;      WRITE(45) nvers,ncyc,timesec,dt,teff,radius,xlum,vphot,xlphot,
;     &     jj,(rn(j),un(j),xln(j),j=jm,jm-jj+1,-1)


COMMON lc,  nmodellmax,time,modellnr,modells,teff,radius,xlum,vphot,xlphot
COMMON lc1, ndata,ndatamax,rn,un,xln
COMMON loadlc, fileinfo

starttime=SYSTIME(/SECONDS)

IF N_ELEMENTS(verbose) EQ 0 THEN verbose=2
IF N_ELEMENTS(showtime) EQ 0 THEN showtime=0
IF verbose GE 2 THEN showtime=1

IF N_ELEMENTS(lastmodell) EQ 0 THEN lastmodell=LONG(2UL^31-1)
IF N_ELEMENTS(firstmodell) EQ 0 THEN firstmodell=LONG(-2UL^31)
IF N_ELEMENTS(nstart) EQ 0 THEN nstart=0
IF N_ELEMENTS(nend) EQ 0 THEN nend=LONG(2UL^31-1)
IF N_ELEMENTS(stepmodell) EQ 0 THEN stepmodell=1L
IF N_ELEMENTS(removezerotime) EQ 0 THEN removezerotime=1
stepmodell=MAX([1L,stepmodell])

IF N_ELEMENTS(map) EQ 0 THEN map=0

ext='.lc'
getfile,ext,name0,fileinfo,compress,reload
IF reload EQ 0 THEN RETURN


;; IF N_ELEMENTS(name0) EQ 0 THEN name='' ELSE name=name0
;; name1=name
;; IF (name EQ '') AND (N_ELEMENTS(filename) NE 0) THEN name=filename
;; IF (name EQ '') THEN name='*'+ext
;; xxx=FILE_SEARCH(name,COUNT=xxx_count,/TEST_REGULAR)
;; IF (xxx_count EQ 0) AND (STRLOWCASE(STRMID(name,2,3,/reverse)) EQ ext) THEN BEGIN
;;     name=name+'.gz'
;;     xxx=FILE_SEARCH(name,COUNT=xxx_count,/TEST_REGULAR)
;; ENDIF
;; ; search in directory
;; IF (xxx_count EQ 0) THEN BEGIN
;;    name=name1
;;    IF (STRLOWCASE(STRMID(name,0,1,/reverse)) NE '/') THEN BEGIN
;;       name+='/'
;;    ENDIF
;;    name+='*'+ext
;;    xxx=FILE_SEARCH(name,COUNT=xxx_count,/TEST_REGULAR)
;;    IF (xxx_count EQ 0) THEN BEGIN
;;       name+='.gz'
;;     xxx=FILE_SEARCH(name,COUNT=xxx_count,/TEST_REGULAR)
;;    ENDIF
;; ENDIF
;; IF (xxx_count NE 1) THEN BEGIN
;;    name=name1
;;    PRINT,' [LOADLC] COULD NOT FIND FILE '+name
;;    name=DIALOG_PICKFILE(/NOCONFIRM,/READ,/MUST_EXIST,FILTER='*'+ext+'*')
;;    IF name EQ '' THEN RETURN
;; ENDIF ELSE BEGIN
;;     name=xxx(0)
;; ENDELSE

;; IF N_ELEMENTS(reload) EQ 0 THEN reload=0
;; IF N_ELEMENTS(filename) EQ 0 THEN filename=''
;; IF name NE filename THEN reload=1
;; IF reload EQ 0 THEN BEGIN
;;     PRINT,' [LOADLC] WARNING: File name did not change.'
;;     PRINT,' [LOADLC] WARNING: Not reloading data.'
;;     RETURN
;; ENDIF
;; filename=name

;; compress=STRLOWCASE(STRMID(STRTRIM(filename,2),2,3,/REVERSE_OFFSET)) EQ '.gz'


OPENR,unit,fileinfo.name,/GET_LUN,/SWAP_IF_LITTLE_ENDIAN,COMPRESS=compress
x=fstat(unit)
xsize=x.size
IF compress THEN x.size=9999999999999LL

IF verbose GE 2 THEN BEGIN
    PRINT,' [LOADLC] loading file '+fileinfo.name
    IF compress THEN sc=' (compressed)' ELSE sc=''
    PRINT,' [LOADLC] filesize '+byte2human(xsize)+sc
ENDIF

nvers=-1L
modell=0L
xtime=1.0D0
teffx=0.D0
radiusx=0.D0
xlumx=0.D0
vphotx=0.0D0
xlphotx=0.0D0
dtx=0.0D0
mdata=0L

IF verbose GE 2 THEN PRINT," [LOADLC] determining model parameters ..."

nnselinc=16384L
nnsel=nnselinc
sel=LONARR(nnsel)
selmod=LONARR(nnsel)
selrec=LONARR(nnsel)
nsel=0L

nloadbytes=0L

ndatamax=1L

i=0L
pos=0L
done=0

first=1

previous_modell=-1L
start_record=0L

data_map_i=0
data_map_max=100
data_map=LONARR(data_map_max,4)

ON_IOERROR,EOF
WHILE (NOT EOF(unit)) AND (modell LT lastmodell) AND (NOT done) DO BEGIN
    recsize=0L
    IF pos+4L GT x.size THEN BEGIN
        done=1
        GOTO,endofloop
    ENDIF
    POINT_LUN,-unit,cur_pos
    IF cur_pos LT pos THEN BEGIN
        temp=BYTARR(pos-cur_pos)
        READU,unit,temp
        temp=0
    ENDIF ELSE IF cur_pos GT pos THEN BEGIN
        POINT_LUN,unit,pos 
    ENDIF
    READU,unit,recsize
    recsize=recsize+8L
    IF pos+recsize GT x.size THEN BEGIN
        done=1
        GOTO,endofloop
    ENDIF
    IF i LT nstart THEN GOTO,countnext
    IF i GT nend THEN GOTO,countnext
    READU,unit,nvers,modell,xtime
    IF nvers GE 10101 THEN BEGIN
        READU,unit,dtx
    ENDIF
    READU,unit,teffx,radiusx,xlumx
    IF nvers GE 10100 THEN BEGIN
        READU,unit,vphotx
    ENDIF
    IF nvers GE 10102 THEN BEGIN
        READU,unit,xlphotx
    ENDIF
    READU,unit,mdata

    IF first EQ 1 THEN BEGIN
        IF verbose GE 2 THEN BEGIN
            PRINT,' [LOADLC] version '+STRING(nvers,FORMAT='(I5)')
        ENDIF
        first=0
    ENDIF

    IF map NE 0 THEN BEGIN
        IF previous_modell NE -1 THEN BEGIN
            IF modell NE previous_modell+1 THEN BEGIN
                data_map(data_map_i,0)=start_record
                data_map(data_map_i,1)=i-1
                data_map(data_map_i,2)=previous_modell-i+start_record+1
                data_map(data_map_i,3)=previous_modell
;                PRINT,' [LOADLC] MAP: record '+STRING(start_record,FORMAT="(I6)")+' - '+STRING(i-1,FORMAT="(I6)")+ $
;                  ': models '+STRING(previous_modell-i+start_record+1,FORMAT="(I7)")+' - '+STRING(previous_modell,FORMAT="(I7)") 
                start_record=i
                data_map_i=data_map_i+1
            ENDIF
        ENDIF
        previous_modell=modell
    ENDIF

    IF modell mod stepmodell NE 0 THEN GOTO,countnext

;    IF mdata LE 0 THEN BEGIN
;        PRINT,' [LOADLC] WARNING: mdata = ',mdata,'; Skipping model = ',modell
;        GOTO,countnext
;    ENDIF

    IF modell GE firstmodell THEN BEGIN
;..... limits section
        ndatamax=MAX([ndatamax,mdata])

;..... administartive section
        IF (modell MOD 100 EQ 0) AND (verbose GE 3) THEN PRINT," [LOADLC] model ",modell

;.... section for selection management
        IF nsel GT 0 THEN BEGIN
            IF modell LE selmod(nsel-1) THEN BEGIN
                isel=nsel
                REPEAT BEGIN
                    isel=isel-1
                ENDREP UNTIL (modell EQ selmod[isel]) OR (isel EQ 0)

                IF (isel EQ 0) AND (modell LT selmod[isel]) THEN BEGIN
                    PRINT,' [LOADLC] ======================================='
                    PRINT,' [LOADLC] *** WARNING *** WARNING *** WARNING ***'
                    PRINT,' [LOADLC] ---------------------------------------'
                    PRINT,' [LOADLC] Earliest model read from file was:'
                    PRINT,' [LOADLC]'
                    PRINT,' [LOADLC]         Position =',sel[0]
                    PRINT,' [LOADLC]         Model    =',selmod[0]
                    PRINT,' [LOADLC]'
                    PRINT,' [LOADLC] Restarting read at:'
                    PRINT,' [LOADLC]'
                    PRINT,' [LOADLC]         Position =',pos
                    PRINT,' [LOADLC]         Model    =',modell
                    PRINT,' [LOADLC]         Record   =',i
                    PRINT,' [LOADLC]'
                    PRINT,' [LOADLC] ======================================='
                    nsel=0L
                    nloadbytes=0L
                    GOTO,setmodell
                ENDIF

                IF (isel EQ 0) AND (modell NE selmod[isel]) THEN BEGIN
                    PRINT,' [LOADLC] FILE ERROR: ABORDING.'
                    PRINT,' [LOADLC] Position =',pos
                    PRINT,' [LOADLC] Model    =',modell
                    PRINT,' [LOADLC] Record   =',i
                    RETURN
                ENDIF  
                PRINT,' [LOADLC] removing redundant models '+STRING(selmod(isel))+'...'+STRING(selmod(nsel-1))+' (records '+STRING(selrec(isel))+'...'+STRING(selrec(nsel-1))+')'
                nsel=isel
            ENDIF
        ENDIF
 
        IF nsel EQ nnsel THEN BEGIN
            nnsel=nnsel+nnselinc
            seltmp=LONARR(nnsel)
            seltmp[0:nsel-1]=sel[0:nsel-1]
            sel=seltmp
            seltmp=LONARR(nnsel)
            seltmp[0:nsel-1]=selmod[0:nsel-1]
            selmod=seltmp            
            seltmp=LONARR(nnsel)
            seltmp[0:nsel-1]=selrec[0:nsel-1]
            selrec=seltmp            
            seltmp=0L ; free memory
        ENDIF
setmodell:

        sel[nsel]=pos
        selmod[nsel]=modell
        selrec[nsel]=i
        nsel=nsel+1
        nloadbytes=nloadbytes+recsize
    ENDIF 
    GOTO,countnext
countnext:
    pos=pos+recsize
    GOTO,endofloop
EOF:
    done=1
endofloop:
    i=i+1
ENDWHILE
nmodellmax=nsel

IF map EQ 1 THEN BEGIN
    data_map(data_map_i,0)=start_record
    data_map(data_map_i,1)=i-2
    data_map(data_map_i,2)=previous_modell-i+start_record+2
    data_map(data_map_i,3)=previous_modell
    FOR ii=0,data_map_i DO BEGIN
        PRINT,' [LOADLC] MAP: record '+STRING(data_map(ii,0),FORMAT="(I6)")+' - '+STRING(data_map(ii,1),FORMAT="(I6)")+ $
          ': models '+STRING(data_map(ii,2),FORMAT="(I7)")+' - '+STRING(data_map(ii,3),FORMAT="(I7)") 
    ENDFOR
ENDIF

ON_IOERROR,NULL

IF ndatamax GT 24 THEN BEGIN
    PRINT,' [LOADLC] WARNING: ndatamax is ',ndatamax
ENDIF

ndata=LONARR(nmodellmax,/NOZERO)
rn   =DBLARR(nmodellmax,ndatamax,/NOZERO)
un   =DBLARR(nmodellmax,ndatamax,/NOZERO)
xln  =DBLARR(nmodellmax,ndatamax,/NOZERO)

time=DBLARR(nmodellmax,/NOZERO)
dt=DBLARR(nmodellmax,/NOZERO)
teff=DBLARR(nmodellmax,/NOZERO)
radius=DBLARR(nmodellmax,/NOZERO)
xlum=DBLARR(nmodellmax,/NOZERO)
vphot=DBLARR(nmodellmax,/NOZERO)
xlphot=DBLARR(nmodellmax,/NOZERO)
modellnr=LONARR(nmodellmax,/NOZERO)

IF (verbose GE 2) THEN PRINT," [LOADLC] reading models ("+byte2human(nloadbytes)+') ...'

FOR i=0L,nsel-1L DO BEGIN
    pos=sel[i]
    POINT_LUN,-unit,cur_pos
    IF cur_pos LT pos THEN BEGIN
        temp=BYTARR(pos-cur_pos)
        READU,unit,temp
        temp=0
    ENDIF ELSE IF cur_pos GT pos THEN BEGIN
        POINT_LUN,unit,pos 
    ENDIF
    recsize=0L
    READU,unit,recsize,nvers,modell,xtime
    modellnr[i]=modell
    time[i]=xtime
    IF nvers GE 10101 THEN BEGIN
        READU,unit,dtx
        dt[i]=dtx
    ENDIF
    READU,unit,teffx,radiusx,xlumx
    teff[i]=teffx
    radius[i]=radiusx
    xlum[i]=xlumx
    IF nvers GE 10100 THEN BEGIN
        READU,unit,vphotx
        vphot[i]=vphotx
    ENDIF
    IF nvers GE 10102 THEN BEGIN
        READU,unit,xlphotx
        xlphot[i]=xlphotx
    ENDIF

    READU,unit,mdata
    ndata[i]=mdata

    IF mdata GT 0 THEN BEGIN
        xdata=DBLARR(3,mdata,/NOZERO)
        READU,unit,xdata
        rn [i,0:mdata-1]=xdata[0,0:mdata-1]
        un [i,0:mdata-1]=xdata[1,0:mdata-1]
        xln[i,0:mdata-1]=xdata[2,0:mdata-1]
    ENDIF

    IF (i MOD 100 EQ 0) AND (verbose GE 3) THEN PRINT," [LOADLC] model ",modell
ENDFOR
CLOSE,unit
FREE_LUN,unit

modells=nsel

;XMSUNI=1.D0/XMSUN
;RSUNI=1.D0/RSUN
;XLSINI=1.D0/XLSUN
;rn=rn*RSUNI
;xln=xln*LSUNI

IF removezerotime THEN BEGIN
    zerotime=0.0D0
    time0=time[0]
    FOR i=1L,modells-1 DO BEGIN
        IF time[i] LT time0 THEN BEGIN 
            zerotime=time[i-1]
            IF (verbose GE 1) THEN PRINT,' [LOADLC] @ model='+STRING(modellnr[i])+' zerotime was set to '+STRING(zerotime)
        ENDIF
        time0=time[i]
        time[i]=time0+zerotime
    ENDFOR
ENDIF

;SECI=1.D0/SEC

;time=time[0:modells-1]*SECI

IF (verbose GE 1) THEN PRINT,' [LOADLC] last model read: '+STRING(modell)

IF (showtime EQ 1) THEN BEGIN
    PRINT,' [LOADLC] data loaded in '+STRING(SYSTIME(/SECONDS)-starttime)+' seconds.' 
ENDIF

END
